# platform/loader/

This document describes how files under `platform/loader/` are organized.

## cors

Contains Cross-Origin Resource Sharing (CORS) related files. Some functions
in this directory will be removed once CORS support is moved to
//services/network. Please contact {kinuko,toyoshim}@chromium.org when you need
to depend on this directory from new code.

## fetch

Contains files for low-level loading APIs.  The `PLATFORM_EXPORT` macro is
needed to use them from `core/`.  Otherwise they can be used only in
`platform/`.

The directory conceptually implements https://fetch.spec.whatwg.org/#fetching
(with lower-level components such as the network service). See also: [slides
describing the relationship with the fetch spec](https://docs.google.com/presentation/d/1r9KHuYbNlgqQ6UABAMiWz0ONTpSTnMaDJ8UeYZGWjls/)

## testing

Contains helper files for testing that are available in both
`blink_platform_unittests` and `blink_unittests`.
These files are built as a part of the `platform:test_support` static library.
