// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_RENDERER_MODULES_WEBDATABASE_SQLITE_SANDBOXED_VFS_DELEGATE_H_
#define THIRD_PARTY_BLINK_RENDERER_MODULES_WEBDATABASE_SQLITE_SANDBOXED_VFS_DELEGATE_H_

#include "sql/sandboxed_vfs.h"

namespace blink {

class SandboxedVfsDelegate : public sql::SandboxedVfs::Delegate {
 public:
  SandboxedVfsDelegate();
  ~SandboxedVfsDelegate() override;

  // sql::SandboxedVfs::Delegate implementation:
  base::File OpenFile(const base::FilePath& file_path,
                      int sqlite_requested_flags) override;
  int DeleteFile(const base::FilePath& file_path, bool sync_dir) override;
  base::Optional<sql::SandboxedVfs::PathAccessInfo> GetPathAccess(
      const base::FilePath& file_path) override;
  bool SetFileLength(const base::FilePath& file_path,
                     base::File& file,
                     size_t size) override;
};

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_MODULES_WEBDATABASE_SQLITE_SANDBOXED_VFS_DELEGATE_H_
