# Copyright 2016 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.
"""Contains Services, Characteristics and Descriptor aliases.

These values are copied from:

https://www.bluetooth.com/specifications/gatt/services

https://www.bluetooth.com/specifications/gatt/characteristics
"""

SERVICES = [
    'alert_notification',
    'automation_io',
    'battery_service',
    'blood_pressure',
    'body_composition',
    'bond_management',
    'continuous_glucose_monitoring',
    'current_time',
    'cycling_power',
    'cycling_speed_and_cadence',
    'device_information',
    'environmental_sensing',
    'fitness_machine',
    'generic_access',
    'generic_attribute',
    'glucose',
    'health_thermometer',
    'heart_rate',
    'http_proxy',
    'human_interface_device',
    'immediate_alert',
    'indoor_positioning',
    'internet_protocol_support',
    'link_loss',
    'location_and_navigation',
    'next_dst_change',
    'object_transfer',
    'phone_alert_status',
    'pulse_oximeter',
    'reference_time_update',
    'running_speed_and_cadence',
    'scan_parameters',
    'transport_discovery',
    'tx_power',
    'user_data',
    'weight_scale',
]

CHARACTERISTICS = [
    'aerobic_heart_rate_lower_limit',
    'aerobic_heart_rate_upper_limit',
    'aerobic_threshold',
    'age',
    'aggregate',
    'alert_category_id',
    'alert_category_id_bit_mask',
    'alert_level',
    'alert_notification_control_point',
    'alert_status',
    'altitude',
    'anaerobic_heart_rate_lower_limit',
    'anaerobic_heart_rate_upper_limit',
    'anaerobic_threshold',
    'analog',
    'apparent_wind_direction',
    'apparent_wind_speed',
    'gap.appearance',
    'barometric_pressure_trend',
    'battery_level',
    'blood_pressure_feature',
    'blood_pressure_measurement',
    'body_composition_feature',
    'body_composition_measurement',
    'body_sensor_location',
    'bond_management_control_point',
    'bond_management_feature',
    'boot_keyboard_input_report',
    'boot_keyboard_output_report',
    'boot_mouse_input_report',
    'gap.central_address_resolution_support',
    'cgm_feature',
    'cgm_measurement',
    'cgm_session_run_time',
    'cgm_session_start_time',
    'cgm_specific_ops_control_point',
    'cgm_status',
    'cross_trainer_data',
    'csc_feature',
    'csc_measurement',
    'current_time',
    'cycling_power_control_point',
    'cycling_power_feature',
    'cycling_power_measurement',
    'cycling_power_vector',
    'database_change_increment',
    'date_of_birth',
    'date_of_threshold_assessment',
    'date_time',
    'day_date_time',
    'day_of_week',
    'descriptor_value_changed',
    'gap.device_name',
    'dew_point',
    'digital',
    'dst_offset',
    'elevation',
    'email_address',
    'exact_time_256',
    'fat_burn_heart_rate_lower_limit',
    'fat_burn_heart_rate_upper_limit',
    'firmware_revision_string',
    'first_name',
    'fitness_machine_control_point',
    'fitness_machine_feature',
    'fitness_machine_status',
    'five_zone_heart_rate_limits',
    'floor_number',
    'gender',
    'glucose_feature',
    'glucose_measurement',
    'glucose_measurement_context',
    'gust_factor',
    'hardware_revision_string',
    'heart_rate_control_point',
    'heart_rate_max',
    'heart_rate_measurement',
    'heat_index',
    'height',
    'hid_control_point',
    'hid_information',
    'hip_circumference',
    'http_control_point',
    'http_entity_body',
    'http_headers',
    'http_status_code',
    'https_security',
    'humidity',
    'ieee_11073-20601_regulatory_certification_data_list',
    'indoor_bike_data',
    'indoor_positioning_configuration',
    'intermediate_cuff_pressure',
    'intermediate_temperature',
    'irradiance',
    'language',
    'last_name',
    'latitude',
    'ln_control_point',
    'ln_feature',
    'local_east_coordinate',
    'local_north_coordinate',
    'local_time_information',
    'location_and_speed',
    'location_name',
    'longitude',
    'magnetic_declination',
    'magnetic_flux_density_2D',
    'magnetic_flux_density_3D',
    'manufacturer_name_string',
    'maximum_recommended_heart_rate',
    'measurement_interval',
    'model_number_string',
    'navigation',
    'new_alert',
    'object_action_control_point',
    'object_changed',
    'object_first_created',
    'object_id',
    'object_last_modified',
    'object_list_control_point',
    'object_list_filter',
    'object_name',
    'object_properties',
    'object_size',
    'object_type',
    'ots_feature',
    'gap.peripheral_preferred_connection_parameters',
    'gap.peripheral_privacy_flag',
    'plx_continuous_measurement',
    'plx_features',
    'plx_spot_check_measurement',
    'pnp_id',
    'pollen_concentration',
    'position_quality',
    'pressure',
    'protocol_mode',
    'rainfall',
    'gap.reconnection_address',
    'record_access_control_point',
    'reference_time_information',
    'report',
    'report_map',
    'resolvable_private_address_only',
    'resting_heart_rate',
    'ringer_control_point',
    'ringer_setting',
    'rower_data',
    'rsc_feature',
    'rsc_measurement',
    'sc_control_point',
    'scan_interval_window',
    'scan_refresh',
    'serial_number_string',
    'gatt.service_changed',
    'software_revision_string',
    'sport_type_for_aerobic_and_anaerobic_thresholds',
    'stair_climber_data',
    'step_climber_data',
    'supported_heart_rate_range',
    'supported_inclination_range',
    'supported_new_alert_category',
    'supported_power_range',
    'supported_resistance_level_range',
    'supported_speed_range',
    'supported_unread_alert_category',
    'system_id',
    'tds_control_point',
    'temperature',
    'temperature_measurement',
    'temperature_type',
    'three_zone_heart_rate_limits',
    'time_accuracy',
    'time_source',
    'time_update_control_point',
    'time_update_state',
    'time_with_dst',
    'time_zone',
    'training_status',
    'treadmill_data',
    'true_wind_direction',
    'true_wind_speed',
    'two_zone_heart_rate_limit',
    'tx_power_level',
    'uncertainty',
    'unread_alert_status',
    'uri',
    'user_control_point',
    'user_index',
    'uv_index',
    'vo2_max',
    'waist_circumference',
    'weight',
    'weight_measurement',
    'weight_scale_feature',
    'wind_chill',
]
