// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/layout/ng/table/layout_ng_table_cell_legacy.h"

#include "third_party/blink/renderer/core/layout/layout_analyzer.h"
#include "third_party/blink/renderer/core/layout/layout_view.h"
#include "third_party/blink/renderer/core/layout/ng/ng_block_node.h"
#include "third_party/blink/renderer/core/layout/ng/ng_constraint_space.h"
#include "third_party/blink/renderer/core/layout/ng/ng_layout_result.h"
#include "third_party/blink/renderer/core/layout/ng/ng_length_utils.h"
#include "third_party/blink/renderer/core/layout/ng/ng_out_of_flow_positioned_node.h"
#include "third_party/blink/renderer/core/layout/ng/ng_physical_box_fragment.h"

namespace blink {

LayoutNGTableCellLegacy::LayoutNGTableCellLegacy(Element* element)
    : LayoutNGBlockFlowMixin<LayoutTableCell>(element) {}

void LayoutNGTableCellLegacy::UpdateBlockLayout(bool relayout_children) {
  NOT_DESTROYED();
  LayoutAnalyzer::BlockScope analyzer(*this);

  SetOverrideLogicalWidth(LogicalWidth().ClampNegativeToZero());
  UpdateInFlowBlockLayout();
}

}  // namespace blink
