// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_FRAME_CSP_TRUSTED_TYPES_DIRECTIVE_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_FRAME_CSP_TRUSTED_TYPES_DIRECTIVE_H_

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/frame/csp/content_security_policy.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

CORE_EXPORT
network::mojom::blink::CSPTrustedTypesPtr CSPTrustedTypesParse(
    const String& value,
    ContentSecurityPolicy* policy);

CORE_EXPORT
bool CSPTrustedTypesAllows(
    const network::mojom::blink::CSPTrustedTypes& trusted_types,
    const String& string_piece,
    bool is_duplicate,
    ContentSecurityPolicy::AllowTrustedTypePolicyDetails& violation_details);

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_CORE_FRAME_CSP_TRUSTED_TYPES_DIRECTIVE_H_
