# Chromium-based Fuchsia services
This directory contains implementation code for various Fuchsia services living
in the Chromium repository. To build Chromium on Fuchsia, check this
[documentation](../docs/fuchsia/build_instructions.md).

[TOC]

## Code organization
Each of the following subdirectories contain code for a specific Fuchsia
service:
* `./engine` contains the WebEngine implementation. The WebEngine enables
Fuchsia applications to embed Chromium frames for rendering web content.
* `./http` contains an implementation for the Fuchsia HTTP service.
* `./runners`contains implementations of Fuchsia `sys.runner`.
    * `./runners/cast` Enables the Fuchsia system to launch cast applications.
    * `./runners/web` Enables the Fuchsia system to launch HTTP or HTTPS URLs.
* `./media_receiver` contains an implementation for an Open Screen receiver.

When writing a new Fuchsia service, it is recommended to create a new
subdirectory under `//fuchsia` or a new subdirectory under `//fuchsia/runners`
depending on the use case.

The `./base` subdirectory contains common utilities used by more than one of
the aforementioned Fuchsia services.

The `./cipd` and `./fidl` subdirectories contain CIPD definitions and FIDL
interface definitions, respectfully.

### Namespacing

Code that is not shared across multiple targets should live in the global
namespace. Code that is shared across multiple targets should live in the
`cr_fuchsia` namespace.

### Test code

Under the `//fuchsia` directory , there are 3 major types of tests:
* Unit tests: Exercises a single class in isolation, allowing full control
  over the external environment of this class.
* Browser tests: Spawns a full browser process along child processes. The test
  code is run inside the browser process, allowing for full access to the
  browser code, but not other processes.
* Integration tests: they exercise the published API of a Fuchsia component. For
  instance, `//fuchsia/engine:web_engine_integration_tests` make use of the
  `//fuchsia/engine:web_engine` component. The test code is run in a separate
  process in a separate component, allowing only access to the published API of
  the component under test.

Integration tests are more resource-intensive than browser tests, which are in
turn more expensive than unit tests. Therefore, when writing new tests, it is
preferred to write unit tests over browser tests over integration tests.

As a general rule, test-only code should live in the same directory as the code
under test with an explicit file name, either `fake_*`, `test_*`,
`*_unittest.cc`, `*_ browser_test.cc` or `*_integration_test.cc`.

Test code that is shared across components should live in a dedicated `test`
directory, under the `cr_fuchsia` namespace. For instance, see the
`//fuchsia/engine/test` directory, which contains code shared by all browser
tests.

## Deploying and running Fuchsia code.

Fuchsia binaries are deployed and executed via scripts that are automatically
generated by the `fuchsia_package_runner()` GN target. Details on deploying and
running Fuchsia test binaries can be found
[here](../docs/fuchsia/gtests.md)

## Debugging

Check [this documentation](../docs/fuchsia/debug_instructions.md) for
debugging tips.


## WebRunner/WebEngine

### Building and deploying the WebRunner service

When you build `web_runner`, Chromium will automatically generate scripts for
you that will automatically provision a device with Fuchsia and then install
`web_runner` and its dependencies.

To build and run `web_runner`, follow these steps:

1. (Optional) Ensure that you have a device ready to boot into Fuchsia.

    If you wish to have `web_runner` manage the OS deployment process, then you
    should have the device booting into
    [Zedboot](https://fuchsia.googlesource.com/zircon/+/master/docs/targets/usb_setup.md).

2. Build `web_runner`.

    ```bash
    $ autoninja -C out/fuchsia web_runner
    ```

3. Install `web_runner`.

    * For devices running Zedboot:

        ```bash
        $ out/fuchsia/bin/install_web_runner -d
        ```

    * For devices already booted into Fuchsia:

        You will need to add command line flags specifying the device's IP
        address and the path to the `ssh_config` used by the device
        (located at `$FUCHSIA_OUT_DIR/ssh-keys/ssh_config`):

        ```bash
        $ out/fuchsia/bin/install_web_runner -d --ssh-config $PATH_TO_SSH_CONFIG
        ```

4. Press Alt-Esc key on your device to switch back to terminal mode or run
`fx shell` from the host.

5. Launch a webpage.

    ```bash
    $ tiles_ctl add https://www.chromium.org/
    ```

6. Press Alt-Esc to switch back to graphical view if needed. The browser
window should be displayed and ready to use.

7. You can deploy and run new versions of Chromium without needing to reboot.

    First kill any running processes:

    ```bash
    $ killall context_provider.cmx; killall web_runner.cmx
    ```

    Then repeat steps 1 through 6 from the installation instructions, excluding
    step #3 (running Tiles).


### Closing a webpage

1. Press the Windows key to return to the terminal.

2. Instruct tiles_ctl to remove the webpage's window tile. The tile's number is
    reported by step 6, or it can be found by running `tiles_ctl list` and
    noting the ID of the "url" entry.

    ```bash
    $ tiles_ctl remove TILE_NUMBER
    ```
