/*
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "third_party/blink/renderer/core/layout/layout_iframe.h"

#include "third_party/blink/renderer/core/layout/layout_analyzer.h"
#include "third_party/blink/renderer/core/page/scrolling/root_scroller_controller.h"

namespace blink {

LayoutIFrame::LayoutIFrame(HTMLFrameOwnerElement* element)
    : LayoutEmbeddedContent(element) {}

bool LayoutIFrame::ShouldComputeSizeAsReplaced() const {
  NOT_DESTROYED();
  return true;
}

bool LayoutIFrame::IsInlineBlockOrInlineTable() const {
  NOT_DESTROYED();
  return IsInline();
}

PaintLayerType LayoutIFrame::LayerTypeRequired() const {
  NOT_DESTROYED();
  if (StyleRef().HasResize())
    return kNormalPaintLayer;
  return LayoutEmbeddedContent::LayerTypeRequired();
}

void LayoutIFrame::UpdateLayout() {
  NOT_DESTROYED();
  DCHECK(NeedsLayout());
  LayoutAnalyzer::Scope analyzer(*this);

  UpdateLogicalWidth();
  // No kids to layout as a replaced element.
  UpdateLogicalHeight();

  ClearLayoutOverflow();
  UpdateAfterLayout();

  ClearNeedsLayout();
}

void LayoutIFrame::StyleWillChange(StyleDifference diff,
                                   const ComputedStyle& new_style) {
  NOT_DESTROYED();
  if (Style() && StyleRef().UsedColorSchemeForInitialColors() !=
                     new_style.UsedColorSchemeForInitialColors()) {
    GetFrameOwnerElement()->SetColorScheme(
        new_style.UsedColorSchemeForInitialColors());
  }
  LayoutEmbeddedContent::StyleWillChange(diff, new_style);
}

}  // namespace blink
