// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_FRAME_OPENED_FRAME_TRACKER_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_FRAME_OPENED_FRAME_TRACKER_H_

#include "base/macros.h"
#include "third_party/blink/renderer/platform/heap/handle.h"
#include "third_party/blink/renderer/platform/wtf/allocator/allocator.h"
#include "third_party/blink/renderer/platform/wtf/hash_set.h"

namespace blink {

class Frame;

// Small helper class to track the set of frames that a Frame has opened.
// Due to layering restrictions, we need to hide the implementation, since
// public/web/ cannot depend on wtf/.
class OpenedFrameTracker {
  DISALLOW_NEW();

 public:
  OpenedFrameTracker();
  ~OpenedFrameTracker();
  void Trace(Visitor*) const;

  bool IsEmpty() const;
  void Add(Frame*);
  void Remove(Frame*);

  // Helper used when swapping a frame into the frame tree: this updates the
  // opener for opened frames to point to the new frame being swapped in.
  void TransferTo(Frame*) const;

 private:
  HeapHashSet<WeakMember<Frame>> opened_frames_;

  DISALLOW_COPY_AND_ASSIGN(OpenedFrameTracker);
};

}  // namespace blink

#endif  // WebFramePrivate_h
