/*
 * Copyright (C) 2012 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef THIRD_PARTY_BLINK_PUBLIC_WEB_WEB_PAGE_POPUP_H_
#define THIRD_PARTY_BLINK_PUBLIC_WEB_WEB_PAGE_POPUP_H_

#include "third_party/blink/public/mojom/page/widget.mojom-shared.h"
#include "third_party/blink/public/platform/cross_variant_mojo_util.h"
#include "third_party/blink/public/platform/web_common.h"
#include "third_party/blink/public/web/web_widget.h"

namespace blink {

class WebDocument;
class WebView;

class WebPagePopup : public WebWidget {
 public:
  // Returns a WebPagePopup which is self-referencing. It's self-reference will
  // be released when the popup is closed via Close().
  BLINK_EXPORT static WebPagePopup* Create(
      CrossVariantMojoAssociatedRemote<mojom::PopupWidgetHostInterfaceBase>
          popup_widget_host,
      CrossVariantMojoAssociatedRemote<mojom::WidgetHostInterfaceBase>
          widget_host,
      CrossVariantMojoAssociatedReceiver<mojom::WidgetInterfaceBase> widget,
      scoped_refptr<base::SingleThreadTaskRunner> task_runner);

  // This method closes and deletes the WebPagePopup.
  virtual void Close() {}

  // The popup's accessibility tree is connected to the main document's
  // accessibility tree. Access to the popup document is needed to ensure the
  // popup's layout is clean before serializing the combined tree.
  virtual WebDocument GetDocument() = 0;

  // Initialization is typically done after creation inside blink, but some
  // content tests call Create directly so we expose an initialization.
  virtual void InitializeForTesting(WebView* view) = 0;
};

}  // namespace blink

#endif
