// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gl_2_autogen.cpp:
//   Defines the Desktop GL 2.x entry points.

#include "libGL/entry_points_gl_2_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture/gl_enum_utils.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationEGL.h"
#include "libANGLE/validationES.h"
#include "libANGLE/validationES1.h"
#include "libANGLE/validationES2.h"
#include "libANGLE/validationES3.h"
#include "libANGLE/validationES31.h"
#include "libANGLE/validationES32.h"
#include "libANGLE/validationESEXT.h"
#include "libANGLE/validationGL2_autogen.h"
#include "libGLESv2/global_state.h"

using namespace gl;

extern "C" {

// GL 2.0
void GL_APIENTRY GL_AttachShader(GLuint program, GLuint shader)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLAttachShader, "context = %d, program = %u, shader = %u", CID(context), program,
          shader);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateAttachShader(context, programPacked, shaderPacked));
        if (isCallValid)
        {
            context->attachShader(programPacked, shaderPacked);
        }
        ANGLE_CAPTURE(AttachShader, isCallValid, context, programPacked, shaderPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BindAttribLocation(GLuint program, GLuint index, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBindAttribLocation,
          "context = %d, program = %u, index = %u, name = 0x%016" PRIxPTR "", CID(context), program,
          index, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBindAttribLocation(context, programPacked, index, name));
        if (isCallValid)
        {
            context->bindAttribLocation(programPacked, index, name);
        }
        ANGLE_CAPTURE(BindAttribLocation, isCallValid, context, programPacked, index, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_BlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLBlendEquationSeparate, "context = %d, modeRGB = %s, modeAlpha = %s",
          CID(context), GLenumToString(GLenumGroup::BlendEquationModeEXT, modeRGB),
          GLenumToString(GLenumGroup::BlendEquationModeEXT, modeAlpha));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateBlendEquationSeparate(context, modeRGB, modeAlpha));
        if (isCallValid)
        {
            context->blendEquationSeparate(modeRGB, modeAlpha);
        }
        ANGLE_CAPTURE(BlendEquationSeparate, isCallValid, context, modeRGB, modeAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_CompileShader(GLuint shader)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCompileShader, "context = %d, shader = %u", CID(context), shader);

    if (context)
    {
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateCompileShader(context, shaderPacked));
        if (isCallValid)
        {
            context->compileShader(shaderPacked);
        }
        ANGLE_CAPTURE(CompileShader, isCallValid, context, shaderPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLuint GL_APIENTRY GL_CreateProgram()
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateProgram, "context = %d", CID(context));

    GLuint returnValue;
    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateCreateProgram(context));
        if (isCallValid)
        {
            returnValue = context->createProgram();
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateProgram, GLuint>();
        }
        ANGLE_CAPTURE(CreateProgram, isCallValid, context, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateProgram, GLuint>();
    }
    return returnValue;
}

GLuint GL_APIENTRY GL_CreateShader(GLenum type)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLCreateShader, "context = %d, type = %s", CID(context),
          GLenumToString(GLenumGroup::ShaderType, type));

    GLuint returnValue;
    if (context)
    {
        ShaderType typePacked                                 = PackParam<ShaderType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateCreateShader(context, typePacked));
        if (isCallValid)
        {
            returnValue = context->createShader(typePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateShader, GLuint>();
        }
        ANGLE_CAPTURE(CreateShader, isCallValid, context, typePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateShader, GLuint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_DeleteProgram(GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteProgram, "context = %d, program = %u", CID(context), program);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteProgram(context, programPacked));
        if (isCallValid)
        {
            context->deleteProgram(programPacked);
        }
        ANGLE_CAPTURE(DeleteProgram, isCallValid, context, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DeleteShader(GLuint shader)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDeleteShader, "context = %d, shader = %u", CID(context), shader);

    if (context)
    {
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDeleteShader(context, shaderPacked));
        if (isCallValid)
        {
            context->deleteShader(shaderPacked);
        }
        ANGLE_CAPTURE(DeleteShader, isCallValid, context, shaderPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DetachShader(GLuint program, GLuint shader)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDetachShader, "context = %d, program = %u, shader = %u", CID(context), program,
          shader);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateDetachShader(context, programPacked, shaderPacked));
        if (isCallValid)
        {
            context->detachShader(programPacked, shaderPacked);
        }
        ANGLE_CAPTURE(DetachShader, isCallValid, context, programPacked, shaderPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DisableVertexAttribArray(GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDisableVertexAttribArray, "context = %d, index = %u", CID(context), index);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateDisableVertexAttribArray(context, index));
        if (isCallValid)
        {
            context->disableVertexAttribArray(index);
        }
        ANGLE_CAPTURE(DisableVertexAttribArray, isCallValid, context, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_DrawBuffers(GLsizei n, const GLenum *bufs)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLDrawBuffers, "context = %d, n = %d, bufs = 0x%016" PRIxPTR "", CID(context), n,
          (uintptr_t)bufs);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateDrawBuffers(context, n, bufs));
        if (isCallValid)
        {
            context->drawBuffers(n, bufs);
        }
        ANGLE_CAPTURE(DrawBuffers, isCallValid, context, n, bufs);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_EnableVertexAttribArray(GLuint index)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLEnableVertexAttribArray, "context = %d, index = %u", CID(context), index);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateEnableVertexAttribArray(context, index));
        if (isCallValid)
        {
            context->enableVertexAttribArray(index);
        }
        ANGLE_CAPTURE(EnableVertexAttribArray, isCallValid, context, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetActiveAttrib(GLuint program,
                                    GLuint index,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLint *size,
                                    GLenum *type,
                                    GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetActiveAttrib,
          "context = %d, program = %u, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", size = 0x%016" PRIxPTR ", type = 0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
          CID(context), program, index, bufSize, (uintptr_t)length, (uintptr_t)size,
          (uintptr_t)type, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetActiveAttrib(context, programPacked, index, bufSize, length,
                                                    size, type, name));
        if (isCallValid)
        {
            context->getActiveAttrib(programPacked, index, bufSize, length, size, type, name);
        }
        ANGLE_CAPTURE(GetActiveAttrib, isCallValid, context, programPacked, index, bufSize, length,
                      size, type, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetActiveUniform(GLuint program,
                                     GLuint index,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLint *size,
                                     GLenum *type,
                                     GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetActiveUniform,
          "context = %d, program = %u, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", size = 0x%016" PRIxPTR ", type = 0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
          CID(context), program, index, bufSize, (uintptr_t)length, (uintptr_t)size,
          (uintptr_t)type, (uintptr_t)name);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetActiveUniform(context, programPacked, index, bufSize, length,
                                                     size, type, name));
        if (isCallValid)
        {
            context->getActiveUniform(programPacked, index, bufSize, length, size, type, name);
        }
        ANGLE_CAPTURE(GetActiveUniform, isCallValid, context, programPacked, index, bufSize, length,
                      size, type, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetAttachedShaders(GLuint program,
                                       GLsizei maxCount,
                                       GLsizei *count,
                                       GLuint *shaders)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetAttachedShaders,
          "context = %d, program = %u, maxCount = %d, count = 0x%016" PRIxPTR
          ", shaders = 0x%016" PRIxPTR "",
          CID(context), program, maxCount, (uintptr_t)count, (uintptr_t)shaders);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        ShaderProgramID *shadersPacked = PackParam<ShaderProgramID *>(shaders);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetAttachedShaders(context, programPacked, maxCount, count, shadersPacked));
        if (isCallValid)
        {
            context->getAttachedShaders(programPacked, maxCount, count, shadersPacked);
        }
        ANGLE_CAPTURE(GetAttachedShaders, isCallValid, context, programPacked, maxCount, count,
                      shadersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLint GL_APIENTRY GL_GetAttribLocation(GLuint program, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetAttribLocation, "context = %d, program = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetAttribLocation(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getAttribLocation(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetAttribLocation, GLint>();
        }
        ANGLE_CAPTURE(GetAttribLocation, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetAttribLocation, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetProgramInfoLog(GLuint program,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLchar *infoLog)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetProgramInfoLog,
          "context = %d, program = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", infoLog = 0x%016" PRIxPTR "",
          CID(context), program, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetProgramInfoLog(context, programPacked, bufSize, length, infoLog));
        if (isCallValid)
        {
            context->getProgramInfoLog(programPacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE(GetProgramInfoLog, isCallValid, context, programPacked, bufSize, length,
                      infoLog);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetProgramiv(GLuint program, GLenum pname, GLint *params)
{
    Context *context = GetGlobalContext();
    EVENT(context, GLGetProgramiv,
          "context = %d, program = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
          program, GLenumToString(GLenumGroup::ProgramPropertyARB, pname), (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetProgramiv(context, programPacked, pname, params));
        if (isCallValid)
        {
            context->getProgramiv(programPacked, pname, params);
        }
        ANGLE_CAPTURE(GetProgramiv, isCallValid, context, programPacked, pname, params);
    }
    else
    {}
}

void GL_APIENTRY GL_GetShaderInfoLog(GLuint shader,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *infoLog)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetShaderInfoLog,
          "context = %d, shader = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", infoLog = 0x%016" PRIxPTR "",
          CID(context), shader, bufSize, (uintptr_t)length, (uintptr_t)infoLog);

    if (context)
    {
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetShaderInfoLog(context, shaderPacked, bufSize, length, infoLog));
        if (isCallValid)
        {
            context->getShaderInfoLog(shaderPacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE(GetShaderInfoLog, isCallValid, context, shaderPacked, bufSize, length,
                      infoLog);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetShaderSource(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetShaderSource,
          "context = %d, shader = %u, bufSize = %d, length = 0x%016" PRIxPTR
          ", source = 0x%016" PRIxPTR "",
          CID(context), shader, bufSize, (uintptr_t)length, (uintptr_t)source);

    if (context)
    {
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateGetShaderSource(context, shaderPacked, bufSize, length, source));
        if (isCallValid)
        {
            context->getShaderSource(shaderPacked, bufSize, length, source);
        }
        ANGLE_CAPTURE(GetShaderSource, isCallValid, context, shaderPacked, bufSize, length, source);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetShaderiv(GLuint shader, GLenum pname, GLint *params)
{
    Context *context = GetGlobalContext();
    EVENT(context, GLGetShaderiv,
          "context = %d, shader = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), shader,
          GLenumToString(GLenumGroup::ShaderParameterName, pname), (uintptr_t)params);

    if (context)
    {
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetShaderiv(context, shaderPacked, pname, params));
        if (isCallValid)
        {
            context->getShaderiv(shaderPacked, pname, params);
        }
        ANGLE_CAPTURE(GetShaderiv, isCallValid, context, shaderPacked, pname, params);
    }
    else
    {}
}

GLint GL_APIENTRY GL_GetUniformLocation(GLuint program, const GLchar *name)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUniformLocation, "context = %d, program = %u, name = 0x%016" PRIxPTR "",
          CID(context), program, (uintptr_t)name);

    GLint returnValue;
    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetUniformLocation(context, programPacked, name));
        if (isCallValid)
        {
            returnValue = context->getUniformLocation(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetUniformLocation, GLint>();
        }
        ANGLE_CAPTURE(GetUniformLocation, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetUniformLocation, GLint>();
    }
    return returnValue;
}

void GL_APIENTRY GL_GetUniformfv(GLuint program, GLint location, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUniformfv,
          "context = %d, program = %u, location = %d, params = 0x%016" PRIxPTR "", CID(context),
          program, location, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUniformfv(context, programPacked, locationPacked, params));
        if (isCallValid)
        {
            context->getUniformfv(programPacked, locationPacked, params);
        }
        ANGLE_CAPTURE(GetUniformfv, isCallValid, context, programPacked, locationPacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetUniformiv(GLuint program, GLint location, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetUniformiv,
          "context = %d, program = %u, location = %d, params = 0x%016" PRIxPTR "", CID(context),
          program, location, (uintptr_t)params);

    if (context)
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetUniformiv(context, programPacked, locationPacked, params));
        if (isCallValid)
        {
            context->getUniformiv(programPacked, locationPacked, params);
        }
        ANGLE_CAPTURE(GetUniformiv, isCallValid, context, programPacked, locationPacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetVertexAttribPointerv(GLuint index, GLenum pname, void **pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribPointerv,
          "context = %d, index = %u, pname = %s, pointer = 0x%016" PRIxPTR "", CID(context), index,
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)pointer);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateGetVertexAttribPointerv(context, index, pname, pointer));
        if (isCallValid)
        {
            context->getVertexAttribPointerv(index, pname, pointer);
        }
        ANGLE_CAPTURE(GetVertexAttribPointerv, isCallValid, context, index, pname, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetVertexAttribdv(GLuint index, GLenum pname, GLdouble *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribdv,
          "context = %d, index = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), index,
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribdv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribdv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribdv, isCallValid, context, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetVertexAttribfv(GLuint index, GLenum pname, GLfloat *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribfv,
          "context = %d, index = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), index,
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribfv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribfv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribfv, isCallValid, context, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_GetVertexAttribiv(GLuint index, GLenum pname, GLint *params)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLGetVertexAttribiv,
          "context = %d, index = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context), index,
          GLenumToString(GLenumGroup::DefaultGroup, pname), (uintptr_t)params);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateGetVertexAttribiv(context, index, pname, params));
        if (isCallValid)
        {
            context->getVertexAttribiv(index, pname, params);
        }
        ANGLE_CAPTURE(GetVertexAttribiv, isCallValid, context, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

GLboolean GL_APIENTRY GL_IsProgram(GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsProgram, "context = %d, program = %u", CID(context), program);

    GLboolean returnValue;
    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsProgram(context, programPacked));
        if (isCallValid)
        {
            returnValue = context->isProgram(programPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsProgram, GLboolean>();
        }
        ANGLE_CAPTURE(IsProgram, isCallValid, context, programPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsProgram, GLboolean>();
    }
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsShader(GLuint shader)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLIsShader, "context = %d, shader = %u", CID(context), shader);

    GLboolean returnValue;
    if (context)
    {
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateIsShader(context, shaderPacked));
        if (isCallValid)
        {
            returnValue = context->isShader(shaderPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsShader, GLboolean>();
        }
        ANGLE_CAPTURE(IsShader, isCallValid, context, shaderPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsShader, GLboolean>();
    }
    return returnValue;
}

void GL_APIENTRY GL_LinkProgram(GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLLinkProgram, "context = %d, program = %u", CID(context), program);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateLinkProgram(context, programPacked));
        if (isCallValid)
        {
            context->linkProgram(programPacked);
        }
        ANGLE_CAPTURE(LinkProgram, isCallValid, context, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ShaderSource(GLuint shader,
                                 GLsizei count,
                                 const GLchar *const *string,
                                 const GLint *length)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLShaderSource,
          "context = %d, shader = %u, count = %d, string = 0x%016" PRIxPTR
          ", length = 0x%016" PRIxPTR "",
          CID(context), shader, count, (uintptr_t)string, (uintptr_t)length);

    if (context)
    {
        ShaderProgramID shaderPacked                          = PackParam<ShaderProgramID>(shader);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateShaderSource(context, shaderPacked, count, string, length));
        if (isCallValid)
        {
            context->shaderSource(shaderPacked, count, string, length);
        }
        ANGLE_CAPTURE(ShaderSource, isCallValid, context, shaderPacked, count, string, length);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_StencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLStencilFuncSeparate, "context = %d, face = %s, func = %s, ref = %d, mask = %u",
          CID(context), GLenumToString(GLenumGroup::StencilFaceDirection, face),
          GLenumToString(GLenumGroup::StencilFunction, func), ref, mask);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateStencilFuncSeparate(context, face, func, ref, mask));
        if (isCallValid)
        {
            context->stencilFuncSeparate(face, func, ref, mask);
        }
        ANGLE_CAPTURE(StencilFuncSeparate, isCallValid, context, face, func, ref, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_StencilMaskSeparate(GLenum face, GLuint mask)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLStencilMaskSeparate, "context = %d, face = %s, mask = %u", CID(context),
          GLenumToString(GLenumGroup::StencilFaceDirection, face), mask);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateStencilMaskSeparate(context, face, mask));
        if (isCallValid)
        {
            context->stencilMaskSeparate(face, mask);
        }
        ANGLE_CAPTURE(StencilMaskSeparate, isCallValid, context, face, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_StencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLStencilOpSeparate,
          "context = %d, face = %s, sfail = %s, dpfail = %s, dppass = %s", CID(context),
          GLenumToString(GLenumGroup::StencilFaceDirection, face),
          GLenumToString(GLenumGroup::StencilOp, sfail),
          GLenumToString(GLenumGroup::StencilOp, dpfail),
          GLenumToString(GLenumGroup::StencilOp, dppass));

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateStencilOpSeparate(context, face, sfail, dpfail, dppass));
        if (isCallValid)
        {
            context->stencilOpSeparate(face, sfail, dpfail, dppass);
        }
        ANGLE_CAPTURE(StencilOpSeparate, isCallValid, context, face, sfail, dpfail, dppass);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform1f(GLint location, GLfloat v0)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform1f, "context = %d, location = %d, v0 = %f", CID(context), location, v0);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform1f(context, locationPacked, v0));
        if (isCallValid)
        {
            context->uniform1f(locationPacked, v0);
        }
        ANGLE_CAPTURE(Uniform1f, isCallValid, context, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform1fv(GLint location, GLsizei count, const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform1fv,
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform1fv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform1fv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform1fv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform1i(GLint location, GLint v0)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform1i, "context = %d, location = %d, v0 = %d", CID(context), location, v0);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform1i(context, locationPacked, v0));
        if (isCallValid)
        {
            context->uniform1i(locationPacked, v0);
        }
        ANGLE_CAPTURE(Uniform1i, isCallValid, context, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform1iv(GLint location, GLsizei count, const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform1iv,
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform1iv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform1iv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform1iv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform2f(GLint location, GLfloat v0, GLfloat v1)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform2f, "context = %d, location = %d, v0 = %f, v1 = %f", CID(context),
          location, v0, v1);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2f(context, locationPacked, v0, v1));
        if (isCallValid)
        {
            context->uniform2f(locationPacked, v0, v1);
        }
        ANGLE_CAPTURE(Uniform2f, isCallValid, context, locationPacked, v0, v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform2fv(GLint location, GLsizei count, const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform2fv,
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform2fv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform2fv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform2fv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform2i(GLint location, GLint v0, GLint v1)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform2i, "context = %d, location = %d, v0 = %d, v1 = %d", CID(context),
          location, v0, v1);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform2i(context, locationPacked, v0, v1));
        if (isCallValid)
        {
            context->uniform2i(locationPacked, v0, v1);
        }
        ANGLE_CAPTURE(Uniform2i, isCallValid, context, locationPacked, v0, v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform2iv(GLint location, GLsizei count, const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform2iv,
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform2iv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform2iv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform2iv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform3f, "context = %d, location = %d, v0 = %f, v1 = %f, v2 = %f",
          CID(context), location, v0, v1, v2);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3f(context, locationPacked, v0, v1, v2));
        if (isCallValid)
        {
            context->uniform3f(locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE(Uniform3f, isCallValid, context, locationPacked, v0, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform3fv(GLint location, GLsizei count, const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform3fv,
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform3fv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform3fv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform3fv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform3i(GLint location, GLint v0, GLint v1, GLint v2)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform3i, "context = %d, location = %d, v0 = %d, v1 = %d, v2 = %d",
          CID(context), location, v0, v1, v2);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUniform3i(context, locationPacked, v0, v1, v2));
        if (isCallValid)
        {
            context->uniform3i(locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE(Uniform3i, isCallValid, context, locationPacked, v0, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform3iv(GLint location, GLsizei count, const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform3iv,
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform3iv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform3iv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform3iv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform4f, "context = %d, location = %d, v0 = %f, v1 = %f, v2 = %f, v3 = %f",
          CID(context), location, v0, v1, v2, v3);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform4f(context, locationPacked, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->uniform4f(locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(Uniform4f, isCallValid, context, locationPacked, v0, v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform4fv(GLint location, GLsizei count, const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform4fv,
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform4fv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform4fv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform4fv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform4i, "context = %d, location = %d, v0 = %d, v1 = %d, v2 = %d, v3 = %d",
          CID(context), location, v0, v1, v2, v3);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform4i(context, locationPacked, v0, v1, v2, v3));
        if (isCallValid)
        {
            context->uniform4i(locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE(Uniform4i, isCallValid, context, locationPacked, v0, v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_Uniform4iv(GLint location, GLsizei count, const GLint *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniform4iv,
          "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "", CID(context),
          location, count, (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateUniform4iv(context, locationPacked, count, value));
        if (isCallValid)
        {
            context->uniform4iv(locationPacked, count, value);
        }
        ANGLE_CAPTURE(Uniform4iv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix2fv(GLint location,
                                     GLsizei count,
                                     GLboolean transpose,
                                     const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix2fv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix2fv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix2fv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix2fv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix3fv(GLint location,
                                     GLsizei count,
                                     GLboolean transpose,
                                     const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix3fv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix3fv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix3fv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix3fv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix4fv(GLint location,
                                     GLsizei count,
                                     GLboolean transpose,
                                     const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix4fv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix4fv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix4fv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix4fv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UseProgram(GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUseProgram, "context = %d, program = %u", CID(context), program);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateUseProgram(context, programPacked));
        if (isCallValid)
        {
            context->useProgram(programPacked);
        }
        ANGLE_CAPTURE(UseProgram, isCallValid, context, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_ValidateProgram(GLuint program)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLValidateProgram, "context = %d, program = %u", CID(context), program);

    if (context)
    {
        ShaderProgramID programPacked                         = PackParam<ShaderProgramID>(program);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateValidateProgram(context, programPacked));
        if (isCallValid)
        {
            context->validateProgram(programPacked);
        }
        ANGLE_CAPTURE(ValidateProgram, isCallValid, context, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib1d(GLuint index, GLdouble x)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib1d, "context = %d, index = %u, x = %f", CID(context), index, x);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexAttrib1d(context, index, x));
        if (isCallValid)
        {
            context->vertexAttrib1d(index, x);
        }
        ANGLE_CAPTURE(VertexAttrib1d, isCallValid, context, index, x);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib1dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib1dv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib1dv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib1dv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib1dv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib1f(GLuint index, GLfloat x)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib1f, "context = %d, index = %u, x = %f", CID(context), index, x);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexAttrib1f(context, index, x));
        if (isCallValid)
        {
            context->vertexAttrib1f(index, x);
        }
        ANGLE_CAPTURE(VertexAttrib1f, isCallValid, context, index, x);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib1fv(GLuint index, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib1fv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib1fv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib1fv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib1fv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib1s(GLuint index, GLshort x)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib1s, "context = %d, index = %u, x = %d", CID(context), index, x);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid = (context->skipValidation() || ValidateVertexAttrib1s(context, index, x));
        if (isCallValid)
        {
            context->vertexAttrib1s(index, x);
        }
        ANGLE_CAPTURE(VertexAttrib1s, isCallValid, context, index, x);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib1sv(GLuint index, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib1sv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib1sv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib1sv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib1sv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib2d(GLuint index, GLdouble x, GLdouble y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib2d, "context = %d, index = %u, x = %f, y = %f", CID(context),
          index, x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib2d(context, index, x, y));
        if (isCallValid)
        {
            context->vertexAttrib2d(index, x, y);
        }
        ANGLE_CAPTURE(VertexAttrib2d, isCallValid, context, index, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib2dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib2dv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib2dv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib2dv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib2dv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib2f(GLuint index, GLfloat x, GLfloat y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib2f, "context = %d, index = %u, x = %f, y = %f", CID(context),
          index, x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib2f(context, index, x, y));
        if (isCallValid)
        {
            context->vertexAttrib2f(index, x, y);
        }
        ANGLE_CAPTURE(VertexAttrib2f, isCallValid, context, index, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib2fv(GLuint index, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib2fv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib2fv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib2fv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib2fv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib2s(GLuint index, GLshort x, GLshort y)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib2s, "context = %d, index = %u, x = %d, y = %d", CID(context),
          index, x, y);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib2s(context, index, x, y));
        if (isCallValid)
        {
            context->vertexAttrib2s(index, x, y);
        }
        ANGLE_CAPTURE(VertexAttrib2s, isCallValid, context, index, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib2sv(GLuint index, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib2sv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib2sv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib2sv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib2sv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib3d(GLuint index, GLdouble x, GLdouble y, GLdouble z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib3d, "context = %d, index = %u, x = %f, y = %f, z = %f",
          CID(context), index, x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib3d(context, index, x, y, z));
        if (isCallValid)
        {
            context->vertexAttrib3d(index, x, y, z);
        }
        ANGLE_CAPTURE(VertexAttrib3d, isCallValid, context, index, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib3dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib3dv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib3dv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib3dv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib3dv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib3f, "context = %d, index = %u, x = %f, y = %f, z = %f",
          CID(context), index, x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib3f(context, index, x, y, z));
        if (isCallValid)
        {
            context->vertexAttrib3f(index, x, y, z);
        }
        ANGLE_CAPTURE(VertexAttrib3f, isCallValid, context, index, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib3fv(GLuint index, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib3fv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib3fv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib3fv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib3fv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib3s(GLuint index, GLshort x, GLshort y, GLshort z)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib3s, "context = %d, index = %u, x = %d, y = %d, z = %d",
          CID(context), index, x, y, z);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib3s(context, index, x, y, z));
        if (isCallValid)
        {
            context->vertexAttrib3s(index, x, y, z);
        }
        ANGLE_CAPTURE(VertexAttrib3s, isCallValid, context, index, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib3sv(GLuint index, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib3sv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib3sv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib3sv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib3sv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4Nbv(GLuint index, const GLbyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4Nbv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Nbv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4Nbv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4Nbv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4Niv(GLuint index, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4Niv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Niv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4Niv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4Niv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4Nsv(GLuint index, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4Nsv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Nsv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4Nsv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4Nsv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4Nub(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4Nub, "context = %d, index = %u, x = %d, y = %d, z = %d, w = %d",
          CID(context), index, x, y, z, w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Nub(context, index, x, y, z, w));
        if (isCallValid)
        {
            context->vertexAttrib4Nub(index, x, y, z, w);
        }
        ANGLE_CAPTURE(VertexAttrib4Nub, isCallValid, context, index, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4Nubv(GLuint index, const GLubyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4Nubv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Nubv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4Nubv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4Nubv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4Nuiv(GLuint index, const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4Nuiv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Nuiv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4Nuiv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4Nuiv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4Nusv(GLuint index, const GLushort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4Nusv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4Nusv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4Nusv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4Nusv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4bv(GLuint index, const GLbyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4bv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4bv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4bv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4bv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4d(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4d, "context = %d, index = %u, x = %f, y = %f, z = %f, w = %f",
          CID(context), index, x, y, z, w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4d(context, index, x, y, z, w));
        if (isCallValid)
        {
            context->vertexAttrib4d(index, x, y, z, w);
        }
        ANGLE_CAPTURE(VertexAttrib4d, isCallValid, context, index, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4dv(GLuint index, const GLdouble *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4dv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4dv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4dv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4dv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4f, "context = %d, index = %u, x = %f, y = %f, z = %f, w = %f",
          CID(context), index, x, y, z, w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4f(context, index, x, y, z, w));
        if (isCallValid)
        {
            context->vertexAttrib4f(index, x, y, z, w);
        }
        ANGLE_CAPTURE(VertexAttrib4f, isCallValid, context, index, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4fv(GLuint index, const GLfloat *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4fv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4fv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4fv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4fv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4iv(GLuint index, const GLint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4iv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4iv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4iv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4iv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4s(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4s, "context = %d, index = %u, x = %d, y = %d, z = %d, w = %d",
          CID(context), index, x, y, z, w);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4s(context, index, x, y, z, w));
        if (isCallValid)
        {
            context->vertexAttrib4s(index, x, y, z, w);
        }
        ANGLE_CAPTURE(VertexAttrib4s, isCallValid, context, index, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4sv(GLuint index, const GLshort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4sv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4sv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4sv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4sv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4ubv(GLuint index, const GLubyte *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4ubv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4ubv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4ubv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4ubv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4uiv(GLuint index, const GLuint *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4uiv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4uiv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4uiv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4uiv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttrib4usv(GLuint index, const GLushort *v)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttrib4usv, "context = %d, index = %u, v = 0x%016" PRIxPTR "",
          CID(context), index, (uintptr_t)v);

    if (context)
    {
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() || ValidateVertexAttrib4usv(context, index, v));
        if (isCallValid)
        {
            context->vertexAttrib4usv(index, v);
        }
        ANGLE_CAPTURE(VertexAttrib4usv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_VertexAttribPointer(GLuint index,
                                        GLint size,
                                        GLenum type,
                                        GLboolean normalized,
                                        GLsizei stride,
                                        const void *pointer)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLVertexAttribPointer,
          "context = %d, index = %u, size = %d, type = %s, normalized = %s, stride = %d, pointer = "
          "0x%016" PRIxPTR "",
          CID(context), index, size, GLenumToString(GLenumGroup::VertexAttribPointerType, type),
          GLbooleanToString(normalized), stride, (uintptr_t)pointer);

    if (context)
    {
        VertexAttribType typePacked                           = PackParam<VertexAttribType>(type);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid                                      = (context->skipValidation() ||
                            ValidateVertexAttribPointer(context, index, size, typePacked,
                                                        normalized, stride, pointer));
        if (isCallValid)
        {
            context->vertexAttribPointer(index, size, typePacked, normalized, stride, pointer);
        }
        ANGLE_CAPTURE(VertexAttribPointer, isCallValid, context, index, size, typePacked,
                      normalized, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

// GL 2.1
void GL_APIENTRY GL_UniformMatrix2x3fv(GLint location,
                                       GLsizei count,
                                       GLboolean transpose,
                                       const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix2x3fv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix2x3fv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix2x3fv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix2x3fv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix2x4fv(GLint location,
                                       GLsizei count,
                                       GLboolean transpose,
                                       const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix2x4fv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix2x4fv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix2x4fv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix2x4fv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix3x2fv(GLint location,
                                       GLsizei count,
                                       GLboolean transpose,
                                       const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix3x2fv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix3x2fv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix3x2fv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix3x2fv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix3x4fv(GLint location,
                                       GLsizei count,
                                       GLboolean transpose,
                                       const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix3x4fv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix3x4fv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix3x4fv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix3x4fv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix4x2fv(GLint location,
                                       GLsizei count,
                                       GLboolean transpose,
                                       const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix4x2fv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix4x2fv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix4x2fv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix4x2fv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

void GL_APIENTRY GL_UniformMatrix4x3fv(GLint location,
                                       GLsizei count,
                                       GLboolean transpose,
                                       const GLfloat *value)
{
    Context *context = GetValidGlobalContext();
    EVENT(context, GLUniformMatrix4x3fv,
          "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
          CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value);

    if (context)
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        std::unique_lock<angle::GlobalMutex> shareContextLock = GetContextLock(context);
        bool isCallValid =
            (context->skipValidation() ||
             ValidateUniformMatrix4x3fv(context, locationPacked, count, transpose, value));
        if (isCallValid)
        {
            context->uniformMatrix4x3fv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE(UniformMatrix4x3fv, isCallValid, context, locationPacked, count, transpose,
                      value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext();
    }
}

}  // extern "C"
