// GENERATED FILE - DO NOT EDIT.
// Generated by gen_spirv_builder_and_parser.py using data from spirv.core.grammar.json.
//
// Copyright 2021 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// spirv_instruction_parser_autogen.h:
//   Functions to parse SPIR-V binary for each instruction.

#ifndef COMMON_SPIRV_SPIRVINSTRUCTIONPARSERAUTOGEN_H_
#define COMMON_SPIRV_SPIRVINSTRUCTIONPARSERAUTOGEN_H_

#include <vector>

#include "spirv_types.h"

namespace angle
{
namespace spirv
{
void GetInstructionOpAndLength(const uint32_t *_instruction, spv::Op *opOut, uint32_t *lengthOut);
void ParseUndef(const uint32_t *_instruction, IdResultType *idResultType, IdResult *idResult);
void ParseSourceContinued(const uint32_t *_instruction, LiteralString *continuedSource);
void ParseSource(const uint32_t *_instruction,
                 spv::SourceLanguage *sourceLanguage,
                 LiteralInteger *version,
                 IdRef *file,
                 LiteralString *source);
void ParseSourceExtension(const uint32_t *_instruction, LiteralString *extension);
void ParseName(const uint32_t *_instruction, IdRef *target, LiteralString *name);
void ParseMemberName(const uint32_t *_instruction,
                     IdRef *type,
                     LiteralInteger *member,
                     LiteralString *name);
void ParseString(const uint32_t *_instruction, IdResult *idResult, LiteralString *string);
void ParseLine(const uint32_t *_instruction,
               IdRef *file,
               LiteralInteger *line,
               LiteralInteger *column);
void ParseExtension(const uint32_t *_instruction, LiteralString *name);
void ParseExtInstImport(const uint32_t *_instruction, IdResult *idResult, LiteralString *name);
void ParseExtInst(const uint32_t *_instruction,
                  IdResultType *idResultType,
                  IdResult *idResult,
                  IdRef *set,
                  LiteralExtInstInteger *instruction,
                  IdRefList *operandList);
void ParseMemoryModel(const uint32_t *_instruction,
                      spv::AddressingModel *addressingModel,
                      spv::MemoryModel *memoryModel);
void ParseEntryPoint(const uint32_t *_instruction,
                     spv::ExecutionModel *executionModel,
                     IdRef *entryPoint,
                     LiteralString *name,
                     IdRefList *interfaceList);
void ParseExecutionMode(const uint32_t *_instruction, IdRef *entryPoint, spv::ExecutionMode *mode);
void ParseCapability(const uint32_t *_instruction, spv::Capability *capability);
void ParseTypeVoid(const uint32_t *_instruction, IdResult *idResult);
void ParseTypeBool(const uint32_t *_instruction, IdResult *idResult);
void ParseTypeInt(const uint32_t *_instruction,
                  IdResult *idResult,
                  LiteralInteger *width,
                  LiteralInteger *signedness);
void ParseTypeFloat(const uint32_t *_instruction, IdResult *idResult, LiteralInteger *width);
void ParseTypeVector(const uint32_t *_instruction,
                     IdResult *idResult,
                     IdRef *componentType,
                     LiteralInteger *componentCount);
void ParseTypeMatrix(const uint32_t *_instruction,
                     IdResult *idResult,
                     IdRef *columnType,
                     LiteralInteger *columnCount);
void ParseTypeImage(const uint32_t *_instruction,
                    IdResult *idResult,
                    IdRef *sampledType,
                    spv::Dim *dim,
                    LiteralInteger *depth,
                    LiteralInteger *arrayed,
                    LiteralInteger *mS,
                    LiteralInteger *sampled,
                    spv::ImageFormat *imageFormat,
                    spv::AccessQualifier *accessQualifier);
void ParseTypeSampler(const uint32_t *_instruction, IdResult *idResult);
void ParseTypeSampledImage(const uint32_t *_instruction, IdResult *idResult, IdRef *imageType);
void ParseTypeArray(const uint32_t *_instruction,
                    IdResult *idResult,
                    IdRef *elementType,
                    IdRef *length);
void ParseTypeRuntimeArray(const uint32_t *_instruction, IdResult *idResult, IdRef *elementType);
void ParseTypeStruct(const uint32_t *_instruction, IdResult *idResult, IdRefList *memberList);
void ParseTypePointer(const uint32_t *_instruction,
                      IdResult *idResult,
                      spv::StorageClass *storageClass,
                      IdRef *type);
void ParseTypeFunction(const uint32_t *_instruction,
                       IdResult *idResult,
                       IdRef *returnType,
                       IdRefList *parameterList);
void ParseTypeForwardPointer(const uint32_t *_instruction,
                             IdRef *pointerType,
                             spv::StorageClass *storageClass);
void ParseConstantTrue(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult);
void ParseConstantFalse(const uint32_t *_instruction,
                        IdResultType *idResultType,
                        IdResult *idResult);
void ParseConstant(const uint32_t *_instruction,
                   IdResultType *idResultType,
                   IdResult *idResult,
                   LiteralContextDependentNumber *value);
void ParseConstantComposite(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult,
                            IdRefList *constituentsList);
void ParseConstantNull(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult);
void ParseSpecConstantTrue(const uint32_t *_instruction,
                           IdResultType *idResultType,
                           IdResult *idResult);
void ParseSpecConstantFalse(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult);
void ParseSpecConstant(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult,
                       LiteralContextDependentNumber *value);
void ParseSpecConstantComposite(const uint32_t *_instruction,
                                IdResultType *idResultType,
                                IdResult *idResult,
                                IdRefList *constituentsList);
void ParseFunction(const uint32_t *_instruction,
                   IdResultType *idResultType,
                   IdResult *idResult,
                   spv::FunctionControlMask *functionControl,
                   IdRef *functionType);
void ParseFunctionParameter(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult);
void ParseFunctionCall(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult,
                       IdRef *function,
                       IdRefList *argumentList);
void ParseVariable(const uint32_t *_instruction,
                   IdResultType *idResultType,
                   IdResult *idResult,
                   spv::StorageClass *storageClass,
                   IdRef *initializer);
void ParseImageTexelPointer(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult,
                            IdRef *image,
                            IdRef *coordinate,
                            IdRef *sample);
void ParseLoad(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *pointer,
               spv::MemoryAccessMask *memoryAccess);
void ParseStore(const uint32_t *_instruction,
                IdRef *pointer,
                IdRef *object,
                spv::MemoryAccessMask *memoryAccess);
void ParseCopyMemory(const uint32_t *_instruction,
                     IdRef *target,
                     IdRef *source,
                     spv::MemoryAccessMask *memoryAccess);
void ParseCopyMemorySized(const uint32_t *_instruction,
                          IdRef *target,
                          IdRef *source,
                          IdRef *size,
                          spv::MemoryAccessMask *memoryAccess);
void ParseAccessChain(const uint32_t *_instruction,
                      IdResultType *idResultType,
                      IdResult *idResult,
                      IdRef *base,
                      IdRefList *indexesList);
void ParseInBoundsAccessChain(const uint32_t *_instruction,
                              IdResultType *idResultType,
                              IdResult *idResult,
                              IdRef *base,
                              IdRefList *indexesList);
void ParseArrayLength(const uint32_t *_instruction,
                      IdResultType *idResultType,
                      IdResult *idResult,
                      IdRef *structure,
                      LiteralInteger *arraymember);
void ParseInBoundsPtrAccessChain(const uint32_t *_instruction,
                                 IdResultType *idResultType,
                                 IdResult *idResult,
                                 IdRef *base,
                                 IdRef *element,
                                 IdRefList *indexesList);
void ParseDecorate(const uint32_t *_instruction,
                   IdRef *target,
                   spv::Decoration *decoration,
                   LiteralIntegerList *valuesPairList);
void ParseMemberDecorate(const uint32_t *_instruction,
                         IdRef *structureType,
                         LiteralInteger *member,
                         spv::Decoration *decoration,
                         LiteralIntegerList *valuesPairList);
void ParseDecorationGroup(const uint32_t *_instruction, IdResult *idResult);
void ParseGroupDecorate(const uint32_t *_instruction,
                        IdRef *decorationGroup,
                        IdRefList *targetsList);
void ParseGroupMemberDecorate(const uint32_t *_instruction,
                              IdRef *decorationGroup,
                              PairIdRefLiteralIntegerList *targetsPairList);
void ParseVectorExtractDynamic(const uint32_t *_instruction,
                               IdResultType *idResultType,
                               IdResult *idResult,
                               IdRef *vector,
                               IdRef *index);
void ParseVectorInsertDynamic(const uint32_t *_instruction,
                              IdResultType *idResultType,
                              IdResult *idResult,
                              IdRef *vector,
                              IdRef *component,
                              IdRef *index);
void ParseVectorShuffle(const uint32_t *_instruction,
                        IdResultType *idResultType,
                        IdResult *idResult,
                        IdRef *vector1,
                        IdRef *vector2,
                        LiteralIntegerList *componentsPairList);
void ParseCompositeConstruct(const uint32_t *_instruction,
                             IdResultType *idResultType,
                             IdResult *idResult,
                             IdRefList *constituentsList);
void ParseCompositeExtract(const uint32_t *_instruction,
                           IdResultType *idResultType,
                           IdResult *idResult,
                           IdRef *composite,
                           LiteralIntegerList *indexesPairList);
void ParseCompositeInsert(const uint32_t *_instruction,
                          IdResultType *idResultType,
                          IdResult *idResult,
                          IdRef *object,
                          IdRef *composite,
                          LiteralIntegerList *indexesPairList);
void ParseCopyObject(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *operand);
void ParseTranspose(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdRef *matrix);
void ParseSampledImage(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult,
                       IdRef *image,
                       IdRef *sampler);
void ParseImageSampleImplicitLod(const uint32_t *_instruction,
                                 IdResultType *idResultType,
                                 IdResult *idResult,
                                 IdRef *sampledImage,
                                 IdRef *coordinate,
                                 spv::ImageOperandsMask *imageOperands,
                                 IdRefList *imageOperandIdsList);
void ParseImageSampleExplicitLod(const uint32_t *_instruction,
                                 IdResultType *idResultType,
                                 IdResult *idResult,
                                 IdRef *sampledImage,
                                 IdRef *coordinate,
                                 spv::ImageOperandsMask *imageOperands,
                                 IdRefList *imageOperandIdsList);
void ParseImageSampleDrefImplicitLod(const uint32_t *_instruction,
                                     IdResultType *idResultType,
                                     IdResult *idResult,
                                     IdRef *sampledImage,
                                     IdRef *coordinate,
                                     IdRef *dref,
                                     spv::ImageOperandsMask *imageOperands,
                                     IdRefList *imageOperandIdsList);
void ParseImageSampleDrefExplicitLod(const uint32_t *_instruction,
                                     IdResultType *idResultType,
                                     IdResult *idResult,
                                     IdRef *sampledImage,
                                     IdRef *coordinate,
                                     IdRef *dref,
                                     spv::ImageOperandsMask *imageOperands,
                                     IdRefList *imageOperandIdsList);
void ParseImageSampleProjImplicitLod(const uint32_t *_instruction,
                                     IdResultType *idResultType,
                                     IdResult *idResult,
                                     IdRef *sampledImage,
                                     IdRef *coordinate,
                                     spv::ImageOperandsMask *imageOperands,
                                     IdRefList *imageOperandIdsList);
void ParseImageSampleProjExplicitLod(const uint32_t *_instruction,
                                     IdResultType *idResultType,
                                     IdResult *idResult,
                                     IdRef *sampledImage,
                                     IdRef *coordinate,
                                     spv::ImageOperandsMask *imageOperands,
                                     IdRefList *imageOperandIdsList);
void ParseImageSampleProjDrefImplicitLod(const uint32_t *_instruction,
                                         IdResultType *idResultType,
                                         IdResult *idResult,
                                         IdRef *sampledImage,
                                         IdRef *coordinate,
                                         IdRef *dref,
                                         spv::ImageOperandsMask *imageOperands,
                                         IdRefList *imageOperandIdsList);
void ParseImageSampleProjDrefExplicitLod(const uint32_t *_instruction,
                                         IdResultType *idResultType,
                                         IdResult *idResult,
                                         IdRef *sampledImage,
                                         IdRef *coordinate,
                                         IdRef *dref,
                                         spv::ImageOperandsMask *imageOperands,
                                         IdRefList *imageOperandIdsList);
void ParseImageFetch(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *image,
                     IdRef *coordinate,
                     spv::ImageOperandsMask *imageOperands,
                     IdRefList *imageOperandIdsList);
void ParseImageGather(const uint32_t *_instruction,
                      IdResultType *idResultType,
                      IdResult *idResult,
                      IdRef *sampledImage,
                      IdRef *coordinate,
                      IdRef *component,
                      spv::ImageOperandsMask *imageOperands,
                      IdRefList *imageOperandIdsList);
void ParseImageDrefGather(const uint32_t *_instruction,
                          IdResultType *idResultType,
                          IdResult *idResult,
                          IdRef *sampledImage,
                          IdRef *coordinate,
                          IdRef *dref,
                          spv::ImageOperandsMask *imageOperands,
                          IdRefList *imageOperandIdsList);
void ParseImageRead(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdRef *image,
                    IdRef *coordinate,
                    spv::ImageOperandsMask *imageOperands,
                    IdRefList *imageOperandIdsList);
void ParseImageWrite(const uint32_t *_instruction,
                     IdRef *image,
                     IdRef *coordinate,
                     IdRef *texel,
                     spv::ImageOperandsMask *imageOperands,
                     IdRefList *imageOperandIdsList);
void ParseImage(const uint32_t *_instruction,
                IdResultType *idResultType,
                IdResult *idResult,
                IdRef *sampledImage);
void ParseImageQueryLod(const uint32_t *_instruction,
                        IdResultType *idResultType,
                        IdResult *idResult,
                        IdRef *sampledImage,
                        IdRef *coordinate);
void ParseConvertFToU(const uint32_t *_instruction,
                      IdResultType *idResultType,
                      IdResult *idResult,
                      IdRef *floatValue);
void ParseConvertFToS(const uint32_t *_instruction,
                      IdResultType *idResultType,
                      IdResult *idResult,
                      IdRef *floatValue);
void ParseConvertSToF(const uint32_t *_instruction,
                      IdResultType *idResultType,
                      IdResult *idResult,
                      IdRef *signedValue);
void ParseConvertUToF(const uint32_t *_instruction,
                      IdResultType *idResultType,
                      IdResult *idResult,
                      IdRef *unsignedValue);
void ParseUConvert(const uint32_t *_instruction,
                   IdResultType *idResultType,
                   IdResult *idResult,
                   IdRef *unsignedValue);
void ParseSConvert(const uint32_t *_instruction,
                   IdResultType *idResultType,
                   IdResult *idResult,
                   IdRef *signedValue);
void ParseFConvert(const uint32_t *_instruction,
                   IdResultType *idResultType,
                   IdResult *idResult,
                   IdRef *floatValue);
void ParseQuantizeToF16(const uint32_t *_instruction,
                        IdResultType *idResultType,
                        IdResult *idResult,
                        IdRef *value);
void ParseConvertPtrToU(const uint32_t *_instruction,
                        IdResultType *idResultType,
                        IdResult *idResult,
                        IdRef *pointer);
void ParseConvertUToPtr(const uint32_t *_instruction,
                        IdResultType *idResultType,
                        IdResult *idResult,
                        IdRef *integerValue);
void ParseBitcast(const uint32_t *_instruction,
                  IdResultType *idResultType,
                  IdResult *idResult,
                  IdRef *operand);
void ParseSNegate(const uint32_t *_instruction,
                  IdResultType *idResultType,
                  IdResult *idResult,
                  IdRef *operand);
void ParseFNegate(const uint32_t *_instruction,
                  IdResultType *idResultType,
                  IdResult *idResult,
                  IdRef *operand);
void ParseIAdd(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseFAdd(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseISub(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseFSub(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseIMul(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseFMul(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseUDiv(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseSDiv(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseFDiv(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseUMod(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseSRem(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseSMod(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseFRem(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseFMod(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *operand1,
               IdRef *operand2);
void ParseVectorTimesScalar(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult,
                            IdRef *vector,
                            IdRef *scalar);
void ParseMatrixTimesScalar(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult,
                            IdRef *matrix,
                            IdRef *scalar);
void ParseVectorTimesMatrix(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult,
                            IdRef *vector,
                            IdRef *matrix);
void ParseMatrixTimesVector(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult,
                            IdRef *matrix,
                            IdRef *vector);
void ParseMatrixTimesMatrix(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult,
                            IdRef *leftMatrix,
                            IdRef *rightMatrix);
void ParseOuterProduct(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult,
                       IdRef *vector1,
                       IdRef *vector2);
void ParseDot(const uint32_t *_instruction,
              IdResultType *idResultType,
              IdResult *idResult,
              IdRef *vector1,
              IdRef *vector2);
void ParseIAddCarry(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseISubBorrow(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *operand1,
                     IdRef *operand2);
void ParseUMulExtended(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseSMulExtended(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseAny(const uint32_t *_instruction,
              IdResultType *idResultType,
              IdResult *idResult,
              IdRef *vector);
void ParseAll(const uint32_t *_instruction,
              IdResultType *idResultType,
              IdResult *idResult,
              IdRef *vector);
void ParseIsNan(const uint32_t *_instruction,
                IdResultType *idResultType,
                IdResult *idResult,
                IdRef *x);
void ParseIsInf(const uint32_t *_instruction,
                IdResultType *idResultType,
                IdResult *idResult,
                IdRef *x);
void ParseLogicalEqual(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseLogicalNotEqual(const uint32_t *_instruction,
                          IdResultType *idResultType,
                          IdResult *idResult,
                          IdRef *operand1,
                          IdRef *operand2);
void ParseLogicalOr(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseLogicalAnd(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *operand1,
                     IdRef *operand2);
void ParseLogicalNot(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *operand);
void ParseSelect(const uint32_t *_instruction,
                 IdResultType *idResultType,
                 IdResult *idResult,
                 IdRef *condition,
                 IdRef *object1,
                 IdRef *object2);
void ParseIEqual(const uint32_t *_instruction,
                 IdResultType *idResultType,
                 IdResult *idResult,
                 IdRef *operand1,
                 IdRef *operand2);
void ParseINotEqual(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseUGreaterThan(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseSGreaterThan(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseUGreaterThanEqual(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult,
                            IdRef *operand1,
                            IdRef *operand2);
void ParseSGreaterThanEqual(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult,
                            IdRef *operand1,
                            IdRef *operand2);
void ParseULessThan(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseSLessThan(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseULessThanEqual(const uint32_t *_instruction,
                         IdResultType *idResultType,
                         IdResult *idResult,
                         IdRef *operand1,
                         IdRef *operand2);
void ParseSLessThanEqual(const uint32_t *_instruction,
                         IdResultType *idResultType,
                         IdResult *idResult,
                         IdRef *operand1,
                         IdRef *operand2);
void ParseFOrdEqual(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseFUnordEqual(const uint32_t *_instruction,
                      IdResultType *idResultType,
                      IdResult *idResult,
                      IdRef *operand1,
                      IdRef *operand2);
void ParseFOrdNotEqual(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseFUnordNotEqual(const uint32_t *_instruction,
                         IdResultType *idResultType,
                         IdResult *idResult,
                         IdRef *operand1,
                         IdRef *operand2);
void ParseFOrdLessThan(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult,
                       IdRef *operand1,
                       IdRef *operand2);
void ParseFUnordLessThan(const uint32_t *_instruction,
                         IdResultType *idResultType,
                         IdResult *idResult,
                         IdRef *operand1,
                         IdRef *operand2);
void ParseFOrdGreaterThan(const uint32_t *_instruction,
                          IdResultType *idResultType,
                          IdResult *idResult,
                          IdRef *operand1,
                          IdRef *operand2);
void ParseFUnordGreaterThan(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult,
                            IdRef *operand1,
                            IdRef *operand2);
void ParseFOrdLessThanEqual(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult,
                            IdRef *operand1,
                            IdRef *operand2);
void ParseFUnordLessThanEqual(const uint32_t *_instruction,
                              IdResultType *idResultType,
                              IdResult *idResult,
                              IdRef *operand1,
                              IdRef *operand2);
void ParseFOrdGreaterThanEqual(const uint32_t *_instruction,
                               IdResultType *idResultType,
                               IdResult *idResult,
                               IdRef *operand1,
                               IdRef *operand2);
void ParseFUnordGreaterThanEqual(const uint32_t *_instruction,
                                 IdResultType *idResultType,
                                 IdResult *idResult,
                                 IdRef *operand1,
                                 IdRef *operand2);
void ParseShiftRightLogical(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult,
                            IdRef *base,
                            IdRef *shift);
void ParseShiftRightArithmetic(const uint32_t *_instruction,
                               IdResultType *idResultType,
                               IdResult *idResult,
                               IdRef *base,
                               IdRef *shift);
void ParseShiftLeftLogical(const uint32_t *_instruction,
                           IdResultType *idResultType,
                           IdResult *idResult,
                           IdRef *base,
                           IdRef *shift);
void ParseBitwiseOr(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdRef *operand1,
                    IdRef *operand2);
void ParseBitwiseXor(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *operand1,
                     IdRef *operand2);
void ParseBitwiseAnd(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *operand1,
                     IdRef *operand2);
void ParseNot(const uint32_t *_instruction,
              IdResultType *idResultType,
              IdResult *idResult,
              IdRef *operand);
void ParseBitFieldInsert(const uint32_t *_instruction,
                         IdResultType *idResultType,
                         IdResult *idResult,
                         IdRef *base,
                         IdRef *insert,
                         IdRef *offset,
                         IdRef *count);
void ParseBitFieldSExtract(const uint32_t *_instruction,
                           IdResultType *idResultType,
                           IdResult *idResult,
                           IdRef *base,
                           IdRef *offset,
                           IdRef *count);
void ParseBitFieldUExtract(const uint32_t *_instruction,
                           IdResultType *idResultType,
                           IdResult *idResult,
                           IdRef *base,
                           IdRef *offset,
                           IdRef *count);
void ParseBitReverse(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *base);
void ParseBitCount(const uint32_t *_instruction,
                   IdResultType *idResultType,
                   IdResult *idResult,
                   IdRef *base);
void ParseDPdx(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *p);
void ParseDPdy(const uint32_t *_instruction,
               IdResultType *idResultType,
               IdResult *idResult,
               IdRef *p);
void ParseFwidth(const uint32_t *_instruction,
                 IdResultType *idResultType,
                 IdResult *idResult,
                 IdRef *p);
void ParseDPdxFine(const uint32_t *_instruction,
                   IdResultType *idResultType,
                   IdResult *idResult,
                   IdRef *p);
void ParseDPdyFine(const uint32_t *_instruction,
                   IdResultType *idResultType,
                   IdResult *idResult,
                   IdRef *p);
void ParseFwidthFine(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *p);
void ParseDPdxCoarse(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *p);
void ParseDPdyCoarse(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *p);
void ParseFwidthCoarse(const uint32_t *_instruction,
                       IdResultType *idResultType,
                       IdResult *idResult,
                       IdRef *p);
void ParseEmitStreamVertex(const uint32_t *_instruction, IdRef *stream);
void ParseEndStreamPrimitive(const uint32_t *_instruction, IdRef *stream);
void ParseControlBarrier(const uint32_t *_instruction,
                         IdScope *execution,
                         IdScope *memory,
                         IdMemorySemantics *semantics);
void ParseMemoryBarrier(const uint32_t *_instruction,
                        IdScope *memory,
                        IdMemorySemantics *semantics);
void ParseAtomicLoad(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *pointer,
                     IdScope *scope,
                     IdMemorySemantics *semantics);
void ParseAtomicStore(const uint32_t *_instruction,
                      IdRef *pointer,
                      IdScope *scope,
                      IdMemorySemantics *semantics,
                      IdRef *value);
void ParseAtomicExchange(const uint32_t *_instruction,
                         IdResultType *idResultType,
                         IdResult *idResult,
                         IdRef *pointer,
                         IdScope *scope,
                         IdMemorySemantics *semantics,
                         IdRef *value);
void ParseAtomicCompareExchange(const uint32_t *_instruction,
                                IdResultType *idResultType,
                                IdResult *idResult,
                                IdRef *pointer,
                                IdScope *scope,
                                IdMemorySemantics *equal,
                                IdMemorySemantics *unequal,
                                IdRef *value,
                                IdRef *comparator);
void ParseAtomicIIncrement(const uint32_t *_instruction,
                           IdResultType *idResultType,
                           IdResult *idResult,
                           IdRef *pointer,
                           IdScope *scope,
                           IdMemorySemantics *semantics);
void ParseAtomicIDecrement(const uint32_t *_instruction,
                           IdResultType *idResultType,
                           IdResult *idResult,
                           IdRef *pointer,
                           IdScope *scope,
                           IdMemorySemantics *semantics);
void ParseAtomicIAdd(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *pointer,
                     IdScope *scope,
                     IdMemorySemantics *semantics,
                     IdRef *value);
void ParseAtomicISub(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *pointer,
                     IdScope *scope,
                     IdMemorySemantics *semantics,
                     IdRef *value);
void ParseAtomicSMin(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *pointer,
                     IdScope *scope,
                     IdMemorySemantics *semantics,
                     IdRef *value);
void ParseAtomicUMin(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *pointer,
                     IdScope *scope,
                     IdMemorySemantics *semantics,
                     IdRef *value);
void ParseAtomicSMax(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *pointer,
                     IdScope *scope,
                     IdMemorySemantics *semantics,
                     IdRef *value);
void ParseAtomicUMax(const uint32_t *_instruction,
                     IdResultType *idResultType,
                     IdResult *idResult,
                     IdRef *pointer,
                     IdScope *scope,
                     IdMemorySemantics *semantics,
                     IdRef *value);
void ParseAtomicAnd(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdRef *pointer,
                    IdScope *scope,
                    IdMemorySemantics *semantics,
                    IdRef *value);
void ParseAtomicOr(const uint32_t *_instruction,
                   IdResultType *idResultType,
                   IdResult *idResult,
                   IdRef *pointer,
                   IdScope *scope,
                   IdMemorySemantics *semantics,
                   IdRef *value);
void ParseAtomicXor(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdRef *pointer,
                    IdScope *scope,
                    IdMemorySemantics *semantics,
                    IdRef *value);
void ParsePhi(const uint32_t *_instruction,
              IdResultType *idResultType,
              IdResult *idResult,
              PairIdRefIdRefList *variableParentPairList);
void ParseLoopMerge(const uint32_t *_instruction,
                    IdRef *mergeBlock,
                    IdRef *continueTarget,
                    spv::LoopControlMask *loopControl);
void ParseSelectionMerge(const uint32_t *_instruction,
                         IdRef *mergeBlock,
                         spv::SelectionControlMask *selectionControl);
void ParseLabel(const uint32_t *_instruction, IdResult *idResult);
void ParseBranch(const uint32_t *_instruction, IdRef *targetLabel);
void ParseBranchConditional(const uint32_t *_instruction,
                            IdRef *condition,
                            IdRef *trueLabel,
                            IdRef *falseLabel,
                            LiteralIntegerList *branchweightsPairList);
void ParseSwitch(const uint32_t *_instruction,
                 IdRef *selector,
                 IdRef *default_,
                 PairLiteralIntegerIdRefList *targetPairList);
void ParseReturnValue(const uint32_t *_instruction, IdRef *value);
void ParseGroupAll(const uint32_t *_instruction,
                   IdResultType *idResultType,
                   IdResult *idResult,
                   IdScope *execution,
                   IdRef *predicate);
void ParseGroupAny(const uint32_t *_instruction,
                   IdResultType *idResultType,
                   IdResult *idResult,
                   IdScope *execution,
                   IdRef *predicate);
void ParseGroupBroadcast(const uint32_t *_instruction,
                         IdResultType *idResultType,
                         IdResult *idResult,
                         IdScope *execution,
                         IdRef *value,
                         IdRef *localId);
void ParseGroupIAdd(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdScope *execution,
                    spv::GroupOperation *operation,
                    IdRef *x);
void ParseGroupFAdd(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdScope *execution,
                    spv::GroupOperation *operation,
                    IdRef *x);
void ParseGroupFMin(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdScope *execution,
                    spv::GroupOperation *operation,
                    IdRef *x);
void ParseGroupUMin(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdScope *execution,
                    spv::GroupOperation *operation,
                    IdRef *x);
void ParseGroupSMin(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdScope *execution,
                    spv::GroupOperation *operation,
                    IdRef *x);
void ParseGroupFMax(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdScope *execution,
                    spv::GroupOperation *operation,
                    IdRef *x);
void ParseGroupUMax(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdScope *execution,
                    spv::GroupOperation *operation,
                    IdRef *x);
void ParseGroupSMax(const uint32_t *_instruction,
                    IdResultType *idResultType,
                    IdResult *idResult,
                    IdScope *execution,
                    spv::GroupOperation *operation,
                    IdRef *x);
void ParseImageSparseSampleImplicitLod(const uint32_t *_instruction,
                                       IdResultType *idResultType,
                                       IdResult *idResult,
                                       IdRef *sampledImage,
                                       IdRef *coordinate,
                                       spv::ImageOperandsMask *imageOperands,
                                       IdRefList *imageOperandIdsList);
void ParseImageSparseSampleExplicitLod(const uint32_t *_instruction,
                                       IdResultType *idResultType,
                                       IdResult *idResult,
                                       IdRef *sampledImage,
                                       IdRef *coordinate,
                                       spv::ImageOperandsMask *imageOperands,
                                       IdRefList *imageOperandIdsList);
void ParseImageSparseSampleDrefImplicitLod(const uint32_t *_instruction,
                                           IdResultType *idResultType,
                                           IdResult *idResult,
                                           IdRef *sampledImage,
                                           IdRef *coordinate,
                                           IdRef *dref,
                                           spv::ImageOperandsMask *imageOperands,
                                           IdRefList *imageOperandIdsList);
void ParseImageSparseSampleDrefExplicitLod(const uint32_t *_instruction,
                                           IdResultType *idResultType,
                                           IdResult *idResult,
                                           IdRef *sampledImage,
                                           IdRef *coordinate,
                                           IdRef *dref,
                                           spv::ImageOperandsMask *imageOperands,
                                           IdRefList *imageOperandIdsList);
void ParseImageSparseSampleProjImplicitLod(const uint32_t *_instruction,
                                           IdResultType *idResultType,
                                           IdResult *idResult,
                                           IdRef *sampledImage,
                                           IdRef *coordinate,
                                           spv::ImageOperandsMask *imageOperands,
                                           IdRefList *imageOperandIdsList);
void ParseImageSparseSampleProjExplicitLod(const uint32_t *_instruction,
                                           IdResultType *idResultType,
                                           IdResult *idResult,
                                           IdRef *sampledImage,
                                           IdRef *coordinate,
                                           spv::ImageOperandsMask *imageOperands,
                                           IdRefList *imageOperandIdsList);
void ParseImageSparseSampleProjDrefImplicitLod(const uint32_t *_instruction,
                                               IdResultType *idResultType,
                                               IdResult *idResult,
                                               IdRef *sampledImage,
                                               IdRef *coordinate,
                                               IdRef *dref,
                                               spv::ImageOperandsMask *imageOperands,
                                               IdRefList *imageOperandIdsList);
void ParseImageSparseSampleProjDrefExplicitLod(const uint32_t *_instruction,
                                               IdResultType *idResultType,
                                               IdResult *idResult,
                                               IdRef *sampledImage,
                                               IdRef *coordinate,
                                               IdRef *dref,
                                               spv::ImageOperandsMask *imageOperands,
                                               IdRefList *imageOperandIdsList);
void ParseImageSparseFetch(const uint32_t *_instruction,
                           IdResultType *idResultType,
                           IdResult *idResult,
                           IdRef *image,
                           IdRef *coordinate,
                           spv::ImageOperandsMask *imageOperands,
                           IdRefList *imageOperandIdsList);
void ParseImageSparseGather(const uint32_t *_instruction,
                            IdResultType *idResultType,
                            IdResult *idResult,
                            IdRef *sampledImage,
                            IdRef *coordinate,
                            IdRef *component,
                            spv::ImageOperandsMask *imageOperands,
                            IdRefList *imageOperandIdsList);
void ParseImageSparseDrefGather(const uint32_t *_instruction,
                                IdResultType *idResultType,
                                IdResult *idResult,
                                IdRef *sampledImage,
                                IdRef *coordinate,
                                IdRef *dref,
                                spv::ImageOperandsMask *imageOperands,
                                IdRefList *imageOperandIdsList);
void ParseImageSparseTexelsResident(const uint32_t *_instruction,
                                    IdResultType *idResultType,
                                    IdResult *idResult,
                                    IdRef *residentCode);
void ParseImageSparseRead(const uint32_t *_instruction,
                          IdResultType *idResultType,
                          IdResult *idResult,
                          IdRef *image,
                          IdRef *coordinate,
                          spv::ImageOperandsMask *imageOperands,
                          IdRefList *imageOperandIdsList);
void ParseGroupIAddNonUniformAMD(const uint32_t *_instruction,
                                 IdResultType *idResultType,
                                 IdResult *idResult,
                                 IdScope *execution,
                                 spv::GroupOperation *operation,
                                 IdRef *x);
void ParseGroupFAddNonUniformAMD(const uint32_t *_instruction,
                                 IdResultType *idResultType,
                                 IdResult *idResult,
                                 IdScope *execution,
                                 spv::GroupOperation *operation,
                                 IdRef *x);
void ParseGroupFMinNonUniformAMD(const uint32_t *_instruction,
                                 IdResultType *idResultType,
                                 IdResult *idResult,
                                 IdScope *execution,
                                 spv::GroupOperation *operation,
                                 IdRef *x);
void ParseGroupUMinNonUniformAMD(const uint32_t *_instruction,
                                 IdResultType *idResultType,
                                 IdResult *idResult,
                                 IdScope *execution,
                                 spv::GroupOperation *operation,
                                 IdRef *x);
void ParseGroupSMinNonUniformAMD(const uint32_t *_instruction,
                                 IdResultType *idResultType,
                                 IdResult *idResult,
                                 IdScope *execution,
                                 spv::GroupOperation *operation,
                                 IdRef *x);
void ParseGroupFMaxNonUniformAMD(const uint32_t *_instruction,
                                 IdResultType *idResultType,
                                 IdResult *idResult,
                                 IdScope *execution,
                                 spv::GroupOperation *operation,
                                 IdRef *x);
void ParseGroupUMaxNonUniformAMD(const uint32_t *_instruction,
                                 IdResultType *idResultType,
                                 IdResult *idResult,
                                 IdScope *execution,
                                 spv::GroupOperation *operation,
                                 IdRef *x);
void ParseGroupSMaxNonUniformAMD(const uint32_t *_instruction,
                                 IdResultType *idResultType,
                                 IdResult *idResult,
                                 IdScope *execution,
                                 spv::GroupOperation *operation,
                                 IdRef *x);

}  // namespace spirv
}  // namespace angle

#endif  // COMMON_SPIRV_SPIRVINSTRUCTIONPARSERAUTOGEN_H_
