// GENERATED FILE - DO NOT EDIT.
// Generated by gen_spirv_builder_and_parser.py using data from spirv.core.grammar.json.
//
// Copyright 2021 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// spirv_instruction_builder_autogen.cpp:
//   Functions to generate SPIR-V binary for each instruction.

#include "spirv_instruction_builder_autogen.h"

#include <string.h>

#include "common/debug.h"

namespace angle
{
namespace spirv
{
namespace
{
uint32_t MakeLengthOp(size_t length, spv::Op op)
{
    ASSERT(length <= 0xFFFFu);
    ASSERT(op <= 0xFFFFu);

    return static_cast<uint32_t>(length) << 16 | op;
}
}  // anonymous namespace

void WriteNop(std::vector<uint32_t> *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpNop);
}
void WriteUndef(std::vector<uint32_t> *blob, IdResultType idResultType, IdResult idResult)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUndef);
}
void WriteSourceContinued(std::vector<uint32_t> *blob, LiteralString continuedSource)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(continuedSource) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), continuedSource);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSourceContinued);
}
void WriteSource(std::vector<uint32_t> *blob,
                 spv::SourceLanguage sourceLanguage,
                 LiteralInteger version,
                 const IdRef *file,
                 const LiteralString *source)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(sourceLanguage);
    blob->push_back(version);
    if (file)
    {
        blob->push_back(*file);
    }
    if (source)
    {
        {
            size_t d = blob->size();
            blob->resize(d + strlen(*source) / 4 + 1, 0);
            ASSERT(IsLittleEndian());
            strcpy(reinterpret_cast<char *>(blob->data() + d), *source);
        }
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSource);
}
void WriteSourceExtension(std::vector<uint32_t> *blob, LiteralString extension)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(extension) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), extension);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSourceExtension);
}
void WriteName(std::vector<uint32_t> *blob, IdRef target, LiteralString name)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(target);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(name) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), name);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpName);
}
void WriteMemberName(std::vector<uint32_t> *blob,
                     IdRef type,
                     LiteralInteger member,
                     LiteralString name)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(type);
    blob->push_back(member);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(name) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), name);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMemberName);
}
void WriteString(std::vector<uint32_t> *blob, IdResult idResult, LiteralString string)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(string) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), string);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpString);
}
void WriteLine(std::vector<uint32_t> *blob, IdRef file, LiteralInteger line, LiteralInteger column)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(file);
    blob->push_back(line);
    blob->push_back(column);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLine);
}
void WriteExtension(std::vector<uint32_t> *blob, LiteralString name)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(name) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), name);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpExtension);
}
void WriteExtInstImport(std::vector<uint32_t> *blob, IdResult idResult, LiteralString name)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(name) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), name);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpExtInstImport);
}
void WriteExtInst(std::vector<uint32_t> *blob,
                  IdResultType idResultType,
                  IdResult idResult,
                  IdRef set,
                  LiteralExtInstInteger instruction,
                  const IdRefList &operandList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(set);
    blob->push_back(instruction);
    for (const auto &operand : operandList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpExtInst);
}
void WriteMemoryModel(std::vector<uint32_t> *blob,
                      spv::AddressingModel addressingModel,
                      spv::MemoryModel memoryModel)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(addressingModel);
    blob->push_back(memoryModel);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMemoryModel);
}
void WriteEntryPoint(std::vector<uint32_t> *blob,
                     spv::ExecutionModel executionModel,
                     IdRef entryPoint,
                     LiteralString name,
                     const IdRefList &interfaceList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(executionModel);
    blob->push_back(entryPoint);
    {
        size_t d = blob->size();
        blob->resize(d + strlen(name) / 4 + 1, 0);
        ASSERT(IsLittleEndian());
        strcpy(reinterpret_cast<char *>(blob->data() + d), name);
    }
    for (const auto &operand : interfaceList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpEntryPoint);
}
void WriteExecutionMode(std::vector<uint32_t> *blob, IdRef entryPoint, spv::ExecutionMode mode)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(entryPoint);
    blob->push_back(mode);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpExecutionMode);
}
void WriteCapability(std::vector<uint32_t> *blob, spv::Capability capability)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(capability);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCapability);
}
void WriteTypeVoid(std::vector<uint32_t> *blob, IdResult idResult)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeVoid);
}
void WriteTypeBool(std::vector<uint32_t> *blob, IdResult idResult)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeBool);
}
void WriteTypeInt(std::vector<uint32_t> *blob,
                  IdResult idResult,
                  LiteralInteger width,
                  LiteralInteger signedness)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    blob->push_back(width);
    blob->push_back(signedness);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeInt);
}
void WriteTypeFloat(std::vector<uint32_t> *blob, IdResult idResult, LiteralInteger width)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    blob->push_back(width);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeFloat);
}
void WriteTypeVector(std::vector<uint32_t> *blob,
                     IdResult idResult,
                     IdRef componentType,
                     LiteralInteger componentCount)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    blob->push_back(componentType);
    blob->push_back(componentCount);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeVector);
}
void WriteTypeMatrix(std::vector<uint32_t> *blob,
                     IdResult idResult,
                     IdRef columnType,
                     LiteralInteger columnCount)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    blob->push_back(columnType);
    blob->push_back(columnCount);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeMatrix);
}
void WriteTypeImage(std::vector<uint32_t> *blob,
                    IdResult idResult,
                    IdRef sampledType,
                    spv::Dim dim,
                    LiteralInteger depth,
                    LiteralInteger arrayed,
                    LiteralInteger mS,
                    LiteralInteger sampled,
                    spv::ImageFormat imageFormat,
                    const spv::AccessQualifier *accessQualifier)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    blob->push_back(sampledType);
    blob->push_back(dim);
    blob->push_back(depth);
    blob->push_back(arrayed);
    blob->push_back(mS);
    blob->push_back(sampled);
    blob->push_back(imageFormat);
    if (accessQualifier)
    {
        blob->push_back(*accessQualifier);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeImage);
}
void WriteTypeSampler(std::vector<uint32_t> *blob, IdResult idResult)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeSampler);
}
void WriteTypeSampledImage(std::vector<uint32_t> *blob, IdResult idResult, IdRef imageType)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    blob->push_back(imageType);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeSampledImage);
}
void WriteTypeArray(std::vector<uint32_t> *blob, IdResult idResult, IdRef elementType, IdRef length)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    blob->push_back(elementType);
    blob->push_back(length);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeArray);
}
void WriteTypeRuntimeArray(std::vector<uint32_t> *blob, IdResult idResult, IdRef elementType)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    blob->push_back(elementType);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeRuntimeArray);
}
void WriteTypeStruct(std::vector<uint32_t> *blob, IdResult idResult, const IdRefList &memberList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    for (const auto &operand : memberList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeStruct);
}
void WriteTypePointer(std::vector<uint32_t> *blob,
                      IdResult idResult,
                      spv::StorageClass storageClass,
                      IdRef type)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    blob->push_back(storageClass);
    blob->push_back(type);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypePointer);
}
void WriteTypeFunction(std::vector<uint32_t> *blob,
                       IdResult idResult,
                       IdRef returnType,
                       const IdRefList &parameterList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    blob->push_back(returnType);
    for (const auto &operand : parameterList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeFunction);
}
void WriteTypeForwardPointer(std::vector<uint32_t> *blob,
                             IdRef pointerType,
                             spv::StorageClass storageClass)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(pointerType);
    blob->push_back(storageClass);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTypeForwardPointer);
}
void WriteConstantTrue(std::vector<uint32_t> *blob, IdResultType idResultType, IdResult idResult)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConstantTrue);
}
void WriteConstantFalse(std::vector<uint32_t> *blob, IdResultType idResultType, IdResult idResult)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConstantFalse);
}
void WriteConstant(std::vector<uint32_t> *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   LiteralContextDependentNumber value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConstant);
}
void WriteConstantComposite(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            const IdRefList &constituentsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    for (const auto &operand : constituentsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConstantComposite);
}
void WriteConstantNull(std::vector<uint32_t> *blob, IdResultType idResultType, IdResult idResult)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConstantNull);
}
void WriteSpecConstantTrue(std::vector<uint32_t> *blob,
                           IdResultType idResultType,
                           IdResult idResult)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSpecConstantTrue);
}
void WriteSpecConstantFalse(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSpecConstantFalse);
}
void WriteSpecConstant(std::vector<uint32_t> *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       LiteralContextDependentNumber value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSpecConstant);
}
void WriteSpecConstantComposite(std::vector<uint32_t> *blob,
                                IdResultType idResultType,
                                IdResult idResult,
                                const IdRefList &constituentsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    for (const auto &operand : constituentsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSpecConstantComposite);
}
void WriteFunction(std::vector<uint32_t> *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   spv::FunctionControlMask functionControl,
                   IdRef functionType)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(functionControl);
    blob->push_back(functionType);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFunction);
}
void WriteFunctionParameter(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFunctionParameter);
}
void WriteFunctionEnd(std::vector<uint32_t> *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFunctionEnd);
}
void WriteFunctionCall(std::vector<uint32_t> *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef function,
                       const IdRefList &argumentList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(function);
    for (const auto &operand : argumentList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFunctionCall);
}
void WriteVariable(std::vector<uint32_t> *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   spv::StorageClass storageClass,
                   const IdRef *initializer)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(storageClass);
    if (initializer)
    {
        blob->push_back(*initializer);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpVariable);
}
void WriteImageTexelPointer(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef image,
                            IdRef coordinate,
                            IdRef sample)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(image);
    blob->push_back(coordinate);
    blob->push_back(sample);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageTexelPointer);
}
void WriteLoad(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef pointer,
               const spv::MemoryAccessMask *memoryAccess)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    if (memoryAccess)
    {
        blob->push_back(*memoryAccess);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLoad);
}
void WriteStore(std::vector<uint32_t> *blob,
                IdRef pointer,
                IdRef object,
                const spv::MemoryAccessMask *memoryAccess)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(pointer);
    blob->push_back(object);
    if (memoryAccess)
    {
        blob->push_back(*memoryAccess);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpStore);
}
void WriteCopyMemory(std::vector<uint32_t> *blob,
                     IdRef target,
                     IdRef source,
                     const spv::MemoryAccessMask *memoryAccess)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(target);
    blob->push_back(source);
    if (memoryAccess)
    {
        blob->push_back(*memoryAccess);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCopyMemory);
}
void WriteCopyMemorySized(std::vector<uint32_t> *blob,
                          IdRef target,
                          IdRef source,
                          IdRef size,
                          const spv::MemoryAccessMask *memoryAccess)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(target);
    blob->push_back(source);
    blob->push_back(size);
    if (memoryAccess)
    {
        blob->push_back(*memoryAccess);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCopyMemorySized);
}
void WriteAccessChain(std::vector<uint32_t> *blob,
                      IdResultType idResultType,
                      IdResult idResult,
                      IdRef base,
                      const IdRefList &indexesList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(base);
    for (const auto &operand : indexesList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAccessChain);
}
void WriteInBoundsAccessChain(std::vector<uint32_t> *blob,
                              IdResultType idResultType,
                              IdResult idResult,
                              IdRef base,
                              const IdRefList &indexesList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(base);
    for (const auto &operand : indexesList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpInBoundsAccessChain);
}
void WriteArrayLength(std::vector<uint32_t> *blob,
                      IdResultType idResultType,
                      IdResult idResult,
                      IdRef structure,
                      LiteralInteger arraymember)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(structure);
    blob->push_back(arraymember);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpArrayLength);
}
void WriteInBoundsPtrAccessChain(std::vector<uint32_t> *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdRef base,
                                 IdRef element,
                                 const IdRefList &indexesList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(base);
    blob->push_back(element);
    for (const auto &operand : indexesList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpInBoundsPtrAccessChain);
}
void WriteDecorate(std::vector<uint32_t> *blob,
                   IdRef target,
                   spv::Decoration decoration,
                   const LiteralIntegerList &valuesPairList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(target);
    blob->push_back(decoration);
    for (const auto &operand : valuesPairList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDecorate);
}
void WriteMemberDecorate(std::vector<uint32_t> *blob,
                         IdRef structureType,
                         LiteralInteger member,
                         spv::Decoration decoration,
                         const LiteralIntegerList &valuesPairList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(structureType);
    blob->push_back(member);
    blob->push_back(decoration);
    for (const auto &operand : valuesPairList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMemberDecorate);
}
void WriteDecorationGroup(std::vector<uint32_t> *blob, IdResult idResult)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDecorationGroup);
}
void WriteGroupDecorate(std::vector<uint32_t> *blob,
                        IdRef decorationGroup,
                        const IdRefList &targetsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(decorationGroup);
    for (const auto &operand : targetsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupDecorate);
}
void WriteGroupMemberDecorate(std::vector<uint32_t> *blob,
                              IdRef decorationGroup,
                              const PairIdRefLiteralIntegerList &targetsPairList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(decorationGroup);
    for (const auto &operand : targetsPairList)
    {
        blob->push_back(operand.id);
        blob->push_back(operand.literal);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupMemberDecorate);
}
void WriteVectorExtractDynamic(std::vector<uint32_t> *blob,
                               IdResultType idResultType,
                               IdResult idResult,
                               IdRef vector,
                               IdRef index)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(vector);
    blob->push_back(index);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpVectorExtractDynamic);
}
void WriteVectorInsertDynamic(std::vector<uint32_t> *blob,
                              IdResultType idResultType,
                              IdResult idResult,
                              IdRef vector,
                              IdRef component,
                              IdRef index)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(vector);
    blob->push_back(component);
    blob->push_back(index);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpVectorInsertDynamic);
}
void WriteVectorShuffle(std::vector<uint32_t> *blob,
                        IdResultType idResultType,
                        IdResult idResult,
                        IdRef vector1,
                        IdRef vector2,
                        const LiteralIntegerList &componentsPairList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(vector1);
    blob->push_back(vector2);
    for (const auto &operand : componentsPairList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpVectorShuffle);
}
void WriteCompositeConstruct(std::vector<uint32_t> *blob,
                             IdResultType idResultType,
                             IdResult idResult,
                             const IdRefList &constituentsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    for (const auto &operand : constituentsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCompositeConstruct);
}
void WriteCompositeExtract(std::vector<uint32_t> *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef composite,
                           const LiteralIntegerList &indexesPairList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(composite);
    for (const auto &operand : indexesPairList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCompositeExtract);
}
void WriteCompositeInsert(std::vector<uint32_t> *blob,
                          IdResultType idResultType,
                          IdResult idResult,
                          IdRef object,
                          IdRef composite,
                          const LiteralIntegerList &indexesPairList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(object);
    blob->push_back(composite);
    for (const auto &operand : indexesPairList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCompositeInsert);
}
void WriteCopyObject(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef operand)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpCopyObject);
}
void WriteTranspose(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef matrix)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(matrix);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpTranspose);
}
void WriteSampledImage(std::vector<uint32_t> *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef image,
                       IdRef sampler)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(image);
    blob->push_back(sampler);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSampledImage);
}
void WriteImageSampleImplicitLod(std::vector<uint32_t> *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdRef sampledImage,
                                 IdRef coordinate,
                                 const spv::ImageOperandsMask *imageOperands,
                                 const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSampleImplicitLod);
}
void WriteImageSampleExplicitLod(std::vector<uint32_t> *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdRef sampledImage,
                                 IdRef coordinate,
                                 spv::ImageOperandsMask imageOperands,
                                 const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(imageOperands);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSampleExplicitLod);
}
void WriteImageSampleDrefImplicitLod(std::vector<uint32_t> *blob,
                                     IdResultType idResultType,
                                     IdResult idResult,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     IdRef dref,
                                     const spv::ImageOperandsMask *imageOperands,
                                     const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSampleDrefImplicitLod);
}
void WriteImageSampleDrefExplicitLod(std::vector<uint32_t> *blob,
                                     IdResultType idResultType,
                                     IdResult idResult,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     IdRef dref,
                                     spv::ImageOperandsMask imageOperands,
                                     const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    blob->push_back(imageOperands);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSampleDrefExplicitLod);
}
void WriteImageSampleProjImplicitLod(std::vector<uint32_t> *blob,
                                     IdResultType idResultType,
                                     IdResult idResult,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     const spv::ImageOperandsMask *imageOperands,
                                     const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSampleProjImplicitLod);
}
void WriteImageSampleProjExplicitLod(std::vector<uint32_t> *blob,
                                     IdResultType idResultType,
                                     IdResult idResult,
                                     IdRef sampledImage,
                                     IdRef coordinate,
                                     spv::ImageOperandsMask imageOperands,
                                     const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(imageOperands);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSampleProjExplicitLod);
}
void WriteImageSampleProjDrefImplicitLod(std::vector<uint32_t> *blob,
                                         IdResultType idResultType,
                                         IdResult idResult,
                                         IdRef sampledImage,
                                         IdRef coordinate,
                                         IdRef dref,
                                         const spv::ImageOperandsMask *imageOperands,
                                         const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSampleProjDrefImplicitLod);
}
void WriteImageSampleProjDrefExplicitLod(std::vector<uint32_t> *blob,
                                         IdResultType idResultType,
                                         IdResult idResult,
                                         IdRef sampledImage,
                                         IdRef coordinate,
                                         IdRef dref,
                                         spv::ImageOperandsMask imageOperands,
                                         const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    blob->push_back(imageOperands);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSampleProjDrefExplicitLod);
}
void WriteImageFetch(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef image,
                     IdRef coordinate,
                     const spv::ImageOperandsMask *imageOperands,
                     const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(image);
    blob->push_back(coordinate);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageFetch);
}
void WriteImageGather(std::vector<uint32_t> *blob,
                      IdResultType idResultType,
                      IdResult idResult,
                      IdRef sampledImage,
                      IdRef coordinate,
                      IdRef component,
                      const spv::ImageOperandsMask *imageOperands,
                      const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(component);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageGather);
}
void WriteImageDrefGather(std::vector<uint32_t> *blob,
                          IdResultType idResultType,
                          IdResult idResult,
                          IdRef sampledImage,
                          IdRef coordinate,
                          IdRef dref,
                          const spv::ImageOperandsMask *imageOperands,
                          const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageDrefGather);
}
void WriteImageRead(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef image,
                    IdRef coordinate,
                    const spv::ImageOperandsMask *imageOperands,
                    const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(image);
    blob->push_back(coordinate);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageRead);
}
void WriteImageWrite(std::vector<uint32_t> *blob,
                     IdRef image,
                     IdRef coordinate,
                     IdRef texel,
                     const spv::ImageOperandsMask *imageOperands,
                     const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(image);
    blob->push_back(coordinate);
    blob->push_back(texel);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageWrite);
}
void WriteImage(std::vector<uint32_t> *blob,
                IdResultType idResultType,
                IdResult idResult,
                IdRef sampledImage)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImage);
}
void WriteImageQueryLod(std::vector<uint32_t> *blob,
                        IdResultType idResultType,
                        IdResult idResult,
                        IdRef sampledImage,
                        IdRef coordinate)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageQueryLod);
}
void WriteConvertFToU(std::vector<uint32_t> *blob,
                      IdResultType idResultType,
                      IdResult idResult,
                      IdRef floatValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(floatValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConvertFToU);
}
void WriteConvertFToS(std::vector<uint32_t> *blob,
                      IdResultType idResultType,
                      IdResult idResult,
                      IdRef floatValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(floatValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConvertFToS);
}
void WriteConvertSToF(std::vector<uint32_t> *blob,
                      IdResultType idResultType,
                      IdResult idResult,
                      IdRef signedValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(signedValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConvertSToF);
}
void WriteConvertUToF(std::vector<uint32_t> *blob,
                      IdResultType idResultType,
                      IdResult idResult,
                      IdRef unsignedValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(unsignedValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConvertUToF);
}
void WriteUConvert(std::vector<uint32_t> *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   IdRef unsignedValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(unsignedValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUConvert);
}
void WriteSConvert(std::vector<uint32_t> *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   IdRef signedValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(signedValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSConvert);
}
void WriteFConvert(std::vector<uint32_t> *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   IdRef floatValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(floatValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFConvert);
}
void WriteQuantizeToF16(std::vector<uint32_t> *blob,
                        IdResultType idResultType,
                        IdResult idResult,
                        IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpQuantizeToF16);
}
void WriteConvertPtrToU(std::vector<uint32_t> *blob,
                        IdResultType idResultType,
                        IdResult idResult,
                        IdRef pointer)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConvertPtrToU);
}
void WriteConvertUToPtr(std::vector<uint32_t> *blob,
                        IdResultType idResultType,
                        IdResult idResult,
                        IdRef integerValue)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(integerValue);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpConvertUToPtr);
}
void WriteBitcast(std::vector<uint32_t> *blob,
                  IdResultType idResultType,
                  IdResult idResult,
                  IdRef operand)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitcast);
}
void WriteSNegate(std::vector<uint32_t> *blob,
                  IdResultType idResultType,
                  IdResult idResult,
                  IdRef operand)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSNegate);
}
void WriteFNegate(std::vector<uint32_t> *blob,
                  IdResultType idResultType,
                  IdResult idResult,
                  IdRef operand)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFNegate);
}
void WriteIAdd(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpIAdd);
}
void WriteFAdd(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFAdd);
}
void WriteISub(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpISub);
}
void WriteFSub(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFSub);
}
void WriteIMul(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpIMul);
}
void WriteFMul(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFMul);
}
void WriteUDiv(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUDiv);
}
void WriteSDiv(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSDiv);
}
void WriteFDiv(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFDiv);
}
void WriteUMod(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUMod);
}
void WriteSRem(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSRem);
}
void WriteSMod(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSMod);
}
void WriteFRem(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFRem);
}
void WriteFMod(std::vector<uint32_t> *blob,
               IdResultType idResultType,
               IdResult idResult,
               IdRef operand1,
               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFMod);
}
void WriteVectorTimesScalar(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef vector,
                            IdRef scalar)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(vector);
    blob->push_back(scalar);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpVectorTimesScalar);
}
void WriteMatrixTimesScalar(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef matrix,
                            IdRef scalar)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(matrix);
    blob->push_back(scalar);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMatrixTimesScalar);
}
void WriteVectorTimesMatrix(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef vector,
                            IdRef matrix)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(vector);
    blob->push_back(matrix);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpVectorTimesMatrix);
}
void WriteMatrixTimesVector(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef matrix,
                            IdRef vector)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(matrix);
    blob->push_back(vector);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMatrixTimesVector);
}
void WriteMatrixTimesMatrix(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef leftMatrix,
                            IdRef rightMatrix)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(leftMatrix);
    blob->push_back(rightMatrix);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMatrixTimesMatrix);
}
void WriteOuterProduct(std::vector<uint32_t> *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef vector1,
                       IdRef vector2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(vector1);
    blob->push_back(vector2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpOuterProduct);
}
void WriteDot(std::vector<uint32_t> *blob,
              IdResultType idResultType,
              IdResult idResult,
              IdRef vector1,
              IdRef vector2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(vector1);
    blob->push_back(vector2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDot);
}
void WriteIAddCarry(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpIAddCarry);
}
void WriteISubBorrow(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef operand1,
                     IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpISubBorrow);
}
void WriteUMulExtended(std::vector<uint32_t> *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUMulExtended);
}
void WriteSMulExtended(std::vector<uint32_t> *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSMulExtended);
}
void WriteAny(std::vector<uint32_t> *blob,
              IdResultType idResultType,
              IdResult idResult,
              IdRef vector)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(vector);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAny);
}
void WriteAll(std::vector<uint32_t> *blob,
              IdResultType idResultType,
              IdResult idResult,
              IdRef vector)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(vector);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAll);
}
void WriteIsNan(std::vector<uint32_t> *blob, IdResultType idResultType, IdResult idResult, IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpIsNan);
}
void WriteIsInf(std::vector<uint32_t> *blob, IdResultType idResultType, IdResult idResult, IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpIsInf);
}
void WriteLogicalEqual(std::vector<uint32_t> *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLogicalEqual);
}
void WriteLogicalNotEqual(std::vector<uint32_t> *blob,
                          IdResultType idResultType,
                          IdResult idResult,
                          IdRef operand1,
                          IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLogicalNotEqual);
}
void WriteLogicalOr(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLogicalOr);
}
void WriteLogicalAnd(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef operand1,
                     IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLogicalAnd);
}
void WriteLogicalNot(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef operand)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLogicalNot);
}
void WriteSelect(std::vector<uint32_t> *blob,
                 IdResultType idResultType,
                 IdResult idResult,
                 IdRef condition,
                 IdRef object1,
                 IdRef object2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(condition);
    blob->push_back(object1);
    blob->push_back(object2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSelect);
}
void WriteIEqual(std::vector<uint32_t> *blob,
                 IdResultType idResultType,
                 IdResult idResult,
                 IdRef operand1,
                 IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpIEqual);
}
void WriteINotEqual(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpINotEqual);
}
void WriteUGreaterThan(std::vector<uint32_t> *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUGreaterThan);
}
void WriteSGreaterThan(std::vector<uint32_t> *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSGreaterThan);
}
void WriteUGreaterThanEqual(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef operand1,
                            IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUGreaterThanEqual);
}
void WriteSGreaterThanEqual(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef operand1,
                            IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSGreaterThanEqual);
}
void WriteULessThan(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpULessThan);
}
void WriteSLessThan(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSLessThan);
}
void WriteULessThanEqual(std::vector<uint32_t> *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdRef operand1,
                         IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpULessThanEqual);
}
void WriteSLessThanEqual(std::vector<uint32_t> *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdRef operand1,
                         IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSLessThanEqual);
}
void WriteFOrdEqual(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFOrdEqual);
}
void WriteFUnordEqual(std::vector<uint32_t> *blob,
                      IdResultType idResultType,
                      IdResult idResult,
                      IdRef operand1,
                      IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFUnordEqual);
}
void WriteFOrdNotEqual(std::vector<uint32_t> *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFOrdNotEqual);
}
void WriteFUnordNotEqual(std::vector<uint32_t> *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdRef operand1,
                         IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFUnordNotEqual);
}
void WriteFOrdLessThan(std::vector<uint32_t> *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef operand1,
                       IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFOrdLessThan);
}
void WriteFUnordLessThan(std::vector<uint32_t> *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdRef operand1,
                         IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFUnordLessThan);
}
void WriteFOrdGreaterThan(std::vector<uint32_t> *blob,
                          IdResultType idResultType,
                          IdResult idResult,
                          IdRef operand1,
                          IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFOrdGreaterThan);
}
void WriteFUnordGreaterThan(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef operand1,
                            IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFUnordGreaterThan);
}
void WriteFOrdLessThanEqual(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef operand1,
                            IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFOrdLessThanEqual);
}
void WriteFUnordLessThanEqual(std::vector<uint32_t> *blob,
                              IdResultType idResultType,
                              IdResult idResult,
                              IdRef operand1,
                              IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFUnordLessThanEqual);
}
void WriteFOrdGreaterThanEqual(std::vector<uint32_t> *blob,
                               IdResultType idResultType,
                               IdResult idResult,
                               IdRef operand1,
                               IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFOrdGreaterThanEqual);
}
void WriteFUnordGreaterThanEqual(std::vector<uint32_t> *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdRef operand1,
                                 IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFUnordGreaterThanEqual);
}
void WriteShiftRightLogical(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef base,
                            IdRef shift)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(base);
    blob->push_back(shift);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpShiftRightLogical);
}
void WriteShiftRightArithmetic(std::vector<uint32_t> *blob,
                               IdResultType idResultType,
                               IdResult idResult,
                               IdRef base,
                               IdRef shift)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(base);
    blob->push_back(shift);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpShiftRightArithmetic);
}
void WriteShiftLeftLogical(std::vector<uint32_t> *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef base,
                           IdRef shift)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(base);
    blob->push_back(shift);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpShiftLeftLogical);
}
void WriteBitwiseOr(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef operand1,
                    IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitwiseOr);
}
void WriteBitwiseXor(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef operand1,
                     IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitwiseXor);
}
void WriteBitwiseAnd(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef operand1,
                     IdRef operand2)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand1);
    blob->push_back(operand2);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitwiseAnd);
}
void WriteNot(std::vector<uint32_t> *blob,
              IdResultType idResultType,
              IdResult idResult,
              IdRef operand)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(operand);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpNot);
}
void WriteBitFieldInsert(std::vector<uint32_t> *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdRef base,
                         IdRef insert,
                         IdRef offset,
                         IdRef count)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(base);
    blob->push_back(insert);
    blob->push_back(offset);
    blob->push_back(count);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitFieldInsert);
}
void WriteBitFieldSExtract(std::vector<uint32_t> *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef base,
                           IdRef offset,
                           IdRef count)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(base);
    blob->push_back(offset);
    blob->push_back(count);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitFieldSExtract);
}
void WriteBitFieldUExtract(std::vector<uint32_t> *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef base,
                           IdRef offset,
                           IdRef count)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(base);
    blob->push_back(offset);
    blob->push_back(count);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitFieldUExtract);
}
void WriteBitReverse(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef base)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(base);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitReverse);
}
void WriteBitCount(std::vector<uint32_t> *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   IdRef base)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(base);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBitCount);
}
void WriteDPdx(std::vector<uint32_t> *blob, IdResultType idResultType, IdResult idResult, IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDPdx);
}
void WriteDPdy(std::vector<uint32_t> *blob, IdResultType idResultType, IdResult idResult, IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDPdy);
}
void WriteFwidth(std::vector<uint32_t> *blob, IdResultType idResultType, IdResult idResult, IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFwidth);
}
void WriteDPdxFine(std::vector<uint32_t> *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDPdxFine);
}
void WriteDPdyFine(std::vector<uint32_t> *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDPdyFine);
}
void WriteFwidthFine(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFwidthFine);
}
void WriteDPdxCoarse(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDPdxCoarse);
}
void WriteDPdyCoarse(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpDPdyCoarse);
}
void WriteFwidthCoarse(std::vector<uint32_t> *blob,
                       IdResultType idResultType,
                       IdResult idResult,
                       IdRef p)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(p);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpFwidthCoarse);
}
void WriteEmitVertex(std::vector<uint32_t> *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpEmitVertex);
}
void WriteEndPrimitive(std::vector<uint32_t> *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpEndPrimitive);
}
void WriteEmitStreamVertex(std::vector<uint32_t> *blob, IdRef stream)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(stream);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpEmitStreamVertex);
}
void WriteEndStreamPrimitive(std::vector<uint32_t> *blob, IdRef stream)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(stream);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpEndStreamPrimitive);
}
void WriteControlBarrier(std::vector<uint32_t> *blob,
                         IdScope execution,
                         IdScope memory,
                         IdMemorySemantics semantics)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(execution);
    blob->push_back(memory);
    blob->push_back(semantics);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpControlBarrier);
}
void WriteMemoryBarrier(std::vector<uint32_t> *blob, IdScope memory, IdMemorySemantics semantics)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(memory);
    blob->push_back(semantics);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpMemoryBarrier);
}
void WriteAtomicLoad(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicLoad);
}
void WriteAtomicStore(std::vector<uint32_t> *blob,
                      IdRef pointer,
                      IdScope scope,
                      IdMemorySemantics semantics,
                      IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicStore);
}
void WriteAtomicExchange(std::vector<uint32_t> *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdRef pointer,
                         IdScope scope,
                         IdMemorySemantics semantics,
                         IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicExchange);
}
void WriteAtomicCompareExchange(std::vector<uint32_t> *blob,
                                IdResultType idResultType,
                                IdResult idResult,
                                IdRef pointer,
                                IdScope scope,
                                IdMemorySemantics equal,
                                IdMemorySemantics unequal,
                                IdRef value,
                                IdRef comparator)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(equal);
    blob->push_back(unequal);
    blob->push_back(value);
    blob->push_back(comparator);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicCompareExchange);
}
void WriteAtomicIIncrement(std::vector<uint32_t> *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef pointer,
                           IdScope scope,
                           IdMemorySemantics semantics)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicIIncrement);
}
void WriteAtomicIDecrement(std::vector<uint32_t> *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef pointer,
                           IdScope scope,
                           IdMemorySemantics semantics)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicIDecrement);
}
void WriteAtomicIAdd(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics,
                     IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicIAdd);
}
void WriteAtomicISub(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics,
                     IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicISub);
}
void WriteAtomicSMin(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics,
                     IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicSMin);
}
void WriteAtomicUMin(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics,
                     IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicUMin);
}
void WriteAtomicSMax(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics,
                     IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicSMax);
}
void WriteAtomicUMax(std::vector<uint32_t> *blob,
                     IdResultType idResultType,
                     IdResult idResult,
                     IdRef pointer,
                     IdScope scope,
                     IdMemorySemantics semantics,
                     IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicUMax);
}
void WriteAtomicAnd(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef pointer,
                    IdScope scope,
                    IdMemorySemantics semantics,
                    IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicAnd);
}
void WriteAtomicOr(std::vector<uint32_t> *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   IdRef pointer,
                   IdScope scope,
                   IdMemorySemantics semantics,
                   IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicOr);
}
void WriteAtomicXor(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdRef pointer,
                    IdScope scope,
                    IdMemorySemantics semantics,
                    IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(pointer);
    blob->push_back(scope);
    blob->push_back(semantics);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpAtomicXor);
}
void WritePhi(std::vector<uint32_t> *blob,
              IdResultType idResultType,
              IdResult idResult,
              const PairIdRefIdRefList &variableParentPairList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    for (const auto &operand : variableParentPairList)
    {
        blob->push_back(operand.id1);
        blob->push_back(operand.id2);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpPhi);
}
void WriteLoopMerge(std::vector<uint32_t> *blob,
                    IdRef mergeBlock,
                    IdRef continueTarget,
                    spv::LoopControlMask loopControl)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(mergeBlock);
    blob->push_back(continueTarget);
    blob->push_back(loopControl);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLoopMerge);
}
void WriteSelectionMerge(std::vector<uint32_t> *blob,
                         IdRef mergeBlock,
                         spv::SelectionControlMask selectionControl)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(mergeBlock);
    blob->push_back(selectionControl);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSelectionMerge);
}
void WriteLabel(std::vector<uint32_t> *blob, IdResult idResult)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResult);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpLabel);
}
void WriteBranch(std::vector<uint32_t> *blob, IdRef targetLabel)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(targetLabel);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBranch);
}
void WriteBranchConditional(std::vector<uint32_t> *blob,
                            IdRef condition,
                            IdRef trueLabel,
                            IdRef falseLabel,
                            const LiteralIntegerList &branchweightsPairList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(condition);
    blob->push_back(trueLabel);
    blob->push_back(falseLabel);
    for (const auto &operand : branchweightsPairList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpBranchConditional);
}
void WriteSwitch(std::vector<uint32_t> *blob,
                 IdRef selector,
                 IdRef default_,
                 const PairLiteralIntegerIdRefList &targetPairList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(selector);
    blob->push_back(default_);
    for (const auto &operand : targetPairList)
    {
        blob->push_back(operand.literal);
        blob->push_back(operand.id);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpSwitch);
}
void WriteKill(std::vector<uint32_t> *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpKill);
}
void WriteReturn(std::vector<uint32_t> *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpReturn);
}
void WriteReturnValue(std::vector<uint32_t> *blob, IdRef value)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(value);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpReturnValue);
}
void WriteUnreachable(std::vector<uint32_t> *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpUnreachable);
}
void WriteGroupAll(std::vector<uint32_t> *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   IdScope execution,
                   IdRef predicate)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(predicate);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupAll);
}
void WriteGroupAny(std::vector<uint32_t> *blob,
                   IdResultType idResultType,
                   IdResult idResult,
                   IdScope execution,
                   IdRef predicate)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(predicate);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupAny);
}
void WriteGroupBroadcast(std::vector<uint32_t> *blob,
                         IdResultType idResultType,
                         IdResult idResult,
                         IdScope execution,
                         IdRef value,
                         IdRef localId)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(value);
    blob->push_back(localId);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupBroadcast);
}
void WriteGroupIAdd(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupIAdd);
}
void WriteGroupFAdd(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupFAdd);
}
void WriteGroupFMin(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupFMin);
}
void WriteGroupUMin(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupUMin);
}
void WriteGroupSMin(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupSMin);
}
void WriteGroupFMax(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupFMax);
}
void WriteGroupUMax(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupUMax);
}
void WriteGroupSMax(std::vector<uint32_t> *blob,
                    IdResultType idResultType,
                    IdResult idResult,
                    IdScope execution,
                    spv::GroupOperation operation,
                    IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupSMax);
}
void WriteImageSparseSampleImplicitLod(std::vector<uint32_t> *blob,
                                       IdResultType idResultType,
                                       IdResult idResult,
                                       IdRef sampledImage,
                                       IdRef coordinate,
                                       const spv::ImageOperandsMask *imageOperands,
                                       const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleImplicitLod);
}
void WriteImageSparseSampleExplicitLod(std::vector<uint32_t> *blob,
                                       IdResultType idResultType,
                                       IdResult idResult,
                                       IdRef sampledImage,
                                       IdRef coordinate,
                                       spv::ImageOperandsMask imageOperands,
                                       const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(imageOperands);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleExplicitLod);
}
void WriteImageSparseSampleDrefImplicitLod(std::vector<uint32_t> *blob,
                                           IdResultType idResultType,
                                           IdResult idResult,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           IdRef dref,
                                           const spv::ImageOperandsMask *imageOperands,
                                           const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleDrefImplicitLod);
}
void WriteImageSparseSampleDrefExplicitLod(std::vector<uint32_t> *blob,
                                           IdResultType idResultType,
                                           IdResult idResult,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           IdRef dref,
                                           spv::ImageOperandsMask imageOperands,
                                           const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    blob->push_back(imageOperands);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleDrefExplicitLod);
}
void WriteImageSparseSampleProjImplicitLod(std::vector<uint32_t> *blob,
                                           IdResultType idResultType,
                                           IdResult idResult,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           const spv::ImageOperandsMask *imageOperands,
                                           const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleProjImplicitLod);
}
void WriteImageSparseSampleProjExplicitLod(std::vector<uint32_t> *blob,
                                           IdResultType idResultType,
                                           IdResult idResult,
                                           IdRef sampledImage,
                                           IdRef coordinate,
                                           spv::ImageOperandsMask imageOperands,
                                           const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(imageOperands);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleProjExplicitLod);
}
void WriteImageSparseSampleProjDrefImplicitLod(std::vector<uint32_t> *blob,
                                               IdResultType idResultType,
                                               IdResult idResult,
                                               IdRef sampledImage,
                                               IdRef coordinate,
                                               IdRef dref,
                                               const spv::ImageOperandsMask *imageOperands,
                                               const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleProjDrefImplicitLod);
}
void WriteImageSparseSampleProjDrefExplicitLod(std::vector<uint32_t> *blob,
                                               IdResultType idResultType,
                                               IdResult idResult,
                                               IdRef sampledImage,
                                               IdRef coordinate,
                                               IdRef dref,
                                               spv::ImageOperandsMask imageOperands,
                                               const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    blob->push_back(imageOperands);
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] =
        MakeLengthOp(blob->size() - startSize, spv::OpImageSparseSampleProjDrefExplicitLod);
}
void WriteImageSparseFetch(std::vector<uint32_t> *blob,
                           IdResultType idResultType,
                           IdResult idResult,
                           IdRef image,
                           IdRef coordinate,
                           const spv::ImageOperandsMask *imageOperands,
                           const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(image);
    blob->push_back(coordinate);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSparseFetch);
}
void WriteImageSparseGather(std::vector<uint32_t> *blob,
                            IdResultType idResultType,
                            IdResult idResult,
                            IdRef sampledImage,
                            IdRef coordinate,
                            IdRef component,
                            const spv::ImageOperandsMask *imageOperands,
                            const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(component);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSparseGather);
}
void WriteImageSparseDrefGather(std::vector<uint32_t> *blob,
                                IdResultType idResultType,
                                IdResult idResult,
                                IdRef sampledImage,
                                IdRef coordinate,
                                IdRef dref,
                                const spv::ImageOperandsMask *imageOperands,
                                const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(sampledImage);
    blob->push_back(coordinate);
    blob->push_back(dref);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSparseDrefGather);
}
void WriteImageSparseTexelsResident(std::vector<uint32_t> *blob,
                                    IdResultType idResultType,
                                    IdResult idResult,
                                    IdRef residentCode)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(residentCode);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSparseTexelsResident);
}
void WriteNoLine(std::vector<uint32_t> *blob)
{
    const size_t startSize = blob->size();
    blob->push_back(0);

    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpNoLine);
}
void WriteImageSparseRead(std::vector<uint32_t> *blob,
                          IdResultType idResultType,
                          IdResult idResult,
                          IdRef image,
                          IdRef coordinate,
                          const spv::ImageOperandsMask *imageOperands,
                          const IdRefList &imageOperandIdsList)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(image);
    blob->push_back(coordinate);
    if (imageOperands)
    {
        blob->push_back(*imageOperands);
    }
    for (const auto &operand : imageOperandIdsList)
    {
        blob->push_back(operand);
    }
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpImageSparseRead);
}
void WriteGroupIAddNonUniformAMD(std::vector<uint32_t> *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupIAddNonUniformAMD);
}
void WriteGroupFAddNonUniformAMD(std::vector<uint32_t> *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupFAddNonUniformAMD);
}
void WriteGroupFMinNonUniformAMD(std::vector<uint32_t> *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupFMinNonUniformAMD);
}
void WriteGroupUMinNonUniformAMD(std::vector<uint32_t> *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupUMinNonUniformAMD);
}
void WriteGroupSMinNonUniformAMD(std::vector<uint32_t> *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupSMinNonUniformAMD);
}
void WriteGroupFMaxNonUniformAMD(std::vector<uint32_t> *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupFMaxNonUniformAMD);
}
void WriteGroupUMaxNonUniformAMD(std::vector<uint32_t> *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupUMaxNonUniformAMD);
}
void WriteGroupSMaxNonUniformAMD(std::vector<uint32_t> *blob,
                                 IdResultType idResultType,
                                 IdResult idResult,
                                 IdScope execution,
                                 spv::GroupOperation operation,
                                 IdRef x)
{
    const size_t startSize = blob->size();
    blob->push_back(0);
    blob->push_back(idResultType);
    blob->push_back(idResult);
    blob->push_back(execution);
    blob->push_back(operation);
    blob->push_back(x);
    (*blob)[startSize] = MakeLengthOp(blob->size() - startSize, spv::OpGroupSMaxNonUniformAMD);
}

}  // namespace spirv
}  // namespace angle
