// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_VIZ_HOST_GPU_CLIENT_DELEGATE_H_
#define COMPONENTS_VIZ_HOST_GPU_CLIENT_DELEGATE_H_

#include "mojo/public/cpp/system/message_pipe.h"

namespace viz {

class GpuHostImpl;
class HostGpuMemoryBufferManager;

// Delegate interface that GpuClient uses to get the current GpuHost and/or
// GpuMemoryBufferManager instances. These functions are guaranteed to be called
// on the thread corresponding to GpuClient's task runner.
class GpuClientDelegate {
 public:
  virtual ~GpuClientDelegate() {}

  // Returns the current instance of GpuHostImpl. If GPU service is not running,
  // tries to launch it. If the launch is unsuccessful, returns nullptr.
  virtual GpuHostImpl* EnsureGpuHost() = 0;

  // Returns the current HostGpuMemoryBufferManager instance.
  virtual HostGpuMemoryBufferManager* GetGpuMemoryBufferManager() = 0;
};

}  // namespace viz

#endif  // COMPONENTS_VIZ_HOST_GPU_CLIENT_DELEGATE_H_
