// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SIGNIN_PUBLIC_IDENTITY_MANAGER_LOAD_CREDENTIALS_STATE_H_
#define COMPONENTS_SIGNIN_PUBLIC_IDENTITY_MANAGER_LOAD_CREDENTIALS_STATE_H_

namespace signin {

enum class LoadCredentialsState {
  // Describes the status of the operation of loading OAuth2 refresh tokens from
  // disk.
  LOAD_CREDENTIALS_NOT_STARTED,
  LOAD_CREDENTIALS_IN_PROGRESS,
  LOAD_CREDENTIALS_FINISHED_WITH_SUCCESS,
  LOAD_CREDENTIALS_FINISHED_WITH_DB_CANNOT_BE_OPENED,
  LOAD_CREDENTIALS_FINISHED_WITH_DB_ERRORS,
  LOAD_CREDENTIALS_FINISHED_WITH_DECRYPT_ERRORS,
  LOAD_CREDENTIALS_FINISHED_WITH_NO_TOKEN_FOR_PRIMARY_ACCOUNT,
  LOAD_CREDENTIALS_FINISHED_WITH_UNKNOWN_ERRORS,
};

}  // namespace signin

#endif  // COMPONENTS_SIGNIN_PUBLIC_IDENTITY_MANAGER_LOAD_CREDENTIALS_STATE_H_
