# About //components/policy/proto

This directory contains proto definitions for communication with the device management server.

## User policies

There are two protocol buffers defining the messages for user policies - `chrome_settings.proto` and `cloud_policy.proto`. Both files are auto-generated by the [generate_policy_source.py](https://source.chromium.org/chromium/chromium/src/+/main:components/policy/tools/generate_policy_source.py) script based on [policy_templates.json](https://source.chromium.org/chromium/chromium/src/+/main:components/policy/resources/policy_templates.json) as part of [building Chrome](https://source.chromium.org/chromium/chromium/src/+/main:components/policy/BUILD.gn;drc=326a2697fbe91fe9a953873763ad0a2695883d73;l=102).

The reason there are two files is a compromise between readability and performance.

* `chrome_settings.proto`

  This file lists all non-device policies including comments containing their detailed descriptions. Additionally every policy in this file has a distinct message type. For example, this is the message for the `HomepageLocation` policy:


  ```
  message HomepageLocationProto {
    optional PolicyOptions policy_options = 1;
    optional string HomepageLocation = 2;
  }
   ```

* `cloud_policy.proto`

  This file is generated for each target platform and it therefore contains only the policy messages that a certain platform supports. Additionally each field uses a generic type defined in [policy_common_definitions.proto](https://source.chromium.org/chromium/chromium/src/+/main:components/policy/proto/policy_common_definitions.proto). For example this is the message for any string policy:

  ```
  message StringPolicyProto {
    optional PolicyOptions policy_options = 1;
    optional string value = 2;
  }
  ```

The client code for each platform uses the more compact `cloud_policy.proto` to parse the policy blobs it receives from the device management server. On the other hand, the device management server needs to know of all the policies that exist for all the platforms, therefore `chrome_settings.proto` is what the server code uses.

The two files are compatible and when the messages are serialized their binary content is equivalent. [CloudPolicyProtoTest.VerifyProtobufEquivalence](https://source.chromium.org/chromium/chromium/src/+/2d4ccc5062a5314b89973a2d53159f431a0ecfd3:chrome/browser/policy/cloud/cloud_policy_browsertest.cc;l=530) browser test makes sure that no regressions are introduced here.