// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_OS_CRYPT_KEY_STORAGE_LIBSECRET_H_
#define COMPONENTS_OS_CRYPT_KEY_STORAGE_LIBSECRET_H_

#include <string>

#include "base/component_export.h"
#include "components/os_crypt/key_storage_linux.h"
#include "third_party/abseil-cpp/absl/types/optional.h"

// Specialisation of KeyStorageLinux that uses Libsecret.
class COMPONENT_EXPORT(OS_CRYPT) KeyStorageLibsecret : public KeyStorageLinux {
 public:
  explicit KeyStorageLibsecret(std::string application_name);

  KeyStorageLibsecret(const KeyStorageLibsecret&) = delete;
  KeyStorageLibsecret& operator=(const KeyStorageLibsecret&) = delete;

  ~KeyStorageLibsecret() override = default;

 protected:
  // KeyStorageLinux
  bool Init() override;
  absl::optional<std::string> GetKeyImpl() override;

 private:
  absl::optional<std::string> AddRandomPasswordInLibsecret();

  const std::string application_name_;
};

#endif  // COMPONENTS_OS_CRYPT_KEY_STORAGE_LIBSECRET_H_
