## Copyright (C) 2007 R.G.H. Eschauzier <reschauzier@yahoo.com>
##
## This program is free software: you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation, either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING. If not, see
## <https://www.gnu.org/licenses/>.

## -*- texinfo -*-
## @deftypefn {Function File} {@var{p_out} =} to_real (@var{p_in})
## Undocumented internal function.  This function is used by the impinvar
## and invimpinvar functions in the signal package.
## @end deftypefn

## Adapted by Carnë Draug on 2011 <carandraug+dev@gmail.com>

## Round complex number to nearest real number

function p_out = to_real(p_in)

  p_out = abs(p_in) .* sign(real(p_in));

endfunction
