/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.ByteVector;
import gnu.lists.Convert;
import gnu.lists.Sequence;

public class S8Vector
extends ByteVector {
    public S8Vector() {
        this.data = ByteVector.empty;
    }

    public S8Vector(int size, byte value) {
        byte[] array = new byte[size];
        this.data = array;
        this.size = size;
        while (--size >= 0) {
            array[size] = value;
        }
    }

    public S8Vector(int size) {
        this.data = new byte[size];
        this.size = size;
    }

    public S8Vector(byte[] data) {
        this.data = data;
        this.size = data.length;
    }

    public S8Vector(Sequence seq) {
        this.data = new byte[seq.size()];
        this.addAll(seq);
    }

    @Override
    public final int intAtBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final Object get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return Convert.toObject(this.data[index]);
    }

    public final Object getBuffer(int index) {
        return Convert.toObject(this.data[index]);
    }

    public void setBuffer(int index, Object value) {
        this.data[index] = Convert.toByte(value);
    }

    @Override
    public int getElementKind() {
        return 18;
    }

    @Override
    public String getTag() {
        return "s8";
    }

    public int compareTo(Object obj) {
        return S8Vector.compareToInt(this, (S8Vector)obj);
    }
}

