/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.text.Path;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class FileInfo {
    static Hashtable fileMap = new Hashtable();
    boolean writeNeeded;
    String path;
    File file;
    FileInfo parent;
    String parentName;
    String[] childLinkText;
    int nchildren;
    FileInputStream fin;
    InPort in;
    ByteArrayOutputStream bout;
    OutPort cout;
    boolean scanned;
    StringBuffer beforeNavbarText;
    StringBuffer oldNavbarText;
    StringBuffer newNavbarText;
    static final Pattern childPat = Pattern.compile("<a .*</a>");
    static final Pattern parentPat = Pattern.compile("<ul[^>]* parent=['\"]([^'\"]*)['\"]");
    static final Pattern linkPat = Pattern.compile(" href=['\"]([^'\"]*)['\"]");

    FileInfo() {
    }

    public static FileInfo find(File file) throws Throwable {
        String string = file.getCanonicalPath();
        FileInfo fileInfo = (FileInfo)fileMap.get(string);
        if (fileInfo == null) {
            fileInfo = new FileInfo();
            fileInfo.file = file;
            fileMap.put(string, fileInfo);
        }
        return fileInfo;
    }

    public void scan() throws Throwable {
        Object object2;
        Object object3;
        Object[] objectArray;
        if (this.scanned) {
            return;
        }
        this.scanned = true;
        this.fin = new FileInputStream(this.file);
        this.in = new InPort(new BufferedInputStream(this.fin));
        this.oldNavbarText = new StringBuffer();
        this.newNavbarText = new StringBuffer();
        if (this.writeNeeded) {
            this.bout = new ByteArrayOutputStream();
            this.cout = new OutPort(this.bout);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Vector<String> vector = new Vector<String>();
        while ((objectArray = this.in.readLine()) != null) {
            if (bl2) {
                if (objectArray.indexOf("<!--end-generated-navbar-->") >= 0) {
                    bl2 = false;
                    break;
                }
                this.oldNavbarText.append((String)objectArray);
                this.oldNavbarText.append('\n');
                if (bl3) {
                    if (objectArray.indexOf("<!--end-children-toc-->") >= 0) {
                        bl3 = false;
                    } else {
                        object3 = childPat.matcher((CharSequence)objectArray);
                        if (((Matcher)object3).find()) {
                            vector.add(((Matcher)object3).group());
                        }
                        if (((Matcher)(object2 = parentPat.matcher((CharSequence)objectArray))).find() && this.parentName == null) {
                            this.parentName = ((Matcher)object2).group(1);
                        }
                    }
                }
                if (objectArray.indexOf("<!--start-children-toc-->") >= 0) {
                    bl3 = true;
                }
            } else if (objectArray.indexOf("<!--start-generated-navbar-->") >= 0) {
                bl2 = true;
            }
            if (!this.writeNeeded || bl2) continue;
            this.cout.println((String)objectArray);
        }
        objectArray = new String[vector.size()];
        this.nchildren = objectArray.length;
        vector.copyInto(objectArray);
        this.childLinkText = objectArray;
        if (!this.writeNeeded) {
            this.in.close();
        }
        if (this.parentName != null) {
            object3 = new File(this.file.toURI().resolve(this.parentName));
            object2 = FileInfo.find((File)object3);
            ((FileInfo)object2).scan();
            this.parent = object2;
        }
    }

    public void writeLinks(int n, StringBuffer stringBuffer) throws Throwable {
        FileInfo fileInfo = this;
        FileInfo fileInfo2 = null;
        int n2 = n;
        while (--n2 >= 0) {
            fileInfo2 = fileInfo;
            fileInfo = fileInfo.parent;
        }
        if (n == 0) {
            stringBuffer.append("<!--start-children-toc-->\n");
        }
        if (n == 0 && this.parentName != null) {
            stringBuffer.append("<ul parent=\"");
            stringBuffer.append(this.parentName);
            stringBuffer.append("\">\n");
        } else {
            stringBuffer.append("<ul>\n");
        }
        URI uRI = this.file.toURI();
        URI uRI2 = fileInfo.file.toURI();
        for (int i = 0; i < fileInfo.nchildren; ++i) {
            String string = fileInfo.childLinkText[i];
            boolean bl = false;
            if (n > 0) {
                FileInfo fileInfo3;
                Matcher matcher = linkPat.matcher(string);
                matcher.find();
                String string2 = matcher.group(1);
                URI uRI3 = uRI2.resolve(string2);
                string = matcher.replaceFirst(" href=\"" + Path.relativize(uRI3.toString(), uRI.toString()) + "\"");
                int n3 = string2.indexOf(35);
                if (n3 >= 0) {
                    string2 = string2.substring(0, n3);
                }
                boolean bl2 = bl = (fileInfo3 = FileInfo.find(new File(uRI2.resolve(string2)))) == fileInfo2;
                if (!bl && n > 1) continue;
            }
            stringBuffer.append("<li>");
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append('\n');
                this.writeLinks(n - 1, stringBuffer);
            }
            stringBuffer.append("</li>\n");
        }
        stringBuffer.append("</ul>\n");
        if (n == 0) {
            stringBuffer.append("<!--end-children-toc-->\n");
        }
    }

    public void write() throws Throwable {
        CharSequence charSequence;
        int n = 0;
        FileInfo fileInfo = this;
        while (fileInfo.parent != null) {
            fileInfo = fileInfo.parent;
            ++n;
        }
        this.cout.println("<!--start-generated-navbar-->");
        this.writeLinks(n, this.newNavbarText);
        this.cout.print(this.newNavbarText);
        this.cout.println("<!--end-generated-navbar-->");
        while ((charSequence = this.in.readLine()) != null) {
            this.cout.println((String)charSequence);
        }
        charSequence = new StringBuffer();
        this.in.close();
        if (this.oldNavbarText.toString().equals(this.newNavbarText.toString())) {
            System.err.println("fixup " + this.file + " - no change");
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            byte[] byArray = this.bout.toByteArray();
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            System.err.println("fixup " + this.file + " - updated");
        }
    }
}

