/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.BindingInitializer;
import gnu.expr.CheckedTarget;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class LetExp
extends ScopeExp {
    public Expression[] inits;
    public Expression body;

    public LetExp(Expression[] expressionArray) {
        this.inits = expressionArray;
    }

    public Expression getBody() {
        return this.body;
    }

    public void setBody(Expression expression) {
        this.body = expression;
    }

    void store_rest(Compilation compilation, int n, Declaration declaration) {
        if (declaration != null) {
            this.store_rest(compilation, n + 1, declaration.nextDecl());
            if (declaration.needsInit()) {
                if (declaration.isIndirectBinding()) {
                    CodeAttr codeAttr = compilation.getCode();
                    if (this.inits[n] == QuoteExp.undefined_exp) {
                        Object object2 = declaration.getSymbol();
                        compilation.compileConstant(object2, Target.pushObject);
                        codeAttr.emitInvokeStatic(BindingInitializer.makeLocationMethod(object2));
                    } else {
                        declaration.pushIndirectBinding(compilation);
                    }
                }
                declaration.compileStore(compilation);
            }
        }
    }

    public void compile(Compilation compilation, Target target) {
        CodeAttr codeAttr = compilation.getCode();
        Declaration declaration = this.firstDecl();
        int n = 0;
        while (n < this.inits.length) {
            Target target2;
            Expression expression = this.inits[n];
            declaration.allocateVariable(codeAttr);
            if (!declaration.needsInit() || declaration.isIndirectBinding() && this.inits[n] == QuoteExp.undefined_exp) {
                target2 = Target.Ignore;
            } else {
                Type type = declaration.getType();
                target2 = CheckedTarget.getInstance(type);
                if (expression == QuoteExp.undefined_exp) {
                    if (type instanceof PrimType) {
                        expression = new QuoteExp(new Byte(0));
                    } else if (type != null && type != Type.pointer_type) {
                        expression = QuoteExp.nullExp;
                    }
                }
            }
            expression.compile(compilation, target2);
            ++n;
            declaration = declaration.nextDecl();
        }
        codeAttr.enterScope(this.getVarScope());
        this.store_rest(compilation, 0, this.firstDecl());
        this.body.compileWithPosition(compilation, target);
        this.popScope(codeAttr);
    }

    public final Type getType() {
        return this.body.getType();
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkLetExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        Declaration declaration = this.firstDecl();
        int n = 0;
        while (n < this.inits.length) {
            Expression expression;
            Expression expression2 = this.inits[n];
            this.inits[n] = expression = expWalker.walk(expression2);
            if (declaration.value == expression2) {
                declaration.value = expression;
            }
            ++n;
            declaration = declaration.nextDecl();
        }
        if (expWalker.exitValue == null) {
            this.body = expWalker.walk(this.body);
        }
    }

    public void print(OutPort outPort) {
        this.print(outPort, "(Let", ")");
    }

    public void print(OutPort outPort, String string, String string2) {
        outPort.startLogicalBlock(string + "#" + this.id, string2, 2);
        outPort.writeSpaceFill();
        this.printLineColumn(outPort);
        outPort.startLogicalBlock("(", false, ")");
        int n = 0;
        for (Declaration declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (n > 0) {
                outPort.writeSpaceFill();
            }
            outPort.startLogicalBlock("(", false, ")");
            declaration.printInfo(outPort);
            if (this.inits != null) {
                outPort.writeSpaceFill();
                outPort.print('=');
                outPort.writeSpaceFill();
                if (n >= this.inits.length) {
                    outPort.print("<missing init>");
                } else if (this.inits[n] == null) {
                    outPort.print("<null>");
                } else {
                    this.inits[n].print(outPort);
                }
                ++n;
            }
            outPort.endLogicalBlock(")");
        }
        outPort.endLogicalBlock(")");
        outPort.writeSpaceLinear();
        this.body.print(outPort);
        outPort.endLogicalBlock(string2);
    }
}

