/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

public class Access {
    public static final short PUBLIC = 1;
    public static final short PRIVATE = 2;
    public static final short PROTECTED = 4;
    public static final short STATIC = 8;
    public static final short FINAL = 16;
    public static final short SUPER = 32;
    public static final short SYNCHRONIZED = 32;
    public static final short VOLATILE = 64;
    public static final short TRANSIENT = 128;
    public static final short NATIVE = 256;
    public static final short INTERFACE = 512;
    public static final short ABSTRACT = 1024;

    public static String toString(int n) {
        return Access.toString(n, '\u0000');
    }

    public static String toString(int n, char c) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append(" public");
        }
        if ((n & 2) != 0) {
            stringBuffer.append(" private");
        }
        if ((n & 4) != 0) {
            stringBuffer.append(" protected");
        }
        if ((n & 8) != 0) {
            stringBuffer.append(" static");
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append(" final");
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append(c == 'C' ? " super" : " synchronized");
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append(" volatile");
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append(" transient");
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append(" native");
        }
        if ((n & 0x200) != 0) {
            stringBuffer.append(" interface");
        }
        if ((n & 0x400) != 0) {
            stringBuffer.append(" abstract");
        }
        if ((n2 = n & 0xFFFFF880) != 0) {
            stringBuffer.append(" 0x");
            stringBuffer.append(Integer.toHexString(n2));
        }
        return stringBuffer.toString();
    }
}

