/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Compilation;
import gnu.expr.Interpreter;
import gnu.expr.ModuleExp;
import gnu.lists.FString;
import gnu.lists.FVector;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure0or1;
import gnu.mapping.Values;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.text.WriterManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import kawa.Shell;
import kawa.Telnet;
import kawa.TelnetInputStream;
import kawa.TelnetRepl;
import kawa.Version;
import kawa.lang.CompileFile;
import kawa.standard.load;

public class repl
extends Procedure0or1 {
    public static String compilationDirectory = null;
    public static String compilationTopname = null;
    public static String compilationPrefix = null;
    Interpreter interp;
    private static int exitCounter;
    public static String[] commandLineArgArray;
    public static FVector commandLineArguments;
    public static String homeDirectory;
    static boolean shutdownRegistered;

    public repl(Interpreter interpreter) {
        this.interp = interpreter;
    }

    public Object apply0() {
        Shell.run(this.interp, Environment.getCurrent());
        return Values.empty;
    }

    public Object apply1(Object object2) {
        Shell.run(this.interp, (Environment)object2);
        return Values.empty;
    }

    static void bad_option(String string) {
        System.err.println("kawa: bad option '" + string + "'");
        repl.printOptions(System.err);
        System.exit(-1);
    }

    public static void printOptions(PrintStream printStream) {
        printStream.println("Usage: [java kawa.repl | kawa] [options ...]");
        printStream.println();
        printStream.println(" Generic options:");
        printStream.println(" --help                    Show help about options");
        printStream.println(" --author                  Show author information");
        printStream.println(" --version                 Show version information");
        printStream.println();
        printStream.println(" Options");
        printStream.println(" -e <expr>                 Evaluate expression <expr>");
        printStream.println(" -c <expr>                 Same as -e, but make sure ~/.kawarc.scm is run first");
        printStream.println(" -f <filename>             File to interpret");
        printStream.println(" -s | --                   Start reading commands interactively from console");
        printStream.println(" -w                        Launch the interpreter in a GUI window");
        printStream.println(" --server <port>           Start a server accepting telnet connections on <port>");
        printStream.println(" --debug-dump-zip          Compiled interactive expressions to a zip archive");
        printStream.println(" --debug-print-expr        Print generated internal expressions");
        printStream.println(" --debug-print-final-expr  Print expression after any optimizations");
        printStream.println(" --[no-]full-tailcalls     (Don't) use full tail-calls");
        printStream.println(" -C <filename> ...         Compile named files to Java class files");
        printStream.println(" --output-format <format>  Use <format> when printing top-level output");
        printStream.println(" --<language>              Select source language, one of:");
        String[][] stringArray = Interpreter.getLanguages();
        int n = 0;
        while (n < stringArray.length) {
            printStream.print("   ");
            String[] stringArray2 = stringArray[n];
            int n2 = stringArray2.length - 1;
            int n3 = 0;
            while (n3 < n2) {
                printStream.print(stringArray2[n3] + " ");
                ++n3;
            }
            if (n == 0) {
                printStream.print("[default]");
            }
            printStream.println();
            ++n;
        }
        printStream.println(" Compilation options, must be specified before -C");
        printStream.println(" -d <dirname>              Directory to place .class files in");
        printStream.println(" -P <prefix>               Prefix to prepand to class names");
        printStream.println(" -T <topname>              name to give ot top-level class");
        printStream.println(" --main                    Generate an application, with a main method");
        printStream.println(" --applet                  Generate an applet");
        printStream.println(" --servlet                 Generate a servlet");
        printStream.println(" --module-static           Top-leval definitions are by default static");
        printStream.println();
        printStream.println("For more information go to:  http://www.gnu.org/software/kawa/");
    }

    public static synchronized void exitIncrement() {
        if (exitCounter == 0) {
            ++exitCounter;
        }
        ++exitCounter;
    }

    public static synchronized void exitDecrement() {
        int n = exitCounter;
        if (n > 0) {
            if (--n == 0) {
                System.exit(0);
            } else {
                exitCounter = n;
            }
        }
    }

    static void checkInitFile() {
        if (homeDirectory == null) {
            Serializable serializable;
            File file = null;
            homeDirectory = System.getProperty("user.home");
            if (homeDirectory != null) {
                serializable = new FString(homeDirectory);
                String string = System.getProperty("file.separator");
                String string2 = "/".equals(string) ? ".kawarc.scm" : "kawarc.scm";
                file = new File(homeDirectory, string2);
            } else {
                serializable = Interpreter.falseObject;
            }
            Environment.define_global("home-directory", serializable);
            if (file != null && file.exists()) {
                Shell.runFile(file.getPath());
            }
        }
    }

    public static void setArgs(String[] stringArray, int n) {
        int n2 = stringArray.length - n;
        Object[] objectArray = new Object[n2];
        if (n == 0) {
            commandLineArgArray = stringArray;
        } else {
            String[] stringArray2 = new String[n2];
            int n3 = n2;
            while (--n3 >= 0) {
                stringArray2[n3] = stringArray[n3 + n];
            }
            commandLineArgArray = stringArray2;
        }
        int n4 = n2;
        while (--n4 >= 0) {
            objectArray[n4] = new FString(stringArray[n4 + n]);
        }
        commandLineArguments = new FVector(objectArray);
        Environment.define_global("command-line-arguments", commandLineArguments);
    }

    public static Interpreter getInterpreterFromFilenameExtension(String string) {
        Interpreter interpreter;
        if (Interpreter.defaultInterpreter == null && (interpreter = Interpreter.getInstanceFromFilenameExtension(string)) != null) {
            Interpreter.defaultInterpreter = interpreter;
            Environment.setCurrent(interpreter.getEnvironment());
            return interpreter;
        }
        return repl.getInterpreter();
    }

    public static Interpreter getInterpreter() {
        if (Interpreter.defaultInterpreter == null) {
            Interpreter.defaultInterpreter = Interpreter.getInstance(null);
            Environment.setCurrent(Interpreter.defaultInterpreter.getEnvironment());
        }
        return Interpreter.defaultInterpreter;
    }

    public static int processArgs(String[] stringArray, int n, int n2) {
        boolean bl = false;
        while (n < n2) {
            Object object2;
            String string = stringArray[n];
            if (string.equals("-c") || string.equals("-e")) {
                if (++n == n2) {
                    repl.bad_option(string);
                }
                repl.getInterpreter();
                repl.setArgs(stringArray, n + 1);
                if (string.equals("-c")) {
                    repl.checkInitFile();
                }
                object2 = Interpreter.defaultInterpreter;
                Shell.runString(stringArray[n], (Interpreter)object2, ((Interpreter)object2).getEnvironment());
                bl = true;
            } else if (string.equals("-f")) {
                if (++n == n2) {
                    repl.bad_option(string);
                }
                object2 = stringArray[n];
                repl.getInterpreterFromFilenameExtension((String)object2);
                repl.setArgs(stringArray, n + 1);
                repl.checkInitFile();
                Shell.runFile((String)object2);
                bl = true;
            } else {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                if (string.equals("\\")) {
                    if (++n == n2) {
                        repl.bad_option(string);
                    }
                    object2 = stringArray[n];
                    try {
                        object6 = new BufferedInputStream(new FileInputStream((String)object2));
                        int n3 = ((InputStream)object6).read();
                        if (n3 == 35) {
                            int n4;
                            object5 = new StringBuffer(100);
                            object4 = new Vector<String>(10);
                            int n5 = 0;
                            while (n3 != 10 && n3 != 13 && n3 >= 0) {
                                n3 = ((InputStream)object6).read();
                            }
                            while (true) {
                                if ((n3 = ((InputStream)object6).read()) < 0) {
                                    System.err.println("unexpected end-of-file processing argument line for: '" + (String)object2 + '\'');
                                    System.exit(-1);
                                }
                                if (n5 == 0) {
                                    if (n3 == 92 || n3 == 39 || n3 == 34) {
                                        n5 = n3;
                                        continue;
                                    }
                                    if (n3 == 10 || n3 == 13) break;
                                    if (n3 == 32 || n3 == 9) {
                                        if (((StringBuffer)object5).length() <= 0) continue;
                                        ((Vector)object4).addElement(((StringBuffer)object5).toString());
                                        ((StringBuffer)object5).setLength(0);
                                        continue;
                                    }
                                } else if (n5 == 92) {
                                    n5 = 0;
                                } else if (n3 == n5) {
                                    n5 = 0;
                                    continue;
                                }
                                ((StringBuffer)object5).append((char)n3);
                            }
                            if (((StringBuffer)object5).length() > 0) {
                                ((Vector)object4).addElement(((StringBuffer)object5).toString());
                            }
                            if ((n4 = ((Vector)object4).size()) > 0) {
                                Object[] objectArray = new String[n4];
                                ((Vector)object4).copyInto(objectArray);
                                int n6 = repl.processArgs((String[])objectArray, 0, n4);
                                if (n6 >= 0 && n6 < n4) {
                                    System.err.println("" + (n4 - n6) + " unused meta args");
                                }
                            }
                        }
                        repl.getInterpreterFromFilenameExtension((String)object2);
                        object3 = InPort.openFile((InputStream)object6, (String)object2);
                        repl.setArgs(stringArray, n + 1);
                        repl.checkInitFile();
                        load.loadSource((InPort)object3, Environment.user());
                        return -1;
                    }
                    catch (SyntaxException syntaxException) {
                        syntaxException.printAll(OutPort.errDefault(), 20);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println("Cannot open file " + (String)object2);
                        System.exit(1);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace(System.err);
                        System.exit(1);
                    }
                    return -1;
                }
                if (string.equals("-s") || string.equals("--")) {
                    repl.getInterpreter();
                    repl.setArgs(stringArray, ++n);
                    repl.checkInitFile();
                    Shell.run(Interpreter.defaultInterpreter, Environment.getCurrent());
                    return -1;
                }
                if (string.equals("-w")) {
                    repl.getInterpreter();
                    repl.setArgs(stringArray, ++n);
                    repl.checkInitFile();
                    try {
                        Class.forName("kawa.GuiConsole").newInstance();
                    }
                    catch (Exception exception) {
                        System.err.println("failed to create Kawa window: " + exception);
                        System.exit(-1);
                    }
                    bl = true;
                } else if (string.equals("-d")) {
                    if (++n == n2) {
                        repl.bad_option(string);
                    }
                    compilationDirectory = stringArray[n];
                } else if (string.equals("-P")) {
                    if (++n == n2) {
                        repl.bad_option(string);
                    }
                    compilationPrefix = stringArray[n];
                } else if (string.equals("-T")) {
                    if (++n == n2) {
                        repl.bad_option(string);
                    }
                    compilationTopname = stringArray[n];
                } else {
                    if (string.equals("-C")) {
                        if (++n == n2) {
                            repl.bad_option(string);
                        }
                        while (n < n2) {
                            string = stringArray[n];
                            repl.getInterpreterFromFilenameExtension(string);
                            try {
                                System.err.println("(compiling " + string + ")");
                                object2 = new SourceMessages();
                                CompileFile.compile_to_files(string, compilationDirectory, compilationPrefix, compilationTopname, (SourceMessages)object2);
                                boolean bl2 = ((SourceMessages)object2).seenErrors();
                                ((SourceMessages)object2).checkErrors(System.err, 50);
                                if (bl2) {
                                    System.exit(-1);
                                }
                            }
                            catch (Throwable throwable) {
                                System.err.println("Internal error while compiling " + string);
                                throwable.printStackTrace(System.err);
                                System.exit(-1);
                            }
                            ++n;
                        }
                        return -1;
                    }
                    if (string.equals("--output-format") || string.equals("--format")) {
                        if (++n == n2) {
                            repl.bad_option(string);
                        }
                        Shell.setDefaultFormat(stringArray[n]);
                    } else {
                        if (string.equals("--connect")) {
                            int n7;
                            if (++n == n2) {
                                repl.bad_option(string);
                            }
                            if (stringArray[n].equals("-")) {
                                n7 = 0;
                            } else {
                                try {
                                    n7 = Integer.parseInt(stringArray[n]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    repl.bad_option("--connect port#");
                                    n7 = -1;
                                }
                            }
                            try {
                                object3 = new Socket("localhost", n7);
                                object6 = new Telnet((Socket)object3, true);
                                TelnetInputStream telnetInputStream = ((Telnet)object6).getInputStream();
                                object5 = ((Telnet)object6).getOutputStream();
                                object4 = new PrintStream((OutputStream)object5, true);
                                System.setIn(telnetInputStream);
                                System.setOut((PrintStream)object4);
                                System.setErr((PrintStream)object4);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace(System.err);
                                throw new Error(iOException.toString());
                            }
                        }
                        if (string.equals("--server")) {
                            int n8;
                            repl.getInterpreter();
                            if (++n == n2) {
                                repl.bad_option(string);
                            }
                            if (stringArray[n].equals("-")) {
                                n8 = 0;
                            } else {
                                try {
                                    n8 = Integer.parseInt(stringArray[n]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    repl.bad_option("--server port#");
                                    n8 = -1;
                                }
                            }
                            try {
                                object3 = new ServerSocket(n8);
                                n8 = ((ServerSocket)object3).getLocalPort();
                                System.err.println("Listening on port " + n8);
                                while (true) {
                                    System.err.print("waiting ... ");
                                    System.err.flush();
                                    object6 = ((ServerSocket)object3).accept();
                                    System.err.println("got connection from " + ((Socket)object6).getInetAddress() + " port:" + ((Socket)object6).getPort());
                                    TelnetRepl.serve(Interpreter.defaultInterpreter, (Socket)object6);
                                }
                            }
                            catch (IOException iOException) {
                                throw new Error(iOException.toString());
                            }
                        }
                        if (string.equals("--main")) {
                            Compilation.generateMainDefault = true;
                        } else if (string.equals("--applet")) {
                            Compilation.generateAppletDefault = true;
                        } else if (string.equals("--servlet")) {
                            Compilation.generateServletDefault = true;
                        } else if (string.equals("--debug-dump-zip")) {
                            ModuleExp.dumpZipPrefix = "kawa-zip-dump-";
                        } else if (string.equals("--debug-print-expr")) {
                            ModuleExp.debugPrintExpr = true;
                        } else if (string.equals("--debug-print-final-expr")) {
                            Compilation.debugPrintFinalExpr = true;
                        } else if (string.equals("--module-static")) {
                            Compilation.moduleStatic = 1;
                        } else if (string.equals("--fewer-classes")) {
                            Compilation.fewerClasses = true;
                        } else if (string.equals("--no-inline") || string.equals("--inline=none")) {
                            Compilation.inlineOk = false;
                        } else if (string.equals("--inline")) {
                            Compilation.inlineOk = true;
                        } else if (string.equals("--cps")) {
                            Compilation.fewerClasses = true;
                            Compilation.usingTailCalls = true;
                            Compilation.usingCPStyle = true;
                        } else if (string.equals("--full-tailcalls")) {
                            Compilation.usingTailCalls = true;
                        } else if (string.equals("--no-full-tailcalls")) {
                            Compilation.usingTailCalls = false;
                        } else if (string.equals("--help")) {
                            repl.printOptions(System.out);
                            System.exit(0);
                        } else if (string.equals("--author")) {
                            System.out.println("Per Bothner <per@bothner.com>");
                            System.exit(0);
                        } else if (string.equals("--version")) {
                            System.out.print("Kawa ");
                            System.out.print(Version.getVersion());
                            System.out.println();
                            System.out.println("Copyright (C) 2002 Per Bothner");
                            bl = true;
                        } else if (string.length() > 0 && string.charAt(0) == '-') {
                            object2 = Interpreter.defaultInterpreter;
                            object3 = string;
                            if (((String)object3).length() > 2 && ((String)object3).charAt(0) == '-') {
                                object3 = ((String)object3).substring(((String)object3).charAt(1) == '-' ? 2 : 1);
                            }
                            if ((object6 = Interpreter.getInstance((String)object3)) == null) {
                                repl.bad_option(string);
                            } else {
                                Interpreter.defaultInterpreter = object6;
                                if (object2 == null) {
                                    Environment.setCurrent(((Interpreter)object6).getEnvironment());
                                }
                            }
                        } else {
                            return n;
                        }
                    }
                }
            }
            ++n;
        }
        return bl ? -1 : n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        block9: {
            block7: {
                block8: {
                    try {
                        int n = repl.processArgs(stringArray, 0, stringArray.length);
                        if (n < 0) {
                            Object var4_2 = null;
                            if (shutdownRegistered) break block7;
                            break block8;
                        }
                        if (n < stringArray.length) {
                            String string = stringArray[n];
                            repl.getInterpreterFromFilenameExtension(string);
                            repl.setArgs(stringArray, n + 1);
                            repl.checkInitFile();
                            Shell.runFile(string);
                            break block9;
                        } else {
                            repl.getInterpreter();
                            repl.setArgs(stringArray, n);
                            repl.checkInitFile();
                            Shell.run(Interpreter.defaultInterpreter);
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (!shutdownRegistered) {
                            OutPort.runCleanups();
                        }
                        repl.exitDecrement();
                        throw throwable;
                    }
                }
                OutPort.runCleanups();
            }
            repl.exitDecrement();
            return;
        }
        Object var4_3 = null;
        if (!shutdownRegistered) {
            OutPort.runCleanups();
        }
        repl.exitDecrement();
    }

    static {
        shutdownRegistered = WriterManager.instance.registerShutdownHook();
    }
}

