/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Location;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.AbstractMethodFilter;
import gnu.expr.ClassInitializer;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ObjectExp;
import gnu.expr.PairClassType;
import gnu.expr.Target;
import gnu.mapping.OutPort;
import java.util.Vector;

public class ClassExp
extends LambdaExp {
    boolean simple;
    ClassType instanceType;
    boolean makeClassPair;
    public Expression[] supers;
    public LambdaExp initMethod;
    boolean partsDeclared;

    public boolean isSimple() {
        return this.simple;
    }

    public void setSimple(boolean bl) {
        this.simple = bl;
    }

    public void setMakingClassPair(boolean bl) {
        this.makeClassPair = bl;
    }

    public boolean isMakingClassPair() {
        return this.makeClassPair;
    }

    public ClassExp() {
        this.type = null;
        this.setCanRead(true);
    }

    public void compile(Compilation compilation, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        ClassType classType = this.compile(compilation);
        this.compilePushClass(compilation, target);
    }

    public void compilePushClass(Compilation compilation, Target target) {
        int n;
        ClassType classType;
        ClassType classType2 = this.type;
        String string = classType2.getName();
        ClassType classType3 = ClassType.make("java.lang.Class");
        Method method = classType3.addMethod("forName", Compilation.string1Arg, classType3, 9);
        CodeAttr codeAttr = compilation.getCode();
        codeAttr.emitPushString(string);
        codeAttr.emitInvokeStatic(method);
        boolean bl = this.getNeedsClosureEnv();
        if (this.isMakingClassPair() || bl) {
            codeAttr.emitPushString(this.instanceType.getName());
            codeAttr.emitInvokeStatic(method);
            classType = ClassType.make("gnu.expr.PairClassType");
            n = bl ? 3 : 2;
        } else {
            classType = ClassType.make("gnu.bytecode.Type");
            n = 1;
        }
        Type[] typeArray = new Type[n];
        if (bl) {
            compilation.curLambda.loadHeapFrame(compilation);
            typeArray[--n] = Type.pointer_type;
        }
        while (--n >= 0) {
            typeArray[n] = classType3;
        }
        Method method2 = classType.addMethod("make", typeArray, classType, 9);
        codeAttr.emitInvokeStatic(method2);
        target.compileFromStack(compilation, classType);
    }

    public String getJavaName() {
        return this.name == null ? "object" : Compilation.mangleNameIfNeeded(this.name);
    }

    public ClassType getCompiledClassType(Compilation compilation) {
        if (!this.partsDeclared) {
            this.getType();
            this.declareParts();
        }
        if (this.type.getName() == null) {
            int n;
            String string = this.getName();
            if (string == null) {
                string = "object";
            } else {
                n = string.length();
                if (n > 2 && string.charAt(0) == '<' && string.charAt(n - 1) == '>') {
                    string = string.substring(1, n - 1);
                }
            }
            if (!this.isSimple() || this instanceof ObjectExp) {
                string = compilation.generateClassName(string);
            } else {
                int n2;
                n = 0;
                StringBuffer stringBuffer = new StringBuffer(100);
                while ((n2 = string.indexOf(46, n)) >= 0) {
                    stringBuffer.append(Compilation.mangleNameIfNeeded(string.substring(n, n2)));
                    stringBuffer.append('.');
                    n = n2 + 1;
                }
                if (n == 0) {
                    int n3;
                    String string2 = compilation.mainClass == null ? null : compilation.mainClass.getName();
                    int n4 = n3 = string2 == null ? -1 : string2.lastIndexOf(46);
                    if (n3 > 0) {
                        stringBuffer.append(string2.substring(0, n3 + 1));
                    } else if (compilation.classPrefix != null) {
                        stringBuffer.append(compilation.classPrefix);
                    }
                }
                if (n < string.length()) {
                    stringBuffer.append(Compilation.mangleNameIfNeeded(string.substring(n)));
                }
                string = stringBuffer.toString();
            }
            this.type.setName(string);
        }
        return this.type;
    }

    void setTypes() {
        ClassType[] classTypeArray;
        ClassType[] classTypeArray2;
        int n = this.supers == null ? 0 : this.supers.length;
        ClassType[] classTypeArray3 = new ClassType[n];
        ClassType[] classTypeArray4 = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            classTypeArray2 = Interpreter.getInterpreter().getTypeFor(this.supers[n3]);
            if (classTypeArray2 == null || !(classTypeArray2 instanceof ClassType)) {
                throw new Error("invalid super type");
            }
            classTypeArray = classTypeArray2;
            if ((classTypeArray.getModifiers() & 0x200) == 0) {
                if (n2 < n3) {
                    throw new Error("duplicate superclass");
                }
                classTypeArray4 = classTypeArray;
            } else {
                classTypeArray3[n2++] = classTypeArray;
            }
            ++n3;
        }
        if (classTypeArray4 == null) {
            if (!this.isSimple()) {
                classTypeArray2 = new PairClassType();
                this.type = classTypeArray2;
                this.setMakingClassPair(true);
                this.instanceType = new ClassType();
                this.type.setInterface(true);
                classTypeArray = new ClassType[]{this.type};
                this.instanceType.setSuper(Type.pointer_type);
                this.instanceType.setInterfaces(classTypeArray);
                classTypeArray2.instanceType = this.instanceType;
            } else {
                this.instanceType = this.type = new ClassType();
            }
            this.type.setSuper(Type.pointer_type);
        } else {
            this.instanceType = this.type = new ClassType();
            this.type.setSuper((ClassType)classTypeArray4);
        }
        this.instanceType.setModifiers(32);
        if (n2 == n) {
            classTypeArray2 = classTypeArray3;
        } else {
            classTypeArray2 = new ClassType[n2];
            System.arraycopy(classTypeArray3, 0, classTypeArray2, 0, n2);
        }
        this.type.setInterfaces(classTypeArray2);
    }

    public Type getType() {
        if (this.type == null) {
            this.setTypes();
        }
        return this.type;
    }

    public void declareParts() {
        if (this.partsDeclared) {
            return;
        }
        this.partsDeclared = true;
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            if (declaration.getCanRead()) {
                Object object2;
                int n = 1;
                if (declaration.getFlag(2048)) {
                    n |= 8;
                }
                if (this.isMakingClassPair()) {
                    object2 = declaration.getType().getImplementationType();
                    this.type.addMethod(ClassExp.slotToMethodName("get", declaration.getName()), n |= 0x400, Type.typeArray0, (Type)object2);
                    Type[] typeArray = new Type[]{object2};
                    this.type.addMethod(ClassExp.slotToMethodName("set", declaration.getName()), n, typeArray, Type.void_type);
                } else {
                    object2 = Compilation.mangleNameIfNeeded(declaration.getName());
                    declaration.field = this.instanceType.addField((String)object2, declaration.getType(), n);
                    declaration.setSimple(false);
                }
            }
            declaration = declaration.nextDecl();
        }
        LambdaExp lambdaExp = this.firstChild;
        while (lambdaExp != null) {
            if (lambdaExp != this.initMethod || !this.isMakingClassPair()) {
                lambdaExp.addMethodFor(this.type, null, null);
            }
            if (this.isMakingClassPair()) {
                lambdaExp.addMethodFor(this.instanceType, null, this.type);
            }
            lambdaExp = lambdaExp.nextSibling;
        }
    }

    static void getImplMethods(ClassType classType, String string, Type[] typeArray, Vector vector) {
        Type[] typeArray2;
        ClassType classType2;
        if (classType instanceof PairClassType) {
            classType2 = ((PairClassType)classType).instanceType;
        } else {
            if (!classType.isInterface()) {
                return;
            }
            typeArray2 = classType.getName() + "$class";
            classType2 = ClassType.make((String)typeArray2);
        }
        typeArray2 = new Type[typeArray.length + 1];
        typeArray2[0] = classType;
        System.arraycopy(typeArray, 0, typeArray2, 1, typeArray.length);
        Method method = classType2.getDeclaredMethod(string, typeArray2);
        if (method != null) {
            int n = vector.size();
            if (n == 0 || !vector.elementAt(n - 1).equals(method)) {
                vector.addElement(method);
            }
        } else {
            ClassType[] classTypeArray = classType.getInterfaces();
            int n = 0;
            while (n < classTypeArray.length) {
                ClassExp.getImplMethods(classTypeArray[n], string, typeArray, vector);
                ++n;
            }
        }
    }

    private static void usedSuperClasses(ClassType classType, Compilation compilation) {
        compilation.usedClass(classType.getSuperclass());
        ClassType[] classTypeArray = classType.getInterfaces();
        if (classTypeArray != null) {
            int n = classTypeArray.length;
            while (--n >= 0) {
                compilation.usedClass(classTypeArray[n]);
            }
        }
    }

    public ClassType compile(Compilation compilation) {
        ClassType classType = compilation.curClass;
        Method method = compilation.method;
        try {
            AttrContainer attrContainer;
            Method[] methodArray;
            Object object2;
            String string;
            ClassType classType2;
            compilation.curClass = classType2 = this.getCompiledClassType(compilation);
            ClassExp.usedSuperClasses(this.type, compilation);
            if (this.type != this.instanceType) {
                ClassExp.usedSuperClasses(this.instanceType, compilation);
            }
            if ((string = this.getFile()) != null) {
                classType2.setSourceFile(string);
            }
            LambdaExp lambdaExp = compilation.curLambda;
            compilation.curLambda = this;
            this.allocFrame(compilation);
            if (this.getNeedsStaticLink()) {
                Object object3 = object2 = lambdaExp.heapFrame != null ? lambdaExp.heapFrame : lambdaExp.closureEnv;
                if (object2 != null) {
                    this.closureEnvField = this.staticLinkField = this.instanceType.addField("this$0", ((Location)object2).getType());
                }
            }
            compilation.generateConstructor(this.instanceType, this);
            LambdaExp lambdaExp2 = this.firstChild;
            while (lambdaExp2 != null) {
                methodArray = compilation.method;
                LambdaExp lambdaExp3 = compilation.curLambda;
                compilation.method = lambdaExp2.getMainMethod();
                lambdaExp2.declareThis(compilation.curClass);
                compilation.curClass = this.instanceType;
                compilation.curLambda = lambdaExp2;
                compilation.method.initCode();
                lambdaExp2.allocChildClasses(compilation);
                lambdaExp2.allocParameters(compilation);
                lambdaExp2.enterFunction(compilation);
                lambdaExp2.compileBody(compilation);
                lambdaExp2.compileEnd(compilation);
                lambdaExp2.compileChildMethods(compilation);
                compilation.method = methodArray;
                compilation.curClass = classType2;
                compilation.curLambda = lambdaExp3;
                lambdaExp2 = lambdaExp2.nextSibling;
            }
            methodArray = this.type.getMethods((Filter)AbstractMethodFilter.instance, 2);
            int n = 0;
            while (n < methodArray.length) {
                block16: {
                    Method method2;
                    Location location2;
                    Object object4;
                    Object object5;
                    Type type;
                    Type[] typeArray;
                    String string2;
                    block17: {
                        char c;
                        block19: {
                            block18: {
                                attrContainer = methodArray[n];
                                string2 = ((Method)attrContainer).getName();
                                typeArray = ((Method)attrContainer).getParameterTypes();
                                type = ((Method)attrContainer).getReturnType();
                                Method method3 = this.instanceType.getMethod(string2, typeArray);
                                if (method3 != null && !method3.isAbstract()) break block16;
                                if (string2.length() <= 3 || string2.charAt(2) != 't' || string2.charAt(1) != 'e' || (c = string2.charAt(0)) != 'g' && c != 's') break block17;
                                if (c != 's' || !type.isVoid() || typeArray.length != 1) break block18;
                                object5 = typeArray[0];
                                break block19;
                            }
                            if (c != 'g' || typeArray.length != 0) break block16;
                            object5 = type;
                        }
                        object4 = Character.toLowerCase(string2.charAt(3)) + string2.substring(4);
                        location2 = this.instanceType.getField((String)object4);
                        if (location2 == null) {
                            location2 = this.instanceType.addField((String)object4, (Type)object5, 1);
                        }
                        method2 = this.instanceType.addMethod(string2, 1, typeArray, type);
                        object2 = method2.startCode();
                        ((CodeAttr)object2).emitPushThis();
                        if (c == 'g') {
                            ((CodeAttr)object2).emitGetField((Field)location2);
                        } else {
                            ((CodeAttr)object2).emitLoad(((CodeAttr)object2).getArg(1));
                            ((CodeAttr)object2).emitPutField((Field)location2);
                        }
                        ((CodeAttr)object2).emitReturn();
                        break block16;
                    }
                    object5 = new Vector();
                    ClassExp.getImplMethods(this.type, string2, typeArray, object5);
                    if (((Vector)object5).size() != 1) {
                        object4 = ((Vector)object5).size() == 0 ? "missing implementation for " : "ambiguous implementation for ";
                        compilation.error('e', (String)object4 + attrContainer);
                    } else {
                        object4 = this.instanceType.addMethod(string2, 1, typeArray, type);
                        object2 = ((Method)object4).startCode();
                        location2 = ((CodeAttr)object2).getCurrentScope().firstVar();
                        while (location2 != null) {
                            ((CodeAttr)object2).emitLoad((Variable)location2);
                            location2 = location2.nextVar();
                        }
                        method2 = (Method)((Vector)object5).elementAt(0);
                        ((CodeAttr)object2).emitInvokeStatic(method2);
                        ((CodeAttr)object2).emitReturn();
                    }
                }
                ++n;
            }
            compilation.curLambda = lambdaExp;
            attrContainer = classType2;
            Object var22_22 = null;
            compilation.curClass = classType;
            compilation.method = method;
            return attrContainer;
        }
        catch (Throwable throwable) {
            Object var22_23 = null;
            compilation.curClass = classType;
            compilation.method = method;
            throw throwable;
        }
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkClassExp(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void walkChildren(ExpWalker expWalker) {
        LambdaExp lambdaExp = expWalker.currentLambda;
        expWalker.currentLambda = this;
        try {
            LambdaExp lambdaExp2 = this.firstChild;
            while (true) {
                block6: {
                    block5: {
                        if (lambdaExp2 == null) break block5;
                        if (expWalker.exitValue == null) break block6;
                    }
                    Object var5_4 = null;
                    expWalker.currentLambda = lambdaExp;
                    return;
                }
                expWalker.walkLambdaExp(lambdaExp2);
                lambdaExp2 = lambdaExp2.nextSibling;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            expWalker.currentLambda = lambdaExp;
            throw throwable;
        }
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(" + this.getExpClassName() + "/", ")", 2);
        if (this.name != null) {
            outPort.print(this.name);
            outPort.print('/');
        }
        outPort.print(this.id);
        outPort.print("/ (");
        Object var2_2 = null;
        int n = 0;
        boolean bl = false;
        int n2 = this.keywords == null ? 0 : this.keywords.length;
        int n3 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n2;
        Declaration declaration = this.firstDecl();
        while (declaration != null) {
            if (n > 0) {
                outPort.print(' ');
            }
            outPort.print(declaration);
            ++n;
            declaration = declaration.nextDecl();
        }
        outPort.print(") ");
        LambdaExp lambdaExp = this.firstChild;
        while (lambdaExp != null) {
            outPort.writeSpaceLinear();
            outPort.print(" method: ");
            lambdaExp.print(outPort);
            lambdaExp = lambdaExp.nextSibling;
        }
        outPort.writeSpaceLinear();
        if (this.body == null) {
            outPort.print("<null body>");
        } else {
            this.body.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    public Field compileSetField(Compilation compilation) {
        return new ClassInitializer((ClassExp)this, (Compilation)compilation).field;
    }

    public static String slotToMethodName(String string, String string2) {
        string2 = Compilation.mangleNameIfNeeded(string2);
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 3);
        stringBuffer.append(string);
        stringBuffer.append(Character.toTitleCase(string2.charAt(0)));
        stringBuffer.append(string2.substring(1));
        return stringBuffer.toString();
    }
}

