/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import java.util.Hashtable;

public abstract class Type {
    String signature;
    String this_name;
    int size;
    static Hashtable mapClassToType;
    static Hashtable mapNameToType;
    public static final PrimType byte_type;
    public static final PrimType short_type;
    public static final PrimType int_type;
    public static final PrimType long_type;
    public static final PrimType float_type;
    public static final PrimType double_type;
    public static final PrimType boolean_type;
    public static final PrimType char_type;
    public static final PrimType void_type;
    public static final PrimType neverReturnsType;
    public static final ObjectType nullType;
    public static ClassType string_type;
    public static ClassType tostring_type;
    public static ClassType pointer_type;
    public static ClassType boolean_ctype;
    public static ClassType throwable_type;
    public static Type[] typeArray0;
    public static Method toString_method;
    public static ClassType number_type;
    public static Method intValue_method;
    public static Method longValue_method;
    public static Method floatValue_method;
    public static Method doubleValue_method;
    public static Method booleanValue_method;
    protected Class reflectClass;

    protected Type() {
    }

    public Type getImplementationType() {
        return this;
    }

    public static Type lookupType(String string) {
        if (mapNameToType == null) {
            mapNameToType = new Hashtable();
            mapNameToType.put("byte", byte_type);
            mapNameToType.put("short", short_type);
            mapNameToType.put("int", int_type);
            mapNameToType.put("long", long_type);
            mapNameToType.put("float", float_type);
            mapNameToType.put("double", double_type);
            mapNameToType.put("boolean", boolean_type);
            mapNameToType.put("char", char_type);
            mapNameToType.put("void", void_type);
        }
        return (Type)mapNameToType.get(string);
    }

    public static Type getType(String string) {
        Type type = Type.lookupType(string);
        if (type == null) {
            if (string.endsWith("[]")) {
                type = Type.getType(string.substring(0, string.length() - 2));
                type = new ArrayType(type, string);
            } else {
                ClassType classType = new ClassType(string);
                classType.flags |= 4;
                type = classType;
            }
            mapNameToType.put(string, type);
        }
        return type;
    }

    public static void registerTypeForClass(Class clazz, Type type) {
        if (mapClassToType == null) {
            mapClassToType = new Hashtable(100);
        }
        mapClassToType.put(clazz, type);
        type.reflectClass = clazz;
    }

    public static Type make(Class clazz) {
        Type type;
        Object object2;
        if (mapClassToType != null && (object2 = mapClassToType.get(clazz)) != null) {
            return (Type)object2;
        }
        if (clazz.isArray()) {
            type = ArrayType.make(Type.make(clazz.getComponentType()));
        } else {
            if (clazz.isPrimitive()) {
                throw new Error("internal error - primitive type not found");
            }
            object2 = clazz.getName();
            type = Type.lookupType(object2);
            if (type == null || type.reflectClass != clazz && type.reflectClass != null) {
                ClassType classType = new ClassType((String)object2);
                classType.flags |= 4;
                type = classType;
                mapNameToType.put(object2, type);
            }
        }
        type.reflectClass = clazz;
        Type.registerTypeForClass(clazz, type);
        return type;
    }

    public final String getSignature() {
        return this.signature;
    }

    protected void setSignature(String string) {
        this.signature = string;
    }

    Type(String string, String string2) {
        this.this_name = string;
        this.signature = string2;
    }

    public Type promote() {
        return this.size < 4 ? int_type : this;
    }

    public final int getSize() {
        return this.size;
    }

    public final boolean isVoid() {
        return this.size == 0;
    }

    public static PrimType signatureToPrimitive(char c) {
        switch (c) {
            case 'B': {
                return byte_type;
            }
            case 'C': {
                return char_type;
            }
            case 'D': {
                return double_type;
            }
            case 'F': {
                return float_type;
            }
            case 'S': {
                return short_type;
            }
            case 'I': {
                return int_type;
            }
            case 'J': {
                return long_type;
            }
            case 'Z': {
                return boolean_type;
            }
            case 'V': {
                return void_type;
            }
        }
        return null;
    }

    public static Type signatureToType(String string, int n, int n2) {
        Type type;
        if (n2 == 0) {
            return null;
        }
        char c = string.charAt(n);
        if (n2 == 1 && (type = Type.signatureToPrimitive(c)) != null) {
            return type;
        }
        if (c == '[') {
            type = Type.signatureToType(string, n + 1, n2 - 1);
            return type == null ? null : new ArrayType(type);
        }
        if (c == 'L' && n2 > 2 && string.indexOf(59, n) == n2 - 1 + n) {
            return ClassType.make(string.substring(n + 1, n2 - 1 + n).replace('/', '.'));
        }
        return null;
    }

    public static Type signatureToType(String string) {
        return Type.signatureToType(string, 0, string.length());
    }

    public static int signatureLength(String string, int n) {
        int n2;
        int n3 = string.length();
        if (n3 <= n) {
            return -1;
        }
        char c = string.charAt(n);
        int n4 = 0;
        while (c == '[') {
            ++n4;
            c = string.charAt(++n);
        }
        if (Type.signatureToPrimitive(c) != null) {
            return n4 + 1;
        }
        if (c == 'L' && (n2 = string.indexOf(59, n)) > 0) {
            return n4 + n2 + 1 - n;
        }
        return -1;
    }

    public static int signatureLength(String string) {
        return Type.signatureLength(string, 0);
    }

    public static String signatureToName(String string) {
        PrimType primType;
        int n = string.length();
        if (n == 0) {
            return null;
        }
        char c = string.charAt(0);
        if (n == 1 && (primType = Type.signatureToPrimitive(c)) != null) {
            return primType.getName();
        }
        if (c == '[') {
            int n2 = 1;
            if (n2 < n && string.charAt(n2) == '[') {
                ++n2;
            }
            if ((string = Type.signatureToName(string.substring(n2))) == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer(50);
            stringBuffer.append(string);
            while (--n2 >= 0) {
                stringBuffer.append("[]");
            }
            return stringBuffer.toString();
        }
        if (c == 'L' && n > 2 && string.indexOf(59) == n - 1) {
            return string.substring(1, n - 1).replace('/', '.');
        }
        return null;
    }

    public final String getName() {
        return this.this_name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidJavaTypeName(String string) {
        boolean bl = false;
        int n = string.length();
        while (n > 2 && string.charAt(n - 1) == ']' && string.charAt(n - 2) == '[') {
            n -= 2;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '.') {
                if (!bl) return false;
                bl = false;
            } else {
                if (!(bl ? Character.isJavaIdentifierPart(c) : Character.isJavaIdentifierStart(c))) return false;
                bl = true;
            }
            ++n2;
        }
        if (n2 != n) return false;
        return true;
    }

    public boolean isInstance(Object object2) {
        return this.getReflectClass().isInstance(object2);
    }

    public final boolean isSubtype(Type type) {
        int n = this.compare(type);
        return n == -1 || n == 0;
    }

    public static Type lowestCommonSuperType(Type type, Type type2) {
        if (type == neverReturnsType) {
            return type2;
        }
        if (type2 == neverReturnsType) {
            return type;
        }
        if (type == null || type2 == null) {
            return null;
        }
        if (type.isSubtype(type2)) {
            return type2;
        }
        if (type2.isSubtype(type)) {
            return type;
        }
        if (!(type instanceof ClassType) || !(type2 instanceof ClassType)) {
            return null;
        }
        ClassType classType = (ClassType)type;
        ClassType classType2 = (ClassType)type2;
        if (classType.isInterface()) {
            return pointer_type;
        }
        if (classType2.isInterface()) {
            return pointer_type;
        }
        return Type.lowestCommonSuperType(classType.getSuperclass(), classType2.getSuperclass());
    }

    public abstract int compare(Type var1);

    protected static int swappedCompareResult(int n) {
        return n == 1 ? -1 : (n == -1 ? 1 : n);
    }

    public static boolean isMoreSpecific(Type[] typeArray, Type[] typeArray2) {
        if (typeArray.length != typeArray2.length) {
            return false;
        }
        int n = typeArray.length;
        while (--n >= 0) {
            if (typeArray[n].isSubtype(typeArray2[n])) continue;
            return false;
        }
        return true;
    }

    public void emitIsInstance(CodeAttr codeAttr) {
        codeAttr.emitInstanceof(this);
    }

    public abstract Object coerceFromObject(Object var1);

    public Object coerceToObject(Object object2) {
        return object2;
    }

    public void emitCoerceToObject(CodeAttr codeAttr) {
    }

    public void emitCoerceFromObject(CodeAttr codeAttr) {
        throw new Error("unimplemented emitCoerceFromObject for " + this);
    }

    public Class getReflectClass() {
        return this.reflectClass;
    }

    public String toString() {
        return "Type " + this.getName();
    }

    static {
        byte_type = new PrimType("byte", "B", 1, Byte.TYPE);
        short_type = new PrimType("short", "S", 2, Short.TYPE);
        int_type = new PrimType("int", "I", 4, Integer.TYPE);
        long_type = new PrimType("long", "J", 8, Long.TYPE);
        float_type = new PrimType("float", "F", 4, Float.TYPE);
        double_type = new PrimType("double", "D", 8, Double.TYPE);
        boolean_type = new PrimType("boolean", "Z", 1, Boolean.TYPE);
        char_type = new PrimType("char", "C", 2, Character.TYPE);
        void_type = new PrimType("void", "V", 0, Void.TYPE);
        neverReturnsType = new PrimType(void_type);
        Type.neverReturnsType.this_name = "(never-returns)";
        nullType = new ObjectType("(type of null)");
        string_type = ClassType.make("java.lang.String");
        tostring_type = new ClassType("java.lang.String");
        pointer_type = ClassType.make("java.lang.Object");
        boolean_ctype = ClassType.make("java.lang.Boolean");
        throwable_type = ClassType.make("java.lang.Throwable");
        typeArray0 = new Type[0];
        toString_method = pointer_type.getDeclaredMethod("toString", 0);
        number_type = ClassType.make("java.lang.Number");
        intValue_method = number_type.addMethod("intValue", typeArray0, int_type, 1);
        longValue_method = number_type.addMethod("longValue", typeArray0, long_type, 1);
        floatValue_method = number_type.addMethod("floatValue", typeArray0, float_type, 1);
        doubleValue_method = number_type.addMethod("doubleValue", typeArray0, double_type, 1);
        booleanValue_method = boolean_ctype.addMethod("booleanValue", typeArray0, boolean_type, 1);
    }
}

