/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEdit;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ComponentMenu;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.PromptAt;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.Example;
import com.sun.electric.tool.user.tecEdit.GeneralInfo;
import com.sun.electric.tool.user.tecEdit.Info;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.NodeInfo;
import com.sun.electric.tool.user.tecEdit.Sample;
import com.sun.electric.tool.user.tecEdit.TechConversionResult;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.FixpRectangle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class Manipulate {
    private static final String PRINTSOLID = "PRINTER: Solid";
    private static final String PRINTPATTERNED = "PRINTER: Patterned";
    private static int[] copiedPattern = null;

    public static void renamedCell(String oldName, String newName, EditingPreferences ep) {
        if (oldName.startsWith("layer-") && newName.startsWith("layer-")) {
            Manipulate.renameSequence(Info.LAYERSEQUENCE_KEY, oldName.substring(6), newName.substring(6), ep);
        }
        if (oldName.startsWith("arc-") && newName.startsWith("arc-")) {
            Manipulate.renameSequence(Info.ARCSEQUENCE_KEY, oldName.substring(4), newName.substring(4), ep);
        }
        if (oldName.startsWith("node-") && newName.startsWith("node-")) {
            Manipulate.renameSequence(Info.NODESEQUENCE_KEY, oldName.substring(5), newName.substring(5), ep);
        }
    }

    public static void deletedCell(Cell np, EditingPreferences ep) {
        if (np.getName().startsWith("layer-")) {
            String layerName = np.getName().substring(6);
            StringBuffer warning = null;
            Iterator<Cell> it = np.getLibrary().getCells();
            block0: while (it.hasNext()) {
                Cell oNp = it.next();
                boolean isNode = false;
                if (oNp.getName().startsWith("node-")) {
                    isNode = true;
                } else if (!oNp.getName().startsWith("arc-")) continue;
                Iterator<NodeInst> nIt = oNp.getNodes();
                while (nIt.hasNext()) {
                    NodeInst ni = nIt.next();
                    Cell varCell = Manipulate.getLayerCell(ni);
                    if (varCell != np) continue;
                    if (warning != null) {
                        warning.append(",");
                    } else {
                        warning = new StringBuffer();
                        warning.append("Warning: layer " + layerName + " is used in");
                    }
                    if (isNode) {
                        warning.append(" node " + oNp.getName().substring(5));
                        continue block0;
                    }
                    warning.append(" arc " + oNp.getName().substring(4));
                    continue block0;
                }
            }
            if (warning != null) {
                System.out.println(warning.toString());
            }
            Manipulate.renamedCell(np.getName(), "", ep);
        } else if (np.getName().startsWith("node-")) {
            Manipulate.renamedCell(np.getName(), "", ep);
        }
    }

    private static void renameSequence(Variable.Key varName, String oldName, String newName, EditingPreferences ep) {
        Library lib = Library.getCurrent();
        Variable var = lib.getVar(varName);
        if (var == null) {
            return;
        }
        String[] strings = (String[])var.getObject();
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(oldName)) continue;
            strings[i] = newName;
        }
        lib.newVar(varName, (Object)strings, ep);
    }

    public static boolean invalidCreation(NodeProto np, Cell cell) {
        if (!cell.getName().startsWith("node-") && !cell.getName().startsWith("arc-")) {
            System.out.println("Must be editing a node or arc to place geometry");
            return true;
        }
        if (np == Generic.tech().portNode && !cell.getName().startsWith("node-")) {
            System.out.println("Can only place ports in node descriptions");
            return true;
        }
        return false;
    }

    public static void makeCell(int type) {
        Library lib = Library.getCurrent();
        String cellName = null;
        switch (type) {
            case 1: {
                String layerName = JOptionPane.showInputDialog("Name of new layer:", (Object)"");
                if (layerName == null) {
                    return;
                }
                cellName = "layer-" + layerName + "{lay}";
                break;
            }
            case 2: {
                String arcName = JOptionPane.showInputDialog("Name of new arc:", (Object)"");
                if (arcName == null) {
                    return;
                }
                cellName = "arc-" + arcName + "{lay}";
                break;
            }
            case 3: {
                String nodeName = JOptionPane.showInputDialog("Name of new node:", (Object)"");
                if (nodeName == null) {
                    return;
                }
                cellName = "node-" + nodeName + "{lay}";
                break;
            }
            case 4: {
                cellName = "factors";
            }
        }
        Cell cell = lib.findNodeProto(cellName);
        if (cell != null) {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf != null) {
                wf.setCellWindow(cell, null);
            }
            return;
        }
        new MakeOneCellJob(lib, cellName, type);
    }

    public static void completeNodeCreation(NodeInst newNi, Variable v) {
        String portName = null;
        if (newNi.getProto() == Generic.tech().portNode && (portName = JOptionPane.showInputDialog("Port name:", (Object)"")) == null) {
            return;
        }
        boolean isHighlight = false;
        if (v != null && v.getObject() instanceof Integer && (Integer)v.getObject() == 19) {
            isHighlight = true;
        }
        new AddTechEditMarks(newNi, isHighlight, portName);
    }

    public static void editLibraryDependencies() {
        new EditDependentLibraries();
    }

    public static void editComponentMenu() {
        String compMenuXML;
        int i;
        Library[] dependentlibs = Info.getDependentLibraries(Library.getCurrent());
        Cell[] layerCells = Info.findCellSequence(dependentlibs, "layer-", Info.LAYERSEQUENCE_KEY);
        Cell[] arcCells = Info.findCellSequence(dependentlibs, "arc-", Info.ARCSEQUENCE_KEY);
        Cell[] nodeCells = Info.findCellSequence(dependentlibs, "node-", Info.NODESEQUENCE_KEY);
        Variable var = Library.getCurrent().getVar(Info.COMPMENU_KEY);
        if (var == null) {
            ArrayList<Object> things = new ArrayList<Object>();
            for (i = 0; i < arcCells.length; ++i) {
                String arcName = arcCells[i].getName().substring(4);
                Xml.ArcProto curArc = new Xml.ArcProto();
                curArc.name = arcName;
                things.add(curArc);
            }
            for (i = 0; i < nodeCells.length; ++i) {
                Cell np = nodeCells[i];
                NodeInfo nIn = NodeInfo.parseCell(np);
                if (nIn.func == PrimitiveNode.Function.NODE) continue;
                String string2 = nodeCells[i].getName().substring(5);
                Xml.PrimitiveNode curNode = new Xml.PrimitiveNode();
                curNode.name = string2;
                curNode.function = nIn.func;
                things.add(curNode);
            }
            things.add("Pure");
            things.add("Misc.");
            things.add("Cell");
            int columns = (things.size() + 13) / 14;
            Xml.MenuPalette xmp = new Xml.MenuPalette();
            xmp.numColumns = columns;
            xmp.menuBoxes = new ArrayList();
            for (Object e : things) {
                if (e instanceof List) {
                    xmp.menuBoxes.add((List)e);
                    continue;
                }
                ArrayList subList = new ArrayList();
                subList.add(e);
                xmp.menuBoxes.add(subList);
            }
            compMenuXML = xmp.writeXml();
        } else {
            compMenuXML = (String)var.getObject();
        }
        ArrayList<Xml.PrimitiveNode> pureLayerNodes = new ArrayList<Xml.PrimitiveNode>();
        for (i = 0; i < layerCells.length; ++i) {
            Xml.PrimitiveNode pln = new Xml.PrimitiveNode();
            pln.name = "node-" + layerCells[i].getName();
            pureLayerNodes.add(pln);
        }
        ArrayList<Xml.PrimitiveNodeGroup> nodeGroups = new ArrayList<Xml.PrimitiveNodeGroup>();
        for (int i2 = 0; i2 < nodeCells.length; ++i2) {
            Xml.PrimitiveNodeGroup ng = new Xml.PrimitiveNodeGroup();
            Xml.PrimitiveNode primitiveNode = new Xml.PrimitiveNode();
            ng.nodes.add(primitiveNode);
            primitiveNode.name = nodeCells[i2].getName().substring(5);
            NodeInfo nIn = NodeInfo.parseCell(nodeCells[i2]);
            primitiveNode.function = nIn.func;
            nodeGroups.add(ng);
        }
        ArrayList<Xml.ArcProto> arcs = new ArrayList<Xml.ArcProto>();
        for (int i3 = 0; i3 < arcCells.length; ++i3) {
            Xml.ArcProto arcProto = new Xml.ArcProto();
            arcProto.name = arcCells[i3].getName().substring(4);
            arcs.add(arcProto);
        }
        Xml.MenuPalette xmp = Xml.parseComponentMenuXMLTechEdit(compMenuXML, nodeGroups, arcs, pureLayerNodes);
        ComponentMenu.showComponentMenuDialog(Library.getCurrent().getName(), xmp, nodeGroups, arcs);
    }

    public static void identifyLayers(boolean doPorts) {
        int i;
        EditWindow wnd = EditWindow.getCurrent();
        Cell np = WindowFrame.needCurCell();
        if (wnd == null || np == null) {
            return;
        }
        if (doPorts) {
            if (!np.getName().startsWith("node-")) {
                System.out.println("Must be editing a node to identify ports");
                return;
            }
        } else if (!np.getName().startsWith("node-") && !np.getName().startsWith("arc-")) {
            System.out.println("Must be editing a node or arc to identify layers");
            return;
        }
        List<Example> neList = null;
        TechConversionResult tcr = new TechConversionResult();
        neList = np.getName().startsWith("node-") ? Example.getExamples(np, true, tcr, null) : Example.getExamples(np, false, tcr, null);
        if (tcr.failed()) {
            tcr.showError();
        }
        if (neList == null || neList.size() == 0) {
            return;
        }
        Example firstEx = neList.get(0);
        int total = 0;
        for (Sample ns : firstEx.samples) {
            if (!doPorts) {
                if (ns.layer == Generic.tech().portNode) continue;
                ++total;
                continue;
            }
            if (ns.layer != Generic.tech().portNode) continue;
            ++total;
        }
        if (total == 0) {
            System.out.println("There are no " + (doPorts ? "ports" : "layers") + " to identify");
            return;
        }
        double[] xPos = new double[total];
        double[] yPos = new double[total];
        Poly.Type[] style = new Poly.Type[total];
        Sample[] whichSam = new Sample[total];
        int qTotal = (total + 3) / 4;
        Rectangle2D screen = wnd.getBoundsInWindow();
        double ySep = screen.getHeight() / (double)qTotal;
        double xSep = screen.getWidth() / (double)qTotal;
        double indent = screen.getHeight() / 15.0;
        for (int i2 = 0; i2 < qTotal; ++i2) {
            xPos[i2] = screen.getMinX() + indent;
            yPos[i2] = screen.getMinY() + ySep * (double)i2 + ySep / 2.0;
            style[i2] = Poly.Type.TEXTLEFT;
            if (i2 + qTotal < total) {
                xPos[i2 + qTotal] = screen.getMinX() + xSep * (double)i2 + xSep / 2.0;
                yPos[i2 + qTotal] = screen.getMaxY() - indent;
                style[i2 + qTotal] = Poly.Type.TEXTTOP;
            }
            if (i2 + qTotal * 2 < total) {
                xPos[i2 + qTotal * 2] = screen.getMaxX() - indent;
                yPos[i2 + qTotal * 2] = screen.getMinY() + ySep * (double)i2 + ySep / 2.0;
                style[i2 + qTotal * 2] = Poly.Type.TEXTRIGHT;
            }
            if (i2 + qTotal * 3 >= total) continue;
            xPos[i2 + qTotal * 3] = screen.getMinX() + xSep * (double)i2 + xSep / 2.0;
            yPos[i2 + qTotal * 3] = screen.getMinY() + indent;
            style[i2 + qTotal * 3] = Poly.Type.TEXTBOT;
        }
        int k = 0;
        for (Sample ns : firstEx.samples) {
            if (!doPorts) {
                if (ns.layer == Generic.tech().portNode) continue;
                whichSam[k++] = ns;
                continue;
            }
            if (ns.layer != Generic.tech().portNode) continue;
            whichSam[k++] = ns;
        }
        double bestDist = Double.MAX_VALUE;
        int bestRot = 0;
        for (i = 0; i < total; ++i) {
            double dist = 0.0;
            for (int j = 0; j < total; ++j) {
                dist += new Point2D.Double(xPos[j], yPos[j]).distance(new Point2D.Double(whichSam[j].xPos, whichSam[j].yPos));
            }
            if (dist < bestDist) {
                bestDist = dist;
                bestRot = i;
            }
            Sample ns = whichSam[0];
            for (int j = 1; j < total; ++j) {
                whichSam[j - 1] = whichSam[j];
            }
            whichSam[total - 1] = ns;
        }
        for (i = 0; i < bestRot; ++i) {
            Sample ns = whichSam[0];
            for (int j = 1; j < total; ++j) {
                whichSam[j - 1] = whichSam[j];
            }
            whichSam[total - 1] = ns;
        }
        Highlighter highlighter = wnd.getHighlighter();
        highlighter.clear();
        for (int i3 = 0; i3 < total; ++i3) {
            Sample ns = whichSam[i3];
            String msg = null;
            if (ns.layer == null) {
                msg = "HIGHLIGHT";
            } else if (ns.layer == Generic.tech().cellCenterNode) {
                msg = "GRAB";
            } else if (ns.layer == Generic.tech().portNode) {
                msg = Info.getPortName(ns.node);
                if (msg == null) {
                    msg = "?";
                }
            } else {
                msg = ns.layer.getName().substring(6);
            }
            Point2D.Double curPt = new Point2D.Double(xPos[i3], yPos[i3]);
            highlighter.addMessage(np, msg, curPt);
            FixpRectangle nodeBounds = ns.node.getBaseShape().getBounds2D();
            Point2D.Double other = null;
            if (style[i3] == Poly.Type.TEXTLEFT) {
                other = new Point2D.Double(((RectangularShape)nodeBounds).getMinX(), ((RectangularShape)nodeBounds).getCenterY());
            } else if (style[i3] == Poly.Type.TEXTRIGHT) {
                other = new Point2D.Double(((RectangularShape)nodeBounds).getMaxX(), ((RectangularShape)nodeBounds).getCenterY());
            } else if (style[i3] == Poly.Type.TEXTTOP) {
                other = new Point2D.Double(((RectangularShape)nodeBounds).getCenterX(), ((RectangularShape)nodeBounds).getMaxY());
            } else if (style[i3] == Poly.Type.TEXTBOT) {
                other = new Point2D.Double(((RectangularShape)nodeBounds).getCenterX(), ((RectangularShape)nodeBounds).getMinY());
            }
            highlighter.addLine(curPt, other, np);
        }
        highlighter.finished();
    }

    public static String describeNodeMeaning(Geometric geom) {
        if (geom instanceof ArcInst) {
            ArcInst ai = (ArcInst)geom;
            if (ai.getProto() != Generic.tech().universal_arc) {
                return "This is an unimportant " + ai.getProto();
            }
            if (ai.getHeadPortInst().getNodeInst().getProto() != Generic.tech().portNode || ai.getTailPortInst().getNodeInst().getProto() != Generic.tech().portNode) {
                return "This arc makes an unimportant connection";
            }
            String pt1 = Info.getPortName(ai.getHeadPortInst().getNodeInst());
            String pt2 = Info.getPortName(ai.getTailPortInst().getNodeInst());
            if (pt1 == null || pt2 == null) {
                return "This arc connects two port objects";
            }
            return "This arc connects ports '" + pt1 + "' and '" + pt2 + "'";
        }
        NodeInst ni = (NodeInst)geom;
        Cell cell = ni.getParent();
        int opt2 = Manipulate.getOptionOnNode(ni);
        if (opt2 < 0) {
            return "No relevance";
        }
        switch (opt2) {
            case 46: {
                return "The technology name";
            }
            case 14: {
                return "The technology scale";
            }
            case 47: {
                return "The technology's foundry";
            }
            case 48: {
                return "The number of metal layers in the technology";
            }
            case 15: {
                return "The technology description";
            }
            case 38: {
                return "Minimum resistance of SPICE elements";
            }
            case 39: {
                return "Minimum capacitance of SPICE elements";
            }
            case 49: {
                return "Maximum series resistance of SPICE elements";
            }
            case 42: {
                return "The shrinkage of gates, in um";
            }
            case 43: {
                return "Whether gates are included in resistance";
            }
            case 44: {
                return "Whether to include the ground network in parasitics";
            }
            case 45: {
                return "The transparent colors";
            }
            case 31: {
                return "The 3D height of " + cell;
            }
            case 32: {
                return "The 3D thickness of " + cell;
            }
            case 1: {
                return "The transparency layer of " + cell;
            }
            case 3: {
                return "The CIF name of " + cell;
            }
            case 33: {
                return "The color of " + cell;
            }
            case 5: {
                return "The unique letter for " + cell + " (obsolete)";
            }
            case 30: {
                return "The DXF name(s) of " + cell + " (obsolete)";
            }
            case 17: {
                return "DRC minimum width " + cell + " (obsolete)";
            }
            case 4: {
                return "The function of " + cell;
            }
            case 20: {
                return "The Calma GDS-II number of " + cell;
            }
            case 7: {
                return "A stipple-pattern controller";
            }
            case 6: {
                return "One of the bitmap squares in " + cell;
            }
            case 28: {
                return "The SPICE capacitance of " + cell;
            }
            case 29: {
                return "The SPICE edge capacitance of " + cell;
            }
            case 27: {
                return "The SPICE resistance of " + cell;
            }
            case 2: {
                return "The style of " + cell;
            }
            case 41: {
                return "The desired coverage percentage for " + cell;
            }
            case 11: {
                return "Whether " + cell + " is fixed-angle";
            }
            case 9: {
                return "The function of " + cell;
            }
            case 23: {
                return "The prefered angle increment of " + cell;
            }
            case 13: {
                return "The arc extension of " + cell;
            }
            case 12: {
                return "Thie arc coverage of " + cell;
            }
            case 40: {
                return "The maximum antenna ratio for " + cell;
            }
            case 62: {
                return "The ELIB width offset for " + cell;
            }
            case 10: {
                return "The function of " + cell;
            }
            case 25: {
                return "Whether " + cell + " can be locked (used in array technologies)";
            }
            case 24: {
                return "The separation between multiple contact cuts in " + cell + " (obsolete)";
            }
            case 16: {
                return "Whether " + cell + " is a serpentine transistor";
            }
            case 21: {
                return "Whether " + cell + " is square";
            }
            case 22: {
                return "Whether " + cell + " disappears when conencted to one or two arcs";
            }
            case 61: {
                return "Spice template for " + cell;
            }
            case 26: {
                return "The grab point of " + cell;
            }
            case 8: 
            case 19: {
                Cell np = Manipulate.getLayerCell(ni);
                if (np == null) {
                    return "Highlight box";
                }
                String msg = "Layer '" + np.getName().substring(6) + "'";
                Variable var = ni.getVar(Info.MINSIZEBOX_KEY);
                if (var != null) {
                    msg = msg + " (at minimum size)";
                }
                return msg;
            }
            case 18: {
                String pt = Info.getPortName(ni);
                if (pt == null) {
                    return "Unnamed port";
                }
                return "Port '" + pt + "'";
            }
        }
        return "Unknown information";
    }

    static Cell getLayerCell(NodeInst ni) {
        Variable var = ni.getVar(Info.LAYER_KEY);
        if (var == null) {
            return null;
        }
        CellId cID = (CellId)var.getObject();
        Cell clientCell = EDatabase.clientDatabase().getCell(cID);
        Cell cell = EDatabase.serverDatabase().getCell(cID);
        if (clientCell != null || cell != null) {
            Iterator<Cell> it = ni.getParent().getLibrary().getCells();
            while (it.hasNext()) {
                Cell oCell = it.next();
                if (oCell != cell && oCell != clientCell) continue;
                return oCell;
            }
        }
        System.out.println("Layer " + cID.cellName + " not found");
        return null;
    }

    public static void modifyObject(EditWindow wnd, NodeInst ni, int opt2) {
        switch (opt2) {
            case 46: {
                Manipulate.modTechShortName(wnd, ni);
                break;
            }
            case 14: {
                Manipulate.modTechScale(wnd, ni);
                break;
            }
            case 47: {
                Manipulate.modTechFoundry(wnd, ni);
                break;
            }
            case 48: {
                Manipulate.modTechNumMetals(wnd, ni);
                break;
            }
            case 15: {
                Manipulate.modTechDescription(wnd, ni);
                break;
            }
            case 38: {
                Manipulate.modTechMinResistance(wnd, ni);
                break;
            }
            case 39: {
                Manipulate.modTechMinCapacitance(wnd, ni);
                break;
            }
            case 49: {
                Manipulate.modTechMaxSeriesResistance(wnd, ni);
                break;
            }
            case 42: {
                Manipulate.modTechGateShrinkage(wnd, ni);
                break;
            }
            case 43: {
                Manipulate.modTechGateIncluded(wnd, ni);
                break;
            }
            case 44: {
                Manipulate.modTechGroundIncluded(wnd, ni);
                break;
            }
            case 45: {
                Manipulate.modTechTransparentColors(wnd, ni);
                break;
            }
            case 4: {
                Manipulate.modLayerFunction(wnd, ni);
                break;
            }
            case 33: {
                Manipulate.modLayerColor(wnd, ni);
                break;
            }
            case 1: {
                Manipulate.modLayerTransparency(wnd, ni);
                break;
            }
            case 2: {
                Manipulate.modLayerStyle(wnd, ni);
                break;
            }
            case 3: {
                Manipulate.modLayerCIF(wnd, ni);
                break;
            }
            case 20: {
                Manipulate.modLayerGDS(wnd, ni);
                break;
            }
            case 27: {
                Manipulate.modLayerResistance(wnd, ni);
                break;
            }
            case 28: {
                Manipulate.modLayerCapacitance(wnd, ni);
                break;
            }
            case 29: {
                Manipulate.modLayerEdgeCapacitance(wnd, ni);
                break;
            }
            case 31: {
                Manipulate.modLayerHeight(wnd, ni);
                break;
            }
            case 32: {
                Manipulate.modLayerThickness(wnd, ni);
                break;
            }
            case 6: {
                Manipulate.modLayerPattern(wnd, ni);
                break;
            }
            case 7: {
                Manipulate.doPatternControl(wnd, ni, 0);
                break;
            }
            case 34: {
                Manipulate.doPatternControl(wnd, ni, 1);
                break;
            }
            case 35: {
                Manipulate.doPatternControl(wnd, ni, 2);
                break;
            }
            case 36: {
                Manipulate.doPatternControl(wnd, ni, 3);
                break;
            }
            case 37: {
                Manipulate.doPatternControl(wnd, ni, 4);
                break;
            }
            case 8: {
                Manipulate.modLayerPatch(wnd, ni);
                break;
            }
            case 41: {
                Manipulate.modLayerCoverage(wnd, ni);
                break;
            }
            case 11: {
                Manipulate.modArcFixAng(wnd, ni);
                break;
            }
            case 9: {
                Manipulate.modArcFunction(wnd, ni);
                break;
            }
            case 23: {
                Manipulate.modArcAngInc(wnd, ni);
                break;
            }
            case 13: {
                Manipulate.modArcExtension(wnd, ni);
                break;
            }
            case 12: {
                Manipulate.modArcWipes(wnd, ni);
                break;
            }
            case 40: {
                Manipulate.modArcAntennaRatio(wnd, ni);
                break;
            }
            case 62: {
                Manipulate.modArcWidthOffset(wnd, ni);
                break;
            }
            case 10: {
                Manipulate.modNodeFunction(wnd, ni);
                break;
            }
            case 25: {
                Manipulate.modNodeLockability(wnd, ni);
                break;
            }
            case 16: {
                Manipulate.modNodeSerpentine(wnd, ni);
                break;
            }
            case 21: {
                Manipulate.modNodeSquare(wnd, ni);
                break;
            }
            case 22: {
                Manipulate.modNodeWipes(wnd, ni);
                break;
            }
            case 61: {
                Manipulate.modNodeSpiceTemplate(wnd, ni);
                break;
            }
            case 18: {
                Manipulate.modPort(wnd, ni);
                break;
            }
            case 19: {
                System.out.println("Cannot modify highlight boxes");
                break;
            }
            default: {
                System.out.println("Cannot modify this object");
            }
        }
    }

    private static void modTechMinResistance(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Minimum Resistance", "Minimum resistance (for parasitics):", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Minimum Resistance: " + newUnit);
        }
    }

    private static void modTechMinCapacitance(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Minimum Capacitance", "Minimum capacitance (for parasitics):", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Minimum Capacitance: " + newUnit);
        }
    }

    private static void modTechMaxSeriesResistance(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Maximum Series Resistance", "Maximum Series Resistance (for parasitics):", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Maximum Series Resistance: " + newUnit);
        }
    }

    private static void modArcAntennaRatio(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Antenna Ratio", "Maximum antenna ratio for this layer:", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Antenna Ratio: " + newUnit);
        }
    }

    private static void modArcWidthOffset(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Width Offset", "ELIB width offset for this arc:", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "ELIB width offset: " + newUnit);
        }
    }

    private static void modLayerCoverage(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Coverage Percent", "Desired coverage percentage:", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Coverage percent: " + newUnit);
        }
    }

    private static void modTechGateShrinkage(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Gate Shrinkage", "Gate shrinkage (in um):", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Gate Shrinkage: " + newUnit);
        }
    }

    private static void modTechGateIncluded(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Whether Gate is Included in Resistance", "Should the gate be included in resistance?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Gates Included in Resistance: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modTechGroundIncluded(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Whether parasitics include the ground network", "Should parasitics include the ground network?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Parasitics Includes Ground: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modTechTransparentColors(EditWindow wnd, NodeInst ni) {
        Color[] colors = GeneralInfo.getTransparentColors(ni);
        if (colors == null) {
            return;
        }
        while (true) {
            PromptAt.Field[][] fields = new PromptAt.Field[colors.length + 1][2];
            for (int i = 0; i < colors.length; ++i) {
                fields[i][0] = new PromptAt.Field("Transparent layer " + (i + 1) + ":", colors[i]);
                JButton but = new JButton("Remove");
                fields[i][1] = new PromptAt.Field("" + (i + 1), but);
            }
            JButton addBut = new JButton("Add");
            fields[colors.length][0] = new PromptAt.Field("add", addBut);
            String choice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Transparent Colors", fields);
            if (choice == null) {
                return;
            }
            if (choice.length() == 0) {
                for (int i = 0; i < colors.length; ++i) {
                    colors[i] = (Color)fields[i][0].getFinal();
                }
                break;
            }
            if (choice.equals("add")) {
                Color[] newColors = new Color[colors.length + 1];
                for (int i = 0; i < colors.length; ++i) {
                    newColors[i] = (Color)fields[i][0].getFinal();
                }
                newColors[colors.length] = new Color(128, 128, 128);
                colors = newColors;
                continue;
            }
            int remove2 = TextUtils.atoi(choice);
            Color[] newColors = new Color[colors.length - 1];
            int j = 0;
            for (int i = 0; i < colors.length; ++i) {
                if (i + 1 == remove2) continue;
                newColors[j++] = (Color)fields[i][0].getFinal();
            }
            colors = newColors;
        }
        new SetTransparentColorJob(ni, GeneralInfo.makeTransparentColorsLine(colors));
        new RedoLayerGraphicsJob(ni.getParent());
    }

    private static void modLayerHeight(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newHei = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change 3D Height", "New 3D height (depth) for this layer:", initialMsg);
        if (newHei != null) {
            new SetTextJob(ni, "3D Height: " + newHei);
        }
    }

    private static void modLayerThickness(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newThk = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change 3D Thickness", "New 3D thickness for this layer:", initialMsg);
        if (newThk != null) {
            new SetTextJob(ni, "3D Thickness: " + newThk);
        }
    }

    private static void modLayerColor(EditWindow wnd, NodeInst ni) {
        String initialString = Info.getValueOnNode(ni);
        StringTokenizer st = new StringTokenizer(initialString, ",");
        if (st.countTokens() != 5) {
            System.out.println("Color information must have 5 fields, separated by commas");
            return;
        }
        PromptAt.Field[] fields = new PromptAt.Field[3];
        int r = TextUtils.atoi(st.nextToken());
        int g = TextUtils.atoi(st.nextToken());
        int b = TextUtils.atoi(st.nextToken());
        fields[0] = new PromptAt.Field("Color:", new Color(r, g, b));
        fields[1] = new PromptAt.Field("Opacity (0-1):", st.nextToken());
        fields[2] = new PromptAt.Field("Foreground:", new String[]{"on", "off"}, st.nextToken());
        String choice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Color", fields);
        if (choice == null) {
            return;
        }
        Color col = (Color)fields[0].getFinal();
        r = col.getRed();
        g = col.getGreen();
        b = col.getBlue();
        double o = TextUtils.atof((String)fields[1].getFinal());
        String oo = (String)fields[2].getFinal();
        new SetTextJob(ni, "Color: " + r + "," + g + "," + b + ", " + o + "," + oo);
        new RedoLayerGraphicsJob(ni.getParent());
    }

    private static void modLayerTransparency(EditWindow wnd, NodeInst ni) {
        String initialTransLayer = Info.getValueOnNode(ni);
        String[] transNames = new String[]{"none", "layer-1", "layer-2", "layer-3", "layer-4", "layer-5", "layer-6", "layer-7", "layer-8", "layer-9", "layer-10"};
        String choice = PromptAt.showPromptAt(wnd, ni, "Change Transparent Layer", "New transparent layer number for this layer:", initialTransLayer, transNames);
        if (choice == null) {
            return;
        }
        new SetTextJob(ni, "Transparency: " + choice);
        new RedoLayerGraphicsJob(ni.getParent());
    }

    private static void modLayerStyle(EditWindow wnd, NodeInst ni) {
        String printerPart;
        String initialStyleName = Info.getValueOnNode(ni);
        int commaPos = initialStyleName.indexOf(44);
        if (commaPos < 0) {
            printerPart = "";
        } else {
            printerPart = initialStyleName.substring(commaPos);
            initialStyleName = initialStyleName.substring(0, commaPos);
        }
        List<EGraphics.Outline> outlines = EGraphics.Outline.getOutlines();
        String[] styleNames = new String[outlines.size() + 3];
        styleNames[0] = "Solid";
        int i = 1;
        for (EGraphics.Outline o : outlines) {
            styleNames[i++] = "Patterned/Outline=" + o.getName();
        }
        styleNames[i++] = PRINTSOLID;
        styleNames[i++] = PRINTPATTERNED;
        String choice = PromptAt.showPromptAt(wnd, ni, "Change Layer Drawing Style", "New drawing style for this layer:", initialStyleName, styleNames);
        if (choice == null) {
            return;
        }
        choice = choice.equals(PRINTSOLID) ? initialStyleName + ",PrintSolid" : (choice.equals(PRINTPATTERNED) ? initialStyleName : choice + printerPart);
        new SetTextJob(ni, "Style: " + choice);
        new RedoLayerGraphicsJob(ni.getParent());
    }

    private static void modLayerCIF(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newCIF = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change CIF layer name", "New CIF symbol for this layer:", initialMsg);
        if (newCIF != null) {
            new SetTextJob(ni, "CIF Layer: " + newCIF);
        }
    }

    private static void modLayerGDS(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newGDS = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change GDS layer name", "New GDS symbol for this layer:", initialMsg);
        if (newGDS != null) {
            new SetTextJob(ni, "GDS-II Layer: " + newGDS);
        }
    }

    private static void modLayerResistance(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newRes = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change SPICE Layer Resistance", "New SPICE resistance for this layer:", initialMsg);
        if (newRes != null) {
            new SetTextJob(ni, "SPICE Resistance: " + newRes);
        }
    }

    private static void modLayerCapacitance(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newCap = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change SPICE Layer Capacitance", "New SPICE capacitance for this layer:", initialMsg);
        if (newCap != null) {
            new SetTextJob(ni, "SPICE Capacitance: " + newCap);
        }
    }

    private static void modLayerEdgeCapacitance(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newCap = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change SPICE Layer Edge Capacitance", "New SPICE edge capacitance for this layer:", initialMsg);
        if (newCap != null) {
            new SetTextJob(ni, "SPICE Edge Capacitance: " + newCap);
        }
    }

    private static void modLayerFunction(EditWindow wnd, NodeInst ni) {
        LayerInfo li;
        String initialFuncName = Info.getValueOnNode(ni);
        int commaPos = initialFuncName.indexOf(44);
        if (commaPos >= 0) {
            initialFuncName = initialFuncName.substring(0, commaPos);
        }
        List<Layer.Function> funs = Layer.Function.getFunctions();
        int[] extraBits = Layer.Function.getFunctionExtras();
        String[] functionNames = new String[funs.size() + extraBits.length];
        int j = 0;
        for (Layer.Function fun : funs) {
            functionNames[j++] = fun.toString();
        }
        for (int i = 0; i < extraBits.length; ++i) {
            functionNames[j++] = Layer.Function.getExtraName(extraBits[i]);
        }
        String choice = PromptAt.showPromptAt(wnd, ni, "Change Layer Function", "New function for this layer:", initialFuncName, functionNames);
        if (choice == null) {
            return;
        }
        int thisExtraBit = -1;
        for (int i = 0; i < extraBits.length; ++i) {
            if (!choice.equals(Layer.Function.getExtraName(extraBits[i]))) continue;
            thisExtraBit = extraBits[i];
            break;
        }
        if ((li = LayerInfo.parseCell(ni.getParent())) == null) {
            return;
        }
        if (thisExtraBit > 0) {
            li.funExtra = (li.funExtra & thisExtraBit) != 0 ? (li.funExtra &= ~thisExtraBit) : (li.funExtra |= thisExtraBit);
        } else {
            li.funExtra = 0;
            for (Layer.Function fun : funs) {
                if (!fun.toString().equalsIgnoreCase(choice)) continue;
                li.fun = fun;
                break;
            }
        }
        new SetTextJob(ni, "Function: " + LayerInfo.makeLayerFunctionName(li.fun, li.funExtra));
    }

    private static void doPatternControl(EditWindow wnd, NodeInst ni, int forced) {
        if (forced == 0) {
            String[] operationNames = new String[]{"Clear Pattern", "Invert Pattern", "Copy Pattern", "Paste Pattern"};
            String choice = PromptAt.showPromptAt(wnd, ni, "Pattern Operations", null, "", operationNames);
            if (choice == null) {
                return;
            }
            if (choice.equals("Clear Pattern")) {
                forced = 1;
            } else if (choice.equals("Invert Pattern")) {
                forced = 2;
            } else if (choice.equals("Copy Pattern")) {
                forced = 3;
            } else if (choice.equals("Paste Pattern")) {
                forced = 4;
            }
        }
        switch (forced) {
            case 1: {
                NodeInst pni;
                Iterator<NodeInst> it = ni.getParent().getNodes();
                while (it.hasNext()) {
                    int color;
                    pni = it.next();
                    int opt2 = Manipulate.getOptionOnNode(pni);
                    if (opt2 != 6 || (color = Manipulate.getLayerColor(pni)) == 0) continue;
                    new SetLayerPatternJob(pni, 0);
                }
                new RedoLayerGraphicsJob(ni.getParent());
                break;
            }
            case 2: {
                NodeInst pni;
                Iterator<NodeInst> it = ni.getParent().getNodes();
                while (it.hasNext()) {
                    pni = it.next();
                    int opt3 = Manipulate.getOptionOnNode(pni);
                    if (opt3 != 6) continue;
                    int color = Manipulate.getLayerColor(pni);
                    new SetLayerPatternJob(pni, ~color);
                }
                new RedoLayerGraphicsJob(ni.getParent());
                break;
            }
            case 3: {
                LayerInfo li = LayerInfo.parseCell(ni.getParent());
                if (li == null) {
                    return;
                }
                copiedPattern = li.desc.getPattern();
                break;
            }
            case 4: {
                if (copiedPattern == null) {
                    return;
                }
                Manipulate.setLayerPattern(ni.getParent(), copiedPattern);
                new RedoLayerGraphicsJob(ni.getParent());
            }
        }
    }

    private static int getLayerColor(NodeInst ni) {
        if (ni.getProto() == Artwork.tech().boxNode) {
            return 0;
        }
        if (ni.getProto() != Artwork.tech().filledBoxNode) {
            return 0;
        }
        Variable var = ni.getVar(Artwork.ART_PATTERN);
        if (var == null) {
            return 65535;
        }
        return ((Short[])var.getObject())[0].intValue();
    }

    private static void modLayerPattern(EditWindow wnd, NodeInst ni) {
        int color = Manipulate.getLayerColor(ni);
        new SetLayerPatternJob(ni, ~color);
        Highlighter h = wnd.getHighlighter();
        h.clear();
        h.addElectricObject(ni, ni.getParent());
        new RedoLayerGraphicsJob(ni.getParent());
    }

    private static String[] getLayerNameList() {
        Library[] dependentlibs = Info.getDependentLibraries(Library.getCurrent());
        Cell[] layerCells = Info.findCellSequence(dependentlibs, "layer-", Info.LAYERSEQUENCE_KEY);
        String[] layerNames = new String[layerCells.length];
        for (int i = 0; i < layerCells.length; ++i) {
            layerNames[i] = layerCells[i].getName().substring(6);
        }
        return layerNames;
    }

    private static String[] getArcNameList() {
        Library[] dependentlibs = Info.getDependentLibraries(Library.getCurrent());
        Cell[] arcCells = Info.findCellSequence(dependentlibs, "arc-", Info.ARCSEQUENCE_KEY);
        String[] arcNames = new String[arcCells.length];
        for (int i = 0; i < arcCells.length; ++i) {
            arcNames[i] = arcCells[i].getName().substring(4);
        }
        return arcNames;
    }

    private static String[] getNodeNameList() {
        Library[] dependentlibs = Info.getDependentLibraries(Library.getCurrent());
        Cell[] nodeCells = Info.findCellSequence(dependentlibs, "node-", Info.NODESEQUENCE_KEY);
        String[] nodeNames = new String[nodeCells.length];
        for (int i = 0; i < nodeCells.length; ++i) {
            nodeNames[i] = nodeCells[i].getName().substring(5);
        }
        return nodeNames;
    }

    private static void modLayerPatch(EditWindow wnd, NodeInst ni) {
        String choice;
        Library[] dependentlibs = Info.getDependentLibraries(Library.getCurrent());
        Cell[] layerCells = Info.findCellSequence(dependentlibs, "layer-", Info.LAYERSEQUENCE_KEY);
        if (layerCells == null) {
            return;
        }
        String[] options = new String[layerCells.length + 2];
        for (int i = 0; i < layerCells.length; ++i) {
            options[i] = layerCells[i].getName().substring(6);
        }
        options[layerCells.length] = "SET-MINIMUM-SIZE";
        options[layerCells.length + 1] = "CLEAR-MINIMUM-SIZE";
        String initial = options[0];
        Cell cell = Manipulate.getLayerCell(ni);
        if (cell != null) {
            initial = cell.getName().substring(6);
        }
        if ((choice = PromptAt.showPromptAt(wnd, ni, "Change Layer", "New layer for this geometry:", initial, options)) == null) {
            return;
        }
        new ModifyLayerJob(ni, choice, layerCells);
    }

    private static void modPort(EditWindow wnd, NodeInst ni) {
        int i;
        ArrayList<Cell> allArcs = new ArrayList<Cell>();
        Iterator<Cell> it = ni.getParent().getLibrary().getCells();
        while (it.hasNext()) {
            Cell cell = it.next();
            if (!cell.getName().startsWith("arc-")) continue;
            allArcs.add(cell);
        }
        HashSet<Cell> connectSet = new HashSet<Cell>();
        Variable var = ni.getVar(Info.CONNECTION_KEY);
        if (var != null) {
            CellId[] connects = (CellId[])var.getObject();
            for (i = 0; i < connects.length; ++i) {
                if (connects[i] == null) continue;
                connectSet.add(EDatabase.clientDatabase().getCell(connects[i]));
            }
        }
        PromptAt.Field[] fields = new PromptAt.Field[allArcs.size() + 3];
        for (i = 0; i < allArcs.size(); ++i) {
            Cell cell = (Cell)allArcs.get(i);
            boolean doesConnect = connectSet.contains(cell);
            fields[i] = new PromptAt.Field(cell.getName().substring(4), new String[]{"Allowed", "Disallowed"}, doesConnect ? "Allowed" : "Disallowed");
        }
        Variable angVar = ni.getVar(Info.PORTANGLE_KEY);
        int ang = 0;
        if (angVar != null) {
            ang = (Integer)angVar.getObject();
        }
        Variable rangeVar = ni.getVar(Info.PORTRANGE_KEY);
        int range2 = 180;
        if (rangeVar != null) {
            range2 = (Integer)rangeVar.getObject();
        }
        Variable meaningVar = ni.getVar(Info.PORTMEANING_KEY);
        int meaning = 0;
        if (meaningVar != null) {
            meaning = (Integer)meaningVar.getObject();
        }
        fields[allArcs.size()] = new PromptAt.Field("Angle:", TextUtils.formatDouble(ang));
        fields[allArcs.size() + 1] = new PromptAt.Field("Angle range:", TextUtils.formatDouble(range2));
        String[] meanings = new String[]{"No meaning", "Gate", "Gated"};
        fields[allArcs.size() + 2] = new PromptAt.Field("Transistor meaning:", meanings, meanings[meaning]);
        String choice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Port", fields);
        if (choice == null) {
            return;
        }
        String[] fieldValues = new String[fields.length];
        for (int i2 = 0; i2 < fields.length; ++i2) {
            fieldValues[i2] = (String)fields[i2].getFinal();
        }
        new ModifyPortJob(ni, allArcs, fieldValues);
    }

    private static void modArcFunction(EditWindow wnd, NodeInst ni) {
        String initialFuncName = Info.getValueOnNode(ni);
        List<ArcProto.Function> funs = ArcProto.Function.getFunctions();
        String[] functionNames = new String[funs.size()];
        for (int i = 0; i < funs.size(); ++i) {
            ArcProto.Function fun = funs.get(i);
            functionNames[i] = fun.toString();
        }
        String choice = PromptAt.showPromptAt(wnd, ni, "Change Arc Function", "New function for this arc:", initialFuncName, functionNames);
        if (choice == null) {
            return;
        }
        new SetTextJob(ni, "Function: " + choice);
    }

    private static void modArcFixAng(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set whether this Arc Remains at a Fixed Angle", "Should instances of this arc be created with the 'fixed angle' constraint?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Fixed-angle: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modArcWipes(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Whether this Arc Can Obscure a Pin Node", "Can this arc obscure a pin node (that is obscurable)?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Wipes pins: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modArcExtension(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Extension Default", "Are new instances of this arc drawn with ends extended?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Extend arcs: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modArcAngInc(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newInc = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Angle Increment", "New angular granularity for placing this type of arc:", initialMsg);
        if (newInc != null) {
            new SetTextJob(ni, "Angle increment: " + newInc);
        }
    }

    private static void modNodeFunction(EditWindow wnd, NodeInst ni) {
        String initialFuncName = Info.getValueOnNode(ni);
        List<PrimitiveNode.Function> funs = PrimitiveNode.Function.getFunctions();
        String[] functionNames = new String[funs.size()];
        for (int i = 0; i < funs.size(); ++i) {
            PrimitiveNode.Function fun = funs.get(i);
            functionNames[i] = fun.toString();
        }
        String choice = PromptAt.showPromptAt(wnd, ni, "Change Node Function", "New function for this node:", initialFuncName, functionNames);
        if (choice == null) {
            return;
        }
        new SetTextJob(ni, "Function: " + choice);
    }

    private static void modNodeSerpentine(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Serpentine Transistor Capability", "Is this node a serpentine transistor?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Serpentine transistor: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modNodeSquare(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Does Node Remain Square", "Must this node remain square?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Square node: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modNodeWipes(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set How Arcs Obscure This Node", "Is this node invisible when 1 or 2 arcs connect to it?", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Invisible with 1 or 2 arcs: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modNodeSpiceTemplate(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newST = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Change Spice Template", "New Spice Template for this node:", initialMsg);
        if (newST != null) {
            new SetTextJob(ni, "Spice Template: " + newST);
        }
    }

    private static void modNodeLockability(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        boolean initialChoice = initialMsg.equalsIgnoreCase("yes");
        boolean finalChoice = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Node Lockability", "Is this node able to be locked down (used for FPGA primitives):", initialChoice);
        if (finalChoice != initialChoice) {
            new SetTextJob(ni, "Lockable: " + (finalChoice ? "Yes" : "No"));
        }
    }

    private static void modTechShortName(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Short Name", "The Short Name of this technology:", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Short Name: " + newUnit);
        }
    }

    private static void modTechScale(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Unit Size", "The scale of this technology (nanometers per grid unit):", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Lambda: " + newUnit);
        }
    }

    private static void modTechFoundry(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newUnit = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Default Foundry", "The default foundry for this technology:", initialMsg);
        if (newUnit != null) {
            new SetTextJob(ni, "Foundry: " + newUnit);
        }
    }

    private static void modTechNumMetals(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newDesc = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Number of Metal Layers", "Number of Metal Layers in this technology:", initialMsg);
        if (newDesc != null) {
            new SetTextJob(ni, "Number of Metal Layers: " + newDesc);
        }
    }

    private static void modTechDescription(EditWindow wnd, NodeInst ni) {
        String initialMsg = Info.getValueOnNode(ni);
        String newDesc = PromptAt.showPromptAt((EditWindow_)wnd, ni, "Set Technology Description", "Full description of this technology:", initialMsg);
        if (newDesc != null) {
            new SetTextJob(ni, "Description: " + newDesc);
        }
    }

    static void setPatch(NodeInst ni, EGraphics desc, EditingPreferences ep) {
        if (desc.getTransparentLayer() > 0) {
            ni.newVar(Artwork.ART_COLOR, (Object)new Integer(EGraphics.makeIndex(desc.getTransparentLayer())), ep);
        } else {
            ni.newVar(Artwork.ART_COLOR, (Object)new Integer(EGraphics.makeIndex(desc.getColor())), ep);
        }
        if (desc.isPatternedOnDisplay()) {
            int[] raster = desc.getPattern();
            Integer[] pattern = new Integer[17];
            for (int i = 0; i < 16; ++i) {
                pattern[i] = new Integer(raster[i]);
            }
            pattern[16] = new Integer(desc.getOutlined().getIndex());
            ni.newVar(Artwork.ART_PATTERN, (Object)pattern, ep);
        } else if (ni.getVar(Artwork.ART_PATTERN) != null) {
            ni.delVar(Artwork.ART_PATTERN);
        }
    }

    private static void setLayerPattern(Cell np, int[] pattern) {
        Variable var;
        NodeInst ni;
        int patternCount = 0;
        ERectangle patternBounds = null;
        Iterator<NodeInst> it = np.getNodes();
        while (it.hasNext()) {
            ni = it.next();
            if (ni.getProto() != Artwork.tech().boxNode && ni.getProto() != Artwork.tech().filledBoxNode || (var = ni.getVar(Info.OPTION_KEY)) == null || (Integer)var.getObject() != 6) continue;
            ERectangle bounds = ni.getBounds();
            if (patternCount == 0) {
                patternBounds = bounds;
            } else {
                Rectangle2D.union(patternBounds, bounds, patternBounds);
            }
            ++patternCount;
        }
        if (patternCount != 256 && patternCount != 128) {
            System.out.println("Incorrect number of pattern boxes in " + np + " (has " + patternCount + ", not " + 256 + ")");
            return;
        }
        it = np.getNodes();
        while (it.hasNext()) {
            int color;
            ni = it.next();
            if (ni.getProto() != Artwork.tech().boxNode && ni.getProto() != Artwork.tech().filledBoxNode || (var = ni.getVar(Info.OPTION_KEY)) == null || (Integer)var.getObject() != 6) continue;
            ERectangle niBounds = ni.getBounds();
            int x2 = (int)((((RectangularShape)niBounds).getMinX() - ((RectangularShape)patternBounds).getMinX()) / (((RectangularShape)patternBounds).getWidth() / 16.0));
            int y = (int)((((RectangularShape)patternBounds).getMaxY() - ((RectangularShape)niBounds).getMaxY()) / (((RectangularShape)patternBounds).getHeight() / 16.0));
            int wantColor = 0;
            if ((pattern[y] & 1 << 15 - x2) != 0) {
                wantColor = 65535;
            }
            if ((color = Manipulate.getLayerColor(ni)) == wantColor) continue;
            new SetLayerPatternJob(ni, wantColor);
        }
    }

    public static int getOptionOnNode(NodeInst ni) {
        Variable var2;
        if (ni.getProto() == Generic.tech().portNode) {
            return 18;
        }
        if (ni.getProto() == Generic.tech().cellCenterNode) {
            return 26;
        }
        Variable var = ni.getVar(Info.OPTION_KEY);
        if (var == null) {
            return -1;
        }
        int option = (Integer)var.getObject();
        if (option == 8 && (var2 = ni.getVar(Info.LAYER_KEY)) != null && var2.getObject() == null) {
            return 19;
        }
        return option;
    }

    public static void reorderPrimitives(int type) {
        new RearrangeOrder(type);
    }

    public static void describeTechnology(Technology tech, EditingPreferences ep) {
        int layerCount = tech.getNumLayers();
        Map<Layer, String> gdsLayers = tech.getGDSLayers();
        DocColumn[] cols = new DocColumn[]{new DocColumn("Layer", layerCount), new DocColumn("Color", layerCount), new DocColumn("Style", layerCount), new DocColumn("CIF", layerCount), new DocColumn("GDS", layerCount), new DocColumn("Function", layerCount), new DocColumn("Coverage", layerCount)};
        Iterator<Layer> it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            cols[0].add(layer.getName());
            EGraphics gra = layer.getGraphics();
            if (gra.getTransparentLayer() > 0) {
                cols[1].add("Transparent " + gra.getTransparentLayer());
            } else {
                Color col = gra.getColor();
                cols[1].add("(" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + ")");
            }
            String tmp = "?";
            tmp = gra.isPatternedOnDisplay() ? (gra.getOutlined() != EGraphics.Outline.NOPAT ? "pat/outl" : "pat") : "solid";
            cols[2].add(tmp);
            cols[3].add(layer.getCIFLayer());
            String gdsLayer = gdsLayers.get(layer);
            cols[4].add(gdsLayer != null ? gdsLayer : "");
            cols[5].add(layer.getFunction().toString());
            cols[6].add(TextUtils.formatDouble(10.0));
        }
        DocColumn.printColumns(cols, "LAYERS IN " + tech.getTechName().toUpperCase());
        cols = new DocColumn[8];
        int numArcs = tech.getNumArcs();
        cols[0] = new DocColumn("Arc", numArcs);
        cols[1] = new DocColumn("Layer", numArcs);
        cols[2] = new DocColumn("Size", numArcs);
        cols[3] = new DocColumn("Extend", numArcs);
        cols[4] = new DocColumn("Angle", numArcs);
        cols[5] = new DocColumn("Wipes", numArcs);
        cols[6] = new DocColumn("Function", numArcs);
        cols[7] = new DocColumn("Antenna", numArcs);
        Iterator<ArcProto> it2 = tech.getArcs();
        while (it2.hasNext()) {
            ArcProto ap = it2.next();
            Poly[] polys = ap.getShapeOfDummyArc(ep, 4000.0);
            for (int k = 0; k < polys.length; ++k) {
                String name = "";
                String extend = "";
                String increment = "";
                String wipe = "";
                String func = "";
                String antenna = "";
                if (k == 0) {
                    name = ap.getName();
                    extend = ap.getFactoryDefaultInst().isTailExtended() ? "yes" : "no";
                    increment = String.valueOf(ap.getFactoryAngleIncrement());
                    wipe = ap.isWipable() ? "yes" : "no";
                    func = ap.getFunction().toString();
                    antenna = TextUtils.formatDouble(ap.getFactoryAntennaRatio());
                }
                cols[0].add(name);
                cols[3].add(extend);
                cols[4].add(increment);
                cols[5].add(wipe);
                cols[6].add(func);
                cols[7].add(antenna);
                Poly poly = polys[k];
                cols[1].add(poly.getLayer().getName());
                FixpRectangle bounds = poly.getBounds2D();
                double width = Math.min(((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight());
                cols[2].add(TextUtils.formatDouble(width));
            }
        }
        DocColumn.printColumns(cols, "ARCS IN " + tech.getTechName().toUpperCase());
        cols = new DocColumn[8];
        int numNodes = tech.getNumNodes();
        cols[0] = new DocColumn("Node", numNodes);
        cols[1] = new DocColumn("Function", numNodes);
        cols[2] = new DocColumn("Layers", numNodes);
        cols[3] = new DocColumn("Size (#instances)", numNodes);
        cols[4] = new DocColumn("Ports", numNodes);
        cols[5] = new DocColumn("Size", numNodes);
        cols[6] = new DocColumn("Angle", numNodes);
        cols[7] = new DocColumn("Connections", numNodes);
        Iterator<PrimitiveNode> it3 = tech.getNodes();
        while (it3.hasNext()) {
            PrimitiveNode np = it3.next();
            if (np.isNotUsed()) continue;
            NodeInst ni = NodeInst.makeDummyInstance((NodeProto)np, ep);
            Poly[] polys = tech.getShapeOfNode(ni);
            HashMap<Layer, ArrayList<Poly>> map2 = new HashMap<Layer, ArrayList<Poly>>();
            for (Poly p : polys) {
                ArrayList<Poly> list2 = (ArrayList<Poly>)map2.get(p.getLayer());
                if (list2 == null) {
                    list2 = new ArrayList<Poly>(1);
                    map2.put(p.getLayer(), list2);
                }
                list2.add(p);
            }
            boolean firstTime = true;
            int numLayers = 0;
            for (Layer layer : map2.keySet()) {
                boolean allIdentical;
                HashSet<ERectangle> set = new HashSet<ERectangle>();
                List list3 = (List)map2.get(layer);
                for (Poly p : list3) {
                    FixpRectangle bound = p.getBounds2D();
                    ERectangle size2 = ERectangle.fromLambda(0.0, 0.0, ((RectangularShape)bound).getWidth(), ((RectangularShape)bound).getHeight());
                    set.add(size2);
                }
                int size3 = list3.size();
                boolean bl = allIdentical = set.size() == 1;
                if (allIdentical) {
                    Poly p = (Poly)list3.get(0);
                    list3.clear();
                    list3.add(p);
                }
                for (Poly poly : list3) {
                    String name = "";
                    String function = "";
                    if (firstTime) {
                        firstTime = false;
                        name = np.getName();
                        function = np.getFunction().getName();
                    }
                    cols[0].add(name);
                    cols[1].add(function);
                    cols[2].add(poly.getLayer().getName());
                    FixpRectangle polyBounds = poly.getBounds2D();
                    String sizeLabel = TextUtils.formatDouble(((RectangularShape)polyBounds).getWidth()) + " x " + TextUtils.formatDouble(((RectangularShape)polyBounds).getHeight());
                    if (allIdentical && size3 > 1) {
                        sizeLabel = sizeLabel + " (" + size3 + ")";
                    }
                    cols[3].add(sizeLabel);
                    ++numLayers;
                }
            }
            int countPorts = 0;
            int extra = 0;
            Iterator<PortProto> pIt = np.getPorts();
            while (pIt.hasNext()) {
                ArcProto[] conList;
                PrimitivePort pp = (PrimitivePort)pIt.next();
                cols[4].add(pp.getName());
                Poly portPoly = ni.getShapeOfPort(pp);
                FixpRectangle portRect = portPoly.getBounds2D();
                cols[5].add(TextUtils.formatDouble(((RectangularShape)portRect).getWidth()) + " x " + TextUtils.formatDouble(((RectangularShape)portRect).getHeight()));
                cols[6].add(pp.getAngleRange() == 180 ? "" : String.valueOf(pp.getAngle()));
                int m = 0;
                for (ArcProto proto : conList = pp.getConnections()) {
                    if (proto.getTechnology() != tech) continue;
                    if (m > 0) {
                        if (countPorts + extra + m >= numLayers) {
                            cols[0].add("");
                            cols[1].add("");
                            cols[2].add("");
                            cols[3].add("");
                        }
                        cols[4].add("");
                        cols[5].add("");
                        cols[6].add("");
                        ++extra;
                    }
                    cols[7].add(proto.getName());
                    ++m;
                }
                if (m == 0) {
                    cols[7].add("<NONE>");
                }
                ++countPorts;
            }
            for (int i = countPorts + extra; i < numLayers; ++i) {
                cols[4].add("");
                cols[5].add("");
                cols[6].add("");
                cols[7].add("");
            }
        }
        DocColumn.printColumns(cols, "NODES IN " + tech.getTechName().toUpperCase());
    }

    static class DocColumn {
        List<String> elements;
        String header;
        int maxWid = 0;

        DocColumn(String header, int numE) {
            this.header = header;
            this.maxWid = header.length();
            this.elements = new ArrayList<String>(numE);
        }

        void add(String el) {
            this.elements.add(el);
            int len = el.length();
            if (this.maxWid < len) {
                this.maxWid = len;
            }
        }

        private String getColumn(String s) {
            int fillS;
            StringBuffer val = new StringBuffer(s);
            val.ensureCapacity(this.maxWid);
            for (int i = fillS = val.length(); i < this.maxWid + 2; ++i) {
                val.append(" ");
            }
            return val.toString();
        }

        String getUnderlying() {
            StringBuffer s = new StringBuffer();
            s.ensureCapacity(this.maxWid);
            for (int i = 0; i < this.maxWid; ++i) {
                s.append("-");
            }
            s.append("  ");
            return s.toString();
        }

        String getHeader() {
            return this.getColumn(this.header);
        }

        String get(int pos) {
            if (pos >= this.elements.size()) {
                return "";
            }
            return this.getColumn(this.elements.get(pos));
        }

        static void printColumns(DocColumn[] cols, String title) {
            int i;
            StringBuffer header = new StringBuffer();
            StringBuffer under = new StringBuffer();
            int totalNumEls = 0;
            for (DocColumn col : cols) {
                header.append(col.getHeader());
                under.append(col.getUnderlying());
                int numEls = col.elements.size();
                if (numEls <= totalNumEls) continue;
                totalNumEls = numEls;
            }
            int numLine = header.length();
            int stars = (numLine - title.length() - 4) / 2;
            for (i = 0; i < stars; ++i) {
                System.out.print("*");
            }
            System.out.print(" " + title + " ");
            for (i = 0; i < stars; ++i) {
                System.out.print("*");
            }
            System.out.println();
            System.out.println(header.toString());
            System.out.println(under.toString());
            for (i = 0; i < totalNumEls; ++i) {
                for (DocColumn col : cols) {
                    System.out.print(col.get(i));
                }
                System.out.println();
            }
            System.out.println();
        }
    }

    private static class RearrangeOrder
    extends EDialog {
        private JList list;
        private DefaultListModel model;
        private Library lib;
        private int type;
        private int startItem;
        private int endItem;
        private boolean endBefore;
        private int endLineHighlightBefore;

        private RearrangeOrder(int type) {
            super((Frame)null, true);
            this.type = type;
            this.lib = Library.getCurrent();
            switch (type) {
                case 1: {
                    this.setTitle("Rearrange Layer Order");
                    break;
                }
                case 2: {
                    this.setTitle("Rearrange Arc Order");
                    break;
                }
                case 3: {
                    this.setTitle("Rearrange Node Order");
                }
            }
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    RearrangeOrder.this.exit(false);
                }
            });
            this.getContentPane().setLayout(new GridBagLayout());
            JLabel title = new JLabel("Drag to reorganize the list");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)title, gbc);
            JScrollPane center = new JScrollPane();
            center.setPreferredSize(new Dimension(300, 150));
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.gridwidth = 2;
            gbc.fill = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)center, gbc);
            this.model = new DefaultListModel();
            this.list = new JList(this.model);
            this.list.setSelectionMode(0);
            center.setViewportView(this.list);
            DragListener dl = new DragListener();
            this.list.addMouseListener(dl);
            this.list.addMouseMotionListener(dl);
            this.list.setCellRenderer(new MyCellRenderer());
            this.model.clear();
            String[] listNames = null;
            switch (type) {
                case 1: {
                    listNames = Manipulate.getLayerNameList();
                    break;
                }
                case 2: {
                    listNames = Manipulate.getArcNameList();
                    break;
                }
                case 3: {
                    listNames = Manipulate.getNodeNameList();
                }
            }
            for (int i = 0; i < listNames.length; ++i) {
                this.model.addElement(listNames[i]);
            }
            this.list.setSelectedIndex(-1);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RearrangeOrder.this.exit(false);
                }
            });
            JButton ok = new JButton("OK");
            this.getRootPane().setDefaultButton(ok);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RearrangeOrder.this.exit(true);
                }
            });
            this.pack();
            this.setVisible(true);
        }

        @Override
        protected void escapePressed() {
            this.exit(false);
        }

        private void exit(boolean goodButton) {
            if (goodButton) {
                String[] newList = new String[this.model.size()];
                for (int i = 0; i < this.model.size(); ++i) {
                    newList[i] = (String)this.model.getElementAt(i);
                }
                new UpdateOrderingJob(this.lib, newList, this.type);
            }
            this.dispose();
        }

        private class DragListener
        implements MouseListener,
        MouseMotionListener {
            private DragListener() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RearrangeOrder.this.startItem = RearrangeOrder.this.list.locationToIndex(e.getPoint());
                RearrangeOrder.this.endItem = RearrangeOrder.this.startItem;
                RearrangeOrder.this.endBefore = true;
                RearrangeOrder.this.endLineHighlightBefore = -1;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.highlightEndItem(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.removeHighlight();
                int newIndex = RearrangeOrder.this.endItem;
                if (!RearrangeOrder.this.endBefore) {
                    ++newIndex;
                }
                if (newIndex > RearrangeOrder.this.startItem) {
                    --newIndex;
                }
                Object was = RearrangeOrder.this.model.getElementAt(RearrangeOrder.this.startItem);
                RearrangeOrder.this.model.remove(RearrangeOrder.this.startItem);
                RearrangeOrder.this.model.add(newIndex, was);
                RearrangeOrder.this.startItem = -1;
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            private void highlightEndItem(MouseEvent e) {
                RearrangeOrder.this.endItem = RearrangeOrder.this.list.locationToIndex(e.getPoint());
                int height = RearrangeOrder.this.list.getFixedCellHeight();
                Point pt = RearrangeOrder.this.list.indexToLocation(RearrangeOrder.this.endItem);
                RearrangeOrder.this.endBefore = e.getPoint().y < pt.y - height / 2;
                this.removeHighlight();
                if (RearrangeOrder.this.startItem == RearrangeOrder.this.endItem) {
                    return;
                }
                if (RearrangeOrder.this.startItem == RearrangeOrder.this.endItem - 1 && RearrangeOrder.this.endBefore) {
                    return;
                }
                if (RearrangeOrder.this.startItem == RearrangeOrder.this.endItem + 1 && !RearrangeOrder.this.endBefore) {
                    return;
                }
                RearrangeOrder.this.endLineHighlightBefore = RearrangeOrder.this.endItem;
                if (!RearrangeOrder.this.endBefore) {
                    RearrangeOrder.this.endLineHighlightBefore++;
                }
                Graphics g = RearrangeOrder.this.list.getGraphics();
                pt = RearrangeOrder.this.list.indexToLocation(RearrangeOrder.this.endLineHighlightBefore);
                Rectangle rect = RearrangeOrder.this.list.getBounds();
                g.setColor(Color.RED);
                g.drawLine(rect.x, pt.y, rect.x + rect.width, pt.y);
            }

            private void removeHighlight() {
                if (RearrangeOrder.this.endLineHighlightBefore >= 0) {
                    Graphics g = RearrangeOrder.this.list.getGraphics();
                    Point pt = RearrangeOrder.this.list.indexToLocation(RearrangeOrder.this.endLineHighlightBefore);
                    Rectangle rect = RearrangeOrder.this.list.getBounds();
                    g.setColor(RearrangeOrder.this.list.getBackground());
                    g.drawLine(rect.x, pt.y, rect.x + rect.width, pt.y);
                    RearrangeOrder.this.endLineHighlightBefore = -1;
                }
            }
        }

        private class MyCellRenderer
        extends JLabel
        implements ListCellRenderer {
            private MyCellRenderer() {
            }

            public Component getListCellRendererComponent(JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                String s = value2.toString();
                this.setText(s);
                if (index == RearrangeOrder.this.startItem) {
                    this.setBackground(list2.getForeground());
                    this.setForeground(list2.getBackground());
                } else {
                    this.setBackground(list2.getBackground());
                    this.setForeground(list2.getForeground());
                }
                this.setEnabled(list2.isEnabled());
                this.setFont(list2.getFont());
                this.setOpaque(true);
                return this;
            }
        }

        private static class UpdateOrderingJob
        extends Job {
            private Library lib;
            private String[] newList;
            private int type;

            private UpdateOrderingJob(Library lib, String[] newList, int type) {
                super("Update Ordering", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
                this.lib = lib;
                this.newList = newList;
                this.type = type;
                this.startJob();
            }

            @Override
            public boolean doIt() throws JobException {
                EditingPreferences ep = this.getEditingPreferences();
                switch (this.type) {
                    case 1: {
                        this.lib.newVar(Info.LAYERSEQUENCE_KEY, (Object)this.newList, ep);
                        break;
                    }
                    case 2: {
                        this.lib.newVar(Info.ARCSEQUENCE_KEY, (Object)this.newList, ep);
                        break;
                    }
                    case 3: {
                        this.lib.newVar(Info.NODESEQUENCE_KEY, (Object)this.newList, ep);
                    }
                }
                return true;
            }

            @Override
            public void terminateOK() {
                WindowFrame.wantToRedoLibraryTree();
            }
        }
    }

    private static class RedoLayerGraphicsJob
    extends Job {
        private Cell cell;

        private RedoLayerGraphicsJob(Cell cell) {
            super("Redo Layer Graphics", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            NodeInst patchNi = null;
            Iterator<NodeInst> it = this.cell.getNodes();
            while (it.hasNext()) {
                int opt2;
                NodeInst ni = it.next();
                if (ni.getProto() != Artwork.tech().filledBoxNode || (opt2 = Manipulate.getOptionOnNode(ni)) == 6) continue;
                patchNi = ni;
                break;
            }
            if (patchNi == null) {
                return false;
            }
            LayerInfo li = LayerInfo.parseCell(this.cell);
            if (li == null) {
                return false;
            }
            Manipulate.setPatch(patchNi, li.desc, ep);
            Iterator<Cell> cIt = this.cell.getLibrary().getCells();
            while (cIt.hasNext()) {
                Cell onp = cIt.next();
                if (!onp.getName().startsWith("arc-") && !onp.getName().startsWith("node-")) continue;
                Iterator<NodeInst> nIt = onp.getNodes();
                while (nIt.hasNext()) {
                    Cell varCell;
                    NodeInst cNi = nIt.next();
                    if (Manipulate.getOptionOnNode(cNi) != 8 || (varCell = Manipulate.getLayerCell(cNi)) != this.cell) continue;
                    Manipulate.setPatch(cNi, li.desc, ep);
                }
            }
            return true;
        }
    }

    private static class SetTransparentColorJob
    extends Job {
        private NodeInst ni;
        private String chr;

        private SetTransparentColorJob(NodeInst ni, String chr) {
            super("Set Transparent Colors", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.chr = chr;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.ni.newVar(Info.TRANSLAYER_KEY, (Object)this.chr, this.getEditingPreferences());
            return true;
        }
    }

    private static class SetTextJob
    extends Job {
        private NodeInst ni;
        private Object chr;

        private SetTextJob(NodeInst ni, Object chr) {
            super("Make Technology Library from Technology", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.chr = chr;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.ni.newDisplayVar(Artwork.ART_MESSAGE, this.chr, this.getEditingPreferences());
            return true;
        }
    }

    private static class ModifyPortJob
    extends Job {
        private NodeInst ni;
        private List<Cell> allArcs;
        private String[] fieldValues;

        private ModifyPortJob(NodeInst ni, List<Cell> allArcs, String[] fieldValues) {
            super("Change Port Information", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.allArcs = allArcs;
            this.fieldValues = fieldValues;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            int numConnects = 0;
            for (int i = 0; i < this.allArcs.size(); ++i) {
                String answer = this.fieldValues[i];
                if (!answer.equals("Allowed")) continue;
                ++numConnects;
            }
            CellId[] newConnects = new CellId[numConnects];
            int k = 0;
            for (int i = 0; i < this.allArcs.size(); ++i) {
                String answer = this.fieldValues[i];
                if (!answer.equals("Allowed")) continue;
                newConnects[k++] = this.allArcs.get(i).getId();
            }
            this.ni.newVar(Info.CONNECTION_KEY, (Object)newConnects, ep);
            int newAngle = TextUtils.atoi(this.fieldValues[this.allArcs.size()]);
            this.ni.newVar(Info.PORTANGLE_KEY, (Object)new Integer(newAngle), ep);
            int newRange = TextUtils.atoi(this.fieldValues[this.allArcs.size() + 1]);
            this.ni.newVar(Info.PORTRANGE_KEY, (Object)new Integer(newRange), ep);
            String newMeaning = this.fieldValues[this.allArcs.size() + 2];
            int meaning = 0;
            if (newMeaning.equals("Gate")) {
                meaning = 1;
            } else if (newMeaning.equals("Gated")) {
                meaning = 2;
            }
            this.ni.newVar(Info.PORTMEANING_KEY, (Object)new Integer(meaning), ep);
            return true;
        }
    }

    private static class ModifyLayerJob
    extends Job {
        private NodeInst ni;
        private String choice;
        private Cell[] layerCells;

        private ModifyLayerJob(NodeInst ni, String choice, Cell[] layerCells) {
            super("Change Layer Information", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.choice = choice;
            this.layerCells = layerCells;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (this.choice.equals("SET-MINIMUM-SIZE")) {
                if (!this.ni.getParent().getName().startsWith("node-")) {
                    System.out.println("Can only set minimum size in node descriptions");
                    return true;
                }
                this.ni.newDisplayVar(Info.MINSIZEBOX_KEY, "MIN", ep);
                return true;
            }
            if (this.choice.equals("CLEAR-MINIMUM-SIZE")) {
                if (this.ni.getVar(Info.MINSIZEBOX_KEY) == null) {
                    System.out.println("Minimum size is not set on this layer");
                    return true;
                }
                this.ni.delVar(Info.MINSIZEBOX_KEY);
                return true;
            }
            for (int i = 0; i < this.layerCells.length; ++i) {
                if (!this.choice.equals(this.layerCells[i].getName().substring(6))) continue;
                LayerInfo li = LayerInfo.parseCell(this.layerCells[i]);
                if (li != null) {
                    Manipulate.setPatch(this.ni, li.desc, ep);
                    this.ni.newVar(Info.LAYER_KEY, (Object)this.layerCells[i].getId(), ep);
                }
                return true;
            }
            System.out.println("Cannot find layer primitive " + this.choice);
            return true;
        }
    }

    private static class SetLayerPatternJob
    extends Job {
        private NodeInst ni;
        private int color;

        private SetLayerPatternJob(NodeInst ni, int color) {
            super("Change Pattern In Layer", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.color = color;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            if (this.ni.getProto() == Artwork.tech().boxNode) {
                if (this.color == 0) {
                    return true;
                }
                this.ni.replace(Artwork.tech().filledBoxNode, ep, false, false);
            } else if (this.ni.getProto() == Artwork.tech().filledBoxNode) {
                Short[] col = new Short[16];
                for (int i = 0; i < 16; ++i) {
                    col[i] = new Short((short)this.color);
                }
                this.ni.newVar(Artwork.ART_PATTERN, (Object)col, ep);
            }
            return true;
        }
    }

    private static class EditDependentLibraries
    extends EDialog {
        private JList allLibsList;
        private JList depLibsList;
        private DefaultListModel allLibsModel;
        private DefaultListModel depLibsModel;
        private JTextField libToAdd;

        private EditDependentLibraries() {
            super((Frame)null, true);
            this.initComponents();
            this.setVisible(true);
        }

        @Override
        protected void escapePressed() {
            this.exit(false);
        }

        private void exit(boolean goodButton) {
            if (goodButton) {
                int numDeps = this.depLibsModel.size();
                String[] depLibs = new String[numDeps];
                for (int i = 0; i < numDeps; ++i) {
                    depLibs[i] = (String)this.depLibsModel.get(i);
                }
                new ModifyDependenciesJob(depLibs);
            }
            this.setVisible(false);
            this.dispose();
        }

        private void removeLib() {
            int index = this.depLibsList.getSelectedIndex();
            if (index < 0) {
                return;
            }
            this.depLibsModel.remove(index);
        }

        private void addLib() {
            String value2 = (String)this.allLibsList.getSelectedValue();
            String specialLib = this.libToAdd.getText();
            if (specialLib.length() > 0) {
                value2 = specialLib;
                this.libToAdd.setText("");
            }
            if (value2 == null) {
                return;
            }
            for (int i = 0; i < this.depLibsModel.size(); ++i) {
                String depLib = (String)this.depLibsModel.get(i);
                if (!depLib.equals(value2)) continue;
                return;
            }
            this.depLibsModel.addElement(value2);
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Dependent Library Selection");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    EditDependentLibraries.this.exit(false);
                }
            });
            JLabel lab1 = new JLabel("Dependent Libraries:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab1, gbc);
            JScrollPane depLibsPane = new JScrollPane();
            this.depLibsModel = new DefaultListModel();
            this.depLibsList = new JList(this.depLibsModel);
            this.depLibsList.setSelectionMode(0);
            depLibsPane.setViewportView(this.depLibsList);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridheight = 4;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)depLibsPane, gbc);
            this.depLibsModel.clear();
            Library[] libs = Info.getDependentLibraries(Library.getCurrent());
            for (int i = 0; i < libs.length; ++i) {
                if (libs[i] == Library.getCurrent()) continue;
                this.depLibsModel.addElement(libs[i].getName());
            }
            JLabel lab2 = new JLabel("Current: " + Library.getCurrent().getName());
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab2, gbc);
            JLabel lab3 = new JLabel("Libraries are examined from bottom up");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 6;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab3, gbc);
            JButton remove2 = new JButton("Remove");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)remove2, gbc);
            remove2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EditDependentLibraries.this.removeLib();
                }
            });
            JButton add = new JButton("<< Add");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)add, gbc);
            add.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EditDependentLibraries.this.addLib();
                }
            });
            JLabel lab4 = new JLabel("All Libraries:");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab4, gbc);
            JScrollPane allLibsPane = new JScrollPane();
            this.allLibsModel = new DefaultListModel();
            this.allLibsList = new JList(this.allLibsModel);
            this.allLibsList.setSelectionMode(0);
            allLibsPane.setViewportView(this.allLibsList);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.gridheight = 2;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)allLibsPane, gbc);
            this.allLibsModel.clear();
            for (Library lib : Library.getVisibleLibraries()) {
                this.allLibsModel.addElement(lib.getName());
            }
            JLabel lab5 = new JLabel("Library (if not in list):");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab5, gbc);
            this.libToAdd = new JTextField("");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 4;
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.libToAdd, gbc);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 6;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EditDependentLibraries.this.exit(false);
                }
            });
            JButton ok = new JButton("OK");
            this.getRootPane().setDefaultButton(ok);
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 6;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EditDependentLibraries.this.exit(true);
                }
            });
            this.pack();
        }

        private static class ModifyDependenciesJob
        extends Job {
            private String[] depLibs;

            private ModifyDependenciesJob(String[] depLibs) {
                super("Modify Library Dependencies", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
                this.depLibs = depLibs;
                this.startJob();
            }

            @Override
            public boolean doIt() throws JobException {
                EditingPreferences ep = this.getEditingPreferences();
                Library lib = Library.getCurrent();
                if (this.depLibs.length == 0) {
                    if (lib.getVar(Info.DEPENDENTLIB_KEY) != null) {
                        lib.delVar(Info.DEPENDENTLIB_KEY);
                    }
                } else {
                    lib.newVar(Info.DEPENDENTLIB_KEY, (Object)this.depLibs, ep);
                }
                return true;
            }
        }
    }

    private static class AddTechEditMarks
    extends Job {
        private NodeInst newNi;
        private boolean isHighlight;
        private String portName;

        private AddTechEditMarks(NodeInst newNi, boolean isHighlight, String portName) {
            super("Prepare node for technology editing", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.newNi = newNi;
            this.isHighlight = isHighlight;
            this.portName = portName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Cell cell;
            EditingPreferences ep = this.getEditingPreferences();
            if (this.isHighlight) {
                this.newNi.newVar(Info.OPTION_KEY, (Object)new Integer(19), ep);
                return true;
            }
            this.newNi.newVar(Info.OPTION_KEY, (Object)new Integer(8), ep);
            if (this.newNi.getProto() == Generic.tech().portNode) {
                this.newNi.newDisplayVar(Info.PORTNAME_KEY, this.portName, ep);
                return true;
            }
            String[] layerNames = Manipulate.getLayerNameList();
            if (layerNames != null && layerNames.length > 0 && (cell = Library.getCurrent().findNodeProto(layerNames[0])) != null) {
                this.newNi.newVar(Info.LAYER_KEY, (Object)cell.getId(), ep);
                LayerInfo li = LayerInfo.parseCell(cell);
                if (li != null) {
                    Manipulate.setPatch(this.newNi, li.desc, ep);
                }
            }
            return true;
        }
    }

    private static class MakeOneCellJob
    extends Job {
        private Library lib;
        private String name;
        private int type;
        private Cell newCell;

        private MakeOneCellJob(Library lib, String name, int type) {
            super("Make Cell in Technology-Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.name = name;
            this.type = type;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            this.newCell = Cell.makeInstance(ep, this.lib, this.name);
            if (this.newCell == null) {
                return false;
            }
            this.newCell.setInTechnologyLibrary();
            this.newCell.setTechnology(Artwork.tech());
            switch (this.type) {
                case 1: {
                    LayerInfo li = new LayerInfo();
                    li.generate(this.newCell, ep);
                    break;
                }
                case 2: {
                    ArcInfo aIn = new ArcInfo();
                    aIn.generate(this.newCell, ep);
                    break;
                }
                case 3: {
                    NodeInfo nIn = new NodeInfo();
                    nIn.generate(this.newCell, ep);
                }
            }
            this.fieldVariableChanged("newCell");
            return true;
        }

        @Override
        public void terminateOK() {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf != null && this.newCell != null) {
                wf.setCellWindow(this.newCell, null);
            }
        }
    }
}

