/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.gates.DrcRing;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class DrcRings {
    public static void addDrcRings(Cell gallery, Filter filter2, StdCellParams stdCell) {
        if (filter2 == null) {
            filter2 = new Filter();
        }
        double spacing = stdCell.getDRCRingSpacing();
        ArrayList<NodeInst> gates = new ArrayList<NodeInst>();
        Iterator<NodeInst> it = gallery.getNodes();
        while (it.hasNext()) {
            gates.add(it.next());
        }
        for (int i = 0; i < gates.size(); ++i) {
            NodeInst ni = (NodeInst)gates.get(i);
            if (filter2.skip(ni) || !ni.isCellInstance()) continue;
            Rectangle2D cellBounds = LayoutLib.getBounds(ni);
            double ringW = cellBounds.getWidth() + spacing;
            double ringH = cellBounds.getHeight() + spacing;
            Cell ringProto = DrcRing.makePart(ringW, ringH, stdCell);
            NodeInst ringInst = LayoutLib.newNodeInst(ringProto, 0.0, 0.0, 0.0, 0.0, 0.0, gallery);
            Rectangle2D ringBounds = LayoutLib.getBounds(ringInst);
            LayoutLib.modNodeInst(ringInst, cellBounds.getCenterX() - ringBounds.getCenterX(), cellBounds.getCenterY() - ringBounds.getCenterY(), 0.0, 0.0, false, false, 0.0);
        }
    }

    public static class Filter {
        public boolean skip(NodeInst ni) {
            return false;
        }
    }
}

