/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SimulatorsTab
extends PreferencePanel {
    private static final int DEBUG_EV = 1;
    private static final int DEBUG_DC = 2;
    private static final int DEBUG_TAU = 4;
    private static final int DEBUG_TAUP = 8;
    private static final int DEBUG_SPK = 16;
    private static final int DEBUG_TW = 32;
    private JCheckBox autoAdvanceTime;
    private JCheckBox debugDC;
    private JCheckBox debugEv;
    private JCheckBox debugSpk;
    private JCheckBox debugTW;
    private JCheckBox debugTau;
    private JCheckBox debugTauP;
    private JCheckBox delayedX;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JCheckBox multistateDisplay;
    private JTextField parameterFile;
    private JCheckBox resimulateEachChange;
    private JButton setParameterFile;
    private JCheckBox showCommands;
    private JComboBox simModel;
    private JPanel simulators;

    public SimulatorsTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getUserPreferencesPanel() {
        return this.simulators;
    }

    public String getName() {
        return "Simulators";
    }

    public void init() {
        this.resimulateEachChange.setSelected(Simulation.isBuiltInResimulateEach());
        this.autoAdvanceTime.setSelected(Simulation.isBuiltInAutoAdvance());
        this.multistateDisplay.setSelected(Simulation.isWaveformDisplayMultiState());
        this.showCommands.setSelected(Simulation.isIRSIMShowsCommands());
        this.delayedX.setSelected(Simulation.isIRSIMDelayedX());
        int initialDebugging = Simulation.getIRSIMDebugging();
        if ((initialDebugging & 1) != 0) {
            this.debugEv.setSelected(true);
        }
        if ((initialDebugging & 2) != 0) {
            this.debugDC.setSelected(true);
        }
        if ((initialDebugging & 4) != 0) {
            this.debugTau.setSelected(true);
        }
        if ((initialDebugging & 8) != 0) {
            this.debugTauP.setSelected(true);
        }
        if ((initialDebugging & 0x10) != 0) {
            this.debugSpk.setSelected(true);
        }
        if ((initialDebugging & 0x20) != 0) {
            this.debugTW.setSelected(true);
        }
        this.parameterFile.setText(Simulation.getIRSIMParameterFile());
        this.simModel.addItem("RC");
        this.simModel.addItem("Linear");
        this.simModel.setSelectedItem(Simulation.getIRSIMStepModel());
        if (!Simulation.hasIRSIM()) {
            this.debugEv.setEnabled(false);
            this.debugDC.setEnabled(false);
            this.debugTau.setEnabled(false);
            this.debugTauP.setEnabled(false);
            this.debugSpk.setEnabled(false);
            this.debugTW.setEnabled(false);
            this.simModel.setEnabled(false);
            this.simModel.setEnabled(false);
            this.parameterFile.setEditable(false);
            this.setParameterFile.setEnabled(false);
            this.showCommands.setEnabled(false);
            this.delayedX.setEnabled(false);
        }
    }

    public void term() {
        String currString;
        boolean currBoolean = this.resimulateEachChange.isSelected();
        if (currBoolean != Simulation.isBuiltInResimulateEach()) {
            Simulation.setBuiltInResimulateEach(currBoolean);
        }
        if ((currBoolean = this.autoAdvanceTime.isSelected()) != Simulation.isBuiltInAutoAdvance()) {
            Simulation.setBuiltInAutoAdvance(currBoolean);
        }
        if ((currBoolean = this.multistateDisplay.isSelected()) != Simulation.isWaveformDisplayMultiState()) {
            Simulation.setWaveformDisplayMultiState(currBoolean);
        }
        if ((currBoolean = this.showCommands.isSelected()) != Simulation.isIRSIMShowsCommands()) {
            Simulation.setIRSIMShowsCommands(currBoolean);
        }
        if ((currBoolean = this.delayedX.isSelected()) != Simulation.isIRSIMDelayedX()) {
            Simulation.setIRSIMDelayedX(currBoolean);
        }
        int currInt = 0;
        if (this.debugEv.isSelected()) {
            currInt |= 1;
        }
        if (this.debugDC.isSelected()) {
            currInt |= 2;
        }
        if (this.debugTau.isSelected()) {
            currInt |= 4;
        }
        if (this.debugTauP.isSelected()) {
            currInt |= 8;
        }
        if (this.debugSpk.isSelected()) {
            currInt |= 0x10;
        }
        if (this.debugTW.isSelected()) {
            currInt |= 0x20;
        }
        if (currInt != Simulation.getIRSIMDebugging()) {
            Simulation.setIRSIMDebugging(currInt);
        }
        if (!(currString = this.parameterFile.getText()).equals(Simulation.getIRSIMParameterFile())) {
            Simulation.setIRSIMParameterFile(currString);
        }
        if (!(currString = (String)this.simModel.getSelectedItem()).equals(Simulation.getIRSIMStepModel())) {
            Simulation.setIRSIMStepModel(currString);
        }
    }

    public void reset() {
        if (Simulation.isFactoryBuiltInResimulateEach() != Simulation.isBuiltInResimulateEach()) {
            Simulation.setBuiltInResimulateEach(Simulation.isFactoryBuiltInResimulateEach());
        }
        if (Simulation.isFactoryBuiltInAutoAdvance() != Simulation.isBuiltInAutoAdvance()) {
            Simulation.setBuiltInAutoAdvance(Simulation.isFactoryBuiltInAutoAdvance());
        }
        if (Simulation.isFactoryWaveformDisplayMultiState() != Simulation.isWaveformDisplayMultiState()) {
            Simulation.setWaveformDisplayMultiState(Simulation.isFactoryWaveformDisplayMultiState());
        }
        if (!Simulation.getFactoryIRSIMParameterFile().equals(Simulation.getIRSIMParameterFile())) {
            Simulation.setIRSIMParameterFile(Simulation.getFactoryIRSIMParameterFile());
        }
        if (!Simulation.getFactoryIRSIMStepModel().equals(Simulation.getIRSIMStepModel())) {
            Simulation.setIRSIMStepModel(Simulation.getFactoryIRSIMStepModel());
        }
        if (Simulation.getFactoryIRSIMDebugging() != Simulation.getIRSIMDebugging()) {
            Simulation.setIRSIMDebugging(Simulation.getFactoryIRSIMDebugging());
        }
        if (Simulation.isFactoryIRSIMShowsCommands() != Simulation.isIRSIMShowsCommands()) {
            Simulation.setIRSIMShowsCommands(Simulation.isFactoryIRSIMShowsCommands());
        }
        if (Simulation.isFactoryIRSIMDelayedX() != Simulation.isIRSIMDelayedX()) {
            Simulation.setIRSIMDelayedX(Simulation.isFactoryIRSIMDelayedX());
        }
    }

    private void initComponents() {
        this.simulators = new JPanel();
        this.jPanel1 = new JPanel();
        this.autoAdvanceTime = new JCheckBox();
        this.resimulateEachChange = new JCheckBox();
        this.multistateDisplay = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.setParameterFile = new JButton();
        this.parameterFile = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.simModel = new JComboBox();
        this.jPanel3 = new JPanel();
        this.debugEv = new JCheckBox();
        this.debugDC = new JCheckBox();
        this.debugTau = new JCheckBox();
        this.debugTauP = new JCheckBox();
        this.debugSpk = new JCheckBox();
        this.debugTW = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.showCommands = new JCheckBox();
        this.delayedX = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SimulatorsTab.this.closeDialog(evt);
            }
        });
        this.simulators.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("For all Built-in Simulators"));
        this.autoAdvanceTime.setText("Auto advance time");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.autoAdvanceTime, gridBagConstraints);
        this.resimulateEachChange.setText("Resimulate each change");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.resimulateEachChange, gridBagConstraints);
        this.multistateDisplay.setText("Multistate display");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.multistateDisplay, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.simulators.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("IRSIM Parasitics"));
        this.setParameterFile.setText("Set");
        this.setParameterFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SimulatorsTab.this.setParameterFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.setParameterFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.parameterFile, gridBagConstraints);
        this.jLabel2.setText("Parameter file:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel4.setText("Model:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.simModel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.simulators.add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("IRSIM Debugging"));
        this.debugEv.setText("Event Scheduling");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.debugEv, gridBagConstraints);
        this.debugDC.setText("Final Value Computation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.debugDC, gridBagConstraints);
        this.debugTau.setText("Tau/Delay Computation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.debugTau, gridBagConstraints);
        this.debugTauP.setText("TauP Computation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.debugTauP, gridBagConstraints);
        this.debugSpk.setText("Spike Analysis");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.debugSpk, gridBagConstraints);
        this.debugTW.setText("Tree Walk");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.debugTW, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.simulators.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("IRSIM Control"));
        this.showCommands.setText("Show IRSIM commands");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.showCommands, gridBagConstraints);
        this.delayedX.setText("Use Delayed X Propagation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel4.add((Component)this.delayedX, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.simulators.add((Component)this.jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.simulators, gridBagConstraints);
        this.pack();
    }

    private void setParameterFileActionPerformed(ActionEvent evt) {
        String paramFile = OpenFile.chooseInputFile(FileType.IRSIMPARAM, "IRSIM Parameter file");
        if (paramFile == null) {
            return;
        }
        this.parameterFile.setText(paramFile);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

