/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.AbstractUserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.menus.FileMenu;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Main {
    private Main() {
    }

    public static void main(String[] args) {
        String serverMachineName;
        ArrayList<String> argsList = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            argsList.add(args[i]);
        }
        if (Main.hasCommandLineOption(argsList, "-v")) {
            System.out.println(Version.getVersion());
            System.exit(0);
        }
        if (Main.hasCommandLineOption(argsList, "-version")) {
            System.out.println(Version.getApplicationInformation());
            System.out.println("\t" + Version.getVersionInformation());
            System.out.println("\t" + Version.getCopyrightInformation());
            System.out.println("\t" + Version.getWarrantyInformation());
            System.exit(0);
        }
        if (Main.hasCommandLineOption(argsList, "-help")) {
            System.out.println("Usage (without plugins):");
            System.out.println("\tjava -jar electric.jar [electric-options]");
            System.out.println("Usage (with plugins):");
            System.out.println("\tjava -classpath electric.jar<delim>{list of plugins} com.sun.electric.Launcher [electric-options]");
            System.out.println("\t\twhere <delim> is OS-dependant separator (colon or semicolon)");
            System.out.println("\nOptions:");
            System.out.println("\t-mdi: multiple document interface mode");
            System.out.println("\t-sdi: single document interface mode");
            System.out.println("\t-NOMINMEM: ignore minimum memory provided for JVM");
            System.out.println("\t-s <script name>: bean shell script to execute");
            System.out.println("\t-version: version information");
            System.out.println("\t-v: brief version information");
            System.out.println("\t-debug: debug mode. Extra information is available");
            System.out.println("\t-threads <numThreads>: recommended size of thread pool for Job execution.");
            System.out.println("\t-batch: running in batch mode.");
            System.out.println("\t-server: dump trace of snapshots");
            System.out.println("\t-client <machine name>: replay trace of snapshots");
            System.out.println("\t-help: this message");
            System.exit(0);
        }
        ActivityLogger.initialize(true, true, true);
        Job.Mode runMode = Job.Mode.FULL_SCREEN;
        if (Main.hasCommandLineOption(argsList, "-debug")) {
            Job.setDebug(true);
        }
        if (Main.hasCommandLineOption(argsList, "-extraDebug")) {
            Job.LOCALDEBUGFLAG = true;
        }
        String numThreadsString = Main.getCommandLineOption(argsList, "-threads");
        int numThreads = 0;
        if (numThreadsString != null && (numThreads = TextUtils.atoi(numThreadsString)) <= 0) {
            System.out.println("Invalid option -threads " + numThreadsString);
        }
        if (Main.hasCommandLineOption(argsList, "-batch")) {
            runMode = Job.Mode.BATCH;
        }
        if (Main.hasCommandLineOption(argsList, "-server")) {
            if (runMode != Job.Mode.FULL_SCREEN) {
                System.out.println("Conflicting thread modes: " + (Object)((Object)runMode) + " and " + (Object)((Object)Job.Mode.SERVER));
            }
            runMode = Job.Mode.SERVER;
        }
        if ((serverMachineName = Main.getCommandLineOption(argsList, "-client")) != null) {
            if (runMode != Job.Mode.FULL_SCREEN) {
                System.out.println("Conflicting thread modes: " + (Object)((Object)runMode) + " and " + (Object)((Object)Job.Mode.CLIENT));
            }
            runMode = Job.Mode.CLIENT;
        }
        UserInterfaceMain.Mode mode = null;
        int defMode = User.getDisplayStyle();
        if (defMode == 1) {
            mode = UserInterfaceMain.Mode.MDI;
        } else if (defMode == 2) {
            mode = UserInterfaceMain.Mode.SDI;
        }
        if (Main.hasCommandLineOption(argsList, "-mdi")) {
            mode = UserInterfaceMain.Mode.MDI;
        }
        if (Main.hasCommandLineOption(argsList, "-sdi")) {
            mode = UserInterfaceMain.Mode.SDI;
        }
        AbstractUserInterface ui = runMode == Job.Mode.FULL_SCREEN || runMode == Job.Mode.CLIENT ? new UserInterfaceMain(argsList, mode, runMode == Job.Mode.FULL_SCREEN) : new UserInterfaceDummy();
        Job.setThreadMode(runMode, ui);
        if (runMode == Job.Mode.BATCH) {
            MessagesStream.getMessagesStream().addObserver(new MessagesStream.OriginalStandardOutWriter());
        }
        EDatabase.serverDatabase();
        InitDatabase job = new InitDatabase(argsList);
        Job.initJobManager(numThreads, job, (Object)mode, serverMachineName);
    }

    private static boolean hasCommandLineOption(List<String> argsList, String option) {
        for (int i = 0; i < argsList.size(); ++i) {
            if (!argsList.get(i).equals(option)) continue;
            argsList.remove(i);
            return true;
        }
        return false;
    }

    private static String getCommandLineOption(List<String> argsList, String option) {
        for (int i = 0; i < argsList.size() - 1; ++i) {
            if (!argsList.get(i).equals(option)) continue;
            argsList.remove(i);
            if (argsList.get(i).startsWith("-")) {
                System.out.println("Bad command line option: " + option + " " + argsList.get(i + 1));
                return null;
            }
            return argsList.remove(i);
        }
        return null;
    }

    public static void openCommandLineLibs(List<String> argsList) {
        for (int i = 0; i < argsList.size(); ++i) {
            String arg = argsList.get(i);
            if (arg.startsWith("-")) {
                System.out.println("Command line option " + arg + " not understood, ignoring.");
                continue;
            }
            URL url = TextUtils.makeURLToFile(arg);
            if (url == null) continue;
            User.setWorkingDirectory(TextUtils.getFilePath(url));
            FileType.setDatabaseGroupPath(User.getWorkingDirectory());
            FileMenu.openLibraryCommand(url);
        }
    }

    public static long getMemoryUsage() {
        Main.collectGarbage();
        Main.collectGarbage();
        long totalMemory = Runtime.getRuntime().totalMemory();
        Main.collectGarbage();
        Main.collectGarbage();
        long freeMemory = Runtime.getRuntime().freeMemory();
        return totalMemory - freeMemory;
    }

    private static void collectGarbage() {
        try {
            System.gc();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InitDatabase
    extends Job {
        List<String> argsList;
        String beanShellScript;

        protected InitDatabase(List<String> argsL) {
            super("Init database", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.argsList = argsL;
            if (Main.hasCommandLineOption(this.argsList, "-NOMINMEM")) {
                // empty if block
            }
            this.beanShellScript = Main.getCommandLineOption(this.argsList, "-s");
        }

        @Override
        public boolean doIt() throws JobException {
            Tool.initAllTools();
            Technology.initAllTechnologies();
            Library mainLib = Library.newInstance("noname", null);
            if (mainLib == null) {
                return false;
            }
            mainLib.clearChanged();
            mainLib.setCurrent();
            if (Job.BATCHMODE && this.beanShellScript != null) {
                EvalJavaBsh.runScript(this.beanShellScript);
            }
            return true;
        }

        @Override
        public void terminateOK() {
            Job.getExtendedUserInterface().finishInitialization();
            Main.openCommandLineLibs(this.argsList);
            if (this.beanShellScript != null) {
                EvalJavaBsh.runScript(this.beanShellScript);
            }
        }

        @Override
        public void terminateFail(Throwable jobException) {
            System.out.println("Initialization failed");
            System.exit(1);
        }
    }

    private static class UserInterfaceDummy
    extends AbstractUserInterface {
        private UserInterfaceDummy() {
        }

        public void startProgressDialog(String type, String filePath) {
        }

        public void stopProgressDialog() {
        }

        public void setProgressValue(long pct) {
        }

        public void setProgressNote(String message) {
        }

        public String getProgressNote() {
            return null;
        }

        public EditWindow_ getCurrentEditWindow_() {
            return null;
        }

        public EditWindow_ needCurrentEditWindow_() {
            System.out.println("Batch mode Electric has no needed windows");
            return null;
        }

        public Cell getCurrentCell() {
            Library lib = Library.getCurrent();
            if (lib == null) {
                return null;
            }
            return lib.getCurCell();
        }

        public Cell getCurrentCell(Library lib) {
            return lib.getCurCell();
        }

        public void setCurrentCell(Library lib, Cell curCell) {
            lib.setCurCell(curCell);
        }

        public Cell needCurrentCell() {
            Cell curCell = this.getCurrentCell();
            if (curCell == null) {
                System.out.println("There is no current cell for this operation.  To create one, use the 'New Cell' command from the 'Cell' menu.");
            }
            return curCell;
        }

        public void repaintAllWindows() {
        }

        public void adjustReferencePoint(Cell cell, double cX, double cY) {
        }

        public void alignToGrid(Point2D pt) {
        }

        public Dimension2D getGridAlignment() {
            return new Dimension2D.Double(1.0, 1.0);
        }

        public int getDefaultTextSize() {
            return 14;
        }

        public EditWindow_ displayCell(Cell cell) {
            return null;
        }

        public void termLogging(ErrorLogger logger, boolean explain, boolean terminate) {
            System.out.println(logger.getInfo());
        }

        public String reportLog(ErrorLogger.MessageLog log, boolean showhigh, Geometric[] gPair) {
            return log.getMessageString();
        }

        public void showErrorMessage(Object message, String title) {
            System.out.println(message);
        }

        public void showInformationMessage(Object message, String title) {
            System.out.println(message);
        }

        public boolean confirmMessage(Object message) {
            return true;
        }

        public int askForChoice(String message, String title, String[] choices, String defaultChoice) {
            System.out.println(message + " CHOOSING " + defaultChoice);
            for (int i = 0; i < choices.length; ++i) {
                if (!choices[i].equals(defaultChoice)) continue;
                return i;
            }
            return 0;
        }

        public String askForInput(Object message, String title, String def) {
            return def;
        }

        public void importPrefs() {
        }

        public void exportPrefs() {
        }
    }
}

