/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.CIF;
import com.sun.electric.tool.io.input.DEF;
import com.sun.electric.tool.io.input.DXF;
import com.sun.electric.tool.io.input.EDIF;
import com.sun.electric.tool.io.input.GDS;
import com.sun.electric.tool.io.input.LEF;
import com.sun.electric.tool.io.input.LibDirs;
import com.sun.electric.tool.io.input.Sue;
import com.sun.electric.tool.io.input.verilog.VerilogReader;
import com.sun.electric.tool.user.ErrorLogger;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;

public class Input {
    protected static final int READ_BUFFER_SIZE = 65536;
    public static ErrorLogger errorLogger;
    private static boolean doChangesQuietly;
    private static boolean newLibraryCreated;
    protected String filePath;
    protected InputStream inputStream;
    protected LineNumberReader lineReader;
    protected DataInputStream dataInputStream;
    protected long fileLength;
    protected long byteCount;
    private String lineBuffer;
    private int lineBufferPosition;

    public static boolean isNewLibraryCreated() {
        return newLibraryCreated;
    }

    public static Library importLibrary(URL fileURL, FileType type) {
        if (fileURL == null) {
            return null;
        }
        StringBuffer errmsg = new StringBuffer();
        if (!TextUtils.URLExists(fileURL, errmsg)) {
            System.out.print(errmsg.toString());
            return null;
        }
        String libName = TextUtils.getFileNameWithoutExtension(fileURL);
        Library lib = Library.newInstance(libName, fileURL);
        newLibraryCreated = true;
        return Input.importLibraryCommon(fileURL, type, lib);
    }

    public static Library importToCurrentLibrary(URL fileURL, FileType type) {
        if (fileURL == null) {
            return null;
        }
        StringBuffer errmsg = new StringBuffer();
        if (!TextUtils.URLExists(fileURL, errmsg)) {
            System.out.print(errmsg.toString());
            return null;
        }
        newLibraryCreated = false;
        return Input.importLibraryCommon(fileURL, type, Library.getCurrent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Library importLibraryCommon(URL fileURL, FileType type, Library lib) {
        long startTime = System.currentTimeMillis();
        errorLogger = ErrorLogger.newInstance("File Import");
        File f = new File(fileURL.getPath());
        if (f != null && f.exists()) {
            LibDirs.readLibDirs(f.getParent());
        }
        try {
            Input.startProgressDialog("import", fileURL.getFile());
            if (type == FileType.DAIS) {
                IOTool.readDais(fileURL, lib, Input.isNewLibraryCreated());
            } else {
                Input in;
                if (type == FileType.VERILOG) {
                    in = new VerilogReader();
                    if (in.openTextInput(fileURL)) {
                        Library library = null;
                        return library;
                    }
                } else if (type == FileType.CIF) {
                    in = new CIF();
                    if (in.openTextInput(fileURL)) {
                        Library library = null;
                        return library;
                    }
                } else if (type == FileType.DEF) {
                    in = new DEF();
                    if (in.openTextInput(fileURL)) {
                        Library library = null;
                        return library;
                    }
                } else if (type == FileType.DXF) {
                    in = new DXF();
                    if (in.openTextInput(fileURL)) {
                        Library library = null;
                        return library;
                    }
                } else if (type == FileType.EDIF) {
                    in = new EDIF();
                    if (in.openTextInput(fileURL)) {
                        Library library = null;
                        return library;
                    }
                } else if (type == FileType.GDS) {
                    in = new GDS();
                    if (in.openBinaryInput(fileURL)) {
                        Library library = null;
                        return library;
                    }
                } else if (type == FileType.LEF) {
                    in = new LEF();
                    if (in.openTextInput(fileURL)) {
                        Library library = null;
                        return library;
                    }
                } else if (type == FileType.SUE) {
                    in = new Sue();
                    if (in.openTextInput(fileURL)) {
                        Library library = null;
                        return library;
                    }
                } else {
                    System.out.println("Unsupported input format");
                    Library library = null;
                    return library;
                }
                in.importALibrary(lib);
                in.closeInput();
            }
        }
        finally {
            Input.stopProgressDialog();
            errorLogger.termLogging(true);
        }
        if (lib == null) {
            System.out.println("Error importing " + lib);
        } else {
            long endTime = System.currentTimeMillis();
            float finalTime = (float)(endTime - startTime) / 1000.0f;
            System.out.println("Library " + fileURL.getFile() + " read, took " + finalTime + " seconds");
        }
        return lib;
    }

    protected boolean importALibrary(Library lib) {
        return true;
    }

    protected boolean openBinaryInput(URL fileURL) {
        this.filePath = fileURL.getFile();
        try {
            URLConnection urlCon = fileURL.openConnection();
            String contentLength = urlCon.getHeaderField("content-length");
            this.fileLength = -1L;
            try {
                this.fileLength = Long.parseLong(contentLength);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.inputStream = urlCon.getInputStream();
        }
        catch (IOException e) {
            System.out.println("Could not find file: " + this.filePath);
            return true;
        }
        this.byteCount = 0L;
        BufferedInputStream bufStrm = new BufferedInputStream(this.inputStream, 65536);
        this.dataInputStream = new DataInputStream(bufStrm);
        return false;
    }

    protected boolean openStringsInput(String[] lines) {
        StringBuffer buffer = new StringBuffer();
        try {
            for (String l : lines) {
                String s = l + "\n";
                buffer.append(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fileLength = lines.length;
        StringReader reader = new StringReader(buffer.toString());
        this.lineReader = new LineNumberReader(reader);
        return false;
    }

    protected boolean openTextInput(URL fileURL) {
        if (this.openBinaryInput(fileURL)) {
            return true;
        }
        InputStreamReader is = new InputStreamReader(this.inputStream);
        this.lineReader = new LineNumberReader(is);
        return false;
    }

    protected static void setProgressNote(String msg) {
        Job.getUserInterface().setProgressNote(msg);
    }

    protected static String getProgressNote() {
        return Job.getUserInterface().getProgressNote();
    }

    protected static void startProgressDialog(String type, String filePath) {
        Job.getUserInterface().startProgressDialog(type, filePath);
    }

    protected static void stopProgressDialog() {
        Job.getUserInterface().stopProgressDialog();
    }

    protected static void setProgressValue(int value) {
        Job.getUserInterface().setProgressValue(value);
    }

    protected void updateProgressDialog(int bytesRead) {
        this.byteCount += (long)bytesRead;
        if (this.fileLength == 0L) {
            return;
        }
        long pct = this.byteCount * 100L / this.fileLength;
        Job.getUserInterface().setProgressValue(pct);
    }

    protected void closeInput() {
        this.dataInputStream = null;
        this.lineReader = null;
        if (this.inputStream == null) {
            return;
        }
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            System.out.println("Error closing file");
        }
        this.inputStream = null;
    }

    protected String getLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.lineReader.read()) == -1) {
                return null;
            }
            if (c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected String getLineFromBinary() throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int c;
            if ((c = this.dataInputStream.read()) == -1) {
                return null;
            }
            if (c == 10 || c == 13) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    protected void initKeywordParsing() {
        this.lineBufferPosition = 0;
        this.lineBuffer = "";
    }

    protected String getRestOfLine() throws IOException {
        int next = this.lineBufferPosition + 1;
        String rest = next < this.lineBuffer.length() ? this.lineBuffer.substring(next, this.lineBuffer.length()) : "";
        this.lineBufferPosition = this.lineBuffer.length();
        this.readNewLine();
        return rest;
    }

    private void readNewLine() throws IOException {
        this.lineBuffer = this.lineReader.readLine();
        if (this.lineBuffer != null) {
            this.updateProgressDialog(this.lineBuffer.length());
            this.lineBuffer = this.preprocessLine(this.lineBuffer);
        }
        this.lineBufferPosition = 0;
    }

    protected String getAKeyword() throws IOException {
        while (true) {
            char chr;
            if (this.lineBuffer == null) {
                return null;
            }
            if (this.lineBufferPosition >= this.lineBuffer.length()) {
                this.readNewLine();
                continue;
            }
            while (this.lineBufferPosition < this.lineBuffer.length() && ((chr = this.lineBuffer.charAt(this.lineBufferPosition)) == ' ' || chr == '\t')) {
                ++this.lineBufferPosition;
            }
            if (this.lineBufferPosition < this.lineBuffer.length()) break;
        }
        int start = this.lineBufferPosition;
        char chr = this.lineBuffer.charAt(this.lineBufferPosition);
        if (this.isBreakCharacter(chr)) {
            ++this.lineBufferPosition;
            return Character.toString(chr);
        }
        while (this.lineBufferPosition < this.lineBuffer.length() && (chr = this.lineBuffer.charAt(this.lineBufferPosition)) != ' ' && chr != '\t' && !this.isBreakCharacter(chr)) {
            ++this.lineBufferPosition;
        }
        return this.lineBuffer.substring(start, this.lineBufferPosition);
    }

    protected boolean isBreakCharacter(char chr) {
        return false;
    }

    protected String preprocessLine(String line) {
        return line;
    }

    public static boolean isChangeQuiet() {
        return doChangesQuietly;
    }

    public static boolean changesQuiet(boolean quiet) {
        Layout.changesQuiet(quiet);
        boolean formerQuiet = doChangesQuietly;
        doChangesQuietly = quiet;
        return formerQuiet;
    }

    protected boolean eofDuring(String when) {
        System.out.println("File " + this.filePath + ", line " + this.lineReader.getLineNumber() + ": End of file while reading " + when);
        return false;
    }

    static {
        doChangesQuietly = false;
        newLibraryCreated = true;
    }
}

