/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class TextAttributesPanel
extends JPanel {
    private static final String displaynone = "None";
    private boolean updateChangesInstantly;
    private boolean loading = false;
    private Variable var;
    private TextDescriptor td;
    private Variable.Key varKey;
    private ElectricObject owner;
    private AbstractTextDescriptor.Unit initialUnit;
    private Object initialDispPos;
    private AbstractTextDescriptor.Code initialCode;
    private JLabel attrInfo1;
    private JLabel attrInfo2;
    private JComboBox code;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JComboBox show;
    private JComboBox units;

    public TextAttributesPanel(boolean updateChangesInstantly) {
        this.updateChangesInstantly = updateChangesInstantly;
        this.initComponents();
        Iterator<Object> it = AbstractTextDescriptor.Code.getCodes();
        while (it.hasNext()) {
            this.code.addItem(it.next());
        }
        it = AbstractTextDescriptor.Unit.getUnits();
        while (it.hasNext()) {
            this.units.addItem(it.next());
        }
        this.populateShowComboBox(true);
        this.initialCode = AbstractTextDescriptor.Code.NONE;
        this.code.setSelectedItem((Object)AbstractTextDescriptor.Code.NONE);
        this.initialUnit = AbstractTextDescriptor.Unit.NONE;
        this.units.setSelectedItem(this.initialUnit);
        this.initialDispPos = AbstractTextDescriptor.DispPos.NAMEVALUE;
        this.show.setSelectedItem(this.initialDispPos);
        this.setVariable(null, null);
        this.code.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextAttributesPanel.this.fieldChanged();
            }
        });
        this.units.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextAttributesPanel.this.fieldChanged();
            }
        });
        this.show.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextAttributesPanel.this.fieldChanged();
            }
        });
    }

    private void fieldChanged() {
        if (!this.updateChangesInstantly) {
            return;
        }
        if (this.loading) {
            return;
        }
        this.applyChanges();
    }

    public synchronized void setVariable(Variable.Key varKey, ElectricObject owner) {
        this.loading = true;
        this.attrInfo1.setText("Attributes created on a cell are");
        this.attrInfo2.setText("inherited by instances of that cell");
        if (varKey != null && varKey.getName().trim().equals("")) {
            varKey = null;
        }
        this.varKey = varKey;
        this.owner = owner;
        boolean enabled = owner != null && varKey != null;
        this.code.setEnabled(enabled);
        this.units.setEnabled(enabled);
        this.show.setEnabled(enabled);
        if (!enabled) {
            return;
        }
        this.td = owner.getTextDescriptor(varKey);
        if (this.td == null) {
            return;
        }
        this.var = owner.getVar(varKey);
        this.initialCode = AbstractTextDescriptor.Code.NONE;
        if (this.var != null) {
            this.initialCode = this.var.getCode();
            this.code.setSelectedItem((Object)this.initialCode);
        } else {
            this.code.setEnabled(false);
        }
        this.initialUnit = this.td.getUnit();
        this.units.setSelectedItem(this.td.getUnit());
        this.initialDispPos = this.td.isDisplay() ? this.td.getDispPart() : displaynone;
        if (this.var != null) {
            this.populateShowComboBox(true);
            if (!this.var.isDisplay()) {
                this.show.setSelectedIndex(0);
            } else {
                this.show.setSelectedItem(this.initialDispPos);
            }
        } else {
            this.populateShowComboBox(false);
            this.show.setSelectedItem(this.initialDispPos);
        }
        if (owner instanceof Cell && !this.td.isInherit()) {
            this.attrInfo1.setText("NOTE: This cell attribute is NOT");
            this.attrInfo2.setText("inherited by instances of the cell");
        }
        this.loading = false;
    }

    public synchronized boolean applyChanges() {
        Object newDisp;
        AbstractTextDescriptor.Unit newUnit;
        if (this.varKey == null) {
            return false;
        }
        boolean changed = false;
        AbstractTextDescriptor.Code newCode = (AbstractTextDescriptor.Code)((Object)this.code.getSelectedItem());
        if (newCode != this.initialCode) {
            changed = true;
        }
        if ((newUnit = (AbstractTextDescriptor.Unit)this.units.getSelectedItem()) != this.initialUnit) {
            changed = true;
        }
        if ((newDisp = this.show.getSelectedItem()) != this.initialDispPos) {
            changed = true;
        }
        int newDispIndex = -1;
        if (newDisp != displaynone) {
            newDispIndex = ((AbstractTextDescriptor.DispPos)newDisp).getIndex();
        }
        if (this.td != null && !changed) {
            return false;
        }
        new ChangeText(this.owner, this.varKey, newCode.getCFlags(), newUnit.getIndex(), newDispIndex);
        this.initialCode = newCode;
        this.initialUnit = newUnit;
        this.initialDispPos = newDisp;
        return true;
    }

    private void populateShowComboBox(boolean includeNoneChoice) {
        this.show.removeAllItems();
        if (includeNoneChoice) {
            this.show.addItem(displaynone);
        }
        Iterator<AbstractTextDescriptor.DispPos> it = AbstractTextDescriptor.DispPos.getShowStyles();
        while (it.hasNext()) {
            this.show.addItem(it.next());
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.code = new JComboBox();
        this.jLabel2 = new JLabel();
        this.units = new JComboBox();
        this.jLabel3 = new JLabel();
        this.show = new JComboBox();
        this.jPanel2 = new JPanel();
        this.attrInfo1 = new JLabel();
        this.attrInfo2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EtchedBorder());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Code:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.jPanel1.add((Component)this.code, gridBagConstraints);
        this.jLabel2.setText("Units:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.jPanel1.add((Component)this.units, gridBagConstraints);
        this.jLabel3.setText("Show:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        this.jPanel1.add((Component)this.show, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.attrInfo1.setText("Attributes created on a cell are");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.attrInfo1, gridBagConstraints);
        this.attrInfo2.setText("inherited by instances of that cell");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.attrInfo2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private static class ChangeText
    extends Job {
        private ElectricObject owner;
        private Variable.Key varKey;
        private int code;
        private int unit;
        private int dispPos;

        private ChangeText(ElectricObject owner, Variable.Key varKey, int code, int unit, int dispPos) {
            super("Modify Text Attribute", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.owner = owner;
            this.varKey = varKey;
            this.code = code;
            this.unit = unit;
            this.dispPos = dispPos;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            TextDescriptor td = this.owner.getTextDescriptor(this.varKey);
            if (td == null) {
                return false;
            }
            Variable var = this.owner.getVar(this.varKey);
            if (var != null) {
                td = td.withCode(AbstractTextDescriptor.Code.getByCBits(this.code));
            }
            td = td.withUnit(AbstractTextDescriptor.Unit.getUnitAt(this.unit));
            if (this.dispPos < 0) {
                if (var != null) {
                    td = td.withDisplay(false);
                }
            } else {
                if (var != null) {
                    td = td.withDisplay(true);
                }
                td = td.withDispPart(AbstractTextDescriptor.DispPos.getShowStylesAt(this.dispPos));
            }
            this.owner.setTextDescriptor(this.varKey, td);
            return true;
        }
    }
}

