/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.projsettings;

import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SkillTab
extends ProjSettingsPanel {
    private JList skillLayerList;
    private DefaultListModel skillLayerModel;
    private HashMap<Layer, String> skillLayers;
    private Technology curTech;
    private JLabel jLabel11;
    private JPanel skill;
    private JTextField skillLayerName;
    private JScrollPane skillLayerPane;
    private JLabel skillNoSkill;
    private JLabel skillTechnology;

    public SkillTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.skill;
    }

    public String getName() {
        return "Skill";
    }

    public void init() {
        this.skillLayerModel = new DefaultListModel();
        this.skillLayerList = new JList(this.skillLayerModel);
        this.skillLayerList.setSelectionMode(0);
        this.skillLayerPane.setViewportView(this.skillLayerList);
        this.skillLayerList.clearSelection();
        this.skillLayerList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                SkillTab.this.skillClickLayer();
            }
        });
        this.skillLayerModel.clear();
        this.skillLayers = new HashMap();
        this.curTech = Technology.getCurrent();
        this.skillTechnology.setText("Skill layers for technology: " + this.curTech.getTechName());
        Iterator<Layer> it = this.curTech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            String skillLayerName = layer.getSkillLayer();
            if (skillLayerName == null) {
                skillLayerName = "";
            }
            this.skillLayers.put(layer, skillLayerName);
            this.skillLayerModel.addElement(layer.getName() + " (" + skillLayerName + ")");
        }
        this.skillLayerList.setSelectedIndex(0);
        this.skillClickLayer();
        this.skillLayerName.getDocument().addDocumentListener(new LayerDocumentListener(this));
        if (!IOTool.hasSkill()) {
            this.skillNoSkill.setText("SKILL OUTPUT IS NOT INSTALLED!");
        }
    }

    private void skillLayerChanged() {
        Layer layer;
        String str = (String)this.skillLayerList.getSelectedValue();
        int spacePos = str.indexOf(" ");
        if (spacePos >= 0) {
            str = str.substring(0, spacePos);
        }
        if ((layer = this.curTech.findLayer(str)) == null) {
            return;
        }
        String layerName = this.skillLayerName.getText();
        this.skillLayers.put(layer, layerName);
        String newLine = layer.getName() + " (" + layerName + ")";
        int index = this.skillLayerList.getSelectedIndex();
        this.skillLayerModel.set(index, newLine);
    }

    private void skillClickLayer() {
        Layer layer;
        String str = (String)this.skillLayerList.getSelectedValue();
        int spacePos = str.indexOf(" ");
        if (spacePos >= 0) {
            str = str.substring(0, spacePos);
        }
        if ((layer = this.curTech.findLayer(str)) == null) {
            return;
        }
        String shownValue = this.skillLayers.get(layer);
        this.skillLayerName.setText(shownValue);
    }

    public void term() {
        for (Layer layer : this.skillLayers.keySet()) {
            String layerName = this.skillLayers.get(layer);
            if (layer.getSkillLayer().equals(layerName)) continue;
            layer.setSkillLayer(layerName);
        }
    }

    private void initComponents() {
        this.skill = new JPanel();
        this.skillLayerPane = new JScrollPane();
        this.skillLayerName = new JTextField();
        this.jLabel11 = new JLabel();
        this.skillNoSkill = new JLabel();
        this.skillTechnology = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SkillTab.this.closeDialog(evt);
            }
        });
        this.skill.setLayout(new GridBagLayout());
        this.skillLayerPane.setMinimumSize(new Dimension(150, 150));
        this.skillLayerPane.setPreferredSize(new Dimension(150, 150));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.skill.add((Component)this.skillLayerPane, gridBagConstraints);
        this.skillLayerName.setColumns(6);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.skill.add((Component)this.skillLayerName, gridBagConstraints);
        this.jLabel11.setText("SKILL Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.skill.add((Component)this.jLabel11, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.skill.add((Component)this.skillNoSkill, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.skill.add((Component)this.skillTechnology, gridBagConstraints);
        this.getContentPane().add((Component)this.skill, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class LayerDocumentListener
    implements DocumentListener {
        SkillTab dialog;

        LayerDocumentListener(SkillTab dialog) {
            this.dialog = dialog;
        }

        public void changedUpdate(DocumentEvent e) {
            this.dialog.skillLayerChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.dialog.skillLayerChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.dialog.skillLayerChanged();
        }
    }
}

