/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Vector;
import snmp.SNMPBERCodec;
import snmp.SNMPBadValueException;
import snmp.SNMPGetException;
import snmp.SNMPMessage;
import snmp.SNMPObject;
import snmp.SNMPObjectIdentifier;
import snmp.SNMPPDU;
import snmp.SNMPRequestException;
import snmp.SNMPRequestListener;
import snmp.SNMPSequence;
import snmp.SNMPSetException;
import snmp.SNMPVariablePair;

public class SNMPv1AgentInterface
implements Runnable {
    public static final int SNMP_PORT = 161;
    public static final int MAXSIZE = 512;
    int version = 0;
    private DatagramSocket dSocket;
    private Thread receiveThread;
    private Vector listenerVector;

    public SNMPv1AgentInterface(int n) throws SocketException {
        this(n, 161);
    }

    public SNMPv1AgentInterface(int n, int n2) throws SocketException {
        this.version = n;
        this.dSocket = new DatagramSocket(n2);
        this.listenerVector = new Vector();
        this.receiveThread = new Thread(this);
    }

    public void addRequestListener(SNMPRequestListener sNMPRequestListener) {
        for (int i = 0; i < this.listenerVector.size(); ++i) {
            if (sNMPRequestListener != this.listenerVector.elementAt(i)) continue;
            return;
        }
        this.listenerVector.add(sNMPRequestListener);
    }

    public void removeRequestListener(SNMPRequestListener sNMPRequestListener) {
        for (int i = 0; i < this.listenerVector.size(); ++i) {
            if (sNMPRequestListener != this.listenerVector.elementAt(i)) continue;
            this.listenerVector.removeElementAt(i);
            break;
        }
    }

    public void startReceiving() {
        if (!this.receiveThread.isAlive()) {
            this.receiveThread = new Thread(this);
            this.receiveThread.start();
        }
    }

    public void stopReceiving() throws SocketException {
        this.receiveThread.interrupt();
    }

    public void run() {
        try {
            while (!this.receiveThread.isInterrupted()) {
                Object object;
                Object object2;
                DatagramPacket datagramPacket = new DatagramPacket(new byte[512], 512);
                this.dSocket.receive(datagramPacket);
                InetAddress inetAddress = datagramPacket.getAddress();
                int n = datagramPacket.getPort();
                byte[] byArray = datagramPacket.getData();
                SNMPMessage sNMPMessage = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray, (int)0).value);
                String string = sNMPMessage.getCommunityName();
                SNMPPDU sNMPPDU = sNMPMessage.getPDU();
                byte by = sNMPPDU.getPDUType();
                SNMPSequence sNMPSequence = sNMPPDU.getVarBindList();
                Hashtable<SNMPObjectIdentifier, SNMPObject> hashtable = new Hashtable<SNMPObjectIdentifier, SNMPObject>();
                SNMPSequence sNMPSequence2 = new SNMPSequence();
                int n2 = 0;
                int n3 = 0;
                int n4 = sNMPPDU.getRequestID();
                try {
                    SNMPObject sNMPObject;
                    SNMPObjectIdentifier sNMPObjectIdentifier;
                    SNMPSequence sNMPSequence3;
                    int n5;
                    if (by == -96 || by == -93) {
                        for (n5 = 0; n5 < this.listenerVector.size(); ++n5) {
                            object2 = (SNMPRequestListener)this.listenerVector.elementAt(n5);
                            object = object2.processRequest(sNMPPDU, string);
                            for (int i = 0; i < ((SNMPSequence)object).size(); ++i) {
                                sNMPSequence3 = (SNMPSequence)((SNMPSequence)object).getSNMPObjectAt(i);
                                sNMPObjectIdentifier = (SNMPObjectIdentifier)sNMPSequence3.getSNMPObjectAt(0);
                                sNMPObject = sNMPSequence3.getSNMPObjectAt(1);
                                if (hashtable.containsKey(sNMPObjectIdentifier)) continue;
                                hashtable.put(sNMPObjectIdentifier, sNMPObject);
                            }
                        }
                        for (n5 = 0; n5 < sNMPSequence.size(); ++n5) {
                            object2 = (SNMPSequence)sNMPSequence.getSNMPObjectAt(n5);
                            object = (SNMPObjectIdentifier)((SNMPSequence)object2).getSNMPObjectAt(0);
                            if (!hashtable.containsKey(object)) {
                                n2 = n5 + 1;
                                n3 = 2;
                                if (by == -96) {
                                    throw new SNMPGetException("OID " + object + " not handled", n2, n3);
                                }
                                throw new SNMPSetException("OID " + object + " not handled", n2, n3);
                            }
                            SNMPObject sNMPObject2 = (SNMPObject)hashtable.get(object);
                            sNMPSequence3 = new SNMPVariablePair((SNMPObjectIdentifier)object, sNMPObject2);
                            sNMPSequence2.addSNMPObject(sNMPSequence3);
                        }
                    } else {
                        if (by != -95) continue;
                        for (n5 = 0; n5 < this.listenerVector.size(); ++n5) {
                            object2 = (SNMPRequestListener)this.listenerVector.elementAt(n5);
                            object = object2.processGetNextRequest(sNMPPDU, string);
                            for (int i = 0; i < ((SNMPSequence)object).size(); ++i) {
                                sNMPSequence3 = (SNMPSequence)((SNMPSequence)object).getSNMPObjectAt(i);
                                sNMPObjectIdentifier = (SNMPObjectIdentifier)sNMPSequence3.getSNMPObjectAt(0);
                                sNMPObject = sNMPSequence3.getSNMPObjectAt(1);
                                if (hashtable.containsKey(sNMPObjectIdentifier)) continue;
                                hashtable.put(sNMPObjectIdentifier, sNMPObject);
                            }
                        }
                        for (n5 = 0; n5 < sNMPSequence.size(); ++n5) {
                            object2 = (SNMPSequence)sNMPSequence.getSNMPObjectAt(n5);
                            object = (SNMPObjectIdentifier)((SNMPSequence)object2).getSNMPObjectAt(0);
                            if (!hashtable.containsKey(object)) {
                                n2 = n5 + 1;
                                n3 = 2;
                                throw new SNMPGetException("OID " + object + " not handled", n2, n3);
                            }
                            SNMPVariablePair sNMPVariablePair = (SNMPVariablePair)hashtable.get(object);
                            sNMPSequence2.addSNMPObject(sNMPVariablePair);
                        }
                    }
                }
                catch (SNMPRequestException sNMPRequestException) {
                    n2 = sNMPRequestException.errorIndex;
                    n3 = sNMPRequestException.errorStatus;
                    sNMPSequence2 = sNMPSequence;
                }
                catch (Exception exception) {
                    n2 = 0;
                    n3 = 5;
                    sNMPSequence2 = sNMPSequence;
                    System.out.println("Exception while processing request: " + exception.toString());
                }
                SNMPPDU sNMPPDU2 = new SNMPPDU(-94, n4, n3, n2, sNMPSequence2);
                object2 = new SNMPMessage(this.version, string, sNMPPDU2);
                object = ((SNMPSequence)object2).getBEREncoding();
                DatagramPacket datagramPacket2 = new DatagramPacket((byte[])object, ((Object)object).length, inetAddress, n);
                this.dSocket.send(datagramPacket2);
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException during request processing: " + iOException.toString());
        }
        catch (SNMPBadValueException sNMPBadValueException) {
            System.out.println("SNMPBadValueException during request processing: " + sNMPBadValueException.toString());
        }
        catch (Exception exception) {
            System.out.println("Exception during request processing: " + exception.toString());
        }
    }

    private String hexByte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = new String();
        string = string + Integer.toHexString(n2 / 16);
        string = string + Integer.toHexString(n2 % 16);
        return string;
    }
}

