/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.Archive;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdDoubleArray;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdInt;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;

public class Robin
implements RrdUpdater {
    private Archive parentArc;
    private RrdInt pointer;
    private RrdDoubleArray values;
    private int rows;
    static final /* synthetic */ boolean $assertionsDisabled;

    Robin(Archive archive, int n, boolean bl) throws IOException {
        this.parentArc = archive;
        this.pointer = new RrdInt(this);
        this.values = new RrdDoubleArray(this, n);
        this.rows = n;
        if (bl) {
            this.pointer.set(0);
            this.values.set(0, Double.NaN, n);
        }
    }

    public double[] getValues() throws IOException {
        return this.getValues(0, this.rows);
    }

    void store(double d) throws IOException {
        int n = this.pointer.get();
        this.values.set(n, d);
        this.pointer.set((n + 1) % this.rows);
    }

    void bulkStore(double d, int n) throws IOException {
        if (!$assertionsDisabled && n > this.rows) {
            throw new AssertionError((Object)("Invalid number of bulk updates: " + n + " rows=" + this.rows));
        }
        int n2 = this.pointer.get();
        int n3 = Math.min(this.rows - n2, n);
        this.values.set(n2, d, n3);
        this.pointer.set((n2 + n3) % this.rows);
        int n4 = n - n3;
        if (n4 > 0) {
            this.values.set(0, d, n4);
            this.pointer.set(n4);
        }
    }

    void update(double[] dArray) throws IOException {
        if (!$assertionsDisabled && this.rows != dArray.length) {
            throw new AssertionError((Object)("Invalid number of values supplied: " + dArray.length + " rows=" + this.rows));
        }
        this.pointer.set(0);
        this.values.writeDouble(0, dArray);
    }

    String dump() throws IOException {
        StringBuffer stringBuffer = new StringBuffer("Robin " + this.pointer.get() + "/" + this.rows + ": ");
        double[] dArray = this.getValues();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuffer.append(Util.formatDouble(dArray[i], true) + " ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public double getValue(int n) throws IOException {
        int n2 = (this.pointer.get() + n) % this.rows;
        return this.values.get(n2);
    }

    double[] getValues(int n, int n2) throws IOException {
        if (!$assertionsDisabled && n2 > this.rows) {
            throw new AssertionError((Object)("Too many values requested: " + n2 + " rows=" + this.rows));
        }
        int n3 = (this.pointer.get() + n) % this.rows;
        int n4 = Math.min(this.rows - n3, n2);
        double[] dArray = this.values.get(n3, n4);
        if (n4 < n2) {
            int n5;
            int n6 = n2 - n4;
            double[] dArray2 = this.values.get(0, n6);
            double[] dArray3 = new double[n2];
            int n7 = 0;
            for (n5 = 0; n5 < dArray.length; ++n5) {
                dArray3[n7++] = dArray[n5];
            }
            for (n5 = 0; n5 < dArray2.length; ++n5) {
                dArray3[n7++] = dArray2[n5];
            }
            return dArray3;
        }
        return dArray;
    }

    public Archive getParent() {
        return this.parentArc;
    }

    public int getSize() {
        return this.rows;
    }

    public void copyStateTo(RrdUpdater rrdUpdater) throws IOException, RrdException {
        if (!(rrdUpdater instanceof Robin)) {
            throw new RrdException("Cannot copy Robin object to " + rrdUpdater.getClass().getName());
        }
        Robin robin = (Robin)rrdUpdater;
        int n = this.rows - robin.rows;
        if (n == 0) {
            robin.pointer.set(this.pointer.get());
            robin.values.writeBytes(this.values.readBytes());
        } else {
            for (int i = 0; i < robin.rows; ++i) {
                int n2 = i + n;
                robin.store(n2 >= 0 ? this.getValue(n2) : Double.NaN);
            }
        }
    }

    void filterValues(double d, double d2) throws IOException {
        for (int i = 0; i < this.rows; ++i) {
            double d3 = this.values.get(i);
            if (!Double.isNaN(d) && !Double.isNaN(d3) && d > d3) {
                this.values.set(i, Double.NaN);
            }
            if (Double.isNaN(d2) || Double.isNaN(d3) || !(d2 < d3)) continue;
            this.values.set(i, Double.NaN);
        }
    }

    public RrdBackend getRrdBackend() {
        return this.parentArc.getRrdBackend();
    }

    public RrdAllocator getRrdAllocator() {
        return this.parentArc.getRrdAllocator();
    }

    static {
        $assertionsDisabled = !Robin.class.desiredAssertionStatus();
    }
}

