/*
 *   Copyright (C) 2010 - 2016 by Ivan Cukic <ivan.cukic(at)kde.org>
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) version 3, or any
 *   later version accepted by the membership of KDE e.V. (or its
 *   successor approved by the membership of KDE e.V.), which shall
 *   act as a proxy defined in Section 6 of version 3 of the license.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library.
 *   If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ACTIVITIES_INFO_H
#define ACTIVITIES_INFO_H

#include <QObject>
#include <QString>
#include <QStringList>
#include <QFuture>

#include "kactivities_export.h"

namespace KActivities {

class InfoPrivate;

/**
 * This class provides info about an activity. Most methods in it require a
 * semantic backend running to function properly.
 *
 * This class is not thread-safe.
 *
 * @see Consumer for info about activities
 *
 * The API of the class is synchronous, but the most used properties
 * are pre-fetched and cached. This means that, in order to get the least
 * amount of d-bus related locks, you should declare long-lived instances
 * of this class.
 *
 * Before relying on the values retrieved by the class, make sure that the
 * state is not Info::Unknown. You can get invalid data either because the
 * service is not functioning properly (or at all) or because the class did
 * not have enough time to synchronize the data with it.
 *
 * For example, if this is the only existing instance of the Info class, the
 * name method will return an empty string.
 *
 * For example, this is wrong (works, but blocks):
 * @code
 * void someMethod(const QString & activity) {
 *     // Do not copy. This approach is not a good one!
 *     Info info(activity);
 *     doSomethingWith(info.name());
 * }
 * @endcode
 *
 * Instances of the Info class should be long-lived. For example, members
 * of the classes that use them, and you should listen for the changes in the
 * provided properties.
 *
 * @since 4.5
 */
class KACTIVITIES_EXPORT Info : public QObject {
    Q_OBJECT

    Q_PROPERTY(QString id READ id)
    Q_PROPERTY(QString name READ name NOTIFY nameChanged)
    Q_PROPERTY(QString description READ description NOTIFY descriptionChanged)
    Q_PROPERTY(QString icon READ icon NOTIFY iconChanged)
    Q_PROPERTY(Info::State state READ state NOTIFY stateChanged)

public:
    explicit Info(const QString &activity, QObject *parent = Q_NULLPTR);
    ~Info();

    /**
     * @return true if the activity represented by this object exists and is valid
     */
    bool isValid() const;

    /**
     * Specifies which parts of this class are functional
     */
    enum Availability {
        Nothing = 0,   ///< No activity info provided (isValid is false)
        BasicInfo = 1, ///< Basic info is provided
        Everything = 2 ///< Everything is available
    };

    /**
     * State of the activity
     */
    enum State {
        Invalid = 0,  ///< This activity does not exist
        Unknown = 1,  ///< Information is not yet retrieved from the service
        Running = 2,  ///< Activity is running
        Starting = 3, ///< Activity is begin started
        Stopped = 4,  ///< Activity is stopped
        Stopping = 5  ///< Activity is begin started
    };

    /**
     * @returns what info is provided by this instance of Info
     */
    Availability a                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   