# Pilatus PC-12/45 Engine System
# Bea Wolf (D-ECHO) 2024
# Reference(s): see pc-12.xml

var n1 = 			props.globals.getNode("engines/engine[0]/n1", 1);
var running_flag =	props.globals.getNode("engines/engine[0]/running");
var starter = 		props.globals.getNode("controls/engines/engine[0]/starter-sw", 1);
var generator = 		props.globals.getNode("controls/electric/generator[0]");
var gen_int = 		props.globals.getNode("controls/electric/engine[0]/generator");
var throttle_cmd = 	props.globals.getNode("controls/engines/engine[0]/throttle", 1);
var reverse_cmd = 	props.globals.getNode("controls/engines/engine[0]/reverser", 1);
var engine_speed_cmd = 	props.globals.getNode("controls/engines/engine[0]/engine-speed", 1);
var cutoff_cmd = 		props.globals.getNode("controls/engines/engine[0]/cutoff", 1);

setlistener( engine_speed_cmd, func () {
	if ( engine_speed_cmd.getDoubleValue() >= 0.2 and cutoff_cmd.getBoolValue() != 0 ){
		cutoff_cmd.setBoolValue( 0 );
	} else if ( engine_speed_cmd.getDoubleValue() < 0.2 and cutoff_cmd.getBoolValue() != 1 ){
		cutoff_cmd.setBoolValue( 1 );
	}
});

var start_engine = func {
	if( n1.getDoubleValue() > 55.0 ){
		starter.setBoolValue( 0 );
		start_engine_updater.stop();
	}
}

var start_engine_updater = maketimer( 0.1, start_engine );
start_engine_updater.simulatedTime = 1;

setlistener( starter, func( i ){
	if( starter.getBoolValue() ){
		start_engine_updater.start();
	}
});

var toggleReverse = func ( i ){
	if( !reverse_cmd[ i ].getBoolValue() and throttle_cmd[ i ].getDoubleValue() < 0.05 ){
		throttle_cmd[ i ].setDoubleValue( 0.0 );
		reverse_cmd[ i ].setBoolValue( 1 );
	} else {
		reverse_cmd[ i ].setBoolValue( 0 );
	}
}

# Generator control unit
var gcu = func () {
	if( generator.getIntValue() == 1 or starter.getBoolValue() ){
		gen_int.setBoolValue( 1 );
	} else {
		gen_int.setBoolValue( 0 );
	}
}
var gcu_updater = maketimer( 0.02, gcu );
gcu_updater.simulatedTime = 1;
gcu_updater.start();
