# ************************************
# ****  Helijah          01/2026  ****
# **** Based on 5H1N0B1 work 2013 ****
# ************************************

var convert = func {
  var rpm0  = getprop("/engines/engine[0]/rpm");
  var cht0  = getprop("/engines/engine[0]/cht-degc");
  var egt0  = getprop("/engines/engine[0]/egt-degc");
  var mp0   = getprop("/engines/engine[0]/mp-osi");
  var run0  = getprop("/engines/engine[0]/running");
  var flow0 = getprop("/engines/engine[0]/fuel-flow-gph");

  var rpm1  = getprop("/engines/engine[1]/rpm");
  var cht1  = getprop("/engines/engine[1]/cht-degc");
  var egt1  = getprop("/engines/engine[1]/egt-degc");
  var mp1   = getprop("/engines/engine[1]/mp-osi");
  var run1  = getprop("/engines/engine[1]/running");
  var flow1 = getprop("/engines/engine[1]/fuel-flow-gph");

  var oat   = getprop("/environment/temperature-degc");
  var ias   = getprop("/instrumentation/airspeed-indicator/indicated-speed-kt");

  # ---------------------------------------- Engine 0 ----------------------------------------
  setprop("/engines/engine[0]/oil-temperature-degc", convertTemp(getprop("/engines/engine[0]/oil-temperature-degf")));

  if ( !mp0 ) {
    mp0  = 10
  }
  if ( mp0 < 10 ) {
    mp0  = 10;
  }
  if ( !rpm0 ) {
    rpm0 = 0
  }
  if (rpm0 > 100.0) {
    var fuel_pres0 = rpm0 / 100;
    var oil_pres0  = rpm0 / 25;
  } else {
    var fuel_pres0 = 0.0;
    var oil_pres0  = 0.0;
  }
  var cyltemp0 = 0;
  if (run0) {
    cht0      = cht0 + (mp0 * 8 + oat - ias/3 - cht0) / 250;
    egt0      = egt0 + ((mp0 * 30 + cht0 * 2) * mp0 / (flow0 * 2 + 1) - egt0) / 100;
    cyltemp0  = egt0 / 1375;
  } else {
    if ( !cht0  ) {
      cht0   = oat;
    }
    if ( !egt0  ) {
      egt0   = oat;
    }
    cht0     = cht0 + (oat - cht0)/100;
    egt0     = egt0 + (oat - egt0)/100;
    cyltemp0 = 0;
  }
  setprop("/engines/engine[0]/cht-degc", cht0);
  setprop("/engines/engine[0]/egt-degc", egt0);
  setprop("/engines/engine[0]/egt-degf-calc", egt0 * 9/5 + 32);
  setprop("/engines/engine[0]/oil-pressure-psi", oil_pres0);
  setprop("/engines/engine[0]/fuel-pressure-psi", fuel_pres0);
  setprop("/engines/engine[0]/cyl-temp", cyltemp0);

  # ---------------------------------------- Engine 1 ----------------------------------------
  setprop("/engines/engine[1]/oil-temperature-degc", convertTemp(getprop("/engines/engine[1]/oil-temperature-degf")));

  if ( !mp1 ) {
    mp1  = 10
  }
  if (mp1 < 10) {
    mp1  = 10;
  }
  if ( !rpm1 ) {
    rpm1 = 0
  }
  if (rpm1 > 100.0) {
    var fuel_pres1 = rpm1 / 100;
    var oil_pres1  = rpm1 / 25;
  } else {
    var fuel_pres1 = 0.0;
    var oil_pres1  = 0.0;
  }
  var cyltemp1 = 0;
  if (run1) {
    cht1      = cht1 + (mp1 * 8 + oat - ias/3 - cht1) / 250;
    egt1      = egt1 + ((mp1 * 30 + cht1 * 2) * mp1 / (flow1 * 2 + 1) - egt1) / 100;
    cyltemp1  = egt1 / 1375;
  } else {
    if ( !cht1  ) {
      cht1    = oat;
    }
    if ( !egt1  ) {
      egt1    = oat;
    }
    cht1      = cht1 + (oat - cht1)/100;
    egt1      = egt1 + (oat - egt1)/100;
    cyltemp1  = 0;
  }
  setprop("/engines/engine[1]/cht-degc", cht1);
  setprop("/engines/engine[1]/egt-degc", egt1);
  setprop("/engines/engine[1]/egt-degf-calc", egt1 * 9/5 + 32);
  setprop("/engines/engine[1]/oil-pressure-psi", oil_pres1);
  setprop("/engines/engine[1]/fuel-pressure-psi", fuel_pres1);
  setprop("/engines/engine[1]/cyl-temp", cyltemp1);

  # ------------------------------------------------------------------------------------------
  setprop("/systems/electrical/amp", (rpm0 + rpm1) / 100 );
}

var convertTemp = func(degF) {
  var degC = 0;
  if ( degF != nil ) {
    degC = (degF - 32) * 5/9;
  }
  return degC;
}

###  Main loop ###
var update_convert = func {
  convert();
  settimer(update_convert, 0.01);
}
setlistener("/sim/signals/fdm-initialized", update_convert);
