#	Ref. AOI, p.3-8ff.; p.7-29f. 
var annun_p = props.globals.initNode("/instrumentation/annunciator");
var selftest = annun_p.initNode("selftest", 0, "BOOL");

var time = props.globals.getNode("/sim/time/elapsed-sec", 1);

var charge_front = taurus_electro.battery_front.charge_percent;
var charge_rear = taurus_electro.battery_rear.charge_percent;
var batt_front_offline = 0;
var batt_rear_offline = 0;
var power_controller_temp = props.globals.getNode("/engines/engine[0]/power-controller-temp-degc");
var engine_temp = props.globals.getNode("/engines/engine[0]/engine-temp-degc");
var eng_coolant_pump_serv = props.globals.getNode("/systems/cooling/engine-coolant-pump-serviceable", 1);
var batt_coolant_pump_serv = [
	props.globals.getNode("/systems/cooling/battery-coolant-pump-serviceable[0]", 1),
	props.globals.getNode("/systems/cooling/battery-coolant-pump-serviceable[1]", 1),
];
var dcdc_serv = props.globals.getNode("/systems/electrical/components/dcdc-serviceable", 1);


var engine_rpm = props.globals.getNode("/engines/engine[0]/rpm", 1);

#	Load Limits
var limits = {
	motor: [
		getprop("/limits/powertrain/motor-temp-degc/caution"),
		getprop("/limits/powertrain/motor-temp-degc/warning"),
	],
	power_controller: [
		getprop("/limits/powertrain/power-controller-temp-degc/caution"),
		getprop("/limits/powertrain/power-controller-temp-degc/warning"),
	],
	battery: [
		getprop("/limits/powertrain/battery-temp-degc/caution"),
		getprop("/limits/powertrain/battery-temp-degc/warning"),
	],
};

var volts = props.globals.getNode("/systems/electrical/lv-volts", 1);
		 

var epsi_message = {
	new: func( prio, message, trigger, light = nil ) {
		var obj = {parents:[epsi_message]};
		obj.priority = prio;		# 0 = warning, 1 = caution, 2 = info
		obj.message = message;		# message text
		obj.light = light;		# associated annunciator panel light
		obj.event_time = time.getDoubleValue();	# save the time the message was triggered, for sorting messages
		obj.ack = 0;			# message has been acknowledged
		obj.caller = trigger;
		return obj;
	},
	acknowledge: func {
		me.caller.acknowledge();
	},
};

var active_messages = [ ];

var trigger = {
	new: func( condition, prio, message, light = nil ) {
		var obj = {parents:[trigger]};
		obj.condition = condition;
		obj.priority = prio;
		obj.message = message;
		obj.light = light;
		obj.active_msg = nil;
		obj.timeout = nil;
		return obj;
	},
	update: func() {
		if( me.timeout != nil ){
			if( ( time.getDoubleValue() - me.timeout ) > 20 ){
				me.timeout = nil;
			} else {
				return;
			}
		}
			
		if( me.condition() and me.active_msg == nil ){
			me.active_msg = epsi_message.new( me.priority, me.message, me, me.light );
		} elsif( !me.condition() and me.active_msg != nil and me.active_msg.ack ){
			me.active_msg = nil;
		}
	},
	acknowledge: func() {
		me.active_msg = nil;
		me.timeout = time.getDoubleValue();
	},
};
var trigger2 = {
	new: func( prio, message, light = nil ) {
		var obj = {parents:[trigger2]};
		obj.priority = prio;
		obj.message = message;
		obj.light = light;
		obj.active_msg = nil;
		obj.timeout = nil;
		return obj;
	},
	update: func() {},
	trigger: func( extra_text = "" ) {
		if( me.timeout != nil ){
			if( ( time.getDoubleValue() - me.timeout ) > 20 ){
				me.timeout = nil;
			} else {
				return;
			}
		}
		if( me.active_msg == nil ){
			me.active_msg = epsi_message.new( me.priority, me.message ~ extra_text, me, me.light );
		}
	},
	reset: func() {
		if( me.active_msg != nil and me.active_msg.ack ){
			me.active_msg = nil;
		}
	},
	acknowledge: func() {
		me.active_msg = nil;
		me.timeout = time.getDoubleValue();
	},
};

var triggers = [
		trigger.new( func return batt_front_offline, 0, "BATTERY 1\nNOT PRESENT" ),
		trigger.new( func return batt_rear_offline, 0, "BATTERY 2\nNOT PRESENT" ),
		trigger.new( func return !dcdc_serv.getBoolValue(), 0, "DC/DC\nNOT\nWORKING"),
		trigger.new( func return taurus_electro.batt.temp[0].getDoubleValue() > limits.battery[0], 1, "BATTERY 1\nOVERTEMP" ),
		trigger.new( func return taurus_electro.batt.temp[1].getDoubleValue() > limits.battery[0], 1, "BATTERY 2\nOVERTEMP" ),
		trigger.new( func return ( ( ( charge_front.getDoubleValue() + charge_rear.getDoubleValue() ) / 2 ) < 0.1 ), 1, "SOC <10%"),
		trigger.new( func return (power_controller_temp.getDoubleValue() >= 76 or engine_temp.getDoubleValue() >= 100), 1, "DRIVE\nOVERTEMP" ),
		trigger2.new( 1, "BATTERY HEATING\nIN\nPROGRESS" ),
		trigger2.new( 2, "DRIVE IS\nACTIVE" ),
];

var master_caution_message = nil;
var master_warning_message = nil;
var last_selftest = -1;

var main_loop = func{
	if( volts.getDoubleValue() < 9 ) return;
	
	foreach( var el; triggers ){
		el.update();
	}
	# Gather all active messages, then sort them
	active_messages = [ ];
	foreach( var el; triggers ){
		if( el.active_msg != nil ){
			append( active_messages, el.active_msg );
		}
	}
	
	# Sort:
	var sorted = 0;
	while( !sorted ){
		sorted = 1;
		var i = 0;
		while( i < size(active_messages)-1 ){
			if( active_messages[i].priority > active_messages[i + 1].priority ){
				var temp = active_messages[i];
				active_messages[i] = active_messages[i+1];
				active_messages[i+1]=temp;
				sorted = 0;
			} elsif( active_messages[i].event_time < active_messages[i+1].event_time ){
				var temp = active_messages[i];
				active_messages[i] = active_messages[i+1];
				active_messages[i+1]=temp;
				sorted = 0;
			}
			i += 1;
		}
	}
		
	
	# EPSI430 Driver: Show the most important message
	if( size( active_messages ) > 0 and epsi430.shown_message != active_messages[0] ){
		epsi430.newAnnunciation( active_messages[0] );
	}
	if( size( active_messages ) == 0 and epsi430.shown_message != nil ){
		epsi430.shown_message = nil;
		epsi430.epsi430_common.update_message( 0 );
	}
	
}

var epsi_ack = func {
	if( epsi430.shown_message != nil )	epsi430.shown_message.acknowledge();
}

var main_loop_timer = maketimer( 1, main_loop );
main_loop_timer.simulatedTime = 1;

var fl = setlistener("/sim/signals/fdm-initialized", func{
	main_loop_timer.start();
	removelistener( fl );
});
