#########################################################
############## General initializers #####################
#########################################################
#                                                        Guns
var n_gun1_ammo_count = "ai/submodels/submodel[0]/count";
var n_gun2_ammo_count = "ai/submodels/submodel[1]/count";
var n_gun3_ammo_count = "ai/submodels/submodel[2]/count";
#                                                        Bombs
var n_bomb1_count     = "ai/submodels/submodel[3]/count";
var n_bomb2_count     = "ai/submodels/submodel[4]/count";
var n_bomb3_count     = "ai/submodels/submodel[5]/count";
var n_bomb4_count     = "ai/submodels/submodel[6]/count";
var n_bomb5_count     = "ai/submodels/submodel[7]/count";
var n_bomb6_count     = "ai/submodels/submodel[8]/count";
var n_bomb7_count     = "ai/submodels/submodel[9]/count";
var n_bomb8_count     = "ai/submodels/submodel[10]/count";
var n_bomb9_count     = "ai/submodels/submodel[11]/count";
var n_bomb10_count    = "ai/submodels/submodel[12]/count";

#########################################################
##################### reload guns #######################
#########################################################
# Guns generally cannot be reloaded in flight.  It requires landing,
# stop, and reload before taking off again.
#
# Note that tracers are modeled as bullets that include a visual model but
# no impact.  They fire along with 1 of every three or four bullets to simulate
# a tracer round every 4 rounds.

reload_guns  = func {

  var  groundspeed = getprop("velocities/groundspeed-kt");

  # only allow it if on ground or if it's already set to unlimited mode
  if ( groundspeed < 5 or getprop( r_gun1_ammo_count) == -1 ) {

    #                                           Guns
    setprop(n_gun1_ammo_count, 400);
    setprop(n_gun2_ammo_count, 400);
    setprop(n_gun3_ammo_count, 400);
    #                                           Bombs
    setprop(n_bomb1_count,  2);
    setprop(n_bomb2_count,  2);
    setprop(n_bomb3_count,  1);
    setprop(n_bomb4_count,  1);
    setprop(n_bomb5_count,  1);
    setprop(n_bomb6_count,  1);
    setprop(n_bomb7_count,  1);
    setprop(n_bomb8_count,  1);
    setprop(n_bomb9_count,  1);
    setprop(n_bomb10_count, 1);

    gui.popupTip ("Guns reloaded--400 rounds in each gun and bombs.", 5)
  } else {
    gui.popupTip ("You must be on the ground and engines dead stopped to re-load guns.",5)
  }
}

#########################################################
################ unlimited ammo #########################
#########################################################
# For testing only, of course!
#

unlimited_guns = func {

  var groundspeed = getprop("velocities/groundspeed-kt");

  #                                           Guns
  setprop ( n_gun1_ammo_count, -1);
  setprop ( n_gun2_ammo_count, -1);
  setprop ( n_gun3_ammo_count, -1);
  #                                           Bombs
  setprop(n_bomb1_count,  2);
  setprop(n_bomb2_count,  2);
  setprop(n_bomb3_count,  1);
  setprop(n_bomb4_count,  1);
  setprop(n_bomb5_count,  1);
  setprop(n_bomb6_count,  1);
  setprop(n_bomb7_count,  1);
  setprop(n_bomb8_count,  1);
  setprop(n_bomb9_count,  1);
  setprop(n_bomb10_count, 1);

  gui.popupTip ("Guns set to unlimited mode--definitely not realistic and only for testing!  Select 'Reload Guns' to revert to limited ammo.",7)
}

######################################################################
###                                                                ###
###                Guns fire only if view is done                  ###
###                                                                ###
### BARANGER Emmanuel aka Helijah 04/10/2024                       ###
###                               03/01/2025                       ###
###                               26/01/2025                       ###
###                               02/02/2025 for B17               ###
###                               26/03/2025 for B24               ###
###                               01/11/2025 for PZL P.37          ###
######################################################################

fire_MG = func {
  var CurrentView = getprop("sim/current-view/view-number-raw");
  if ( CurrentView == 101 ) {
    # Nose
    #setprop("/controls/armament/trigger", 1);
    setprop("sim/multiplay/generic/int[10]", 1);
  } elsif ( CurrentView == 102 ) {
    # Roof
    #setprop("/controls/armament/trigger1", 1);
    setprop("sim/multiplay/generic/int[12]", 1);
  } elsif ( CurrentView == 103 ) {
    # Tail
    #setprop("/controls/armament/trigger2", 1);
    setprop("sim/multiplay/generic/int[13]", 1);
  }
}

stop_MG = func {
  #setprop("/controls/armament/trigger0", 0);
  setprop("sim/multiplay/generic/int[10]", 0);
  #setprop("/controls/armament/trigger1", 0);
  setprop("sim/multiplay/generic/int[12]", 0);
  #setprop("/controls/armament/trigger2", 0);
  setprop("sim/multiplay/generic/int[13]", 0);
}
