##########################################
##	Rolladen-Schneider LS1-C		##
##########################################

##	Liveries	##
aircraft.livery.init("Aircraft/LS1-c/Models/Liveries");

##	Instruments	##
# Load vario instrument for the mechanical vario PUF68
# (the following code is based on the ILEC SC7 e-vario)
io.include("Aircraft/Generic/soaring-instrumentation-sdk.nas");

var probe = TotalEnergyProbe.new();

var vario_needle = Dampener.new(
	input: probe,
	dampening: 1.3, # ref. http://www.hkavionics.com/Bohli_man/ba_vario1e.pdf, p.3 (time constant)
	on_update: update_prop("/instrumentation/puf-68/te-reading-mps"));

# Wrap everything together into an instrument
var fast_instruments = UpdateLoop.new(
	update_period: 0,
	components: [probe, vario_needle],
	enable: 1);

# Vibrating yaw string
var yawstring = YawString.new(
	on_update: update_prop("instrumentation/yawstring"));

var string_instrument = Instrument.new(
	components: [yawstring],
	enable: 1);
