# vim: set foldmethod=marker foldmarker={{{,}}} :
displayClass.MFD = {
    AUX: {
        'SYSTEM SETUP' : func {
            var obj_infos = [
                {text: 'NAV BOX DATA FIELDS', type: 'title'},
                {type: 'separator'},
                {text: 'DATA FIELD NUMBER', type: 'normal'},
                {text: '  1 >', type: 'selected|end-of-line', choices: ['  1 >', '< 2 >', '< 3 >', '< 4  ']},
            ];
            var lines = 2;
            var column = 0;
            var colmax = 5;
            foreach (var text; me.device.display.updateNavigationBox(1)) {
                append(obj_infos, {
                    text: text,
                    type: column == colmax ? 'editable|end-of-line' : 'editable',
                    callback: func (id, selected) {
                        var field = me.device.windows.state[id].objects[3].text;
                        field = substr(field, 2);
                        field = substr(field, 0, size(field) - 2);
                        field = string.trim(field);
                        me.device.display.screenElements['DATA-FIELD' ~ field ~ '-ID-text']
                            .setText(me.device.windows.state[id].objects[selected].text);
                    }
                });
                if (column < colmax) column += 1;
                else {
                    column = 0;
                    lines += 1;
                }
            }
            var windowId = 'SYSTEM SETUP';
            var obj_s = size(obj_infos);
            me.device.windows.draw(
                windowId,
                {x: 720, y: 758 - ((lines + 3) * 24), w: 300, l: lines, sep: 1},
                obj_infos
            );
            me.device.buttons.CLR = func {
                me.device.windows.del(windowId);
                me.device.buttons.ENT = func;
                me.device.buttons.CLR = func;
                me.device.knobs.FmsInner = func;
                me.device.knobs.FmsOuter = me.device.knobs.MFD_select_page_group;
            }
            me.device.knobs.FmsInner = me.device.knobs.MenuSettings;
            me.device.knobs.FmsOuter = me.device.knobs.NavigateMenu;
            me.device.buttons.ENT = me.device.buttons.ValidateTMRREF;
        },
    },
};

displayClass.setMFDPages = func {
    me.device.data['page selection'] = [
# list of pages, by group {{{
        {
            name: 'MAP',
            objects: [
                {text: 'NAVIGATION MAP'},
                {text: 'TRAFFIC MAP'},
                {text: 'STORMSCOPE'},
                {text: 'WEATHER DATA LINK'},
                {text: 'TAWS-B'},
            ],
        },
        {
            name: 'WPT',
            objects: [
                {text: 'AIRPORT INFORMATION'},
                {text: 'AIRPORT DIRECTORY'},
                {text: 'DEPARTURE INFORMATION'},
                {text: 'ARRIVAL INFORMATION'},
                {text: 'APPROACH INFORMATION'},
                {text: 'WEATHER INFORMATION'},
                {text: 'INTERSECTION INFORMATION'},
                {text: 'NDB INFORMATION'},
                {text: 'VOR INFORMATION'},
                {text: 'USER WAYPOINT INFORMATION'},
            ],
        },
        {
            name: 'AUX',
            objects: [
                {text: 'TRIP PLANNING'},
                {text: 'UTILITY'},
                {text: 'GPS STATUS'},
                {text: 'SYSTEM SETUP'},
            ],
        },
        {
            name: 'FPL',
            objects: [
                {text: 'ACTIVE FLIGHT PLAN'},
                {text: 'WIDE VIEW, NARROW VIEW'},
                {text: 'FLIGHT PLAN CATALOG'},
            ],
        },
        {
            name: 'PROC',
            objects: [
                {text: 'DEPARTURE LOADING'},
                {text: 'ARRIVAL LOADING'},
                {text: 'APPROACH LOADING'},
            ],
        },
        {
            name: 'NRST',
            objects: [
                {text: 'NEAREST AIRPORTS'},
                {text: 'NEAREST INTERSECTIONS'},
                {text: 'NEAREST NDB'},
                {text: 'NEAREST VOR'},
                {text: 'NEAREST USER WAYPOINTS'},
                {text: 'NEAREST FREQUENCIES'},
                {text: 'NEAREST AIRSPACES'},
            ],
        },
# }}}
    ];

    foreach (var g; me.device.data['page selection']) {
        var obj_s = size(g.objects);
        # build specific geometry per page, depending of number of sub-pages
        g.geometry = {x: 720, y: 758 - ((obj_s + 3) * 24), w: 300, l: obj_s + 1, sep: 1};
        # complete the hash with reccurrent elements type and callback
        var firstEntry = 1;
        foreach (var o; g.objects) {
            if (contains(me.MFD, g.name) and contains(me.MFD[g.name], o.text)) {
                o.type = firstEntry ? 'selected' : 'editable';
                o.type ~= '|end-of-line';
                o.callback = me.device.buttons.MFD_page_wrapper;
                firstEntry = ! firstEntry;
            }
            else
                o.type = 'normal|end-of-line';
        }
    }
    # build the available groups line, at the bottom
    forindex (var g; me.device.data['page selection']) {
        append(me.device.data['page selection'][g].objects, {type: 'separator'});
        for (var i = 0; i < g; i+=1)
            append(me.device.data['page selection'][g].objects,
                {text: me.device.data['page selection'][i].name, type: 'normal'});
        append(me.device.data['page selection'][g].objects,
            {text: me.device.data['page selection'][i].name, type: 'highlighted'});
        for (var i = g+1; i < size(me.device.data['page selection']); i+=1)
            append(me.device.data['page selection'][g].objects,
                {text: me.device.data['page selection'][i].name, type: 'normal'});
    }
    me.device.knobs.FmsOuter = me.device.knobs.MFD_select_page_group;
};
