# Autostart based on Jet and turboprop system for piston engines
#
# BARANGER Emmanuel (04/2024)

props.globals.initNode("/sim/autostart/started", 0, "BOOL");

var eng1fuelon = func { setprop("/controls/engines/engine[0]/cutoff", 0); }
var eng2fuelon = func { setprop("/controls/engines/engine[1]/cutoff", 0); }
var eng3fuelon = func { setprop("/controls/engines/engine[2]/cutoff", 0); }
var eng4fuelon = func { setprop("/controls/engines/engine[3]/cutoff", 0); }
var eng5fuelon = func { setprop("/controls/engines/engine[4]/cutoff", 0); }
var eng6fuelon = func { setprop("/controls/engines/engine[5]/cutoff", 0); }
var eng7fuelon = func { setprop("/controls/engines/engine[6]/cutoff", 0); }
var eng8fuelon = func { setprop("/controls/engines/engine[7]/cutoff", 0); }

var eng1fueloff = func {
  setprop("/controls/engines/engine[0]/cutoff", 1);
  setprop("/controls/engines/engine[0]/throttle", 0);
}
var eng2fueloff = func {
  setprop("/controls/engines/engine[1]/cutoff", 1);
  setprop("/controls/engines/engine[1]/throttle", 0);
}
var eng3fueloff = func {
  setprop("/controls/engines/engine[2]/cutoff", 1);
  setprop("/controls/engines/engine[2]/throttle", 0);
}
var eng4fueloff = func {
  setprop("/controls/engines/engine[3]/cutoff", 1);
  setprop("/controls/engines/engine[3]/throttle", 0);
}
var eng5fueloff = func {
  setprop("/controls/engines/engine[4]/cutoff", 1);
  setprop("/controls/engines/engine[4]/throttle", 0);
}
var eng6fueloff = func {
  setprop("/controls/engines/engine[5]/cutoff", 1);
  setprop("/controls/engines/engine[5]/throttle", 0);
}
var eng7fueloff = func {
  setprop("/controls/engines/engine[6]/cutoff", 1);
  setprop("/controls/engines/engine[6]/throttle", 0);
}
var eng8fueloff = func {
  setprop("/controls/engines/engine[7]/cutoff", 1);
  setprop("/controls/engines/engine[7]/throttle", 0);
}

var eng1starter = func { setprop("/controls/engines/engine[0]/starter", 1); }
var eng2starter = func { setprop("/controls/engines/engine[1]/starter", 1); }
var eng3starter = func { setprop("/controls/engines/engine[2]/starter", 1); }
var eng4starter = func { setprop("/controls/engines/engine[3]/starter", 1); }
var eng5starter = func { setprop("/controls/engines/engine[4]/starter", 1); }
var eng6starter = func { setprop("/controls/engines/engine[5]/starter", 1); }
var eng7starter = func { setprop("/controls/engines/engine[6]/starter", 1); }
var eng8starter = func { setprop("/controls/engines/engine[7]/starter", 1); }

var eng1staroff = func { setprop("/controls/engines/engine[0]/starter", 0); }
var eng2staroff = func { setprop("/controls/engines/engine[1]/starter", 0); }
var eng3staroff = func { setprop("/controls/engines/engine[2]/starter", 0); }
var eng4staroff = func { setprop("/controls/engines/engine[3]/starter", 0); }
var eng5staroff = func { setprop("/controls/engines/engine[4]/starter", 0); }
var eng6staroff = func { setprop("/controls/engines/engine[5]/starter", 0); }
var eng7staroff = func { setprop("/controls/engines/engine[6]/starter", 0); }
var eng8staroff = func { setprop("/controls/engines/engine[7]/starter", 0); }

var eng1start = func {
  gui.popupTip("*** Engine start 1 left  ***");
  eng1fueloff();
  eng1starter();
  settimer(eng1fuelon, 2);
  settimer(eng1staroff, 4);
}

var eng2start = func {
  gui.popupTip("*** Engine start 2 right  ***");
  eng2fueloff();
  eng2starter();
  settimer(eng2fuelon, 2);
  settimer(eng2staroff, 4);
}

var eng3start = func {
  gui.popupTip("*** Engine start 3 right  ***");
  eng3fueloff();
  eng3starter();
  settimer(eng3fuelon, 2);
  settimer(eng3staroff, 4);
}

var eng4start = func {
  gui.popupTip("*** Engine start 4 right  ***");
  eng4fueloff();
  eng4starter();
  settimer(eng4fuelon, 2);
  settimer(eng4staroff, 4);
}

var eng5start = func {
  gui.popupTip("*** Engine start 5 right  ***");
  eng5fueloff();
  eng5starter();
  settimer(eng5fuelon, 2);
  settimer(eng5staroff, 4);
}

var eng6start = func {
  gui.popupTip("*** Engine start 6 right  ***");
  eng6fueloff();
  eng6starter();
  settimer(eng6fuelon, 2);
  settimer(eng6staroff, 4);
}

var eng7start = func {
  gui.popupTip("*** Engine start 7 right  ***");
  eng7fueloff();
  eng7starter();
  settimer(eng7fuelon, 2);
  settimer(eng7staroff, 4);
}

var eng8start = func {
  gui.popupTip("*** Engine start 8 right  ***");
  eng8fueloff();
  eng8starter();
  settimer(eng8fuelon, 2);
  settimer(eng8staroff, 4);
}

var engstart = func {
  settimer(eng1start, 2);
  settimer(eng8start, 6);
  settimer(eng2start, 10);
  settimer(eng7start, 14);
  settimer(eng3start, 18);
  settimer(eng6start, 22);
  settimer(eng4start, 26);
  settimer(eng5start, 30);
}

var engstop = func {
  settimer(eng1fueloff, 1);
  settimer(eng8fueloff, 2);
  settimer(eng2fueloff, 3);
  settimer(eng7fueloff, 4);
  settimer(eng3fueloff, 5);
  settimer(eng6fueloff, 6);
  settimer(eng4fueloff, 7);
  settimer(eng5fueloff, 8);
}

var autostart = func {
  var startstatus = getprop("/sim/autostart/started");
  if ( startstatus == 0 ) {
    gui.popupTip("Autostarting...");
    setprop("/sim/model/autostart", 1);
    setprop("/sim/autostart/started", 1);
    settimer(engstart, 0.4);
    gui.popupTip("Starting Engines");
  }
  if ( startstatus == 1 ) {
    gui.popupTip("Shutting Down...");
    setprop("/sim/model/autostart", 0);
    setprop("/sim/autostart/started", 0);
    engstop();
  }
}
