#Ground Services added by Isaak Dieleman - 20190405

var icecrane = aircraft.door.new("services/deicing_truck/crane", 20);
var icecrane1 = aircraft.door.new("services/deicing_truck/crane[1]", 20);
var icecrane2 = aircraft.door.new("services/deicing_truck/crane[2]", 20);
var icecrane3 = aircraft.door.new("services/deicing_truck/crane[3]", 20);
var icecrane4 = aircraft.door.new("services/deicing_truck/crane[4]", 20);
var icetruck = aircraft.door.new("services/deicing_truck/truck[0]", 100);
var icetruck1 = aircraft.door.new("services/deicing_truck/truck[1]", 100);
var icetruck2 = aircraft.door.new("services/deicing_truck/truck[2]", 100);
var icetruck3 = aircraft.door.new("services/deicing_truck/truck[3]", 100);
var icetruck4 = aircraft.door.new("services/deicing_truck/truck[4]", 100);
var icedeicing = aircraft.door.new("services/deicing_truck/deicing", 70);
var icedeicing1 = aircraft.door.new("services/deicing_truck/deicing[1]", 80);
var icedeicing2 = aircraft.door.new("services/deicing_truck/deicing[2]", 75);
var icedeicing3 = aircraft.door.new("services/deicing_truck/deicing[3]", 78);
var icedeicing4 = aircraft.door.new("services/deicing_truck/deicing[4]", 77);
var StartTimeText = "";

#Autoconnect variables:

var OnBlocksTime = "";
var CurrentSecond = 0;
var PreviousSecond = 0;
var OnBlocksSecond = 0;
var DeboardingFinished = 0;
var DeboardingStarted = 0;
var BoardingStatus = 0;
var DeBoardingTime = 0;
var CateringStatus = 0;
var CateringStartUnloadingT = 0;
var AutoJetways = getprop("aircraft/settings/gnd_autojetways");

#Autoconnect Connection variables
var GPU1 = 0;
var GPU2 = 0;
var GPUBox = 0;
var ChockL = 0;
var ChockR = 0;
var ChockN = 0;
var ConeL = 0;
var ConeR = 0;
var Bus1 = 0;
var Bus2 = 0;
var Jetway1 = 0;
var Jetway2 = 0;
var Stairs1 = 0;
var Stairs2 = 0;
var Stairs3 = 0;
var Stairs4 = 0;
var Baggage1 = 0;
var Baggage2 = 0;
var Catering1 = 0;
var Catering2 = 0;
var Catering3 = 0;
var Catering4 = 0;
var FuelTruck = 0;
var FuelTruckPipe = 0;

#Autoconnect Connection Time Variables
var GPU1T = 0;
var GPU2T = 0;
var GPUBoxT = 0;
var ChockLT = 0;
var ChockRT = 0;
var ChockNT = 0;
var ConeLT = 0;
var ConeRT = 0;
var Bus1T = 0;
var Bus2T = 0;
var Jetway1T = 0;
var Jetway2T = 0;
var Stairs1T = 0;
var Stairs2T = 0;
var Stairs3T = 0;
var Stairs4T = 0;
var Baggage1T = 0;
var Baggage2T = 0;
var Catering1T = 0;
var Catering2T = 0;
var Catering3T = 0;
var Catering4T = 0;
var FuelTruckT = 0;
var FuelTruckPipeT = 0;

var ground_services = {
    init : func {
    
    # Fuel Truck
    
    setprop("services/fuel-truck/enable", 0);
    setprop("services/fuel-truck/connect", 0);
    setprop("services/fuel-truck/transfer", 0);
    setprop("services/fuel-truck/clean", 0);
    setprop("services/fuel-truck/request-lbs", getprop("consumables/fuel/total-fuel-lbs"));
    setprop("services/fuel-truck/extra-lbs", 0);
    setprop("services/fuel-truck/speed-text", " ");
    setprop("services/fuel-truck/finished", 0);
    
    # Payload System
    
    if (getprop("sim/aero") != "777-200F") {
        # The 777-200F has its own payload dialog. For the other types, the max number of first/business/economy pax and catering has to be defined, so we
        # overwrite the dialog with the values specified in their respective -set files.
        var payload = gui.Dialog.new("sim/gui/dialogs/payload/dialog", "gui/dialogs/payload-dlg.xml");
        setprop("sim/gui/dialogs/payload/dialog/group[1]/slider/max", getprop("services/payload/first-max-nr"));
        setprop("sim/gui/dialogs/payload/dialog/group[1]/slider[1]/max", getprop("services/payload/business-max-nr"));
        setprop("sim/gui/dialogs/payload/dialog/group[1]/slider[2]/max", getprop("services/payload/economy-max-nr"));
        setprop("sim/gui/dialogs/payload/dialog/group[1]/slider[3]/max", getprop("services/catering/weight-max-lbs"));
        setprop("sim/gui/dialogs/payload/dialog/group[1]/button[1]/binding/max", getprop("services/payload/first-max-nr"));
        setprop("sim/gui/dialogs/payload/dialog/group[1]/button[3]/binding/max", getprop("services/payload/business-max-nr"));
        setprop("sim/gui/dialogs/payload/dialog/group[1]/button[5]/binding/max", getprop("services/payload/economy-max-nr"));
        setprop("sim/gui/dialogs/payload/dialog/group[1]/button[7]/binding/max", getprop("services/catering/weight-max-lbs"));
    }
    setprop("services/stairs/flaps-jammed", 0);
        
    # External Power
    
    setprop("services/ext-pwr/enable", 0);
    setprop("services/ext-pwr/was_enabled", 0);
    setprop("services/ext-pwr/primary", 0);
    setprop("services/ext-pwr/secondary", 0);
    
    # Chocks
    
    setprop("services/chocks/nose", 0);
    setprop("services/chocks/left", 0);
    setprop("services/chocks/right", 0);
    
    # De-Icing
    setprop("services/deicing_truck/truck/position-norm", 0);
    setprop("services/deicing_truck/crane/position-norm", 0);
    setprop("services/deicing_truck/deicing/position-norm", 0);
    setprop("services/deicing_truck/enable", 0);
    setprop("services/deicing_truck/de-ice", 0);
    setprop("services/deicing_truck/truck/direction", 0);    

    _startstop_gsv();
    
    },
    update : func {
        
        #Autoconnect: Enable services based on assigned connection time.
        
        if (OnBlocksTime != "") {
            
            #Keep track of current time
            CurrentSecond = getprop("sim/time/elapsed-sec");
            
            if (CurrentSecond != PreviousSecond) {
                BoardingStatus = getprop("services/payload/pax-boarding");
                CateringStatus = getprop("services/catering/loading");
                
                if (BoardingStatus == 2) {
                    DeboardingStarted = 1;
                } elsif (DeboardingStarted == 1 and BoardingStatus == 0) {
                    DeboardingFinished = 1;
                    DeboardingStarted = 0;
                }
            }
            
            
            #### Ground Power Unit autoconnection
            
            #Connect GPUBox if required
            if (GPUBox == 0 and GPUBoxT != 0) {
                if (GPUBoxT <= CurrentSecond) {
                    GPUBox = 1;
                    setprop("services/ext-pwr/enable", 1);
                }
            }
            #Connect GPU 1 if required
            if (GPU1 == 0 and GPU1T != 0) {
                if (GPU1T <= CurrentSecond) {
                    GPU1 = 1;
                    setprop("services/ext-pwr/primary", 1);
                    
                    if ((GPU2T != 0 and GPU2 == 1) or GPU2T == 0) {
                        screen.log.write("Ground Power available", 0, 0.584, 1);
                    }
                }
            }
            #Connect GPU 2 if required
            if (GPU2 == 0 and GPU2T != 0) {
                if (GPU2T <= CurrentSecond) {
                    GPU2 = 1;
                    setprop("services/ext-pwr/secondary", 1);
                    
                    if ((GPU1T != 0 and GPU1 == 1) or GPU1T == 0) {
                        screen.log.write("Ground Power available", 0, 0.584, 1);
                    }
                }
            }
            
            #### Chocks
            
            if (ChockL == 0 and ChockLT != 0) {
                if (ChockLT <= CurrentSecond) {
                    ChockL = 1;
                    setprop("services/chocks/left", 1);
                }
                
                if (ChockL == 1 and ChockR == 1 and ChockN == 1) {
                    screen.log.write("Chocks in place, cleared to release Parking Brake", 0, 0.584, 1);
                }
            }
            
            if (ChockR == 0 and ChockRT != 0) {
                if (ChockRT <= CurrentSecond) {
                    ChockR = 1;
                    setprop("services/chocks/right", 1);
                }
                
                if (ChockL == 1 and ChockR == 1 and ChockN == 1) {
                    screen.log.write("Chocks in place, cleared to release Parking Brake", 0, 0.584, 1);
                }
            }
            
            if (ChockN == 0 and ChockNT != 0) {
                if (ChockNT <= CurrentSecond) {
                    ChockN = 1;
                    setprop("services/chocks/nose", 1);
                }
                
                if (ChockL == 1 and ChockR == 1 and ChockN == 1) {
                    screen.log.write("Chocks in place, cleared to release Parking Brake", 0, 0.584, 1);
                }
            }
            
            #### Safety Cones
            
            if (ConeL == 0 and ConeLT != 0) {
                if (ConeLT <= CurrentSecond) {
                    ConeL = 1;
                    setprop("services/cones/cone1-enable", 1);
                }
            }
            
            if (ConeR == 0 and ConeRT != 0) {
                if (ConeRT <= CurrentSecond) {
                    ConeR = 1;
                    setprop("services/cones/cone2-enable", 1);
                }
            }
            
            #Implement tail cones here
            
            #### Busses
            
            if (Bus1 == 0 and Bus1T != 0) {
                if (Bus1T <= CurrentSecond) {
                    Bus1 = 1;
                    setprop("services/bus/bus1-enable", 1);
                }
            }
            
            if (Bus2 == 0 and Bus2T != 0) {
                if (Bus2T <= CurrentSecond) {
                    Bus2 = 1;
                    setprop("services/bus/bus2-enable", 1);
                }
            }
            
            ####Jetways
            
            if (Jetway1 == 0 and Jetway1T != 0) {
                if (Jetway1T <= CurrentSecond) {
                    Jetway1 = 1;
                    setprop("services/payload/jetway1_enable", 1);
                    
                    # Connect 3D Jetway to door 1L (if available)
                    if (AutoJetways) {
                        JetwayConnect(0);
                    }
                    
                    if (DeBoardingTime == 0 and DeboardingStarted != 1 and DeboardingFinished != 1) {
                        DeBoardingTime = CurrentSecond + 60 + rand() * 60;
                    }
                }
            }
            
            if (Jetway2 == 0 and Jetway2T != 0) {
                if (Jetway2T <= CurrentSecond) {
                    Jetway2 = 1;
                    setprop("services/payload/jetway2_enable", 1);
                    
                    # Connect 3D Jetway to door 2L (if available)
                    if (AutoJetways) {
                        JetwayConnect(1);
                    }
                    
                    if (DeBoardingTime == 0 and DeboardingStarted != 1 and DeboardingFinished != 1) {
                        DeBoardingTime = CurrentSecond + 60 + rand() * 60;
                    }
                }
            }
            
            ####Stairs
            
            if (Stairs1 == 0 and Stairs1T != 0) {
                if (Stairs1T <= CurrentSecond) {
                    Stairs1 = 1;
                    setprop("services/stairs/stairs1_enable", 1);
                    if (DeBoardingTime == 0 and DeboardingStarted != 1 and DeboardingFinished != 1) {
                        DeBoardingTime = CurrentSecond + 10 + rand() * 60;
                    }
                }
            }
            
            if (Stairs2 == 0 and Stairs2T != 0) {
                if (Stairs2T <= CurrentSecond) {
                    Stairs2 = 1;
                    setprop("services/stairs/stairs2_enable", 1);
                    if (DeBoardingTime == 0 and DeboardingStarted != 1 and DeboardingFinished != 1) {
                        DeBoardingTime = CurrentSecond + 10 + rand() * 60;
                    }
                }
            }
            
            if (Stairs3 == 0 and Stairs3T != 0) {
                if (Stairs3T <= CurrentSecond) {
                    Stairs3 = 1;
                    setprop("services/stairs/stairs3_enable", 1);
                    if (DeBoardingTime == 0 and DeboardingStarted != 1 and DeboardingFinished != 1) {
                        DeBoardingTime = CurrentSecond + 10 + rand() * 60;
                    }
                }
            }
            
            if (Stairs4 == 0 and Stairs4T != 0) {
                if (Stairs4T <= CurrentSecond) {
                    Stairs4 = 1;
                    setprop("services/stairs/stairs4_enable", 1);
                    if (DeBoardingTime == 0 and DeboardingStarted != 1 and DeboardingFinished != 1) {
                        DeBoardingTime = CurrentSecond + 10 + rand() * 60;
                    }
                }
            }
            
            #### Baggage Trucks
            
            if (Baggage1 == 0 and Baggage1T != 0) {
                if (Baggage1T <= CurrentSecond) {
                    Baggage1 = 1;
                    setprop("services/payload/baggage-truck1-enable", 1);
                    
                    # If there is baggage on board, start unloading if that hasn't started yet.
                    if (getprop("services/payload/baggage-loading") != 2 and getprop("services/payload/belly-onboard-lbs") > 0) {
                        setprop("services/payload/baggage-loading", 2);
                        screen.log.write("Baggage unloading started.", 0, 0.584, 1);
                        setprop("services/payload/loadingtime_remaining", "Start unloading...");
                    }
                }
            }
            
            if (Baggage2 == 0 and Baggage2T != 0) {
                if (Baggage2T <= CurrentSecond) {
                    Baggage2 = 1;
                    setprop("services/payload/baggage-truck2-enable", 1);
                    
                    # If there is baggage on board, start unloading if that hasn't started yet.
                    if (getprop("services/payload/baggage-loading") != 2 and getprop("services/payload/belly-onboard-lbs") > 0) {
                        setprop("services/payload/baggage-loading", 2);
                        screen.log.write("Baggage unloading started.", 0, 0.584, 1);
                        setprop("services/payload/loadingtime_remaining", "Start unloading...");
                    }
                }
            }
            
            #### Catering Trucks
            
            if (Catering1 == 0 and Catering1T != 0) {
                if ((Stairs1T == 0 and Jetway1T == 0) or DeboardingFinished == 1) {
                    Catering1 = 1;
                    setprop("services/catering/truck[0]/connect", 1);
                    if (CateringStatus != 2 and getprop("services/catering/truck[0]/weight-lbs") > 0) {
                        CateringLogic();
                    }
                }
            }
            
            if (Catering2 == 0 and Catering2T != 0) {
                if (DeboardingFinished == 1) {
                    Catering2 = 1;
                    setprop("services/catering/truck[1]/connect", 1);
                    if (CateringStatus != 2 and getprop("services/catering/truck[1]/weight-lbs") > 0) {
                        CateringLogic();
                    }
                }
            }
            
            if (Catering3 == 0 and Catering3T != 0) {
                if (DeboardingFinished == 1) {
                    Catering3 = 1;
                    setprop("services/catering/truck[2]/connect", 1);
                    if (CateringStatus != 2 and getprop("services/catering/truck[2]/weight-lbs") > 0) {
                        CateringLogic();
                    }
                }
            }
            
            if (Catering4 == 0 and Catering4T != 0) {
                if (Stairs4T == 0 or DeboardingFinished == 1) {
                    Catering4 = 1;
                    setprop("services/catering/truck[3]/connect", 1);
                    if (CateringStatus != 2 and getprop("services/catering/truck[3]/weight-lbs") > 0) {
                        CateringLogic();
                    }
                }
            }
            
            #### Fuel Truck
            
            if (FuelTruck == 0 and FuelTruckT != 0) {
                if (FuelTruckT <= CurrentSecond) {
                    FuelTruck = 1;
                    setprop("services/fuel-truck/enable", 1);
                }
            }
            
            if (FuelTruckPipe == 0 and FuelTruckPipeT != 0) {
                if (FuelTruckPipeT <= CurrentSecond) {
                    FuelTruckPipe = 1;
                    setprop("services/fuel-truck/connect", 1);
                }
            }
            
            if (CateringStartUnloadingT != 0 and CateringStartUnloadingT <= CurrentSecond and CateringStatus != 2 and getprop("services/catering/weight-lbs") > 0) {
                CateringLogic();
            }
            
            if (DeBoardingTime != 0 and DeBoardingTime <= CurrentSecond) {
                DeBoardingTime = 0;
                
                # If there are passengers on board and deboarding has not yet started, start deboarding
                if (BoardingStatus != 2 and getprop("services/payload/pax-onboard-nr") > 0 and getprop("controls/cabin/SeatBelt-status") == -1) {
                    setprop("services/payload/pax-boarding", 2);
                    screen.log.write("Passenger deboarding started.", 0, 0.584, 1);
                    setprop("services/payload/boardingtime_remaining", "Start deboarding...");
                } elsif (BoardingStatus != 2 and getprop("services/payload/pax-onboard-nr") > 0 and getprop("controls/cabin/SeatBelt-status") != -1 and (Stairs1 == 1 or Stairs2 == 1 or Stairs3 == 1 or Stairs4 == 1)) {
                    screen.log.write("Stairs connected. Please switch off the Seatbelt sign and manually start deboarding.", 1, 0.4, 0);
                } elsif (BoardingStatus != 2 and getprop("services/payload/pax-onboard-nr") > 0 and getprop("controls/cabin/SeatBelt-status") != -1 and (Jetway1 == 1 or Jetway2 == 1)) {
                    screen.log.write("Jetway connected. Please switch off the Seatbelt sign and manually start deboarding.", 1, 0.4, 0);
                }
            }
            
            if (DeboardingFinished == 1 and getprop("services/payload/belly-onboard-lbs") == 0 and getprop("services/catering") == 0) {
                OnBlocksTime = "";
            }
            
            PreviousSecond = CurrentSecond;
        }
    
        # Fuel Truck Controls
        # Fuel Transfer Rate is based on a 1000 US Gal flow per minute, which is at the fast side of real life operations, but not unrealistic.
        
        if (getprop("services/fuel-truck/enable") and getprop("services/fuel-truck/connect")) {
        
            if (getprop("services/fuel-truck/transfer")) {
            
                if (getprop("consumables/fuel/total-fuel-lbs") < getprop("services/fuel-truck/request-lbs")) {
                    if (getprop("consumables/fuel/tank/level-gal_us") < getprop("consumables/fuel/tank[2]/capacity-gal_us")) {
                        if (getprop("consumables/fuel/tank/level-lbs") + 6 > getprop("services/fuel-truck/request-lbs") - getprop("consumables/fuel/tank[2]/level-lbs") - getprop("consumables/fuel/tank[1]/level-lbs")) {
                            setprop("consumables/fuel/tank/level-lbs", getprop("consumables/fuel/tank/level-lbs") + 0.1);
                        } else {
                            setprop("consumables/fuel/tank/level-lbs", getprop("consumables/fuel/tank/level-lbs") + 5.55);
                        }
                    }
                    if (getprop("consumables/fuel/tank[2]/level-gal_us") < getprop("consumables/fuel/tank[2]/capacity-gal_us")) {
                        if (getprop("consumables/fuel/tank[2]/level-lbs") + 6 > getprop("services/fuel-truck/request-lbs") - getprop("consumables/fuel/tank/level-lbs") - getprop("consumables/fuel/tank[1]/level-lbs")) {
                            setprop("consumables/fuel/tank[2]/level-lbs", getprop("consumables/fuel/tank[2]/level-lbs") + 0.1);
                        } else {
                            setprop("consumables/fuel/tank[2]/level-lbs", getprop("consumables/fuel/tank[2]/level-lbs") + 5.55);
                        }
                    }
                    if ((getprop("consumables/fuel/tank/capacity-gal_us") <= getprop("consumables/fuel/tank/level-gal_us")) and (getprop("consumables/fuel/tank[2]/capacity-gal_us") <= getprop("consumables/fuel/tank[2]/level-gal_us"))) {
                        if (getprop("consumables/fuel/tank/level-gal_us") > getprop("consumables/fuel/tank/capacity-gal_us")) {
                            setprop("consumables/fuel/tank[1]/level-gal_us", (getprop("consumables/fuel/tank[1]/level-gal_us") + getprop("consumables/fuel/tank/level-gal_us") - getprop("consumables/fuel/tank/capacity-gal_us")));
                            setprop("consumables/fuel/tank/level-gal_us", getprop("consumables/fuel/tank/capacity-gal_us"));
                        }
                        if (getprop("consumables/fuel/tank[2]/level-gal_us") > getprop("consumables/fuel/tank[2]/capacity-gal_us")) {
                            setprop("consumables/fuel/tank[1]/level-gal_us", (getprop("consumables/fuel/tank[1]/level-gal_us") + getprop("consumables/fuel/tank[2]/level-gal_us") - getprop("consumables/fuel/tank[2]/capacity-gal_us")));
                            setprop("consumables/fuel/tank[2]/level-gal_us", getprop("consumables/fuel/tank[2]/capacity-gal_us"));
                        }
                        if (getprop("consumables/fuel/tank[1]/level-lbs") + 12 > getprop("services/fuel-truck/request-lbs") - getprop("consumables/fuel/tank/level-lbs") - getprop("consumables/fuel/tank[2]/level-lbs")) {
                            setprop("consumables/fuel/tank[1]/level-lbs", getprop("consumables/fuel/tank[1]/level-lbs") + 0.1);
                        } else {
                            setprop("consumables/fuel/tank[1]/level-lbs", getprop("consumables/fuel/tank[1]/level-lbs") + 11.1);
                        }
                    }
                setprop("services/fuel-truck/speed-text", math.round((getprop("services/fuel-truck/request-lbs")-getprop("consumables/fuel/total-fuel-lbs")) / 6660) ~ " min remaining");
                } else {
                    setprop("services/fuel-truck/transfer", 0);
                    setprop("services/fuel-truck/speed-text", " ");
                    setprop("services/fuel-truck/finished", 1);
                    screen.log.write("Refueling complete. " ~ math.round(getprop("consumables/fuel/total-fuel-lbs")) ~" Lbs. of fuel loaded.", 0, 0.584, 1);
                    if (getprop("aircraft/settings/gnd_autodisconnect") == 1) {
                        setprop("services/fuel-truck/connect", 0);
                        setprop("services/fuel-truck/enable", 0);
                    }
                }
            }
            
            if (getprop("services/fuel-truck/clean")) {
            
                if (getprop("consumables/fuel/total-fuel-lbs") > 200) {
                
                    setprop("consumables/fuel/tank/level-lbs", getprop("consumables/fuel/tank/level-lbs") - 3.7);
                    setprop("consumables/fuel/tank[1]/level-lbs", getprop("consumables/fuel/tank[1]/level-lbs") - 3.7);
                    setprop("consumables/fuel/tank[2]/level-lbs", getprop("consumables/fuel/tank[2]/level-lbs") - 3.7);
                    setprop("services/fuel-truck/speed-text", math.round(getprop("consumables/fuel/total-fuel-lbs") / 6660) ~ " min remaining");
                } else {
                    setprop("services/fuel-truck/clean", 0);
                    setprop("services/fuel-truck/speed-text", " ");
                    screen.log.write("Fuel tanks drained.", 0, 0.584, 1);
                    if (getprop("aircraft/settings/gnd_autodisconnect") == 1) {
                        setprop("services/fuel-truck/connect", 0);
                        setprop("services/fuel-truck/enable", 0);
                    }
                }	
            
            }
        } elsif (!(getprop("services/fuel-truck/enable")) and (getprop("services/fuel-truck/connect"))) {
            setprop("services/fuel-truck/connect", 0);
        }
        
        #External Ground Power controls
        
        if (getprop("services/ext-pwr/enable") == 1) {
            if (getprop("services/ext-pwr/primary") == 1) {
                setprop("controls/electric/external-power", 1);
            } else {
                setprop("controls/electric/external-power", 0);
            }
            if (getprop("services/ext-pwr/secondary") == 1) {
                setprop("controls/electric/external-power[1]", 1);
            } else {
                setprop("controls/electric/external-power[1]", 0);
            }
            setprop("services/ext-pwr/was_enabled", 1);
        } else {
            if (getprop("services/ext-pwr/primary") == 1) {
                if (getprop("services/ext-pwr/was_enabled") != 1) {
                    screen.log.write("Can't connect primary ground power without a powerbox!", 1, 0 ,0);
                }
                setprop("services/ext-pwr/primary", 0);
                setprop("controls/electric/external-power", 0);
            }
            if (getprop("services/ext-pwr/secondary") == 1) {
                if (getprop("services/ext-pwr/was_enabled") != 1) {
                    screen.log.write("Can't connect secondary ground power without a powerbox!", 1, 0 ,0);
                }
                setprop("services/ext-pwr/secondary", 0);
                setprop("controls/electric/external-power[1]", 0);
            }
            setprop("services/ext-pwr/was_enabled", 0);
        }
        
        # Chocks
        # This uses the left and right brakes for the moment, to avoid the parking brake from being active.
        
        if ((getprop("services/chocks/nose") == 1) or (getprop("services/chocks/left") == 1)) {
            setprop("controls/gear/brake-left", 1);
            setprop("services/chocks/left-was-enabled", 1);
        } else {
            if (getprop("services/chocks/left-was-enabled") == 1) {
                setprop("controls/gear/brake-left", 0);
                setprop("services/chocks/left-was-enabled", 0);
            }
        }
        
        if ((getprop("services/chocks/nose") == 1) or (getprop("services/chocks/right") == 1)) {
            setprop("controls/gear/brake-right", 1);
            setprop("services/chocks/right-was-enabled", 1);
        } else {
            if (getprop("services/chocks/right-was-enabled") == 1) {
                setprop("controls/gear/brake-right", 0);
                setprop("services/chocks/right-was-enabled", 0);
            }
        }
        
        # Pax and baggage
        
        # Gui update for the weight & payload dialog (code is in payload.nas, but Gui update needs the faster timer of the ground services system)
        setprop("services/payload/expected-weight-lbs", getprop("services/payload/belly-request-lbs") + getprop("services/catering/request-lbs") + getprop("services/payload/first-request-nr") * 247 + getprop("services/payload/business-request-nr") * 225 + getprop("services/payload/economy-request-nr") * 170 + getprop("services/payload/crew-request-nr") * 150);
        setprop("services/payload/pax-request-nr", getprop("services/payload/first-request-nr") + getprop("services/payload/business-request-nr") + getprop("services/payload/economy-request-nr"));
        
        # Make sure a Jetway and Stair cannot be connected to the same door at the same time.
        
        if (getprop("services/payload/jetway1_enable") == 1) {
            if (getprop("services/stairs/stairs1_enable") == 1) {
                setprop("services/stairs/stairs1_enable", 0);
                screen.log.write("Can't connect a Stair and a Jetway to the same door!", 1, 0 ,0);
            }
        }
        if (getprop("services/payload/jetway2_enable") == 1) {
            if (getprop("services/stairs/stairs2_enable") == 1) {
                setprop("services/stairs/stairs2_enable", 0);
                screen.log.write("Can't connect a Stair and a Jetway to the same door!", 1, 0 ,0);
            }
        }

        # De-icing Truck
		
		if (getprop("/services/deicing_truck/enable") and getprop("/services/deicing_truck/de-ice"))
		{		
			if (me.ice_time == 2){
				StartTimeText = getprop("sim/time/gmt");
                setprop("services/deicing_truck/truck/direction", 1);
                setprop("services/deicing_truck/truck[1]/direction", 1);
                setprop("services/deicing_truck/truck[2]/direction", 1);
                setprop("services/deicing_truck/truck[3]/direction", 1);
                setprop("services/deicing_truck/truck[4]/direction", 1);
                icetruck.move(1);
                icetruck1.move(1);
                icetruck2.move(1);
                icetruck3.move(1);
                icetruck4.move(1);
                icecrane1.move(1);
			}
            
            if (me.ice_time == 22){
                icecrane3.move(1);
            }
            
            if (me.ice_time == 32){
                icecrane4.move(1);
            }
            
            if (me.ice_time == 52) {
                icecrane2.move(1);
            }
            
            if (me.ice_time == 102) {
                icecrane.move(1);
            }
            
            if (me.ice_time == 202) {
                icedeicing.move(1);
                icedeicing1.move(1);
                icedeicing4.move(1);
            }
            
            if (me.ice_time == 222) {
                icedeicing3.move(1);
            }
            
            if (me.ice_time == 252) {
                icedeicing2.move(1);
            }
            
            if (me.ice_time == 1002){
                
                
                setprop("services/deicing_truck/truck/direction", -1);                
				icedeicing.move(0);
                icetruck.move(0);
                
                setprop("services/deicing_truck/truck[1]/direction", -1);
                icedeicing1.move(0);
                icetruck1.move(0);
                
                setprop("services/deicing_truck/truck[2]/direction", -1);
                icedeicing2.move(0);
                icetruck2.move(0);
                
                setprop("services/deicing_truck/truck[3]/direction", -1);
                icedeicing3.move(0);
                icetruck3.move(0);
                
                setprop("services/deicing_truck/truck[4]/direction", -1);
                icedeicing4.move(0);
                icetruck4.move(0);
			}
            
            if (me.ice_time == 1702){
				icecrane.move(0);
			}
				
			if (me.ice_time == 1752){
                icecrane2.move(0);
                icecrane1.move(0);
			}
            
            if (me.ice_time == 1772){
                icecrane4.move(0);
			}
            
            if (me.ice_time == 1782){
                icecrane3.move(0);
			}

			if (me.ice_time == 2002) {
				screen.log.write("De-icing on aircraft complete. Propylene glycol, type IV fluid applied at 75%.", 0.5, 0.9, 1.0);
                screen.log.write("De-icing started at " ~ StartTimeText ~ "UTC. Holdover time is 0 hours 45 minutes.", 0.5, 0.9, 1.0);
				setprop("services/deicing_truck/de-ice", 0);
                setprop("services/deicing_truck/truck/direction", 0);
                setprop("services/deicing_truck/truck[1]/direction", 0);
                setprop("services/deicing_truck/truck[2]/direction", 0);
                setprop("services/deicing_truck/truck[3]/direction", 0);
                setprop("services/deicing_truck/truck[4]/direction", 0);
                if (getprop("aircraft/settings/gnd_autodisconnect") == 1) {
                    setprop("services/deicing_truck/enable", 0);
                }
                #Enter true icing props here
			}
		
		} else {
			me.ice_time = 0;
		}
		
	me.ice_time += 1;
        
    }

};

var CateringLogic = func {
    
    if (       (getprop("services/catering/truck[0]/cargo/position-norm") == 1 and getprop("services/catering/truck[0]/weight-lbs") > 0)
            or (getprop("services/catering/truck[1]/cargo/position-norm") == 1 and getprop("services/catering/truck[1]/weight-lbs") > 0)
            or (getprop("services/catering/truck[2]/cargo/position-norm") == 1 and getprop("services/catering/truck[2]/weight-lbs") > 0)
            or (getprop("services/catering/truck[3]/cargo/position-norm") == 1 and getprop("services/catering/truck[3]/weight-lbs") > 0)
    ){
        setprop("services/catering/complete", 0);
        setprop("services/catering/loading", 2);
        if (getprop("services/catering/truck[0]/cargo/position-norm") == 1) {
            setprop("services/catering/truck[0]/complete", 0);
        } else {
            setprop("services/catering/truck[0]/complete", 1);
        }
        if (getprop("services/catering/truck[1]/cargo/position-norm") == 1) {
            setprop("services/catering/truck[1]/complete", 0);
        } else {
            setprop("services/catering/truck[1]/complete", 1);
        }
        if (getprop("services/catering/truck[2]/cargo/position-norm") == 1) {
            setprop("services/catering/truck[2]/complete", 0);
        } else {
            setprop("services/catering/truck[2]/complete", 1);
        }
        if (getprop("services/catering/truck[3]/cargo/position-norm") == 1) {
            setprop("services/catering/truck[3]/complete", 0);
        } else {
            setprop("services/catering/truck[3]/complete", 1);
        }
        var loadingtime = math.round(getprop("services/catering/weight-lbs") / 80 / 60 * getprop("services/payload/speed"));
        screen.log.write("Waste unloading started. Estimated time remaining: " ~ loadingtime ~ " minutes.", 0, 0.584, 1);
        setprop("services/catering/time_remaining", loadingtime ~ " min remaining");  
    } elsif (getprop("services/catering/weight-lbs") != 0) {
        #Try again in 10 seconds
        CateringStartUnloadingT = CurrentSecond + 10;
    } else {
        CateringStartUnloadingT = 0;
    }
}

var JetwayConnect = func(door) {
    #This function uses the ability to connect the nearest animated jetway(s) to the aircraft. See fgdata/Nasal/Jetways.nas for full explanation.

    var coord = geo.aircraft_position();
    var jetwayhdg = getprop("orientation/heading-deg");
    var jetwaydoor = door;
    var jetwaylat = coord.apply_course_distance(jetwayhdg, -getprop("sim/model/door[" ~ door ~ "]/position-x-m"));
    var jetwaylon = coord.apply_course_distance(jetwayhdg + 90, getprop("sim/model/door[" ~ door ~ "]/position-y-m"));
    var jetwayhood = getprop("sim/model/door[" ~ door ~ "]/jetway-hood-deg");
    jetways.toggle_jetway_from_coord(jetwaydoor, jetwayhood, jetwayhdg, jetwaylat, jetwaylon);

}

var autoconnect = func {

    #Check if autoconnect is enabled in Aircraft Settings
    
    if (getprop("aircraft/settings/gnd_autoconnect") == 1) {
        #Function fires from listener when cutoff switches have been moved. Only proceed to autoconnect groundservices when below conditions are met.
        
        if (getprop("aircaft/settings/autoconnect/force-start") or (getprop("controls/engines/engine[0]/cutoff") == 1 and getprop("controls/engines/engine[1]/cutoff") == 1 and getprop("controls/gear/brake-parking") == 1)) {
        
            #detect On Blocks Time
            
            OnBlocksTime = getprop("sim/time/gmt-string");
            OnBlocksSecond = getprop("sim/time/elapsed-sec");
            print("On Blocks Time detected at " ~ OnBlocksTime);
            setprop("sim/time/OnBlocksTime", OnBlocksTime);
            
            #detect which services are available (based on in flight config or on default profile) and assign connection times (with a little randomisation)
            
            var GPU1Sel = getprop("aircraft/settings/autoconnect/GPU1");
            var GPU2Sel = getprop("aircraft/settings/autoconnect/GPU2");
            var ChockSel = getprop("aircraft/settings/autoconnect/Chocks");
            var ConeSel = getprop("aircraft/settings/autoconnect/Cones");
            var Jetway1Sel = getprop("aircraft/settings/autoconnect/Jetway1");
            var Jetway2Sel = getprop("aircraft/settings/autoconnect/Jetway2");
            var Stairs1Sel = getprop("aircraft/settings/autoconnect/Stairs1");
            var Stairs2Sel = getprop("aircraft/settings/autoconnect/Stairs2");
            var Stairs3Sel = getprop("aircraft/settings/autoconnect/Stairs3");
            var Stairs4Sel = getprop("aircraft/settings/autoconnect/Stairs4");
            var Catering1Sel = getprop("aircraft/settings/autoconnect/Catering1");
            var Catering2Sel = getprop("aircraft/settings/autoconnect/Catering2");
            var Catering3Sel = getprop("aircraft/settings/autoconnect/Catering3");
            var Catering4Sel = getprop("aircraft/settings/autoconnect/Catering4");
            var FuelTruckSel = getprop("aircraft/settings/autoconnect/FuelTruck");
            var FuelTruckPipeSel = getprop("aircraft/settings/autoconnect/FuelTruckPipe");
            var Bus1Sel = getprop("aircraft/settings/autoconnect/Bus1");
            var Bus2Sel = getprop("aircraft/settings/autoconnect/Bus2");
            var Baggage1Sel = getprop("aircraft/settings/autoconnect/Baggage1");
            var Baggage2Sel = getprop("aircraft/settings/autoconnect/Baggage2");
            var RealisticTiming = getprop("aircraft/settings/gnd_autoconnect_delay");
            
            #GPU
            
            if (GPU1Sel or GPU2Sel) {
                GPUBox = getprop("services/ext-pwr/enable");
                if (!RealisticTiming) {
                    GPUBoxT = OnBlocksSecond;
                } else {
                    GPUBoxT = math.round(OnBlocksSecond + 0 + rand() * 20); #Enable GPU box between 0" and 20" after OBT
                }
                
                if (GPU1Sel) {
                    GPU1 = getprop("services/ext-pwr/primary");
                    if (!RealisticTiming) {
                        GPU1T = OnBlocksSecond;
                    } else {
                        GPU1T = math.round(OnBlocksSecond + 20 + rand() * 90); #Enable GPU1 between 20" and 1'50" after on blocks time
                    }
                }
                
                if (GPU2Sel) {
                    GPU2 = getprop("services/ext-pwr/secondary");
                    if (GPU1T != 0) {
                        if (!RealisticTiming) {
                            GPU2T = OnBlocksSecond;
                        } else {
                            GPU2T = math.round(GPU1T + 20 + rand() * 30); #Enable GPU2 between 20" and 50" after GPU1T
                        }
                    } else {
                        if (!RealisticTiming) {
                            GPU2T = OnBlocksSecond;
                        } else {
                            GPU2T = math.round(OnBlocksSecond + 20 + rand() * 90); #Enable GPU2 between 20" and 1'50" after OBT
                        }
                    }
                }
            }
            
            # Chocks
            
            if (ChockSel) {
                ChockN = getprop("services/chocks/nose");
                if (!RealisticTiming) {
                    ChockNT = OnBlocksSecond;
                } else {
                    ChockNT = math.round(OnBlocksSecond + 30 + rand() * 60); #Enable Nose Chock between 30" and 1'30" after on blocks time
                }
                ChockL = getprop("services/chocks/left");
                if (!RealisticTiming) {
                    ChockLT = OnBlocksSecond;
                } else {
                    ChockLT = math.round(OnBlocksSecond + 30 + rand() * 90); #Enable Left Chock between 30" and 2' after OBT
                }
                ChockR = getprop("services/chocks/right");
                if (!RealisticTiming) {
                    ChockTT = OnBlocksSecond;
                } else {
                    ChockRT = math.round(OnBlocksSecond + 30 + rand() * 110); #Enable Right Chock between 30" and 2'20" after OBT
                }
            }
            
            # Cones
            
            if (ConeSel) {
                ConeL = getprop("services/cones/cone1-enable");
                if (!RealisticTiming) {
                    ConeLT = OnBlocksSecond;
                } else {
                    ConeLT = math.round(OnBlocksSecond + 240 + rand() * 60); #Enable Left Cones between 4' and 5' after OBT
                }
                ConeR = getprop("services/cones/cone2-enable");
                if (!RealisticTiming) {
                    ConeRT = OnBlocksSecond;
                } else {
                    ConeRT = math.round(OnBlocksSecond + 360 + rand() * 60); #Enable Right Cones between 6' and 7' after OBT
                }
            }
            
            # Jetways
            
            if (Jetway1Sel) {
                Jetway1 = getprop("services/payload/jetway1_enable");
                if (!RealisticTiming) {
                    Jetway1T = OnBlocksSecond;
                } else {
                    Jetway1T = math.round(OnBlocksSecond + 155 + rand() * 235); #Enable Front Jetway between 2'35" and 6'30" after OBT
                }
            }
            if (Jetway2Sel) {
                Jetway2 = getprop("services/payload/jetway2_enable");
                if (!RealisticTiming) {
                    Jetway2T = OnBlocksSecond;
                } else {
                    Jetway2T = math.round(Jetway1T + 30 + rand() * 90); #Enable Rear Jetway between 30" and 2' after the first jetway has connected (to make sure the first is out of the way before moving)
                }
            }
            
            # Stairs
            
            if (Stairs1Sel) {
                Stairs1 = getprop("services/stairs/stairs1_enable");
                if (!RealisticTiming) {
                    Stairs1T = OnBlocksSecond;
                } else {
                    Stairs1T = math.round(OnBlocksSecond + 155 + rand() * 235); #Enable Stairs 1L between 2'35" and 6'30" after OBT
                }
            }
            if (Stairs2Sel) {
                Stairs2 = getprop("services/stairs/stairs2_enable");
                if (Stairs1T != 0) {
                    if (!RealisticTiming) {
                        Stairs2T = OnBlocksSecond;
                    } else {
                        Stairs2T = math.round(Stairs1T + 10 + rand() * 90); #Enable Rear Stairs between 10" and 1'40" after the first Stairs has connected
                    }
                } else {
                    if (!RealisticTiming) {
                        Stairs2T = OnBlocksSecond;
                    } else {
                        Stairs2T = math.round(OnBlocksSecond + 180 + rand() * 240); #Enable Stairs 2L between 3' and 7' after OBT.
                    }
                }
            }
            
            if (Stairs3Sel) {
                Stairs3 = getprop("services/stairs/stairs3_enable");
                if (!RealisticTiming) {
                    Stairs3T = OnBlocksSecond;
                } else {
                    Stairs3T = math.round(OnBlocksSecond + 215 + rand() * 235); #Enable Stairs 4L between 3'35" and 7'30" after OBT
                }
            }
            
            if (Stairs4Sel) {
                Stairs4 = getprop("services/stairs/stairs4_enable");
                if (!RealisticTiming) {
                    Stairs4T = OnBlocksSecond;
                } else {
                    Stairs4T = math.round(OnBlocksSecond + 200 + rand() * 280); #Enable Stairs 4L between 3'20" and 8'00" after OBT
                }
            }
            
            # Busses - time is calculated on expected deboarding time
            
            if (Jetway1T != 0 or Jetway2T != 0) {
            
                if (Bus1Sel) {
                    Bus1 = getprop("services/bus/bus1-enable");
                    if (!RealisticTiming) {
                        Bus1T = OnBlocksSecond;
                    } else {
                        Bus1T = math.round(math.avg(Jetway1T, Jetway2T) + 10 + rand() * 60);
                    }
                }
                
                if (Bus2Sel) {
                    Bus2 = getprop("services/bus/bus2-enable");
                    if (!RealisticTiming) {
                        Bus2T = OnBlocksSecond;
                    } else {
                        Bus2T = math.round(math.avg(Jetway1T, Jetway2T) + 30 + rand() * 60);
                    }
                }
            
            } elsif (Stairs1T != 0 or Stairs2T != 0) {
                if (Bus1Sel) {
                    Bus1 = getprop("services/bus/bus1-enable");
                    if (!RealisticTiming) {
                        Bus1T = OnBlocksSecond;
                    } else {
                        Bus1T = math.round(math.avg(Stairs1T, Stairs2T) + rand() * 60);
                    }
                }
                
                if (Bus2Sel) {
                    Bus2 = getprop("services/bus/bus2-enable");
                    if (!RealisticTiming) {
                        Bus2T = OnBlocksSecond;
                    } else {
                        Bus2T = math.round(math.avg(Stairs1T, Stairs2T, Stairs3T, Stairs4T) + rand() * 90);
                    }
                }
            } else {
                if (Bus1Sel) {
                    Bus1 = getprop("services/bus/bus1-enable");
                    if (!RealisticTiming) {
                        Bus1T = OnBlocksSecond;
                    } else {
                        Bus1T = math.round(OnBlocksSecond + 120 + rand() * 60);
                    }
                }
                
                if (Bus2Sel) {
                    Bus2 = getprop("services/bus/bus2-enable");
                    if (!RealisticTiming) {
                        Bus2T = OnBlocksSecond;
                    } else {
                        Bus2T = math.round(OnBlocksSecond + 150 + rand() * 60);
                    }
                }
            }
            
            # Baggage trucks
            
            if (Baggage1Sel) {
                Baggage1 = getprop("services/payload/baggage-truck1-enable");
                if (!RealisticTiming) {
                    Baggage1T = OnBlocksSecond;
                } else {
                    Baggage1T = math.round(OnBlocksSecond + 120 + rand() * 300); #Enable Front Baggage Truck between 2' and 7' after OBT
                }
            }
            if (Baggage2Sel) {
                Baggage2 = getprop("services/payload/baggage-truck2-enable");
                if (!RealisticTiming) {
                    Baggage2T = OnBlocksSecond;
                } else {
                    Baggage2T = math.round(OnBlocksSecond + 120 + rand() * 300); #Enable Rear Baggage Truck between 2' and 7' after OBT
                }
            }
            
            # Catering trucks
            
            #Set all catering trucks to enabled immediately, connection comes when deboarding is finished (see code above).
            if (Catering1Sel) {
                setprop("services/catering/truck[0]/enabled", 1);
                Catering1T = 1;
            }
            
            if (Catering2Sel) {
                setprop("services/catering/truck[1]/enabled", 1);
                Catering2T = 1;
            }
            
            if (Catering3Sel) {
                setprop("services/catering/truck[2]/enabled", 1);
                Catering3T = 1;
            }
            
            if (Catering4Sel) {
                setprop("services/catering/truck[3]/enabled", 1);
                Catering4T = 1;
            }
            
            # Fuel Truck
            
            if (FuelTruckSel) {
                FuelTruck = getprop("services/fuel-truck/enable");
                if (!RealisticTiming) {
                    FuelTruckT = OnBlocksSecond;
                } else {
                    FuelTruckT = math.round(OnBlocksSecond + 600 + rand() * 600); #Connect Fuel Truck between 10' and 20' after OBT
                }
                if (FuelTruckPipeSel) {
                    FuelTruckPipe = getprop("services/fuel-truck/connect");
                    if (!RealisticTiming) {
                        FuelTruckPipeT = OnBlocksSecond + 1;
                    } else {
                        FuelTruckPipeT = math.round(FuelTruckT + 60 + rand() * 120); #Connect Fuel Pipe between 1' and 3' after truck placement.
                    }
                }
            }
        }
    }
}

var _timer_gsv = maketimer(0.1, func{ground_services.update()});

var _startstop_gsv = func() {
    if (getprop("gear/gear[0]/wow") == 1) {
        _timer_gsv.start();
    } else {
        _timer_gsv.stop();
    }
}

setlistener("sim/signals/fdm-initialized", func {
    ground_services.init();
    print("Ground Services ..... Initialized");
});

setlistener("aircraft/settings/autoconnect/launch", func{
    setlistener("controls/engines/engine/cutoff", func{
        if (OnBlocksTime == "") {
            autoconnect();
        }
    });
    setlistener("controls/engines/engine[1]/cutoff", func{
        if (OnBlocksTime == "") {
            autoconnect();
        }
    });
    setlistener("aircraft/settings/autoconnect/force-start", func{autoconnect()});
    print("Autoconnect ..... Ready");
});

setlistener("gear/gear[0]/wow", func {_startstop_gsv()});