# Simulation of Alpha Electro Air Speed Indicator (ASI) by Bea Wolf (D-ECHO) based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)

#Information based on manual http://www.flypipistrel.com/manuals/ALPHA%20ELECTRO%20POH%20A02.pdf
#######################################

var ASI_main = nil;
var ASI_display = nil;

var base = "/instrumentation/airspeed-indicator/";
var inputs = base~"inputs/";


var volt_prop = "systems/electrical/outputs/instruments";

var instrument_dir = "Aircraft/AlphaElectro/Models/Instruments/ASI/";


var canvas_ASI_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		 var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var svg_keys = me.getKeys();
			foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volt = getprop(volt_prop) or 0;
		
		if ( volt > 10) {
			ASI_main.page.show();
		} else {
			ASI_main.page.hide();
		}
		
		settimer(func me.update(), 0.02);
	},
};
	
	
var canvas_ASI_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_ASI_main , canvas_ASI_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["ias"];
	},
	update: func() {
		
		#ASI
		var asi = (getprop("instrumentation/airspeed-indicator/indicated-speed-kt") or 0);
		me["ias"].setText(sprintf("%3d", math.round(asi)));
		
		
		
		settimer(func me.update(), 0.02);
	}
	
};




setlistener("sim/signals/fdm-initialized", func {
	ASI_display = canvas.new({
		"name": "ASI",
		"size": [256, 256],
		"view": [256, 256],
		"mipmapping": 1
	});
	ASI_display.addPlacement({"node": "ASI.screen"});
	var groupMain = ASI_display.createGroup();


	ASI_main = canvas_ASI_main.new(groupMain, instrument_dir~"ASI_main.svg");

	ASI_main.update();
	canvas_ASI_base.update();
});

var showASI = func {
	var dlg = canvas.Window.new([256, 256], "dialog").set("resize", 1);
	dlg.setCanvas(ASI_display);
}

	
