/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.svg;

import java.io.File;
import java.io.FilePermission;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BaseScriptingEnvironment;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DefaultExternalResourceSecurity;
import org.apache.batik.bridge.DefaultScriptSecurity;
import org.apache.batik.bridge.EmbededExternalResourceSecurity;
import org.apache.batik.bridge.EmbededScriptSecurity;
import org.apache.batik.bridge.ExternalResourceSecurity;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.NoLoadExternalResourceSecurity;
import org.apache.batik.bridge.NoLoadScriptSecurity;
import org.apache.batik.bridge.RelaxedExternalResourceSecurity;
import org.apache.batik.bridge.RelaxedScriptSecurity;
import org.apache.batik.bridge.ScriptSecurity;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.test.AbstractTest;
import org.apache.batik.test.DefaultTestReport;
import org.apache.batik.test.Test;
import org.apache.batik.test.TestReport;
import org.apache.batik.util.ApplicationSecurityEnforcer;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGOnLoadExceptionTest
extends AbstractTest {
    public static final String RAN = "ran";
    public static final String ERROR_EXCEPTION_DID_NOT_OCCUR = "SVGOnLoadExceptionTest.error.exception.did.not.occur";
    public static final String ERROR_UNEXPECTED_EXCEPTION = "SVGOnLoadExceptionTest.error.unexpected.exception";
    public static final String ERROR_UNEXPECTED_ERROR_CODE = "SVGOnLoadExceptionTest.error.unexpected.error.code";
    public static final String ERROR_SCRIPT_DID_NOT_RUN = "SVGOnLoadExceptionTest.error.script.did.not.run";
    public static final String ENTRY_KEY_UNEXPECTED_EXCEPTION = "SVGOnLoadExceptionTest.entry.key.unexpected.exception";
    public static final String ENTRY_KEY_UNEXPECTED_ERROR_CODE = "SVGOnLoadExceptionTest.entry.key.unexpected.error.code";
    public static final String ENTRY_KEY_EXPECTED_ERROR_CODE = "SVGOnLoadExceptionTest.entry.key.expected.error.code";
    public static final String ENTRY_KEY_EXPECTED_EXCEPTION = "SVGOnLoadExceptionTest.entry.key.expected.exception";
    public static final String ENTRY_KEY_UNEXPECTED_RESULT = "SVGOnLoadExceptionTest.entry.key.unexpected.result";
    public static final String ERROR_CODE_NO_CHECK = "noCheck";
    public static final String testNS = "http://xml.apache.org/batik/test";
    protected String svgURL;
    protected String scripts = "text/ecmascript, application/java-archive";
    protected String expectedExceptionClass = "org.apache.batik.bridge.Exception";
    protected String expectedErrorCode = "none";
    protected String scriptOrigin = "ANY";
    protected String resourceOrigin = "ANY";
    protected boolean secure = false;
    protected Boolean validate = Boolean.FALSE;
    protected String fileName;
    protected boolean restricted = false;

    public boolean getRestricted() {
        return this.restricted;
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public void setScripts(String scripts) {
        this.scripts = scripts;
    }

    public String getScripts() {
        return this.scripts;
    }

    public void setScriptOrigin(String scriptOrigin) {
        this.scriptOrigin = scriptOrigin;
    }

    public String getScriptOrigin() {
        return this.scriptOrigin;
    }

    public void setResourceOrigin(String resourceOrigin) {
        this.resourceOrigin = resourceOrigin;
    }

    public String getResourceOrigin() {
        return this.resourceOrigin;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean getSecure() {
        return this.secure;
    }

    public void setExpectedExceptionClass(String expectedExceptionClass) {
        this.expectedExceptionClass = expectedExceptionClass;
    }

    public String getExpectedExceptionClass() {
        return this.expectedExceptionClass;
    }

    public void setExpectedErrorCode(String expectedErrorCode) {
        this.expectedErrorCode = expectedErrorCode;
    }

    public String getExpectedErrorCode() {
        return this.expectedErrorCode;
    }

    public Boolean getValidate() {
        return this.validate;
    }

    public void setValidate(Boolean validate) {
        this.validate = validate;
        if (this.validate == null) {
            this.validate = Boolean.FALSE;
        }
    }

    public void setId(String id) {
        super.setId(id);
        if (id != null) {
            int i = id.indexOf("(");
            if (i != -1) {
                id = id.substring(0, i);
            }
            this.fileName = "test-resources/org/apache/batik/" + id + ".svg";
            this.svgURL = this.resolveURL(this.fileName);
        }
    }

    protected String resolveURL(String url) {
        File f = new File(url).getAbsoluteFile();
        if (f.getParentFile().exists()) {
            try {
                return f.toURI().toURL().toString();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException();
            }
        }
        try {
            return new URL(url).toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(url);
        }
    }

    public TestReport runImpl() throws Exception {
        ApplicationSecurityEnforcer ase;
        block13: {
            ase = new ApplicationSecurityEnforcer(((Object)((Object)this)).getClass(), "org/apache/batik/apps/svgbrowser/resources/svgbrowser.policy");
            if (this.secure) {
                try {
                    ase.enforceSecurity(true);
                }
                catch (UnsupportedOperationException e) {
                    if (!"java.lang.SecurityException".equals(this.expectedExceptionClass)) break block13;
                    return new DefaultTestReport((Test)this);
                }
            }
        }
        try {
            if (!this.restricted) {
                TestReport e = this.testImpl();
                return e;
            }
            Policy policy = Policy.getPolicy();
            URL classesURL = new File("classes").toURI().toURL();
            CodeSource cs = new CodeSource(classesURL, (Certificate[])null);
            PermissionCollection permissionsOrig = policy.getPermissions(cs);
            Permissions permissions = new Permissions();
            Enumeration<Permission> iter = permissionsOrig.elements();
            while (iter.hasMoreElements()) {
                Permission p = iter.nextElement();
                if (!(p instanceof RuntimePermission)) {
                    if (p instanceof AllPermission) continue;
                    permissions.add(p);
                    continue;
                }
                if ("createClassLoader".equals(p.getName())) continue;
                permissions.add(p);
            }
            this.fileName = new File(this.fileName).getAbsolutePath();
            permissions.add(new FilePermission(this.fileName, "read"));
            permissions.add(new RuntimePermission("accessDeclaredMembers"));
            ProtectionDomain domain = new ProtectionDomain(null, permissions);
            AccessControlContext ctx = new AccessControlContext(new ProtectionDomain[]{domain});
            try {
                TestReport testReport = (TestReport)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return SVGOnLoadExceptionTest.this.testImpl();
                    }
                }, ctx);
                return testReport;
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        finally {
            ase.enforceSecurity(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TestReport testImpl() {
        Document doc;
        block12: {
            String parserClassName = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(parserClassName);
            f.setValidating(this.validate.booleanValue());
            doc = null;
            try {
                doc = f.createDocument(this.svgURL);
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.handleException(e);
            }
            TestUserAgent userAgent = this.buildUserAgent();
            GVTBuilder builder = new GVTBuilder();
            BridgeContext ctx = new BridgeContext((UserAgent)userAgent);
            ctx.setDynamic(true);
            Exception e = null;
            try {
                builder.build(ctx, doc);
                BaseScriptingEnvironment scriptEnvironment = new BaseScriptingEnvironment(ctx);
                scriptEnvironment.loadScripts();
                scriptEnvironment.dispatchSVGLoadEvent();
            }
            catch (Exception ex) {
                e = ex;
                return e;
            }
            finally {
                if (e == null && userAgent.e != null) {
                    e = userAgent.e;
                }
                if (e == null) break block12;
                return this.handleException(e);
            }
        }
        TestReport report = null;
        if (this.expectedExceptionClass == null) {
            Element elem = doc.getElementById("testResult");
            String s = elem.getAttributeNS(null, "result");
            if (RAN.equals(s)) {
                report = this.reportSuccess();
            } else {
                report = this.reportError(ERROR_SCRIPT_DID_NOT_RUN);
                report.addDescriptionEntry(ENTRY_KEY_UNEXPECTED_RESULT, (Object)s);
            }
        }
        if (report == null) {
            report = this.reportError(ERROR_EXCEPTION_DID_NOT_OCCUR);
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_EXCEPTION, (Object)this.expectedExceptionClass);
        }
        return report;
    }

    protected TestReport handleException(Exception e) {
        if (!this.isMatch(e.getClass(), this.expectedExceptionClass)) {
            TestReport report = this.reportError(ERROR_UNEXPECTED_EXCEPTION);
            report.addDescriptionEntry(ENTRY_KEY_UNEXPECTED_EXCEPTION, (Object)e.getClass().getName());
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_EXCEPTION, (Object)this.expectedExceptionClass);
            return report;
        }
        if (!ERROR_CODE_NO_CHECK.equals(this.expectedErrorCode) && e instanceof BridgeException && !this.expectedErrorCode.equals(((BridgeException)((Object)e)).getCode())) {
            TestReport report = this.reportError(ERROR_UNEXPECTED_ERROR_CODE);
            report.addDescriptionEntry(ENTRY_KEY_UNEXPECTED_ERROR_CODE, (Object)((BridgeException)((Object)e)).getCode());
            report.addDescriptionEntry(ENTRY_KEY_EXPECTED_ERROR_CODE, (Object)this.expectedErrorCode);
            return report;
        }
        return this.reportSuccess();
    }

    protected boolean isMatch(Class cl, String name) {
        if (cl == null) {
            return false;
        }
        if (cl.getName().equals(name)) {
            return true;
        }
        return this.isMatch(cl.getSuperclass(), name);
    }

    protected TestUserAgent buildUserAgent() {
        return new TestUserAgent();
    }

    class TestUserAgent
    extends UserAgentAdapter {
        Exception e;

        TestUserAgent() {
        }

        public ExternalResourceSecurity getExternalResourceSecurity(ParsedURL resourceURL, ParsedURL docURL) {
            if ("ANY".equals(SVGOnLoadExceptionTest.this.resourceOrigin)) {
                return new RelaxedExternalResourceSecurity(resourceURL, docURL);
            }
            if ("DOCUMENT".equals(SVGOnLoadExceptionTest.this.resourceOrigin)) {
                return new DefaultExternalResourceSecurity(resourceURL, docURL);
            }
            if ("EMBEDED".equals(SVGOnLoadExceptionTest.this.resourceOrigin)) {
                return new EmbededExternalResourceSecurity(resourceURL);
            }
            return new NoLoadExternalResourceSecurity();
        }

        public ScriptSecurity getScriptSecurity(String scriptType, ParsedURL scriptURL, ParsedURL docURL) {
            Object result = null;
            result = SVGOnLoadExceptionTest.this.scripts.indexOf(scriptType) == -1 ? new NoLoadScriptSecurity(scriptType) : ("ANY".equals(SVGOnLoadExceptionTest.this.scriptOrigin) ? new RelaxedScriptSecurity(scriptType, scriptURL, docURL) : ("DOCUMENT".equals(SVGOnLoadExceptionTest.this.scriptOrigin) ? new DefaultScriptSecurity(scriptType, scriptURL, docURL) : ("EMBEDED".equals(SVGOnLoadExceptionTest.this.scriptOrigin) ? new EmbededScriptSecurity(scriptType, scriptURL, docURL) : new NoLoadScriptSecurity(scriptType))));
            return result;
        }

        public void displayError(Exception e) {
            this.e = e;
        }
    }
}

