/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.jmx;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.jmx.ResourceSettingsMBean;
import org.apache.wicket.jmx.Stringz;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.time.Duration;

public class ResourceSettings
implements ResourceSettingsMBean {
    private final Application application;

    public ResourceSettings(Application application) {
        this.application = application;
    }

    @Override
    public String getLocalizer() {
        return Stringz.className(this.application.getResourceSettings().getLocalizer());
    }

    @Override
    public String getPackageResourceGuard() {
        return Stringz.className(this.application.getResourceSettings().getPackageResourceGuard());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPropertiesFactory() {
        ThreadContext.setApplication((Application)this.application);
        try {
            String string = Stringz.className(this.application.getResourceSettings().getPropertiesFactory());
            return string;
        }
        finally {
            ThreadContext.detach();
        }
    }

    @Override
    public String getResourceFinders() {
        StringBuilder builder = new StringBuilder();
        for (IResourceFinder rf : this.application.getResourceSettings().getResourceFinders()) {
            builder.append(Stringz.className(rf));
        }
        return builder.toString();
    }

    @Override
    public String getResourcePollFrequency() {
        Duration duration = this.application.getResourceSettings().getResourcePollFrequency();
        return duration != null ? duration.toString() : null;
    }

    @Override
    public String getResourceStreamLocator() {
        return Stringz.className(this.application.getResourceSettings().getResourceStreamLocator());
    }

    @Override
    public String[] getStringResourceLoaders() {
        List loaders = this.application.getResourceSettings().getStringResourceLoaders();
        if (loaders != null) {
            ArrayList list = Generics.newArrayList();
            for (IStringResourceLoader loader : loaders) {
                list.add(loader.toString());
            }
            return list.toArray(new String[loaders.size()]);
        }
        return null;
    }

    @Override
    public boolean getThrowExceptionOnMissingResource() {
        return this.application.getResourceSettings().getThrowExceptionOnMissingResource();
    }

    @Override
    public boolean getUseDefaultOnMissingResource() {
        return this.application.getResourceSettings().getUseDefaultOnMissingResource();
    }

    @Override
    public void setThrowExceptionOnMissingResource(boolean throwExceptionOnMissingResource) {
        this.application.getResourceSettings().setThrowExceptionOnMissingResource(throwExceptionOnMissingResource);
    }

    @Override
    public void setUseDefaultOnMissingResource(boolean useDefaultOnMissingResource) {
        this.application.getResourceSettings().setUseDefaultOnMissingResource(useDefaultOnMissingResource);
    }
}

