/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.AbstractCheckSelector;
import org.apache.wicket.markup.html.form.CheckBox;

public class CheckBoxSelector
extends AbstractCheckSelector {
    private static final long serialVersionUID = 1L;
    private final String checkBoxIdArrayLiteral;

    public CheckBoxSelector(String id, CheckBox ... boxes) {
        super(id);
        this.checkBoxIdArrayLiteral = this.buildMarkupIdJSArrayLiteral(Arrays.asList(boxes));
    }

    @Override
    protected CharSequence getFindCheckboxesFunction() {
        return String.format("Wicket.CheckboxSelector.getCheckboxesFunction(%s)", this.checkBoxIdArrayLiteral);
    }

    private String buildMarkupIdJSArrayLiteral(Iterable<? extends Component> components) {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        if (components.iterator().hasNext()) {
            for (Component component : components) {
                component.setOutputMarkupId(true);
                buf.append('\'').append(component.getMarkupId()).append("', ");
            }
            buf.delete(buf.length() - 2, buf.length());
        }
        buf.append(']');
        return buf.toString();
    }
}

