/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.Property;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.messaging.MessageHandler;

public class EnumProperty
extends Property {
    private int value;

    public EnumProperty(int explicitValue) {
        this.value = explicitValue;
    }

    public int getEnum() {
        return this.value;
    }

    public Object getObject() {
        return new Integer(this.value);
    }

    public static class Maker
    extends Property.Maker {
        protected Maker(String propName) {
            super(propName);
        }

        public Property checkEnumValues(String value) {
            MessageHandler.errorln("Unknown enumerated value for property '" + this.getPropName() + "': " + value);
            return null;
        }

        public Property convertProperty(Property p, PropertyList propertyList, FObj fo) throws FOPException {
            if (p instanceof EnumProperty) {
                return p;
            }
            return null;
        }

        protected Property findConstant(String value) {
            return null;
        }
    }
}

