/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.metrics.internal;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.metrics.CallerCount;
import org.apache.unomi.metrics.Metric;
import org.apache.unomi.metrics.MetricsService;
import org.apache.unomi.metrics.internal.CallerCountImpl;
import org.apache.unomi.metrics.internal.MetricImpl;

public class MetricsServiceImpl
implements MetricsService {
    boolean activated = false;
    Map<String, Metric> metrics = new ConcurrentHashMap<String, Metric>();
    Map<String, Boolean> callersStatus = new ConcurrentHashMap<String, Boolean>();

    @Override
    public void setActivated(boolean activated) {
        this.activated = activated;
        if (!activated) {
            this.metrics.clear();
        }
    }

    @Override
    public boolean isActivated() {
        return this.activated;
    }

    @Override
    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    @Override
    public void resetMetrics() {
        this.metrics.clear();
    }

    @Override
    public void updateTimer(String timerName, long startTime) {
        if (!this.activated) {
            return;
        }
        long totalTime = System.currentTimeMillis() - startTime;
        Metric metric = this.metrics.get(timerName);
        if (metric == null) {
            metric = new MetricImpl(timerName);
            this.metrics.put(timerName, metric);
        }
        metric.incTotalCount();
        metric.addTotalTime(totalTime);
        if (this.isCallerActivated(timerName)) {
            StackTraceElement[] stackTraceElements = new Throwable().getStackTrace();
            ArrayList<String> stackTraces = new ArrayList<String>();
            if (stackTraceElements != null && stackTraceElements.length > 2) {
                for (int i = 2; i < stackTraceElements.length; ++i) {
                    stackTraces.add(String.valueOf(stackTraceElements[i]));
                }
                String stackTraceHash = Integer.toString(stackTraces.hashCode());
                CallerCount callerCount = metric.getCallerCounts().get(stackTraceHash);
                if (callerCount == null) {
                    callerCount = new CallerCountImpl(stackTraceHash, stackTraces);
                    callerCount.incCount();
                    callerCount.addTime(totalTime);
                    metric.getCallerCounts().put(stackTraceHash, callerCount);
                } else {
                    callerCount.incCount();
                    callerCount.addTime(totalTime);
                }
            }
        }
    }

    @Override
    public Map<String, Boolean> getCallersStatus() {
        return this.callersStatus;
    }

    @Override
    public void setCallerActivated(String timerName, boolean activated) {
        if (!activated) {
            if (this.callersStatus.containsKey(timerName)) {
                this.callersStatus.remove(timerName);
            }
        } else {
            this.callersStatus.put(timerName, true);
        }
    }

    @Override
    public boolean isCallerActivated(String timerName) {
        if (this.callersStatus.containsKey(timerName)) {
            return this.callersStatus.get(timerName);
        }
        if (this.callersStatus.containsKey("*")) {
            return this.callersStatus.get("*");
        }
        return false;
    }
}

