/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.personalization;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.api.PersonalizationResult;
import org.apache.unomi.api.PersonalizationStrategy;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.PersonalizationService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.services.sorts.ControlGroupPersonalizationStrategy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class PersonalizationServiceImpl
implements PersonalizationService {
    private BundleContext bundleContext;
    private ProfileService profileService;
    private Map<String, PersonalizationStrategy> personalizationStrategies = new ConcurrentHashMap<String, PersonalizationStrategy>();
    private final PersonalizationStrategy controlGroupStrategy = new ControlGroupPersonalizationStrategy();

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void addPersonalizationStrategy(ServiceReference<PersonalizationStrategy> personalizationStrategyRef) {
        PersonalizationStrategy personalizationStrategy = (PersonalizationStrategy)this.bundleContext.getService(personalizationStrategyRef);
        this.personalizationStrategies.put(personalizationStrategyRef.getProperty("personalizationStrategyId").toString(), personalizationStrategy);
    }

    public void removePersonalizationStrategy(ServiceReference<PersonalizationStrategy> personalizationStrategyRef) {
        if (personalizationStrategyRef == null) {
            return;
        }
        this.personalizationStrategies.remove(personalizationStrategyRef.getProperty("personalizationStrategyId").toString());
    }

    public boolean filter(Profile profile, Session session, PersonalizationService.PersonalizedContent personalizedContent) {
        boolean result = true;
        if (personalizedContent.getFilters() != null) {
            for (PersonalizationService.Filter filter : personalizedContent.getFilters()) {
                Condition condition = filter.getCondition();
                if (condition == null || condition.getConditionTypeId() == null) continue;
                result &= this.profileService.matchCondition(condition, profile, session);
            }
        }
        return result;
    }

    public String bestMatch(Profile profile, Session session, PersonalizationService.PersonalizationRequest personalizationRequest) {
        PersonalizationResult result = this.personalizeList(profile, session, personalizationRequest);
        if (result.getContentIds().size() > 0) {
            return (String)result.getContentIds().get(0);
        }
        return null;
    }

    public PersonalizationResult personalizeList(Profile profile, Session session, PersonalizationService.PersonalizationRequest personalizationRequest) {
        PersonalizationStrategy strategy = this.personalizationStrategies.get(personalizationRequest.getStrategy());
        if (strategy != null) {
            PersonalizationResult controlGroupStrategyResult = null;
            if (personalizationRequest.getStrategyOptions() != null && personalizationRequest.getStrategyOptions().containsKey("controlGroup") && (controlGroupStrategyResult = this.controlGroupStrategy.personalizeList(profile, session, personalizationRequest)).isInControlGroup()) {
                return controlGroupStrategyResult;
            }
            PersonalizationResult originalStrategyResult = strategy.personalizeList(profile, session, personalizationRequest);
            if (controlGroupStrategyResult != null) {
                originalStrategyResult.addChanges(controlGroupStrategyResult.getChangeType());
                originalStrategyResult.getAdditionalResultInfos().putAll(controlGroupStrategyResult.getAdditionalResultInfos());
            }
            return originalStrategyResult;
        }
        throw new IllegalArgumentException("Unknown strategy : " + personalizationRequest.getStrategy());
    }
}

