/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.services.impl.goals;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.campaigns.Campaign;
import org.apache.unomi.api.campaigns.CampaignDetail;
import org.apache.unomi.api.campaigns.events.CampaignEvent;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.goals.Goal;
import org.apache.unomi.api.goals.GoalReport;
import org.apache.unomi.api.query.AggregateQuery;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.rules.Rule;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.GoalsService;
import org.apache.unomi.api.services.RulesService;
import org.apache.unomi.api.utils.ParserHelper;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.persistence.spi.aggregate.BaseAggregate;
import org.apache.unomi.persistence.spi.aggregate.DateAggregate;
import org.apache.unomi.persistence.spi.aggregate.DateRangeAggregate;
import org.apache.unomi.persistence.spi.aggregate.IpRangeAggregate;
import org.apache.unomi.persistence.spi.aggregate.NumericRangeAggregate;
import org.apache.unomi.persistence.spi.aggregate.TermsAggregate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoalsServiceImpl
implements GoalsService,
SynchronousBundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GoalsServiceImpl.class.getName());
    private BundleContext bundleContext;
    private PersistenceService persistenceService;
    private DefinitionsService definitionsService;
    private RulesService rulesService;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setRulesService(RulesService rulesService) {
        this.rulesService = rulesService;
    }

    public void postConstruct() {
        LOGGER.debug("postConstruct {{}}", (Object)this.bundleContext.getBundle());
        this.loadPredefinedGoals(this.bundleContext);
        this.loadPredefinedCampaigns(this.bundleContext);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getBundleContext() == null || bundle.getBundleId() == this.bundleContext.getBundle().getBundleId()) continue;
            this.loadPredefinedGoals(bundle.getBundleContext());
            this.loadPredefinedCampaigns(bundle.getBundleContext());
        }
        this.bundleContext.addBundleListener((BundleListener)this);
        LOGGER.info("Goal service initialized.");
    }

    public void preDestroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        LOGGER.info("Goal service shutdown.");
    }

    private void processBundleStartup(BundleContext bundleContext) {
        if (bundleContext == null) {
            return;
        }
        this.loadPredefinedGoals(bundleContext);
        this.loadPredefinedCampaigns(bundleContext);
    }

    private void processBundleStop(BundleContext bundleContext) {
    }

    private void loadPredefinedGoals(BundleContext bundleContext) {
        Enumeration predefinedRuleEntries = bundleContext.getBundle().findEntries("META-INF/cxs/goals", "*.json", true);
        if (predefinedRuleEntries == null) {
            return;
        }
        while (predefinedRuleEntries.hasMoreElements()) {
            URL predefinedGoalURL = (URL)predefinedRuleEntries.nextElement();
            LOGGER.debug("Found predefined goals at {}, loading... ", (Object)predefinedGoalURL);
            try {
                Goal goal = (Goal)CustomObjectMapper.getObjectMapper().readValue(predefinedGoalURL, Goal.class);
                if (goal.getMetadata().getScope() == null) {
                    goal.getMetadata().setScope("systemscope");
                }
                this.setGoal(goal);
                LOGGER.info("Predefined goal with id {} registered", (Object)goal.getMetadata().getId());
            }
            catch (IOException e) {
                LOGGER.error("Error while loading segment definition {}", (Object)predefinedGoalURL, (Object)e);
            }
        }
    }

    private void createRule(Goal goal, Condition event, String id, boolean testStart) {
        Rule rule = new Rule(new Metadata(goal.getMetadata().getScope(), goal.getMetadata().getId() + id + "Event", "Auto generated rule for goal " + goal.getMetadata().getName(), ""));
        Condition res = new Condition();
        ArrayList<Condition> subConditions = new ArrayList<Condition>();
        res.setConditionType(this.definitionsService.getConditionType("booleanCondition"));
        res.setParameter("operator", (Object)"and");
        res.setParameter("subConditions", subConditions);
        subConditions.add(event);
        Condition notExist = new Condition();
        notExist.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
        notExist.setParameter("propertyName", (Object)("systemProperties.goals." + goal.getMetadata().getId() + id + "Reached"));
        notExist.setParameter("comparisonOperator", (Object)"missing");
        subConditions.add(notExist);
        if (testStart) {
            Condition startExists = new Condition();
            startExists.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
            startExists.setParameter("propertyName", (Object)("systemProperties.goals." + goal.getMetadata().getId() + "StartReached"));
            startExists.setParameter("comparisonOperator", (Object)"exists");
            subConditions.add(startExists);
        }
        if (goal.getCampaignId() != null) {
            Condition engagedInCampaign = new Condition();
            engagedInCampaign.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
            engagedInCampaign.setParameter("propertyName", (Object)("systemProperties.campaigns." + goal.getCampaignId() + "Engaged"));
            engagedInCampaign.setParameter("comparisonOperator", (Object)"exists");
            subConditions.add(engagedInCampaign);
        }
        rule.setCondition(res);
        rule.getMetadata().setHidden(true);
        Action action1 = new Action();
        action1.setActionType(this.definitionsService.getActionType("setPropertyAction"));
        String name = "systemProperties.goals." + goal.getMetadata().getId() + id + "Reached";
        action1.setParameter("setPropertyName", (Object)name);
        action1.setParameter("setPropertyValueCurrentEventTimestamp", (Object)true);
        action1.setParameter("storeInSession", (Object)true);
        Action action2 = new Action();
        action2.setActionType(this.definitionsService.getActionType("setPropertyAction"));
        action2.setParameter("setPropertyName", (Object)name);
        action2.setParameter("setPropertyValueCurrentEventTimestamp", (Object)true);
        action2.setParameter("storeInSession", (Object)false);
        rule.setActions(Arrays.asList(action1, action2));
        if (id.equals("Target")) {
            Action action3 = new Action();
            action3.setActionType(this.definitionsService.getActionType("sendEventAction"));
            action3.setParameter("eventType", (Object)"goal");
            action3.setParameter("eventTarget", (Object)goal);
            action3.setParameter("eventProperties", new HashMap());
            action3.setParameter("toBePersisted", (Object)false);
            rule.setActions(Arrays.asList(action1, action2, action3));
        }
        this.rulesService.setRule(rule);
    }

    public Set<Metadata> getGoalMetadatas() {
        HashSet<Metadata> descriptions = new HashSet<Metadata>();
        for (Goal definition : this.persistenceService.getAllItems(Goal.class, 0, 50, null).getList()) {
            descriptions.add(definition.getMetadata());
        }
        return descriptions;
    }

    public Set<Metadata> getGoalMetadatas(Query query) {
        this.definitionsService.resolveConditionType(query.getCondition());
        LinkedHashSet<Metadata> descriptions = new LinkedHashSet<Metadata>();
        List goals = this.persistenceService.query(query.getCondition(), query.getSortby(), Goal.class, query.getOffset(), query.getLimit()).getList();
        for (Goal definition : goals) {
            descriptions.add(definition.getMetadata());
        }
        return descriptions;
    }

    public Goal getGoal(String goalId) {
        Goal goal = (Goal)this.persistenceService.load(goalId, Goal.class);
        if (goal != null) {
            ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)goal.getStartEvent(), (String)("goal " + goalId + " start event"));
            ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)goal.getTargetEvent(), (String)("goal " + goalId + " target event"));
        }
        return goal;
    }

    public void removeGoal(String goalId) {
        this.persistenceService.remove(goalId, Goal.class);
        this.rulesService.removeRule(goalId + "StartEvent");
        this.rulesService.removeRule(goalId + "TargetEvent");
    }

    public void setGoal(Goal goal) {
        if (goal == null) {
            LOGGER.warn("Trying to save null goal, aborting...");
            return;
        }
        ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)goal.getStartEvent(), (String)("goal " + goal.getItemId() + " start event"));
        ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)goal.getTargetEvent(), (String)("goal " + goal.getItemId() + " start event"));
        if (goal.getMetadata().isEnabled()) {
            if (goal.getStartEvent() != null) {
                this.createRule(goal, goal.getStartEvent(), "Start", false);
            }
            if (goal.getTargetEvent() != null) {
                this.createRule(goal, goal.getTargetEvent(), "Target", goal.getStartEvent() != null);
            }
        } else {
            this.rulesService.removeRule(goal.getMetadata().getId() + "StartEvent");
            this.rulesService.removeRule(goal.getMetadata().getId() + "TargetEvent");
        }
        this.persistenceService.save((Item)goal);
    }

    public Set<Metadata> getCampaignGoalMetadatas(String campaignId) {
        HashSet<Metadata> descriptions = new HashSet<Metadata>();
        for (Goal definition : this.persistenceService.query("campaignId", campaignId, null, Goal.class, 0, 50).getList()) {
            descriptions.add(definition.getMetadata());
        }
        return descriptions;
    }

    private void loadPredefinedCampaigns(BundleContext bundleContext) {
        Enumeration predefinedRuleEntries = bundleContext.getBundle().findEntries("META-INF/cxs/campaigns", "*.json", true);
        if (predefinedRuleEntries == null) {
            return;
        }
        while (predefinedRuleEntries.hasMoreElements()) {
            URL predefinedCampaignURL = (URL)predefinedRuleEntries.nextElement();
            LOGGER.debug("Found predefined campaigns at {}, loading... ", (Object)predefinedCampaignURL);
            try {
                Campaign campaign = (Campaign)CustomObjectMapper.getObjectMapper().readValue(predefinedCampaignURL, Campaign.class);
                this.setCampaign(campaign);
                LOGGER.info("Predefined campaign with id {} registered", (Object)campaign.getMetadata().getId());
            }
            catch (IOException e) {
                LOGGER.error("Error while loading segment definition {}", (Object)predefinedCampaignURL, (Object)e);
            }
        }
    }

    private void createRule(Campaign campaign, Condition event) {
        Rule rule = new Rule(new Metadata(campaign.getMetadata().getScope(), campaign.getMetadata().getId() + "EntryEvent", "Auto generated rule for campaign " + campaign.getMetadata().getName(), ""));
        Condition res = new Condition();
        ArrayList<Condition> subConditions = new ArrayList<Condition>();
        res.setConditionType(this.definitionsService.getConditionType("booleanCondition"));
        res.setParameter("operator", (Object)"and");
        res.setParameter("subConditions", subConditions);
        if (campaign.getStartDate() != null) {
            Condition startCondition = new Condition();
            startCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
            startCondition.setParameter("propertyName", (Object)"timeStamp");
            startCondition.setParameter("comparisonOperator", (Object)"greaterThan");
            startCondition.setParameter("propertyValueDate", (Object)campaign.getStartDate());
            subConditions.add(startCondition);
        }
        if (campaign.getEndDate() != null) {
            Condition endCondition = new Condition();
            endCondition.setConditionType(this.definitionsService.getConditionType("sessionPropertyCondition"));
            endCondition.setParameter("propertyName", (Object)"timeStamp");
            endCondition.setParameter("comparisonOperator", (Object)"lessThan");
            endCondition.setParameter("propertyValueDate", (Object)campaign.getEndDate());
            subConditions.add(endCondition);
        }
        rule.setPriority(-5);
        subConditions.add(event);
        rule.setCondition(res);
        rule.getMetadata().setHidden(true);
        Action action1 = new Action();
        action1.setActionType(this.definitionsService.getActionType("setPropertyAction"));
        String name = "systemProperties.campaigns." + campaign.getMetadata().getId() + "Engaged";
        action1.setParameter("setPropertyName", (Object)name);
        action1.setParameter("setPropertyValueCurrentEventTimestamp", (Object)true);
        action1.setParameter("storeInSession", (Object)true);
        Action action2 = new Action();
        action2.setActionType(this.definitionsService.getActionType("setPropertyAction"));
        action2.setParameter("setPropertyName", (Object)name);
        action2.setParameter("setPropertyValueCurrentEventTimestamp", (Object)true);
        action2.setParameter("storeInSession", (Object)false);
        rule.setActions(Arrays.asList(action1, action2));
        this.rulesService.setRule(rule);
    }

    public Set<Metadata> getCampaignMetadatas() {
        HashSet<Metadata> descriptions = new HashSet<Metadata>();
        for (Campaign definition : this.persistenceService.getAllItems(Campaign.class, 0, 50, null).getList()) {
            descriptions.add(definition.getMetadata());
        }
        return descriptions;
    }

    public Set<Metadata> getCampaignMetadatas(Query query) {
        this.definitionsService.resolveConditionType(query.getCondition());
        HashSet<Metadata> descriptions = new HashSet<Metadata>();
        for (Campaign definition : this.persistenceService.query(query.getCondition(), query.getSortby(), Campaign.class, query.getOffset(), query.getLimit()).getList()) {
            descriptions.add(definition.getMetadata());
        }
        return descriptions;
    }

    public PartialList<CampaignDetail> getCampaignDetails(Query query) {
        this.definitionsService.resolveConditionType(query.getCondition());
        PartialList campaigns = this.persistenceService.query(query.getCondition(), query.getSortby(), Campaign.class, query.getOffset(), query.getLimit());
        LinkedList<CampaignDetail> details = new LinkedList<CampaignDetail>();
        for (Campaign definition : campaigns.getList()) {
            CampaignDetail campaignDetail = this.getCampaignDetail(definition);
            if (campaignDetail == null) continue;
            details.add(campaignDetail);
        }
        return new PartialList(details, campaigns.getOffset(), campaigns.getPageSize(), campaigns.getTotalSize(), campaigns.getTotalSizeRelation());
    }

    public CampaignDetail getCampaignDetail(String id) {
        return this.getCampaignDetail(this.getCampaign(id));
    }

    private CampaignDetail getCampaignDetail(Campaign campaign) {
        if (campaign == null) {
            return null;
        }
        CampaignDetail campaignDetail = new CampaignDetail(campaign);
        Condition profileEngagedCondition = new Condition(this.definitionsService.getConditionType("profilePropertyCondition"));
        profileEngagedCondition.setParameter("propertyName", (Object)("systemProperties.campaigns." + campaign.getMetadata().getId() + "Engaged"));
        profileEngagedCondition.setParameter("comparisonOperator", (Object)"exists");
        campaignDetail.setEngagedProfiles(this.persistenceService.queryCount(profileEngagedCondition, "profile"));
        Condition campaignGoalsCondition = new Condition(this.definitionsService.getConditionType("sessionPropertyCondition"));
        campaignGoalsCondition.setParameter("propertyName", (Object)"campaignId");
        campaignGoalsCondition.setParameter("comparisonOperator", (Object)"equals");
        campaignGoalsCondition.setParameter("propertyValue", (Object)campaign.getMetadata().getId());
        campaignDetail.setNumberOfGoals(this.persistenceService.queryCount(campaignGoalsCondition, "goal"));
        Condition sessionEngagedCondition = new Condition(this.definitionsService.getConditionType("sessionPropertyCondition"));
        sessionEngagedCondition.setParameter("propertyName", (Object)("systemProperties.campaigns." + campaign.getMetadata().getId() + "Engaged"));
        sessionEngagedCondition.setParameter("comparisonOperator", (Object)"exists");
        campaignDetail.setCampaignSessionViews(this.persistenceService.queryCount(sessionEngagedCondition, "session"));
        Condition sessionConvertedCondition = new Condition(this.definitionsService.getConditionType("sessionPropertyCondition"));
        sessionConvertedCondition.setParameter("propertyName", (Object)("systemProperties.goals." + campaign.getPrimaryGoal() + "TargetReached"));
        sessionConvertedCondition.setParameter("comparisonOperator", (Object)"exists");
        campaignDetail.setCampaignSessionSuccess(this.persistenceService.queryCount(sessionConvertedCondition, "session"));
        campaignDetail.setConversionRate((double)campaignDetail.getCampaignSessionSuccess() / (campaignDetail.getCampaignSessionViews() > 0L ? (double)campaignDetail.getCampaignSessionViews() : 1.0));
        return campaignDetail;
    }

    public Campaign getCampaign(String id) {
        Campaign campaign = (Campaign)this.persistenceService.load(id, Campaign.class);
        if (campaign != null) {
            ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)campaign.getEntryCondition(), (String)("campaign " + id));
        }
        return campaign;
    }

    public void removeCampaign(String id) {
        for (Metadata m : this.getCampaignGoalMetadatas(id)) {
            this.removeGoal(m.getId());
        }
        this.rulesService.removeRule(id + "EntryEvent");
        this.persistenceService.remove(id, Campaign.class);
    }

    public void setCampaign(Campaign campaign) {
        ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)campaign.getEntryCondition(), (String)("campaign " + campaign.getItemId()));
        if (this.rulesService.getRule(campaign.getMetadata().getId() + "EntryEvent") != null) {
            this.rulesService.removeRule(campaign.getMetadata().getId() + "EntryEvent");
        }
        if (campaign.getMetadata().isEnabled() && campaign.getEntryCondition() != null) {
            this.createRule(campaign, campaign.getEntryCondition());
        }
        this.persistenceService.save((Item)campaign);
    }

    public GoalReport getGoalReport(String goalId) {
        return this.getGoalReport(goalId, null);
    }

    public GoalReport getGoalReport(String goalId, AggregateQuery query) {
        HashMap<String, Long> match;
        Map all;
        Condition goalStartCondition;
        Condition condition = new Condition(this.definitionsService.getConditionType("booleanCondition"));
        ArrayList<Condition> list = new ArrayList<Condition>();
        condition.setParameter("operator", (Object)"and");
        condition.setParameter("subConditions", list);
        Goal g = this.getGoal(goalId);
        Condition goalTargetCondition = new Condition(this.definitionsService.getConditionType("sessionPropertyCondition"));
        goalTargetCondition.setParameter("propertyName", (Object)("systemProperties.goals." + goalId + "TargetReached"));
        goalTargetCondition.setParameter("comparisonOperator", (Object)"exists");
        if (g.getStartEvent() == null && g.getCampaignId() != null) {
            goalStartCondition = new Condition(this.definitionsService.getConditionType("sessionPropertyCondition"));
            goalStartCondition.setParameter("propertyName", (Object)("systemProperties.campaigns." + g.getCampaignId() + "Engaged"));
            goalStartCondition.setParameter("comparisonOperator", (Object)"exists");
        } else if (g.getStartEvent() == null) {
            goalStartCondition = new Condition(this.definitionsService.getConditionType("matchAllCondition"));
        } else {
            goalStartCondition = new Condition(this.definitionsService.getConditionType("sessionPropertyCondition"));
            goalStartCondition.setParameter("propertyName", (Object)("systemProperties.goals." + goalId + "StartReached"));
            goalStartCondition.setParameter("comparisonOperator", (Object)"exists");
        }
        if (query != null && query.getCondition() != null) {
            ParserHelper.resolveConditionType((DefinitionsService)this.definitionsService, (Condition)query.getCondition(), (String)("goal " + goalId + " report"));
            list.add(query.getCondition());
        }
        TermsAggregate aggregate = null;
        String property = query.getAggregate().getProperty();
        if (query != null && query.getAggregate() != null && property != null) {
            if (query.getAggregate().getType() != null) {
                if (query.getAggregate().getType().equals("date")) {
                    String interval = (String)query.getAggregate().getParameters().get("interval");
                    String format = (String)query.getAggregate().getParameters().get("format");
                    aggregate = new DateAggregate(property, interval, format);
                } else if (query.getAggregate().getType().equals("dateRange") && query.getAggregate().getDateRanges() != null && !query.getAggregate().getDateRanges().isEmpty()) {
                    String format = (String)query.getAggregate().getParameters().get("format");
                    aggregate = new DateRangeAggregate(property, format, query.getAggregate().getDateRanges());
                } else if (query.getAggregate().getType().equals("numericRange") && query.getAggregate().getNumericRanges() != null && !query.getAggregate().getNumericRanges().isEmpty()) {
                    aggregate = new NumericRangeAggregate(property, query.getAggregate().getNumericRanges());
                } else if (query.getAggregate().getType().equals("ipRange") && query.getAggregate().ipRanges() != null && !query.getAggregate().ipRanges().isEmpty()) {
                    aggregate = new IpRangeAggregate(property, query.getAggregate().ipRanges());
                }
            }
            if (aggregate == null) {
                aggregate = new TermsAggregate(property);
            }
        }
        if (aggregate != null) {
            list.add(goalStartCondition);
            all = this.persistenceService.aggregateWithOptimizedQuery(condition, aggregate, "session");
            list.remove(goalStartCondition);
            list.add(goalTargetCondition);
            match = this.persistenceService.aggregateWithOptimizedQuery(condition, (BaseAggregate)aggregate, "session");
        } else {
            list.add(goalStartCondition);
            all = new HashMap<String, Long>();
            all.put("_filtered", this.persistenceService.queryCount(condition, "session"));
            list.remove(goalStartCondition);
            list.add(goalTargetCondition);
            match = new HashMap<String, Long>();
            match.put("_filtered", this.persistenceService.queryCount(condition, "session"));
        }
        GoalReport report = new GoalReport();
        GoalReport.Stat stat = new GoalReport.Stat();
        Long allFiltered = (Long)all.remove("_filtered");
        Long matchFiltered = (Long)match.remove("_filtered");
        stat.setStartCount(allFiltered != null ? allFiltered : 0L);
        stat.setTargetCount(matchFiltered != null ? matchFiltered : 0L);
        stat.setConversionRate(stat.getStartCount() > 0L ? (double)((float)stat.getTargetCount() / (float)stat.getStartCount()) : 0.0);
        report.setGlobalStats(stat);
        all.remove("_all");
        report.setSplit(new LinkedList());
        for (Map.Entry entry : all.entrySet()) {
            GoalReport.Stat dateStat = new GoalReport.Stat();
            dateStat.setKey((String)entry.getKey());
            dateStat.setStartCount(((Long)entry.getValue()).longValue());
            dateStat.setTargetCount(match.containsKey(entry.getKey()) ? (Long)match.get(entry.getKey()) : 0L);
            dateStat.setConversionRate(dateStat.getStartCount() > 0L ? (double)((float)dateStat.getTargetCount() / (float)dateStat.getStartCount()) : 0.0);
            dateStat.setPercentage(stat.getTargetCount() > 0L ? (double)((float)dateStat.getTargetCount() / (float)stat.getTargetCount()) : 0.0);
            report.getSplit().add(dateStat);
        }
        return report;
    }

    public PartialList<CampaignEvent> getEvents(Query query) {
        if (query.isForceRefresh()) {
            this.persistenceService.refreshIndex(CampaignEvent.class);
        }
        this.definitionsService.resolveConditionType(query.getCondition());
        return this.persistenceService.query(query.getCondition(), query.getSortby(), CampaignEvent.class, query.getOffset(), query.getLimit());
    }

    public void setCampaignEvent(CampaignEvent event) {
        this.persistenceService.save((Item)event);
    }

    public void removeCampaignEvent(String campaignEventId) {
        this.persistenceService.remove(campaignEventId, CampaignEvent.class);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.processBundleStartup(event.getBundle().getBundleContext());
                break;
            }
            case 256: {
                this.processBundleStop(event.getBundle().getBundleContext());
            }
        }
    }
}

